/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.JCheckBoxJList;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;

public class ViewPropertiesPane
extends JPanePlugin {
    private static final long serialVersionUID = 2554693130978453347L;
    private ListModel<Object> defaultListModel = new DefaultListModel<Object>();
    private JLabel permissionCountLabel = null;
    private JCheckBoxJList permissionsJList = null;
    private Account account;
    private Permission permission = new Permission();
    private JScrollPane permissionsScrollPane = null;
    private JPanel buttonPane = null;
    private JButton closeButton = null;

    public ViewPropertiesPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(396, 208));
        this.add((Component)this.getPermissionsScrollPane(), "Center");
        this.add((Component)this.getButtonPane(), "South");
    }

    @Override
    public String getPluginTitle() {
        return "View Properties Pane";
    }

    private JCheckBoxJList getPermissionsJList() {
        if (this.permissionsJList == null) {
            this.permissionsJList = new JCheckBoxJList();
            this.permissionsJList.setModel(this.defaultListModel);
            this.permissionsJList.addPropertyChangeListener("change", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ViewPropertiesPane.this.showPermissionCount(String.valueOf(ViewPropertiesPane.this.permissionsJList.getSelectedIndices().length) + " permissions selected");
                }
            });
        }
        return this.permissionsJList;
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.account = inContest.getAccount(inContest.getClientId());
        this.populatePermissions(this.account);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setTitle("Permissions/Abilities for " + inContest.getClientId());
        }
    }

    private void populatePermissions(Account inAccount) {
        ((DefaultListModel)this.defaultListModel).removeAllElements();
        if (inAccount == null) {
            String[] stringArray = this.getPermissionDescriptions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                JCheckBox checkBox = new JCheckBox(name);
                ((DefaultListModel)this.defaultListModel).addElement(checkBox);
                ++n2;
            }
            this.getPermissionsJList().setSelectedIndex(-1);
        } else {
            Permission.Type type;
            int count = 0;
            Permission.Type[] typeArray = Permission.Type.values();
            int n = typeArray.length;
            int n3 = 0;
            while (n3 < n) {
                type = typeArray[n3];
                if (this.account.isAllowed(type)) {
                    ++count;
                }
                ++n3;
            }
            if (count > 0) {
                int[] indexes = new int[count];
                count = 0;
                int idx = 0;
                Permission.Type[] typeArray2 = Permission.Type.values();
                int n4 = typeArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    Permission.Type type2 = typeArray2[n5];
                    JCheckBox checkBox = new JCheckBox(this.permission.getDescription(type2));
                    ((DefaultListModel)this.defaultListModel).addElement(checkBox);
                    if (this.account.isAllowed(type2)) {
                        indexes[count] = idx;
                        ++count;
                    }
                    ++idx;
                    ++n5;
                }
                this.getPermissionsJList().setSelectedIndices(indexes);
                this.getPermissionsJList().ensureIndexIsVisible(0);
            } else {
                typeArray = Permission.Type.values();
                n = typeArray.length;
                n3 = 0;
                while (n3 < n) {
                    type = typeArray[n3];
                    JCheckBox checkBox = new JCheckBox(this.permission.getDescription(type));
                    ((DefaultListModel)this.defaultListModel).addElement(checkBox);
                    ++n3;
                }
            }
        }
        this.showPermissionCount(String.valueOf(this.getPermissionsJList().getSelectedIndices().length) + " permissions selected");
    }

    private String[] getPermissionDescriptions() {
        Object[] permissionListNames = new String[Permission.Type.values().length];
        int i = 0;
        Permission.Type[] typeArray = Permission.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Permission.Type type = typeArray[n2];
            permissionListNames[i] = this.permission.getDescription(type);
            ++i;
            ++n2;
        }
        Arrays.sort(permissionListNames);
        return permissionListNames;
    }

    public void showPermissionCount(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewPropertiesPane.this.permissionCountLabel.setText(message);
            }
        });
    }

    private JScrollPane getPermissionsScrollPane() {
        if (this.permissionsScrollPane == null) {
            this.permissionsScrollPane = new JScrollPane();
            this.permissionsScrollPane.setViewportView(this.getPermissionsJList());
        }
        return this.permissionsScrollPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(new FlowLayout());
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getCloseButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewPropertiesPane.this.closeWindow();
                }
            });
        }
        return this.closeButton;
    }

    protected void closeWindow() {
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }
}

