/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ViewJudgementsPane
extends JPanePlugin
implements UIPlugin {
    private static final long serialVersionUID = 2350404181525660056L;
    private JPanel centerPane = null;
    private JPanel northPane = null;
    private JPanel titlePane = null;
    private MCLB judgementsListbox = null;
    private JLabel statusLabel = null;
    private Run run;
    private JLabel titleLabel = null;

    public ViewJudgementsPane() {
        this.initialize();
    }

    public void setRun(Run run) {
        this.run = run;
        this.populateGUI();
    }

    private void populateGUI() {
        Runnable updateGrid = new Runnable(){

            @Override
            public void run() {
                String deletedString = "";
                if (ViewJudgementsPane.this.run.isDeleted()) {
                    deletedString = " DELETED ";
                }
                ViewJudgementsPane.this.setTitle("Run " + ViewJudgementsPane.this.run.getNumber() + " elapsed " + ViewJudgementsPane.this.run.getElapsedMins() + deletedString);
                JudgementRecord judgementRecord = ViewJudgementsPane.this.run.getJudgementRecord();
                ViewJudgementsPane.this.judgementsListbox.removeAllRows();
                if (judgementRecord == null) {
                    ViewJudgementsPane.this.showMessage("No judgements found for Run " + ViewJudgementsPane.this.run.getNumber());
                } else {
                    ViewJudgementsPane.this.populateJudgementRows(ViewJudgementsPane.this.run);
                }
            }
        };
        SwingUtilities.invokeLater(updateGrid);
    }

    protected void setTitle(final String infoString) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewJudgementsPane.this.titleLabel.setText(infoString);
            }
        });
    }

    protected String getSiteTitle(int siteNumber) {
        Site site = this.getContest().getSites()[siteNumber - 1];
        if (site == null) {
            return "<missing>";
        }
        return site.toString();
    }

    protected void showMessage(String string) {
        this.statusLabel.setText(string);
    }

    private void populateJudgementRows(Run inRun) {
        JudgementRecord[] records = inRun.getAllJudgementRecords();
        int i = 0;
        while (i < records.length) {
            Object[] objects = this.buildJudgmentRow(i + 1, inRun, records[i]);
            this.judgementsListbox.addRow(objects);
            ++i;
        }
        this.judgementsListbox.autoSizeAllColumns();
        if (records.length == 1) {
            this.showMessage("There is " + records.length + " judgement");
        } else {
            this.showMessage("There are " + records.length + " judgements");
        }
    }

    private String yesNoString(boolean b) {
        if (b) {
            return "Yes";
        }
        return "No";
    }

    private Object[] buildJudgmentRow(int rowNumber, Run inRun, JudgementRecord judgementRecord) {
        int numberColumns = this.judgementsListbox.getColumnCount();
        Object[] column = new Object[numberColumns];
        int col = 0;
        column[col] = new Integer(rowNumber).toString();
        column[++col] = this.getJudgementName(judgementRecord);
        column[++col] = String.valueOf(judgementRecord.getJudgerClientId().getName()) + "/s" + judgementRecord.getJudgerClientId().getSiteNumber();
        if (judgementRecord.isComputerJudgement()) {
            column[col] = String.valueOf(judgementRecord.getJudgerClientId().getName()) + "/Computer";
        } else if (judgementRecord.isUsedValidator()) {
            column[col] = String.valueOf(judgementRecord.getJudgerClientId().getName()) + "/Val";
        }
        column[++col] = this.yesNoString(judgementRecord.isActive());
        column[++col] = "" + inRun.getElapsedMins();
        ++col;
        try {
            column[col] = this.yesNoString(!judgementRecord.isPreliminaryJudgement());
        }
        catch (Exception exception) {
            column[col] = "-";
        }
        column[++col] = "" + judgementRecord.getWhenJudgedTime();
        column[++col] = String.valueOf(judgementRecord.getHowLongToJudgeInSeconds()) + "s";
        column[++col] = judgementRecord.getCommentForTeam() != null ? judgementRecord.getCommentForTeam().getComment() : "(None)";
        column[++col] = judgementRecord.getCommentForJudge() != null ? judgementRecord.getCommentForJudge().getComment() : "(None)";
        column[++col] = String.valueOf(judgementRecord.getExecuteMS()) + "ms";
        return column;
    }

    private String getJudgementName(JudgementRecord judgementRecord) {
        String name = "No";
        if (judgementRecord != null && judgementRecord.getJudgementId() != null) {
            if (judgementRecord.isUsedValidator() && judgementRecord.getValidatorResultString() != null) {
                name = judgementRecord.getValidatorResultString();
            } else {
                Judgement judgement = this.getContest().getJudgement(judgementRecord.getJudgementId());
                if (judgement != null) {
                    name = judgement.toString();
                }
            }
        } else {
            name = "<missing>";
        }
        return name;
    }

    private void initialize() {
        this.setSize(new Dimension(527, 195));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getCenterPane(), "Center");
        this.add((Component)this.getNorthPane(), "North");
        this.add((Component)this.getButtonPane(), "South");
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new BorderLayout());
            this.centerPane.add((Component)((Object)this.getJudgementsListbox()), "Center");
        }
        return this.centerPane;
    }

    private JPanel getNorthPane() {
        if (this.northPane == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText("statusLabel");
            this.statusLabel.setHorizontalAlignment(0);
            this.statusLabel.setName("statusLabel");
            this.northPane = new JPanel();
            this.northPane.setLayout(new BorderLayout());
            this.northPane.setPreferredSize(new Dimension(35, 35));
            this.northPane.add((Component)this.statusLabel, "Center");
        }
        return this.northPane;
    }

    private JPanel getButtonPane() {
        if (this.titlePane == null) {
            this.titleLabel = new JLabel();
            this.titleLabel.setText("No run chosen");
            this.titleLabel.setHorizontalAlignment(0);
            this.titlePane = new JPanel();
            this.titlePane.setLayout(new BorderLayout());
            this.titlePane.setPreferredSize(new Dimension(35, 35));
            this.titlePane.add((Component)this.titleLabel, "Center");
        }
        return this.titlePane;
    }

    private MCLB getJudgementsListbox() {
        if (this.judgementsListbox == null) {
            this.judgementsListbox = new MCLB();
            Object[] cols = new Object[]{"##", "Judgement", "Judge", "Active", "Time", "Final", "TWJ", "TTJ", "Comment for team", "Comment for judge", "X time"};
            this.judgementsListbox.addColumns(cols);
            this.judgementsListbox.autoSizeAllColumns();
        }
        return this.judgementsListbox;
    }

    @Override
    public String getPluginTitle() {
        return "Run Judgement View";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addRunListener(new RunListenerImplementation());
    }

    public class RunListenerImplementation
    implements IRunListener {
        @Override
        public void runAdded(RunEvent event) {
            if (ViewJudgementsPane.this.run != null && event.getRun().getElementId().equals(ViewJudgementsPane.this.run.getElementId())) {
                ViewJudgementsPane.this.setRun(event.getRun());
            }
        }

        @Override
        public void refreshRuns(RunEvent event) {
        }

        @Override
        public void runChanged(RunEvent event) {
            if (ViewJudgementsPane.this.run != null && event.getRun().getElementId().equals(ViewJudgementsPane.this.run.getElementId())) {
                ViewJudgementsPane.this.setRun(event.getRun());
            }
        }

        @Override
        public void runRemoved(RunEvent event) {
            if (ViewJudgementsPane.this.run != null && event.getRun().getElementId().equals(ViewJudgementsPane.this.run.getElementId())) {
                ViewJudgementsPane.this.setRun(event.getRun());
            }
        }
    }
}

