/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.CategoryEvent;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.ICategoryListener;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SubmitClarificationPane
extends JPanePlugin {
    private static final long serialVersionUID = 6395977089692171705L;
    private Log log;
    private JPanel problemPane = null;
    private JComboBox<Problem> problemComboBox = null;
    private JPanel questionPane = null;
    private JTextArea questionTextArea = null;
    private JButton submitClarificationButton = null;

    public SubmitClarificationPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.setSize(new Dimension(456, 285));
        this.add((Component)this.getProblemPane(), null);
        this.add((Component)this.getQuestionPane(), null);
        this.add((Component)this.getSubmitClarificationButton(), null);
    }

    @Override
    public String getPluginTitle() {
        return "Submit Clarifications Pane";
    }

    private JPanel getProblemPane() {
        if (this.problemPane == null) {
            this.problemPane = new JPanel();
            this.problemPane.setLayout(new BorderLayout());
            this.problemPane.setBounds(new Rectangle(19, 13, 336, 54));
            this.problemPane.setBorder(BorderFactory.createTitledBorder(null, "Problem", 0, 0, null, null));
            this.problemPane.add(this.getProblemComboBox(), "Center");
        }
        return this.problemPane;
    }

    private JComboBox<Problem> getProblemComboBox() {
        if (this.problemComboBox == null) {
            this.problemComboBox = new JComboBox();
        }
        return this.problemComboBox;
    }

    private JPanel getQuestionPane() {
        if (this.questionPane == null) {
            this.questionPane = new JPanel();
            this.questionPane.setLayout(new BorderLayout());
            this.questionPane.setBounds(new Rectangle(19, 80, 406, 125));
            this.questionPane.setBorder(BorderFactory.createTitledBorder(null, "Question", 0, 0, null, null));
            this.questionPane.add((Component)this.getQuestionTextArea(), "Center");
        }
        return this.questionPane;
    }

    private JTextArea getQuestionTextArea() {
        if (this.questionTextArea == null) {
            this.questionTextArea = new JTextArea();
        }
        return this.questionTextArea;
    }

    private JButton getSubmitClarificationButton() {
        if (this.submitClarificationButton == null) {
            this.submitClarificationButton = new JButton();
            this.submitClarificationButton.setText("Submit Clarification");
            this.submitClarificationButton.setPreferredSize(new Dimension(200, 26));
            this.submitClarificationButton.setLocation(new Point(20, 219));
            this.submitClarificationButton.setSize(new Dimension(200, 34));
            this.submitClarificationButton.setToolTipText("Click this button to submit your Clarification");
            this.submitClarificationButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SubmitClarificationPane.this.submitClarification();
                }
            });
        }
        return this.submitClarificationButton;
    }

    private void reloadProblems() {
        Problem problem;
        int n;
        int n2;
        Problem[] problemArray;
        this.getProblemComboBox().removeAllItems();
        Problem problemN = new Problem("Select Problem");
        this.getProblemComboBox().addItem(problemN);
        if (this.getContest().getCategories().length > 0) {
            problemArray = this.getContest().getCategories();
            n2 = problemArray.length;
            n = 0;
            while (n < n2) {
                problem = problemArray[n];
                if (problem.isActive()) {
                    this.getProblemComboBox().addItem(problem);
                }
                ++n;
            }
        }
        problemArray = this.getContest().getProblems();
        n2 = problemArray.length;
        n = 0;
        while (n < n2) {
            problem = problemArray[n];
            if (problem.isActive()) {
                this.getProblemComboBox().addItem(problem);
            }
            ++n;
        }
    }

    private void populateGUI() {
        this.reloadProblems();
        this.setButtonsActive(this.getContest().getContestTime().isContestRunning());
    }

    private void setButtonsActive(final boolean turnButtonsOn) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubmitClarificationPane.this.getSubmitClarificationButton().setEnabled(turnButtonsOn);
            }
        });
        FrameUtilities.regularCursor(this);
    }

    protected void submitClarification() {
        Problem problem = (Problem)this.getProblemComboBox().getSelectedItem();
        if (this.getProblemComboBox().getSelectedIndex() < 1) {
            this.showMessage("Please select problem");
            return;
        }
        String question = this.questionTextArea.getText().trim();
        if (question.length() < 1) {
            this.showMessage("Please enter a question");
            return;
        }
        String confirmQuestion = "<HTML><FONT SIZE=+1>Do you wish to submit a clarification for<BR><BR>Problem:  <FONT COLOR=BLUE>" + Utilities.forHTML(problem.toString()) + "</FONT><BR><BR>" + "Question: <FONT COLOR=BLUE>" + Utilities.forHTML(question) + "</FONT><BR><BR></FONT>";
        int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), confirmQuestion, "Submit Clarification Confirm");
        if (result != 0) {
            return;
        }
        try {
            this.log.info("submit clarification for " + problem + " " + question);
            this.getController().submitClarification(problem, question);
            this.questionTextArea.setText("");
        }
        catch (Exception e) {
            this.showMessage("Error sending clar, contact staff");
            this.log.log(Log.SEVERE, "Exception sending clarification ", e);
        }
    }

    private boolean isThisSite(int siteNumber) {
        return siteNumber == this.getContest().getSiteNumber();
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.initializePermissions();
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addContestTimeListener(new ContestTimeListenerImplementation());
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        this.getContest().addCategoryListener(new CategoryListenerImplementation());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubmitClarificationPane.this.populateGUI();
            }
        });
    }

    private void updateGUIperPermissions() {
        this.submitClarificationButton.setVisible(this.isAllowed(Permission.Type.SUBMIT_CLARIFICATION));
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountModified(AccountEvent event) {
            Account account = event.getAccount();
            if (SubmitClarificationPane.this.getContest().getClientId().equals(account.getClientId())) {
                SubmitClarificationPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SubmitClarificationPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            boolean theyModifiedUs = false;
            Account[] accountArray = accountEvent.getAccounts();
            int n = accountArray.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (SubmitClarificationPane.this.getContest().getClientId().equals(account.getClientId())) {
                    theyModifiedUs = true;
                    SubmitClarificationPane.this.initializePermissions();
                }
                ++n2;
            }
            final boolean finalTheyModifiedUs = theyModifiedUs;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (finalTheyModifiedUs) {
                        SubmitClarificationPane.this.updateGUIperPermissions();
                    }
                }
            });
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubmitClarificationPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    private class CategoryListenerImplementation
    implements ICategoryListener {
        private CategoryListenerImplementation() {
        }

        @Override
        public void categoryAdded(CategoryEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubmitClarificationPane.this.reloadProblems();
                }
            });
        }

        @Override
        public void categoryChanged(CategoryEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubmitClarificationPane.this.reloadProblems();
                }
            });
        }

        @Override
        public void categoryRemoved(CategoryEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubmitClarificationPane.this.reloadProblems();
                }
            });
        }

        @Override
        public void categoryRefreshAll(CategoryEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubmitClarificationPane.this.reloadProblems();
                }
            });
        }
    }

    private class ContestTimeListenerImplementation
    implements IContestTimeListener {
        private ContestTimeListenerImplementation() {
        }

        @Override
        public void contestTimeAdded(ContestTimeEvent event) {
            if (SubmitClarificationPane.this.isThisSite(event.getSiteNumber())) {
                SubmitClarificationPane.this.setButtonsActive(event.getContestTime().isContestRunning());
            }
        }

        @Override
        public void contestTimeRemoved(ContestTimeEvent event) {
        }

        @Override
        public void contestTimeChanged(ContestTimeEvent event) {
        }

        @Override
        public void contestStarted(ContestTimeEvent event) {
            if (SubmitClarificationPane.this.isThisSite(event.getSiteNumber())) {
                SubmitClarificationPane.this.setButtonsActive(event.getContestTime().isContestRunning());
            }
        }

        @Override
        public void contestStopped(ContestTimeEvent event) {
            if (SubmitClarificationPane.this.isThisSite(event.getSiteNumber())) {
                SubmitClarificationPane.this.setButtonsActive(event.getContestTime().isContestRunning());
            }
        }

        @Override
        public void refreshAll(ContestTimeEvent event) {
            if (SubmitClarificationPane.this.isThisSite(event.getSiteNumber())) {
                SubmitClarificationPane.this.setButtonsActive(event.getContestTime().isContestRunning());
            }
        }
    }

    private class ProblemListenerImplementation
    implements IProblemListener {
        private ProblemListenerImplementation() {
        }

        @Override
        public void problemAdded(final ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubmitClarificationPane.this.getProblemComboBox().addItem(event.getProblem());
                }
            });
        }

        @Override
        public void problemChanged(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int selectedIndex = SubmitClarificationPane.this.getProblemComboBox().getSelectedIndex();
                    SubmitClarificationPane.this.reloadProblems();
                    if (selectedIndex > -1) {
                        SubmitClarificationPane.this.getProblemComboBox().setSelectedIndex(selectedIndex);
                    }
                }
            });
        }

        @Override
        public void problemRemoved(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubmitClarificationPane.this.reloadProblems();
                }
            });
        }

        @Override
        public void problemRefreshAll(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubmitClarificationPane.this.reloadProblems();
                }
            });
        }
    }
}

