/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.HeapSorter;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.ContestTimeComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProfileListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.ProfileEvent;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.ProfileCloneSettingsReport;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.util.QuickLoad;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import edu.csus.ecs.pc2.ui.ProfileSaveFrame;
import edu.csus.ecs.pc2.ui.ResetContestFrame;
import edu.csus.ecs.pc2.ui.SwitchProfileConfirmFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ProfilesPane
extends JPanePlugin {
    private static final long serialVersionUID = 9075523788534575300L;
    private ProfileSaveFrame profileSaveFrame = null;
    private JLabel profileNameLabel = null;
    private JButton switchButton = null;
    private JButton setButton = null;
    private JTextField profileTextField = null;
    private JPanel centerPane = null;
    private JPanel buttonPane = null;
    private JButton newButton = null;
    private JButton exportButton = null;
    private JButton cloneButton = null;
    private JButton resetContestButton = null;
    private ResetContestFrame resetContestFrame = null;
    private JTextField profileDescriptionTextField = null;
    private JLabel profileDescriptionLabel = null;
    private JPanel topPanel = null;
    private MCLB profilesListBox = null;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private JButton reportButton = null;
    private SwitchProfileConfirmFrame switchFrame = null;
    private boolean usingExtraColumns = false;
    private boolean showHidden = false;
    private JCheckBox showHiddenProfilesCheckbox = null;
    private JButton loadButton = null;

    public ProfilesPane() {
        this.initialize();
    }

    private void initialize() {
        this.usingExtraColumns = Utilities.isDebugMode();
        this.profileNameLabel = new JLabel();
        this.profileNameLabel.setHorizontalAlignment(4);
        this.profileNameLabel.setText("Active Profile Name");
        this.profileNameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1 && e.isControlDown() && e.isShiftDown()) {
                    Profile profile = ProfilesPane.this.getContest().getProfile();
                    String message = "Contest Id " + profile.getContestId();
                    JOptionPane.showMessageDialog(null, message);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(843, 319));
        this.add((Component)this.getCenterPane(), "Center");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getTopPanel(), "North");
        FrameUtilities.centerFrame(this);
    }

    @Override
    public String getPluginTitle() {
        return "Profiles Pane";
    }

    private JButton getSwitchButton() {
        if (this.switchButton == null) {
            this.switchButton = new JButton();
            this.switchButton.setEnabled(true);
            this.switchButton.setMnemonic(87);
            this.switchButton.setPreferredSize(new Dimension(100, 26));
            this.switchButton.setSelected(false);
            this.switchButton.setText("Switch");
            this.switchButton.setToolTipText("Switch to the selected profile");
            this.switchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.switchSelectedProfile();
                }
            });
        }
        return this.switchButton;
    }

    private JButton getSetButton() {
        if (this.setButton == null) {
            this.setButton = new JButton();
            this.setButton.setEnabled(false);
            this.setButton.setMnemonic(83);
            this.setButton.setText("Set");
            this.setButton.setToolTipText("Update the profile name and description");
            this.setButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.renameProfile();
                }
            });
        }
        return this.setButton;
    }

    private JTextField getProfileTextField() {
        if (this.profileTextField == null) {
            this.profileTextField = new JTextField();
            this.profileTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    ProfilesPane.this.enableSetButton();
                }
            });
        }
        return this.profileTextField;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.profileDescriptionLabel = new JLabel();
            this.profileDescriptionLabel.setText("Active Profile Description");
            this.profileDescriptionLabel.setHorizontalAlignment(4);
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new BorderLayout());
            this.centerPane.add((Component)((Object)this.getProfilesListBox()), "Center");
        }
        return this.centerPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(35);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getNewButton(), null);
            this.buttonPane.add((Component)this.getCloneButton(), null);
            this.buttonPane.add((Component)this.getSwitchButton(), null);
            this.buttonPane.add((Component)this.getResetContestButton(), null);
            this.buttonPane.add((Component)this.getExportButton(), null);
            this.buttonPane.add((Component)this.getReportButton(), null);
            this.buttonPane.add((Component)this.getLoadButton(), null);
            this.buttonPane.add((Component)this.getShowHiddenProfilesCheckbox(), null);
        }
        return this.buttonPane;
    }

    private JButton getNewButton() {
        if (this.newButton == null) {
            this.newButton = new JButton();
            this.newButton.setText("New");
            this.newButton.setMnemonic(78);
            this.newButton.setEnabled(true);
            this.newButton.setToolTipText("Create a new (blank) profile");
            this.newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.newProfile();
                }
            });
        }
        return this.newButton;
    }

    private JButton getExportButton() {
        if (this.exportButton == null) {
            this.exportButton = new JButton();
            this.exportButton.setText("Export");
            this.exportButton.setMnemonic(88);
            this.exportButton.setEnabled(false);
            this.exportButton.setToolTipText("Export profile information");
            this.exportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.exportProfile();
                }
            });
        }
        return this.exportButton;
    }

    private JButton getCloneButton() {
        if (this.cloneButton == null) {
            this.cloneButton = new JButton();
            this.cloneButton.setText("Clone");
            this.cloneButton.setMnemonic(67);
            this.cloneButton.setEnabled(true);
            this.cloneButton.setToolTipText("Create a copy of the active profile");
            this.cloneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.cloneProfile();
                }
            });
        }
        return this.cloneButton;
    }

    private String getProfileName() {
        return this.getContest().getProfile().getName();
    }

    private String getProfileDescription() {
        return this.getContest().getProfile().getDescription();
    }

    protected void newProfile() {
        this.getProfileSaveFrame().setTitle("Create new profile");
        this.getProfileSaveFrame().setSaveButtonName("Ok");
        this.getProfileSaveFrame().setVisible(true);
    }

    protected void exportProfile() {
        this.getProfileSaveFrame().setTitle("Export settings " + this.getProfileName());
        this.getProfileSaveFrame().setSaveButtonName("Export");
        this.getProfileSaveFrame().setVisible(true);
    }

    public SwitchProfileConfirmFrame getSwitchFrame() {
        if (this.switchFrame == null) {
            this.switchFrame = new SwitchProfileConfirmFrame();
        }
        return this.switchFrame;
    }

    protected void switchSelectedProfile() {
        int result;
        int selectedIndex = this.getProfilesListBox().getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("No profile selected");
            return;
        }
        if (this.getContest().getContestTime().isContestRunning()) {
            this.showMessage("Contest Clock/Time must be stopped");
            return;
        }
        String profilePath = (String)this.getProfilesListBox().getKeys()[selectedIndex];
        Profile selectedProfile = this.getProfile(profilePath);
        if (selectedProfile.equals(this.getContest().getProfile()) && (result = FrameUtilities.yesNoCancelDialog(this, "Currently using profile '" + selectedProfile.getName() + "' change to this profile?", "Change profile")) != 0) {
            return;
        }
        this.getSwitchFrame().setProfile(selectedProfile);
        this.getSwitchFrame().setVisible(true);
    }

    private Profile getProfile(String profilePath) {
        Profile[] profileArray = this.getContest().getProfiles();
        int n = profileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (profile.getProfilePath().equals(profilePath)) {
                return profile;
            }
            ++n2;
        }
        return null;
    }

    protected void renameProfile() {
        if (this.getProfileTextField() == null || this.getProfileTextField().getText().trim().length() < 1) {
            this.showMessage("No profile name specified");
            return;
        }
        String newProfileName = this.getProfileTextField().getText().trim();
        String description = String.valueOf(this.getProfileDescriptionTextField().getText().trim());
        Profile profile = this.getContest().getProfile();
        profile.setName(newProfileName);
        profile.setDescription(description);
        this.getController().updateProfile(profile);
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public ProfileSaveFrame getProfileSaveFrame() {
        if (this.profileSaveFrame == null) {
            this.profileSaveFrame = new ProfileSaveFrame();
        }
        return this.profileSaveFrame;
    }

    private JButton getResetContestButton() {
        if (this.resetContestButton == null) {
            this.resetContestButton = new JButton();
            this.resetContestButton.setMnemonic(83);
            this.resetContestButton.setText("Reset");
            this.resetContestButton.setToolTipText("Reset the active contest profile - clear runs, clars, reset contest time");
            this.resetContestButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.resetContest();
                }
            });
        }
        return this.resetContestButton;
    }

    protected void resetContest() {
        String siteContestClockRunning = "";
        ContestTime[] contestTimes = this.getContest().getContestTimes();
        Arrays.sort(contestTimes, new ContestTimeComparator());
        int numberSites = 0;
        ContestTime[] contestTimeArray = contestTimes;
        int n = contestTimes.length;
        int n2 = 0;
        while (n2 < n) {
            ContestTime contestTime = contestTimeArray[n2];
            if (contestTime.isContestRunning() && this.siteConnected(contestTime.getSiteNumber())) {
                Site site = this.getContest().getSite(contestTime.getSiteNumber());
                siteContestClockRunning = String.valueOf(siteContestClockRunning) + ", " + site.format("%L");
                ++numberSites;
            }
            ++n2;
        }
        if (numberSites != 0) {
            siteContestClockRunning = siteContestClockRunning.substring(2);
            String sitePhrase = "a site";
            if (numberSites > 1) {
                sitePhrase = String.valueOf(numberSites) + " sites";
            }
            JOptionPane.showMessageDialog(this, "Contest Clock not stopped at " + sitePhrase + " (" + siteContestClockRunning + ")\n All contest clocks must be stopped", "Unable to reset", 0);
        } else {
            this.showResetDialog();
        }
    }

    private boolean siteConnected(int siteNumber) {
        ClientId serverId = new ClientId(siteNumber, ClientType.Type.SERVER, 0);
        return this.getContest().isLocalLoggedIn(serverId) || this.isThisSite(siteNumber);
    }

    private boolean isThisSite(int siteNumber) {
        return this.getContest().getSiteNumber() == siteNumber;
    }

    private void showResetDialog() {
        if (this.resetContestFrame == null) {
            this.resetContestFrame = new ResetContestFrame();
            this.resetContestFrame.setContestAndController(this.getContest(), this.getController());
        }
        this.resetContestFrame.setVisible(true);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.initializePermissions();
        this.getProfileSaveFrame().setContestAndController(inContest, inController);
        this.getSwitchFrame().setContestAndController(this.getContest(), this.getController());
        Profile profile = this.getContest().getProfile();
        this.updateProfileInformation(profile);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilesPane.this.refreshProfilesList();
                ProfilesPane.this.updateGUIperPermissions();
            }
        });
        inContest.addProfileListener(new ProfileListenerImplementation());
        inContest.addAccountListener(new AccountListenerImplementation());
        inContest.addSiteListener(new SiteListenerImplementation());
    }

    private void updateGUIperPermissions() {
        this.switchButton.setVisible(this.isAllowed(Permission.Type.SWITCH_PROFILE));
        this.setButton.setVisible(this.isAllowed(Permission.Type.CLONE_PROFILE));
        this.newButton.setVisible(this.isAllowed(Permission.Type.CLONE_PROFILE));
        this.exportButton.setVisible(this.isAllowed(Permission.Type.EXPORT_PROFILE));
        this.cloneButton.setVisible(this.isAllowed(Permission.Type.CLONE_PROFILE));
        this.resetContestButton.setVisible(this.isAllowed(Permission.Type.RESET_CONTEST));
        this.reportButton.setVisible(this.isAllowed(Permission.Type.CLONE_PROFILE));
        this.loadButton.setVisible(this.isAllowed(Permission.Type.CLONE_PROFILE) && Utilities.isDebugMode());
    }

    protected void refreshProfilesList() {
        try {
            Profile[] profiles = this.getContest().getProfiles();
            this.getProfilesListBox().removeAllRows();
            this.getSwitchButton().setEnabled(false);
            if (profiles.length > 0) {
                Profile[] profileArray = profiles;
                int n = profiles.length;
                int n2 = 0;
                while (n2 < n) {
                    Profile profile = profileArray[n2];
                    this.updateProfileRow(profile);
                    ++n2;
                }
                this.getProfilesListBox().autoSizeAllColumns();
                this.getSwitchButton().setEnabled(true);
            }
            if (this.getContest().getSites().length > 1) {
                this.disableAllButtons();
            }
            this.updateProfileInformation(this.getContest().getProfile());
        }
        catch (Exception e) {
            this.getController().getLog().log(Log.DEBUG, "Exception refreshing profile list", e);
        }
    }

    private void disableAllButtons() {
        this.getNewButton().setEnabled(false);
        this.getSwitchButton().setEnabled(false);
        this.getSetButton().setEnabled(false);
        this.getCloneButton().setEnabled(false);
        this.getResetContestButton().setEnabled(false);
        this.getResetContestButton().setEnabled(false);
    }

    private Object[] buildProfileRow(Profile profile) {
        int numberColumns = this.profilesListBox.getColumnCount();
        Object[] c = new String[numberColumns];
        c[0] = profile.getName();
        if (profile.getProfilePath().equals(this.getContest().getProfile().getProfilePath())) {
            c[0] = "(Active) " + profile.getName();
        }
        c[1] = profile.getDescription();
        c[2] = this.formatter.format(profile.getCreateDate());
        if (this.usingExtraColumns) {
            c[3] = profile.getContestId();
            c[4] = profile.getProfilePath();
        }
        return c;
    }

    private void updateProfileInformation(final Profile profile) {
        if (profile != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilesPane.this.getProfileTextField().setText(profile.getName());
                    ProfilesPane.this.profileNameLabel.setToolTipText("Contest Profile Name " + profile.getContestId());
                    ProfilesPane.this.getProfileDescriptionTextField().setText(profile.getDescription());
                    ProfilesPane.this.enableSetButton();
                }
            });
        }
    }

    private JTextField getProfileDescriptionTextField() {
        if (this.profileDescriptionTextField == null) {
            this.profileDescriptionTextField = new JTextField();
            this.profileDescriptionTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    ProfilesPane.this.enableSetButton();
                }
            });
        }
        return this.profileDescriptionTextField;
    }

    protected void enableSetButton() {
        Profile profile = this.getContest().getProfile();
        String name = this.getProfileTextField().getText();
        String description = this.getProfileDescriptionTextField().getText();
        boolean enable = !profile.getName().equals(name) || !profile.getDescription().equals(description);
        this.getSetButton().setEnabled(enable);
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(1, 26, 40, 187);
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.ipadx = 47;
            gridBagConstraints4.gridheight = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 3;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.ipadx = 244;
            gridBagConstraints3.ipady = 9;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(10, 9, 16, 25);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.gridheight = 2;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.ipadx = 244;
            gridBagConstraints2.ipady = 10;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(25, 9, 10, 25);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(13, 51, 19, 8);
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.ipadx = 46;
            gridBagConstraints1.ipady = 7;
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(29, 51, 1, 8);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.ipadx = 78;
            gridBagConstraints.ipady = 7;
            gridBagConstraints.gridx = 0;
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new GridBagLayout());
            this.topPanel.setPreferredSize(new Dimension(120, 120));
            this.topPanel.add((Component)this.profileNameLabel, gridBagConstraints);
            this.topPanel.add((Component)this.profileDescriptionLabel, gridBagConstraints1);
            this.topPanel.add((Component)this.getProfileTextField(), gridBagConstraints2);
            this.topPanel.add((Component)this.getProfileDescriptionTextField(), gridBagConstraints3);
            this.topPanel.add((Component)this.getSetButton(), gridBagConstraints4);
        }
        return this.topPanel;
    }

    private MCLB getProfilesListBox() {
        if (this.profilesListBox == null) {
            this.profilesListBox = new MCLB();
            Object[] defaultColumns = new Object[]{"Name", "Description", "Create Date"};
            Object[] fullColumns = new Object[]{"Name", "Description", "Create Date", "Contest ID", "Path"};
            Object[] cols = defaultColumns;
            if (this.usingExtraColumns) {
                cols = fullColumns;
            }
            this.profilesListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            int idx = 0;
            this.profilesListBox.setColumnSorter(idx++, sorter, 1);
            this.profilesListBox.setColumnSorter(idx++, sorter, 2);
            this.profilesListBox.setColumnSorter(idx++, sorter, 3);
            if (this.usingExtraColumns) {
                this.profilesListBox.setColumnSorter(idx++, sorter, 4);
                this.profilesListBox.setColumnSorter(idx++, sorter, 5);
            }
        }
        return this.profilesListBox;
    }

    private void removeProfilesRow(final Profile profile) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int rowNumber = ProfilesPane.this.profilesListBox.getIndexByKey(profile.getProfilePath());
                if (rowNumber != -1) {
                    ProfilesPane.this.profilesListBox.removeRow(rowNumber);
                }
            }
        });
    }

    public void updateProfileRow(final Profile profile) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!profile.isActive() && !ProfilesPane.this.isShowHidden()) {
                    ProfilesPane.this.removeProfilesRow(profile);
                } else {
                    Object[] objects = ProfilesPane.this.buildProfileRow(profile);
                    int rowNumber = ProfilesPane.this.profilesListBox.getIndexByKey(profile.getProfilePath());
                    if (rowNumber == -1) {
                        ProfilesPane.this.profilesListBox.addRow(objects, profile.getProfilePath());
                    } else {
                        ProfilesPane.this.profilesListBox.replaceRow(objects, rowNumber);
                    }
                    ProfilesPane.this.profilesListBox.autoSizeAllColumns();
                    ProfilesPane.this.profilesListBox.sort();
                }
            }
        });
    }

    private JButton getReportButton() {
        if (this.reportButton == null) {
            this.reportButton = new JButton();
            this.reportButton.setText("Report");
            this.reportButton.setMnemonic(82);
            this.reportButton.setToolTipText("Display Profiles Report");
            this.reportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.createReport(new ProfileCloneSettingsReport());
                }
            });
        }
        return this.reportButton;
    }

    protected void createReport(IReport report) {
        report.setContestAndController(this.getContest(), this.getController());
        try {
            this.createAndViewReportFile(report, new Filter(), this.getController().getLog());
        }
        catch (IOException e) {
            StaticLog.log("Exception creating report", e);
            JOptionPane.showMessageDialog(this, "Exception in report " + e.getLocalizedMessage());
        }
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    private JCheckBox getShowHiddenProfilesCheckbox() {
        if (this.showHiddenProfilesCheckbox == null) {
            this.showHiddenProfilesCheckbox = new JCheckBox();
            this.showHiddenProfilesCheckbox.setText("Show Backups");
            this.showHiddenProfilesCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.toggleShowHiddenProfiles();
                }
            });
        }
        return this.showHiddenProfilesCheckbox;
    }

    protected void toggleShowHiddenProfiles() {
        this.showHidden = this.getShowHiddenProfilesCheckbox().isSelected();
        this.refreshProfilesList();
    }

    protected void cloneProfile() {
        this.getProfileSaveFrame().setTitle("Clone active profile: " + this.getProfileName() + " (" + this.getProfileDescription() + ")");
        this.getProfileSaveFrame().setSaveButtonName("Clone");
        this.getProfileSaveFrame().setVisible(true);
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setText("Load");
            this.loadButton.setMnemonic(76);
            this.loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProfilesPane.this.quickLoad();
                }
            });
        }
        return this.loadButton;
    }

    protected boolean isAdministrator(ClientId clientId) {
        return clientId.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR);
    }

    protected void quickLoad() {
        if (!this.isAdministrator(this.getContest().getClientId())) {
            JOptionPane.showMessageDialog(this, "You must be an Administrator to use this feature");
            return;
        }
        QuickLoad loader = new QuickLoad();
        loader.setContestAndController(this.getContest(), this.getController());
        loader = null;
        JOptionPane.showMessageDialog(this, "Contest quick loaded");
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountModified(AccountEvent event) {
            Account account = event.getAccount();
            if (ProfilesPane.this.getContest().getClientId().equals(account.getClientId())) {
                ProfilesPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilesPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            Account[] accountArray = accountEvent.getAccounts();
            int n = accountArray.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (ProfilesPane.this.getContest().getClientId().equals(account.getClientId())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProfilesPane.this.initializePermissions();
                            ProfilesPane.this.updateGUIperPermissions();
                        }
                    });
                }
                ++n2;
            }
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            this.accountsModified(accountEvent);
        }
    }

    protected class ProfileListenerImplementation
    implements IProfileListener {
        protected ProfileListenerImplementation() {
        }

        @Override
        public void profileAdded(ProfileEvent event) {
            ProfilesPane.this.updateProfileRow(event.getProfile());
        }

        @Override
        public void profileChanged(ProfileEvent event) {
            ProfilesPane.this.updateProfileRow(event.getProfile());
            Profile profile = ProfilesPane.this.getContest().getProfile();
            ProfilesPane.this.updateProfileInformation(profile);
        }

        @Override
        public void profileRemoved(ProfileEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilesPane.this.refreshProfilesList();
                }
            });
        }

        @Override
        public void profileRefreshAll(ProfileEvent profileEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilesPane.this.refreshProfilesList();
                }
            });
        }
    }

    public class SiteListenerImplementation
    implements ISiteListener {
        @Override
        public void siteAdded(SiteEvent event) {
            ProfilesPane.this.refreshProfilesList();
        }

        @Override
        public void siteRemoved(SiteEvent event) {
            ProfilesPane.this.refreshProfilesList();
        }

        @Override
        public void siteChanged(SiteEvent event) {
            ProfilesPane.this.refreshProfilesList();
        }

        @Override
        public void siteLoggedOn(SiteEvent event) {
        }

        @Override
        public void siteLoggedOff(SiteEvent event) {
        }

        @Override
        public void siteProfileStatusChanged(SiteEvent event) {
        }

        @Override
        public void sitesRefreshAll(SiteEvent siteEvent) {
            ProfilesPane.this.refreshProfilesList();
        }
    }
}

