/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientSettingsEvent;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IClientSettingsListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.JudgementNotification;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import edu.csus.ecs.pc2.ui.EditNotificationSettingFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class NotificationsPane
extends JPanePlugin {
    private static final long serialVersionUID = -5837850150714301616L;
    private JPanel languageButtonPane = null;
    private MCLB notificationListBox = null;
    private JButton editButton = null;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private EditNotificationSettingFrame editNotificationSettingFrame = null;
    private Log log;

    public NotificationsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(564, 229));
        this.add((Component)((Object)this.getNotificationListBox()), "Center");
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getNotificationButtonPane(), "South");
        this.editNotificationSettingFrame = new EditNotificationSettingFrame();
    }

    @Override
    public String getPluginTitle() {
        return "Notifications Pane";
    }

    private JPanel getNotificationButtonPane() {
        if (this.languageButtonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.languageButtonPane = new JPanel();
            this.languageButtonPane.setLayout(flowLayout);
            this.languageButtonPane.setPreferredSize(new Dimension(35, 35));
            this.languageButtonPane.add((Component)this.getEditButton(), null);
        }
        return this.languageButtonPane;
    }

    private MCLB getNotificationListBox() {
        if (this.notificationListBox == null) {
            this.notificationListBox = new MCLB();
            Object[] cols = new Object[]{"Client", "Final", "Preliminary"};
            this.notificationListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            this.notificationListBox.setColumnSorter(0, sorter, 1);
            this.notificationListBox.setColumnSorter(1, sorter, 2);
            this.notificationListBox.setColumnSorter(2, sorter, 3);
            this.notificationListBox.autoSizeAllColumns();
        }
        return this.notificationListBox;
    }

    public void updateNotificationRow(final ClientId clientId) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] objects = NotificationsPane.this.buildNotificationRow(clientId);
                int rowNumber = NotificationsPane.this.notificationListBox.getIndexByKey(clientId);
                if (rowNumber == -1) {
                    NotificationsPane.this.notificationListBox.addRow(objects, clientId);
                } else {
                    NotificationsPane.this.notificationListBox.replaceRow(objects, rowNumber);
                }
                NotificationsPane.this.notificationListBox.autoSizeAllColumns();
            }
        });
    }

    protected Object[] buildNotificationRow(ClientId clientId) {
        int numberColumns = this.notificationListBox.getColumnCount();
        Object[] c = new String[numberColumns];
        c[0] = NotificationsPane.getClientTitle(clientId);
        c[1] = "";
        c[2] = "";
        NotificationSetting notificationSetting = this.getNotificationSettings(clientId);
        if (notificationSetting != null) {
            c[1] = this.getNotificationSettingsString(notificationSetting.getFinalNotificationYes(), notificationSetting.getFinalNotificationNo());
            c[2] = this.getNotificationSettingsString(notificationSetting.getPreliminaryNotificationYes(), notificationSetting.getPreliminaryNotificationNo());
        }
        return c;
    }

    public static String getClientTitle(ClientId clientId) {
        if (clientId.getSiteNumber() == 0 && clientId.getClientNumber() == 0 && clientId.getClientType().equals((Object)ClientType.Type.TEAM)) {
            return "All teams";
        }
        return String.valueOf(clientId.getName()) + " Site " + clientId.getSiteNumber();
    }

    protected String getNotificationSettingsString(JudgementNotification notificationYes, JudgementNotification notificationNo) {
        String s = "";
        if (notificationYes.isNotificationSupressed()) {
            s = "Send Yes";
            if (notificationYes.getCuttoffMinutes() > 0) {
                s = String.valueOf(s) + " cutoff " + notificationYes.getCuttoffMinutes() + " min";
            }
        }
        if (notificationNo.isNotificationSupressed()) {
            s = String.valueOf(s) + " Send No";
            if (notificationNo.getCuttoffMinutes() > 0) {
                s = String.valueOf(s) + " cutoff " + notificationNo.getCuttoffMinutes() + " min";
            }
        }
        return s;
    }

    private Account[] getAccountList(ClientType.Type type) {
        Vector<Account> vector = this.getContest().getAccounts(type);
        return vector.toArray(new Account[vector.size()]);
    }

    private void reloadListBox() {
        Account account;
        this.notificationListBox.removeAllRows();
        Account[] accountArray = this.getAccountList(ClientType.Type.SCOREBOARD);
        int n = accountArray.length;
        int n2 = 0;
        while (n2 < n) {
            account = accountArray[n2];
            this.addNotificationRow(account.getClientId());
            ++n2;
        }
        accountArray = this.getAccountList(ClientType.Type.SPECTATOR);
        n = accountArray.length;
        n2 = 0;
        while (n2 < n) {
            account = accountArray[n2];
            this.addNotificationRow(account.getClientId());
            ++n2;
        }
        ClientId clientId = new ClientId(0, ClientType.Type.TEAM, 0);
        this.addNotificationRow(clientId);
    }

    private void addNotificationRow(ClientId clientId) {
        Object[] objects = this.buildNotificationRow(clientId);
        this.notificationListBox.addRow(objects, clientId);
        this.notificationListBox.autoSizeAllColumns();
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.editNotificationSettingFrame.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.getContest().addClientSettingsListener(new ClientSettingsListenerImplementation());
        this.getContest().addAccountListener(new AccountListenerImplementation());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationsPane.this.reloadListBox();
            }
        });
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setToolTipText("Edit existing Notification definition");
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationsPane.this.editSelectedNotification();
                }
            });
        }
        return this.editButton;
    }

    protected void editSelectedNotification() {
        int selectedIndex = this.notificationListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a notification to edit");
            return;
        }
        try {
            this.editNotificationSettingFrame.setVisible(true);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit notification, check log");
            e.printStackTrace();
        }
    }

    private NotificationSetting getNotificationSettings(ClientId clientId) {
        ClientSettings clientSettings = this.getContest().getClientSettings(clientId);
        if (clientSettings != null) {
            return clientSettings.getNotificationSetting();
        }
        return null;
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
            NotificationsPane.this.reloadListBox();
        }

        @Override
        public void accountModified(AccountEvent accountEvent) {
            NotificationsPane.this.reloadListBox();
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
            NotificationsPane.this.reloadListBox();
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            NotificationsPane.this.reloadListBox();
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            NotificationsPane.this.reloadListBox();
        }
    }

    public class ClientSettingsListenerImplementation
    implements IClientSettingsListener {
        @Override
        public void clientSettingsAdded(ClientSettingsEvent event) {
            this.clientSettingsChanged(event);
        }

        @Override
        public void clientSettingsChanged(final ClientSettingsEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClientSettingsListenerImplementation.this.updateNotificationRowIfRowExists(event.getClientSettings().getClientId());
                }
            });
        }

        protected void updateNotificationRowIfRowExists(ClientId clientId2) {
            int rowNumber = NotificationsPane.this.notificationListBox.getIndexByKey(clientId2);
            if (rowNumber != -1) {
                NotificationsPane.this.updateNotificationRow(clientId2);
            }
        }

        @Override
        public void clientSettingsRemoved(ClientSettingsEvent event) {
            this.clientSettingsChanged(event);
        }

        @Override
        public void clientSettingsRefreshAll(ClientSettingsEvent clientSettingsEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NotificationsPane.this.reloadListBox();
                }
            });
        }
    }
}

