/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.execute.Executable;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunTestCase;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MultiFileComparator;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import edu.csus.ecs.pc2.ui.TestCaseResultsTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class MultiTestSetOutputViewerPane
extends JPanePlugin {
    private static final long serialVersionUID = 7363093989131251458L;
    protected static final String CTYPES = "CTYPES";
    protected static final String VTYPES = "VTYPES";
    protected static final String COMPARATOR_CMD = "COMPARATOR_CMD";
    protected static final String VIEWER_CMD = "VIEWER_CMD";
    private String[] columnNames = new String[]{"Select", "Data Set #", "Result", "Time (ms)", "Team Output", "Compare Outputs", "Judge's Output", "Judge's Data", "Validator StdOut", "Validator StdErr"};
    private JPanel centerPanel = null;
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final ButtonGroup buttonGroup_1 = new ButtonGroup();
    private JComboBox<String> pulldownSelectComparator;
    private JTextField textUserSpecifyComparator;
    private JTextField textUserSpecifyViewer;
    private JComboBox<String> pulldownSelectViewer;
    private JButton btnCompareSelected;
    private JTable resultsTable;
    private JLabel lblProblemTitle;
    private JLabel lblTeamNumber;
    private JLabel lblRunID;
    private Run currentRun;
    private Problem currentProblem;
    private ProblemDataFiles currentProblemDataFiles;
    private String[] currentTeamOutputFileNames;
    private JLabel lblLanguage;
    private JLabel lblNumFailedTestCases;
    private JLabel lblNumTestCases;
    private MultipleFileViewer currentViewer;
    private MultiFileComparator currentComparator;
    private JScrollPane resultsScrollPane;
    private String lastViewer = "";
    private String lastComparator = "";
    private Log log;
    private RunFiles currentRunFiles;
    private String executableDir;
    private String currentComparatorCmd;
    private String currentViewerCmd;
    private JButton btnCancel;
    private JButton btnUpdate;
    private JTabbedPane multiTestSetTabbedPane;
    private TYPES ctype = TYPES.INTERNAL;
    private TYPES vtype = TYPES.INTERNAL;
    private ClientSettings clientSettings = null;
    private JRadioButton rdbtnInternalCompareProgram;
    private JRadioButton rdbtnSpecifyCompareProgram;
    private JRadioButton rdbtnPulldownCompareList;
    private JRadioButton rdbtnInternalViewerProgram;
    private JRadioButton rdbtnPulldownViewerList;
    private JRadioButton rdbtnSpecifyViewerProgram;
    private String[] currentValidatorOutputFileNames;
    private String[] currentValidatorStderrFileNames;

    public MultipleFileViewer getCurrentViewer() {
        if (this.currentViewer == null) {
            this.currentViewer = new MultipleFileViewer(this.getController().getLog());
        }
        return this.currentViewer;
    }

    public MultiTestSetOutputViewerPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(568, 363));
        this.add((Component)this.getCenterPanel(), "Center");
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.clientSettings = this.getContest().getClientSettings();
        if (this.clientSettings != null) {
            String tmp = this.clientSettings.getProperty(CTYPES);
            if (tmp != null) {
                this.ctype = TYPES.valueOf(tmp);
            }
            if ((tmp = this.clientSettings.getProperty(COMPARATOR_CMD)) != null) {
                this.lastComparator = tmp;
                this.currentComparatorCmd = tmp;
            }
            if ((tmp = this.clientSettings.getProperty(VTYPES)) != null) {
                this.vtype = TYPES.valueOf(tmp);
            }
            if ((tmp = this.clientSettings.getProperty(VIEWER_CMD)) != null) {
                this.lastViewer = tmp;
                this.currentViewerCmd = tmp;
            }
            if (this.ctype == TYPES.LIST) {
                this.pulldownSelectComparator.setSelectedItem(this.currentComparatorCmd);
            }
            if (this.vtype == TYPES.LIST) {
                this.pulldownSelectViewer.setSelectedItem(this.currentViewerCmd);
            }
            if (this.ctype == TYPES.USER) {
                this.textUserSpecifyComparator.setText(this.currentComparatorCmd);
            } else {
                this.textUserSpecifyComparator.setText("<enter comparator name>");
            }
            if (this.vtype == TYPES.USER) {
                this.textUserSpecifyViewer.setText(this.currentViewerCmd);
            } else {
                this.textUserSpecifyViewer.setText("<enter viewer name>");
            }
            ButtonModel model = null;
            switch (this.ctype) {
                case LIST: {
                    model = this.rdbtnPulldownCompareList.getModel();
                    break;
                }
                case USER: {
                    model = this.rdbtnSpecifyCompareProgram.getModel();
                    break;
                }
                default: {
                    model = this.rdbtnInternalCompareProgram.getModel();
                }
            }
            this.buttonGroup.setSelected(model, true);
            switch (this.ctype) {
                case INTERNAL: {
                    model = this.rdbtnInternalViewerProgram.getModel();
                    break;
                }
                case LIST: {
                    model = this.rdbtnPulldownViewerList.getModel();
                    break;
                }
                case USER: {
                    model = this.rdbtnSpecifyViewerProgram.getModel();
                    break;
                }
                default: {
                    model = this.rdbtnInternalViewerProgram.getModel();
                }
            }
            this.buttonGroup_1.setSelected(model, true);
            this.getCurrentComparator().setComparatorCommand(this.lastComparator);
            this.getCurrentViewer().setViewerCommand(this.lastViewer);
            this.enableUpdateCancel(this.currentComparatorCmd, this.currentViewerCmd);
        }
    }

    @Override
    public String getPluginTitle() {
        return "MultiTestSetOutputViewer Pane";
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(0);
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(borderLayout);
            this.getMultiTestSetTabbedPane().setName("multiTestSetTabbedPane");
            this.getMultiTestSetTabbedPane().setBorder(new LineBorder(new Color(0, 0, 0)));
            this.centerPanel.add((Component)this.getMultiTestSetTabbedPane(), "Center");
            JPanel resultsPane = new JPanel();
            resultsPane.setName("ViewDataSets");
            this.getMultiTestSetTabbedPane().addTab("Data Set Results", null, resultsPane, "Show the results of this submission for each test data set");
            resultsPane.setLayout(new BorderLayout(0, 0));
            final JButton btnClose = this.getResultsPaneHeaderPanel(resultsPane);
            JPanel optionsPane = new JPanel();
            this.getMultiTestSetTabbedPane().addTab("Options", null, optionsPane, "Set options for tools used to display test set results");
            optionsPane.setLayout(new BorderLayout(0, 0));
            JPanel panelFooterButtons = this.getPanelFooterButtons(optionsPane);
            this.currentViewerCmd = this.lastViewer;
            this.currentComparatorCmd = this.lastComparator;
            this.enableUpdateCancel(this.currentComparatorCmd, this.currentViewerCmd);
            this.btnUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MultiTestSetOutputViewerPane.this.lastComparator = MultiTestSetOutputViewerPane.this.currentComparatorCmd;
                    MultiTestSetOutputViewerPane.this.lastViewer = MultiTestSetOutputViewerPane.this.currentViewerCmd;
                    MultiTestSetOutputViewerPane.this.getCurrentComparator().setComparatorCommand(MultiTestSetOutputViewerPane.this.lastComparator);
                    MultiTestSetOutputViewerPane.this.getCurrentViewer().setViewerCommand(MultiTestSetOutputViewerPane.this.lastViewer);
                    MultiTestSetOutputViewerPane.this.enableUpdateCancel(MultiTestSetOutputViewerPane.this.currentComparatorCmd, MultiTestSetOutputViewerPane.this.currentViewerCmd);
                    if (MultiTestSetOutputViewerPane.this.clientSettings == null) {
                        MultiTestSetOutputViewerPane.this.clientSettings = new ClientSettings();
                    }
                    MultiTestSetOutputViewerPane.this.clientSettings.put(MultiTestSetOutputViewerPane.CTYPES, MultiTestSetOutputViewerPane.this.ctype.toString());
                    MultiTestSetOutputViewerPane.this.clientSettings.put(MultiTestSetOutputViewerPane.VTYPES, MultiTestSetOutputViewerPane.this.vtype.toString());
                    MultiTestSetOutputViewerPane.this.clientSettings.put(MultiTestSetOutputViewerPane.COMPARATOR_CMD, MultiTestSetOutputViewerPane.this.currentComparatorCmd);
                    MultiTestSetOutputViewerPane.this.clientSettings.put(MultiTestSetOutputViewerPane.VIEWER_CMD, MultiTestSetOutputViewerPane.this.currentViewerCmd);
                    MultiTestSetOutputViewerPane.this.getController().updateClientSettings(MultiTestSetOutputViewerPane.this.clientSettings);
                }
            });
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (MultiTestSetOutputViewerPane.this.ctype == TYPES.USER) {
                        MultiTestSetOutputViewerPane.this.textUserSpecifyComparator.setText(MultiTestSetOutputViewerPane.this.lastComparator);
                    }
                    if (MultiTestSetOutputViewerPane.this.vtype == TYPES.USER) {
                        MultiTestSetOutputViewerPane.this.textUserSpecifyViewer.setText(MultiTestSetOutputViewerPane.this.lastViewer);
                    }
                    MultiTestSetOutputViewerPane.this.currentComparatorCmd = MultiTestSetOutputViewerPane.this.lastComparator;
                    MultiTestSetOutputViewerPane.this.currentViewerCmd = MultiTestSetOutputViewerPane.this.lastViewer;
                }
            });
            this.rdbtnInternalCompareProgram.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (MultiTestSetOutputViewerPane.this.rdbtnInternalCompareProgram.isSelected()) {
                        MultiTestSetOutputViewerPane.this.currentComparatorCmd = "";
                        MultiTestSetOutputViewerPane.this.enableUpdateCancel(MultiTestSetOutputViewerPane.this.currentComparatorCmd, MultiTestSetOutputViewerPane.this.currentViewerCmd);
                        MultiTestSetOutputViewerPane.this.ctype = TYPES.INTERNAL;
                    }
                }
            });
            this.rdbtnPulldownCompareList.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (MultiTestSetOutputViewerPane.this.rdbtnPulldownCompareList.isSelected()) {
                        MultiTestSetOutputViewerPane.this.pulldownSelectComparator.setEnabled(true);
                        MultiTestSetOutputViewerPane.this.ctype = TYPES.LIST;
                    } else {
                        MultiTestSetOutputViewerPane.this.pulldownSelectComparator.setEnabled(false);
                    }
                    MultiTestSetOutputViewerPane.this.currentComparatorCmd = (String)MultiTestSetOutputViewerPane.this.pulldownSelectComparator.getSelectedItem();
                    MultiTestSetOutputViewerPane.this.enableUpdateCancel(MultiTestSetOutputViewerPane.this.currentComparatorCmd, MultiTestSetOutputViewerPane.this.currentViewerCmd);
                }
            });
            this.rdbtnSpecifyCompareProgram.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (MultiTestSetOutputViewerPane.this.rdbtnSpecifyCompareProgram.isSelected()) {
                        MultiTestSetOutputViewerPane.this.textUserSpecifyComparator.setEnabled(true);
                        MultiTestSetOutputViewerPane.this.currentComparatorCmd = MultiTestSetOutputViewerPane.this.textUserSpecifyComparator.getText();
                        MultiTestSetOutputViewerPane.this.ctype = TYPES.USER;
                    } else {
                        MultiTestSetOutputViewerPane.this.textUserSpecifyComparator.setEnabled(false);
                    }
                    MultiTestSetOutputViewerPane.this.enableUpdateCancel(MultiTestSetOutputViewerPane.this.currentComparatorCmd, MultiTestSetOutputViewerPane.this.currentViewerCmd);
                }
            });
            this.rdbtnInternalViewerProgram.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (MultiTestSetOutputViewerPane.this.rdbtnInternalViewerProgram.isSelected()) {
                        MultiTestSetOutputViewerPane.this.currentViewerCmd = "";
                        MultiTestSetOutputViewerPane.this.vtype = TYPES.INTERNAL;
                    }
                    MultiTestSetOutputViewerPane.this.enableUpdateCancel(MultiTestSetOutputViewerPane.this.currentComparatorCmd, MultiTestSetOutputViewerPane.this.currentViewerCmd);
                }
            });
            this.rdbtnPulldownViewerList.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (MultiTestSetOutputViewerPane.this.rdbtnPulldownViewerList.isSelected()) {
                        MultiTestSetOutputViewerPane.this.currentViewerCmd = (String)MultiTestSetOutputViewerPane.this.pulldownSelectViewer.getSelectedItem();
                        MultiTestSetOutputViewerPane.this.pulldownSelectViewer.setEnabled(true);
                        MultiTestSetOutputViewerPane.this.vtype = TYPES.LIST;
                    } else {
                        MultiTestSetOutputViewerPane.this.pulldownSelectViewer.setEnabled(false);
                    }
                    MultiTestSetOutputViewerPane.this.enableUpdateCancel(MultiTestSetOutputViewerPane.this.currentComparatorCmd, MultiTestSetOutputViewerPane.this.currentViewerCmd);
                }
            });
            this.rdbtnSpecifyViewerProgram.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (MultiTestSetOutputViewerPane.this.rdbtnSpecifyViewerProgram.isSelected()) {
                        MultiTestSetOutputViewerPane.this.textUserSpecifyViewer.setEnabled(true);
                        MultiTestSetOutputViewerPane.this.vtype = TYPES.USER;
                        MultiTestSetOutputViewerPane.this.currentViewerCmd = MultiTestSetOutputViewerPane.this.textUserSpecifyViewer.getText();
                    } else {
                        MultiTestSetOutputViewerPane.this.textUserSpecifyViewer.setEnabled(false);
                    }
                    MultiTestSetOutputViewerPane.this.enableUpdateCancel(MultiTestSetOutputViewerPane.this.currentComparatorCmd, MultiTestSetOutputViewerPane.this.currentViewerCmd);
                }
            });
            this.textUserSpecifyViewer.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent arg0) {
                }

                @Override
                public void keyReleased(KeyEvent arg0) {
                    if (MultiTestSetOutputViewerPane.this.vtype == TYPES.USER) {
                        MultiTestSetOutputViewerPane.this.currentViewerCmd = MultiTestSetOutputViewerPane.this.textUserSpecifyViewer.getText();
                        MultiTestSetOutputViewerPane.this.enableUpdateCancel(MultiTestSetOutputViewerPane.this.currentComparatorCmd, MultiTestSetOutputViewerPane.this.currentViewerCmd);
                    }
                }

                @Override
                public void keyPressed(KeyEvent arg0) {
                }
            });
            this.textUserSpecifyComparator.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent arg0) {
                }

                @Override
                public void keyReleased(KeyEvent arg0) {
                    if (MultiTestSetOutputViewerPane.this.ctype == TYPES.USER) {
                        MultiTestSetOutputViewerPane.this.currentComparatorCmd = MultiTestSetOutputViewerPane.this.textUserSpecifyComparator.getText();
                        MultiTestSetOutputViewerPane.this.enableUpdateCancel(MultiTestSetOutputViewerPane.this.currentComparatorCmd, MultiTestSetOutputViewerPane.this.currentViewerCmd);
                    }
                }

                @Override
                public void keyPressed(KeyEvent arg0) {
                }
            });
            Component horizontalGlue_6 = Box.createHorizontalGlue();
            horizontalGlue_6.setPreferredSize(new Dimension(20, 20));
            panelFooterButtons.add(horizontalGlue_6);
            JButton btnClose_1 = new JButton("Close");
            btnClose_1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MultiTestSetOutputViewerPane.this.getMultiTestSetTabbedPane().getSelectedIndex() > 0) {
                        MultiTestSetOutputViewerPane.this.getMultiTestSetTabbedPane().setSelectedIndex(0);
                    } else {
                        Window parentFrame = SwingUtilities.getWindowAncestor(btnClose);
                        parentFrame.dispose();
                    }
                }
            });
            panelFooterButtons.add(btnClose_1);
        }
        return this.centerPanel;
    }

    private JPanel getPanelFooterButtons(JPanel optionsPane) {
        JPanel panelChoosers = new JPanel();
        optionsPane.add((Component)panelChoosers, "Center");
        JPanel chooseComparatorPanel = new JPanel();
        panelChoosers.add(chooseComparatorPanel);
        chooseComparatorPanel.setBounds(new Rectangle(0, 0, 0, 20));
        chooseComparatorPanel.setAlignmentX(0.0f);
        chooseComparatorPanel.setPreferredSize(new Dimension(220, 200));
        chooseComparatorPanel.setBorder(new TitledBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "", 4, 2, null, new Color(0, 0, 0)), "Choose Compare Program", 4, 2, null, null));
        chooseComparatorPanel.setLayout(new BoxLayout(chooseComparatorPanel, 1));
        Component verticalStrut = Box.createVerticalStrut(20);
        verticalStrut.setMinimumSize(new Dimension(0, 10));
        verticalStrut.setPreferredSize(new Dimension(0, 15));
        chooseComparatorPanel.add(verticalStrut);
        this.rdbtnInternalCompareProgram = new JRadioButton("Built-in Comparator");
        this.rdbtnInternalCompareProgram.setSelected(true);
        this.buttonGroup.add(this.rdbtnInternalCompareProgram);
        chooseComparatorPanel.add(this.rdbtnInternalCompareProgram);
        this.rdbtnPulldownCompareList = new JRadioButton("Select");
        chooseComparatorPanel.add(this.rdbtnPulldownCompareList);
        this.buttonGroup.add(this.rdbtnPulldownCompareList);
        JPanel panelSelectComparator = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panelSelectComparator.getLayout();
        flowLayout.setAlignOnBaseline(true);
        panelSelectComparator.setAlignmentX(0.0f);
        chooseComparatorPanel.add(panelSelectComparator);
        String[] comparators = this.getAvailableComparatorsList();
        this.pulldownSelectComparator = new JComboBox<String>(comparators);
        this.pulldownSelectComparator.setEnabled(false);
        panelSelectComparator.add(this.pulldownSelectComparator);
        this.rdbtnSpecifyCompareProgram = new JRadioButton("User Specified");
        chooseComparatorPanel.add(this.rdbtnSpecifyCompareProgram);
        this.buttonGroup.add(this.rdbtnSpecifyCompareProgram);
        JPanel panelSpecifyComparator = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)panelSpecifyComparator.getLayout();
        flowLayout_1.setAlignOnBaseline(true);
        panelSpecifyComparator.setAlignmentX(0.0f);
        chooseComparatorPanel.add(panelSpecifyComparator);
        this.textUserSpecifyComparator = new JTextField();
        this.textUserSpecifyComparator.setEnabled(false);
        panelSpecifyComparator.add(this.textUserSpecifyComparator);
        this.textUserSpecifyComparator.setColumns(15);
        Component horizontalStrut = Box.createHorizontalStrut(20);
        horizontalStrut.setMinimumSize(new Dimension(40, 0));
        panelChoosers.add(horizontalStrut);
        JPanel chooseViewerPanel = new JPanel();
        chooseViewerPanel.setAlignmentX(0.0f);
        panelChoosers.add(chooseViewerPanel);
        chooseViewerPanel.setPreferredSize(new Dimension(220, 200));
        chooseViewerPanel.setBorder(new TitledBorder(null, "Choose Viewer Program", 4, 2, null, null));
        chooseViewerPanel.setLayout(new BoxLayout(chooseViewerPanel, 1));
        Component verticalStrut_1 = Box.createVerticalStrut(20);
        verticalStrut_1.setPreferredSize(new Dimension(0, 15));
        verticalStrut_1.setMinimumSize(new Dimension(0, 10));
        chooseViewerPanel.add(verticalStrut_1);
        this.rdbtnInternalViewerProgram = new JRadioButton("Built-in Viewer");
        this.rdbtnInternalViewerProgram.setSelected(true);
        this.rdbtnInternalViewerProgram.setPreferredSize(new Dimension(117, 23));
        this.rdbtnInternalViewerProgram.setMinimumSize(new Dimension(117, 23));
        this.rdbtnInternalViewerProgram.setMaximumSize(new Dimension(117, 23));
        this.buttonGroup_1.add(this.rdbtnInternalViewerProgram);
        chooseViewerPanel.add(this.rdbtnInternalViewerProgram);
        this.rdbtnPulldownViewerList = new JRadioButton("Select");
        this.buttonGroup_1.add(this.rdbtnPulldownViewerList);
        chooseViewerPanel.add(this.rdbtnPulldownViewerList);
        JPanel panel = new JPanel();
        panel.setAlignmentX(0.0f);
        chooseViewerPanel.add(panel);
        this.pulldownSelectViewer = new JComboBox<String>(this.getAvailableViewersList());
        this.pulldownSelectViewer.setEnabled(false);
        panel.add(this.pulldownSelectViewer);
        this.rdbtnSpecifyViewerProgram = new JRadioButton("User Specified");
        this.buttonGroup_1.add(this.rdbtnSpecifyViewerProgram);
        chooseViewerPanel.add(this.rdbtnSpecifyViewerProgram);
        JPanel panel_1 = new JPanel();
        panel_1.setEnabled(false);
        chooseViewerPanel.add(panel_1);
        this.textUserSpecifyViewer = new JTextField();
        this.textUserSpecifyViewer.setEnabled(false);
        panel_1.add(this.textUserSpecifyViewer);
        this.textUserSpecifyViewer.setColumns(15);
        JPanel panelFooterButtons = new JPanel();
        optionsPane.add((Component)panelFooterButtons, "South");
        JButton btnRestoreDefaults = new JButton("Restore Defaults");
        panelFooterButtons.add(btnRestoreDefaults);
        Component horizontalGlue_4 = Box.createHorizontalGlue();
        horizontalGlue_4.setPreferredSize(new Dimension(20, 20));
        panelFooterButtons.add(horizontalGlue_4);
        this.btnUpdate = new JButton("Update");
        this.btnUpdate.setEnabled(false);
        panelFooterButtons.add(this.btnUpdate);
        Component horizontalGlue_5 = Box.createHorizontalGlue();
        horizontalGlue_5.setPreferredSize(new Dimension(20, 20));
        panelFooterButtons.add(horizontalGlue_5);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setEnabled(false);
        panelFooterButtons.add(this.btnCancel);
        return panelFooterButtons;
    }

    private JButton getResultsPaneHeaderPanel(JPanel resultsPane) {
        JPanel resultsPaneHeaderPanel = new JPanel();
        resultsPaneHeaderPanel.setBorder(new LineBorder(Color.BLUE, 2));
        resultsPane.add((Component)resultsPaneHeaderPanel, "North");
        resultsPaneHeaderPanel.add(this.getRunIDLabel());
        Component horizontalGlue_1 = Box.createHorizontalGlue();
        horizontalGlue_1.setPreferredSize(new Dimension(20, 20));
        resultsPaneHeaderPanel.add(horizontalGlue_1);
        resultsPaneHeaderPanel.add(this.getProblemTitleLabel());
        Component horizontalGlue = Box.createHorizontalGlue();
        horizontalGlue.setPreferredSize(new Dimension(20, 20));
        resultsPaneHeaderPanel.add(horizontalGlue);
        resultsPaneHeaderPanel.add(this.getTeamNumberLabel());
        Component horizontalGlue_2 = Box.createHorizontalGlue();
        horizontalGlue_2.setPreferredSize(new Dimension(20, 20));
        resultsPaneHeaderPanel.add(horizontalGlue_2);
        resultsPaneHeaderPanel.add(this.getLanguageLabel());
        Component horizontalGlue_8 = Box.createHorizontalGlue();
        horizontalGlue_8.setPreferredSize(new Dimension(20, 20));
        resultsPaneHeaderPanel.add(horizontalGlue_8);
        resultsPaneHeaderPanel.add(this.getNumTestCasesLabel());
        Component horizontalGlue_7 = Box.createHorizontalGlue();
        horizontalGlue_7.setPreferredSize(new Dimension(20, 20));
        resultsPaneHeaderPanel.add(horizontalGlue_7);
        resultsPaneHeaderPanel.add(this.getNumFailedTestCasesLabel());
        this.resultsScrollPane = new JScrollPane();
        resultsPane.add((Component)this.resultsScrollPane, "Center");
        this.resultsTable = new JTable(12, 7);
        this.resultsTable.setValueAt(true, 0, 0);
        this.resultsScrollPane.setViewportView(this.resultsTable);
        JPanel resultsPaneFooterPanel = new JPanel();
        resultsPane.add((Component)resultsPaneFooterPanel, "South");
        this.btnCompareSelected = new JButton("Compare Selected");
        this.btnCompareSelected.setToolTipText("Show comparison between Team and Judge output for selected row(s)");
        this.btnCompareSelected.setEnabled(true);
        this.btnCompareSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiTestSetOutputViewerPane.this.compareFiles(MultiTestSetOutputViewerPane.this.getSelectedRowNums());
            }
        });
        JCheckBox chkboxShowFailuresOnly = new JCheckBox("Show Failures Only", false);
        chkboxShowFailuresOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    MultiTestSetOutputViewerPane.this.loadTableWithFailedTestCases();
                } else {
                    MultiTestSetOutputViewerPane.this.loadTableWithAllTestCases();
                }
            }
        });
        resultsPaneFooterPanel.add(chkboxShowFailuresOnly);
        Component horizontalStrut_1 = Box.createHorizontalStrut(20);
        resultsPaneFooterPanel.add(horizontalStrut_1);
        JButton btnSelectAll = new JButton("Select All");
        btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableModel tm = MultiTestSetOutputViewerPane.this.resultsTable.getModel();
                if (tm != null) {
                    int col = MultiTestSetOutputViewerPane.this.resultsTable.getColumn(MultiTestSetOutputViewerPane.this.columnNames[COLUMN.SELECT_CHKBOX.ordinal()]).getModelIndex();
                    int row = 0;
                    while (row < tm.getRowCount()) {
                        tm.setValueAt(new Boolean(true), row, col);
                        ++row;
                    }
                    MultiTestSetOutputViewerPane.this.btnCompareSelected.setEnabled(true);
                }
            }
        });
        resultsPaneFooterPanel.add(btnSelectAll);
        Component horizontalStrut_3 = Box.createHorizontalStrut(20);
        resultsPaneFooterPanel.add(horizontalStrut_3);
        JButton btnUnselectAll = new JButton("Unselect All");
        btnUnselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableModel tm = MultiTestSetOutputViewerPane.this.resultsTable.getModel();
                if (tm != null) {
                    int col = MultiTestSetOutputViewerPane.this.resultsTable.getColumn(MultiTestSetOutputViewerPane.this.columnNames[COLUMN.SELECT_CHKBOX.ordinal()]).getModelIndex();
                    int row = 0;
                    while (row < tm.getRowCount()) {
                        tm.setValueAt(new Boolean(false), row, col);
                        ++row;
                    }
                    MultiTestSetOutputViewerPane.this.btnCompareSelected.setEnabled(false);
                }
            }
        });
        resultsPaneFooterPanel.add(btnUnselectAll);
        Component horizontalStrut_2 = Box.createHorizontalStrut(20);
        resultsPaneFooterPanel.add(horizontalStrut_2);
        this.btnCompareSelected.setEnabled(true);
        resultsPaneFooterPanel.add(this.btnCompareSelected);
        Component horizontalGlue_3 = Box.createHorizontalGlue();
        horizontalGlue_3.setPreferredSize(new Dimension(20, 20));
        resultsPaneFooterPanel.add(horizontalGlue_3);
        final JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MultiTestSetOutputViewerPane.this.currentComparator != null) {
                    MultiTestSetOutputViewerPane.this.currentComparator.dispose();
                }
                Window parentFrame = SwingUtilities.getWindowAncestor(btnClose);
                parentFrame.dispose();
            }
        });
        resultsPaneFooterPanel.add(btnClose);
        return btnClose;
    }

    private int[] getSelectedRowNums() {
        ArrayList<Integer> selectedRows = new ArrayList<Integer>();
        int i = 0;
        while (i < this.resultsTable.getRowCount()) {
            if (((Boolean)this.resultsTable.getValueAt(i, COLUMN.SELECT_CHKBOX.ordinal())).booleanValue()) {
                selectedRows.add(new Integer(i));
            }
            ++i;
        }
        Integer[] selectedRowNumbers = selectedRows.toArray(new Integer[selectedRows.size()]);
        int[] intArray = new int[selectedRowNumbers.length];
        int i2 = 0;
        while (i2 < intArray.length) {
            intArray[i2] = selectedRowNumbers[i2];
            ++i2;
        }
        return intArray;
    }

    private JLabel getNumTestCasesLabel() {
        if (this.lblNumTestCases == null) {
            this.lblNumTestCases = new JLabel("Test Cases: XXX");
        }
        return this.lblNumTestCases;
    }

    private JLabel getNumFailedTestCasesLabel() {
        if (this.lblNumFailedTestCases == null) {
            this.lblNumFailedTestCases = new JLabel("Failed: XXX");
        }
        return this.lblNumFailedTestCases;
    }

    private JLabel getLanguageLabel() {
        if (this.lblLanguage == null) {
            this.lblLanguage = new JLabel("Language: XXX");
        }
        return this.lblLanguage;
    }

    private JLabel getRunIDLabel() {
        if (this.lblRunID == null) {
            this.lblRunID = new JLabel("Run ID: XXX");
        }
        return this.lblRunID;
    }

    private JLabel getTeamNumberLabel() {
        if (this.lblTeamNumber == null) {
            this.lblTeamNumber = new JLabel("Team: XXX");
        }
        return this.lblTeamNumber;
    }

    private JLabel getProblemTitleLabel() {
        if (this.lblProblemTitle == null) {
            this.lblProblemTitle = new JLabel("Problem: XXX");
        }
        return this.lblProblemTitle;
    }

    private void populateGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int spaceIndex;
                while (MultiTestSetOutputViewerPane.this.getMultiTestSetTabbedPane().getTabCount() > 2) {
                    MultiTestSetOutputViewerPane.this.getMultiTestSetTabbedPane().removeTabAt(1);
                }
                MultiTestSetOutputViewerPane.this.populateCompilerOutput();
                MultiTestSetOutputViewerPane.this.getMultiTestSetTabbedPane().setSelectedIndex(0);
                String letter = MultiTestSetOutputViewerPane.this.currentProblem.getLetter();
                String shortName = MultiTestSetOutputViewerPane.this.currentProblem.getShortName();
                if (letter == null || letter.equals("null") || letter.equals("")) {
                    Problem[] problems = MultiTestSetOutputViewerPane.this.getContest().getProblems();
                    int i = 0;
                    while (i < problems.length) {
                        if (problems[i].equals(MultiTestSetOutputViewerPane.this.currentProblem)) {
                            int asciiLetter = i + 65;
                            letter = Character.toString((char)asciiLetter);
                        }
                        ++i;
                    }
                }
                if ((shortName == null || shortName.equals("")) && (spaceIndex = (shortName = MultiTestSetOutputViewerPane.this.currentProblem.getDisplayName().toLowerCase().trim()).indexOf(" ")) > 0) {
                    shortName = shortName.substring(0, spaceIndex);
                }
                MultiTestSetOutputViewerPane.this.getProblemTitleLabel().setText("Problem:  " + letter + " - " + shortName);
                MultiTestSetOutputViewerPane.this.getTeamNumberLabel().setText("Team:  " + MultiTestSetOutputViewerPane.this.currentRun.getSubmitter().getClientNumber());
                MultiTestSetOutputViewerPane.this.getRunIDLabel().setText("Run ID:  " + MultiTestSetOutputViewerPane.this.currentRun.getNumber());
                MultiTestSetOutputViewerPane.this.getLanguageLabel().setText("Language:  " + MultiTestSetOutputViewerPane.this.getCurrentRunLanguageName());
                RunTestCase[] testCases = MultiTestSetOutputViewerPane.this.getCurrentTestCases(MultiTestSetOutputViewerPane.this.currentRun);
                if (testCases == null) {
                    MultiTestSetOutputViewerPane.this.getNumTestCasesLabel().setText("Test Cases:  0");
                } else {
                    MultiTestSetOutputViewerPane.this.getNumTestCasesLabel().setText("Test Cases:  " + testCases.length);
                    System.out.println("MTSVPane.populateGUI(): loading " + testCases.length + " test cases into GUI pane...");
                }
                int failedCount = MultiTestSetOutputViewerPane.this.getNumFailedTestCases(testCases);
                if (!MultiTestSetOutputViewerPane.this.currentProblem.isValidatedProblem()) {
                    MultiTestSetOutputViewerPane.this.getNumFailedTestCasesLabel().setForeground(Color.black);
                    MultiTestSetOutputViewerPane.this.getNumFailedTestCasesLabel().setText("");
                } else if (failedCount > 0) {
                    MultiTestSetOutputViewerPane.this.getNumFailedTestCasesLabel().setForeground(Color.red);
                    MultiTestSetOutputViewerPane.this.getNumFailedTestCasesLabel().setText("Failed:  " + failedCount);
                } else if (testCases == null || testCases.length == 0) {
                    MultiTestSetOutputViewerPane.this.getNumFailedTestCasesLabel().setForeground(Color.ORANGE);
                    MultiTestSetOutputViewerPane.this.getNumFailedTestCasesLabel().setText("ERROR");
                } else {
                    MultiTestSetOutputViewerPane.this.getNumFailedTestCasesLabel().setForeground(Color.green);
                    MultiTestSetOutputViewerPane.this.getNumFailedTestCasesLabel().setText("ALL PASSED");
                }
                MultiTestSetOutputViewerPane.this.resultsTable = MultiTestSetOutputViewerPane.this.getResultsTable(testCases);
                MultiTestSetOutputViewerPane.this.resultsScrollPane.setViewportView(MultiTestSetOutputViewerPane.this.resultsTable);
            }
        });
    }

    public boolean loadFile(JTextArea jPane, String filename) {
        try {
            jPane.setFont(new Font("Courier", 0, 12));
            BufferedReader inFile = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            StringBuffer sb = new StringBuffer();
            char[] cbuf = new char[8000];
            int n = inFile.read(cbuf);
            while (n > -1) {
                sb.append(cbuf, 0, n);
                n = inFile.read(cbuf);
            }
            inFile.close();
            inFile = null;
            String s = sb.toString();
            jPane.append(s);
            jPane.setCaretPosition(0);
            return true;
        }
        catch (Exception e) {
            System.out.println("MultipleFileViewer class: exception " + e);
            return false;
        }
    }

    public boolean addFilePane(String title, String filename) {
        if (title == null) {
            title = filename;
        }
        if (title.length() < 1) {
            title = filename;
        }
        JTextArea textArea = new JTextArea();
        textArea.setBounds(0, 0, 11, 6);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(textArea);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)scrollPane, "Center");
        this.getMultiTestSetTabbedPane().insertTab(title, null, jPanel, null, 1);
        return this.loadFile(textArea, filename);
    }

    private void populateCompilerOutput() {
        String outputFile = String.valueOf(this.executableDir) + File.separatorChar + "cstdout.pc2";
        File file = new File(outputFile);
        if (file.isFile() && file.length() > 0L) {
            this.addFilePane("Compiler stdout", outputFile);
        }
        if ((file = new File(outputFile = String.valueOf(this.executableDir) + File.separatorChar + "cstderr.pc2")).isFile() && file.length() > 0L) {
            this.addFilePane("Compiler stderr", outputFile);
        }
    }

    private int getNumFailedTestCases(RunTestCase[] testCases) {
        int failed = 0;
        if (testCases != null) {
            int i = 0;
            while (i < testCases.length) {
                if (!testCases[i].isPassed()) {
                    ++failed;
                }
                ++i;
            }
        }
        return failed;
    }

    private String getCurrentRunLanguageName() {
        Language language = this.getContest().getLanguage(this.currentRun.getLanguageId());
        return language.toString();
    }

    private RunTestCase[] getCurrentTestCases(Run run) {
        RunTestCase[] testCases = null;
        RunTestCase[] allTestCases = run.getRunTestCases();
        if (allTestCases != null && allTestCases.length > 0) {
            testCases = new RunTestCase[allTestCases[allTestCases.length - 1].getTestNumber()];
            int i = allTestCases.length - 1;
            while (i >= 0) {
                RunTestCase runTestCase = allTestCases[i];
                int testCaseNumIndex = runTestCase.getTestNumber() - 1;
                if (testCases[testCaseNumIndex] == null) {
                    testCases[testCaseNumIndex] = runTestCase;
                    if (testCaseNumIndex == 0) break;
                }
                --i;
            }
        }
        return testCases;
    }

    private void loadTableWithAllTestCases() {
        RunTestCase[] allTestCases = this.getCurrentTestCases(this.currentRun);
        this.resultsTable = this.getResultsTable(allTestCases);
        this.resultsScrollPane.setViewportView(this.resultsTable);
    }

    private void loadTableWithFailedTestCases() {
        RunTestCase[] allTestCases = this.getCurrentTestCases(this.currentRun);
        Vector<RunTestCase> failedTestCaseList = new Vector<RunTestCase>();
        int i = 0;
        while (i < allTestCases.length) {
            if (!allTestCases[i].isPassed()) {
                failedTestCaseList.add(allTestCases[i]);
            }
            ++i;
        }
        RunTestCase[] failedTestCases = failedTestCaseList.toArray(new RunTestCase[failedTestCaseList.size()]);
        this.resultsTable = this.getResultsTable(failedTestCases);
        this.resultsScrollPane.setViewportView(this.resultsTable);
    }

    private JTable getResultsTable(RunTestCase[] testCases) {
        TestCaseResultsTableModel tableModel = new TestCaseResultsTableModel(testCases, (Object[])this.columnNames);
        JTable localResultsTable = new JTable(tableModel);
        localResultsTable.setSelectionMode(2);
        localResultsTable.setFillsViewportHeight(true);
        localResultsTable.setRowSelectionAllowed(false);
        localResultsTable.getTableHeader().setReorderingAllowed(false);
        localResultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MultiTestSetOutputViewerPane.this.btnCompareSelected.setEnabled(MultiTestSetOutputViewerPane.this.getSelectedRowNums().length > 0);
            }
        });
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        localResultsTable.getColumn(this.columnNames[COLUMN.DATASET_NUM.ordinal()]).setCellRenderer(centerRenderer);
        localResultsTable.getColumn(this.columnNames[COLUMN.SELECT_CHKBOX.ordinal()]).setCellRenderer(new CheckBoxRenderer());
        localResultsTable.getColumn(this.columnNames[COLUMN.TEAM_OUTPUT_VIEW.ordinal()]).setCellRenderer(new LinkRenderer());
        localResultsTable.getColumn(this.columnNames[COLUMN.TEAM_OUTPUT_COMPARE.ordinal()]).setCellRenderer(new LinkRenderer());
        localResultsTable.getColumn(this.columnNames[COLUMN.JUDGE_OUTPUT.ordinal()]).setCellRenderer(new LinkRenderer());
        localResultsTable.getColumn(this.columnNames[COLUMN.JUDGE_DATA.ordinal()]).setCellRenderer(new LinkRenderer());
        localResultsTable.getColumn(this.columnNames[COLUMN.VALIDATOR_OUTPUT.ordinal()]).setCellRenderer(new LinkRenderer());
        localResultsTable.getColumn(this.columnNames[COLUMN.VALIDATOR_ERR.ordinal()]).setCellRenderer(new LinkRenderer());
        localResultsTable.getColumn(this.columnNames[COLUMN.RESULT.ordinal()]).setCellRenderer(new PassFailCellRenderer());
        localResultsTable.getColumn(this.columnNames[COLUMN.TIME.ordinal()]).setCellRenderer(new RightJustifyRenderer());
        localResultsTable.getColumn(this.columnNames[COLUMN.SELECT_CHKBOX.ordinal()]).setPreferredWidth(15);
        localResultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JTable target = (JTable)e.getSource();
                int row = target.getSelectedRow();
                int column = target.getSelectedColumn();
                System.out.println("MTSVPane.mouseClicked(): row=" + row + ", col=" + column);
                if (column == COLUMN.TEAM_OUTPUT_VIEW.ordinal() || column == COLUMN.JUDGE_OUTPUT.ordinal() || column == COLUMN.JUDGE_DATA.ordinal() || column == COLUMN.VALIDATOR_OUTPUT.ordinal() || column == COLUMN.VALIDATOR_ERR.ordinal()) {
                    MultiTestSetOutputViewerPane.this.viewFile(row, column);
                } else if (column == COLUMN.TEAM_OUTPUT_COMPARE.ordinal() || e.getClickCount() > 1) {
                    int[] rows = new int[]{row};
                    MultiTestSetOutputViewerPane.this.compareFiles(rows);
                }
            }
        });
        return localResultsTable;
    }

    private String[] getAvailableViewersList() {
        return new String[]{"gvim --nofork -n -M", "notepad", "write"};
    }

    private void enableUpdateCancel(String theCurrentComparatorCmd, String theCurrentViewerCmd) {
        boolean state = true;
        if (theCurrentComparatorCmd.equals(this.lastComparator) && theCurrentViewerCmd.equals(this.lastViewer)) {
            state = false;
        }
        this.btnUpdate.setEnabled(state);
        this.btnCancel.setEnabled(state);
    }

    private String[] getAvailableComparatorsList() {
        return new String[]{"gvim --nofork -n -M -d"};
    }

    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    protected void viewFile(int row, int col) {
        if (col != COLUMN.TEAM_OUTPUT_VIEW.ordinal() && col != COLUMN.JUDGE_OUTPUT.ordinal() && col != COLUMN.JUDGE_DATA.ordinal() && col != COLUMN.VALIDATOR_OUTPUT.ordinal() && col != COLUMN.VALIDATOR_ERR.ordinal()) {
            if (this.log != null) {
                this.log.log(Log.WARNING, "MTSVPane.viewFile(): invalid column number for file viewing request: " + col);
            } else {
                System.err.println("Invalid column number for file viewing request: " + col);
            }
            return;
        }
        if (this.getCurrentViewer() != null) {
            this.getCurrentViewer().dispose();
            this.currentViewer = null;
        }
        this.getCurrentViewer().setViewerCommand(this.currentViewerCmd);
        String title = "<unknown>";
        if (col == COLUMN.TEAM_OUTPUT_VIEW.ordinal()) {
            title = "Team Output";
        } else if (col == COLUMN.JUDGE_OUTPUT.ordinal()) {
            title = "Judge's Output";
        } else if (col == COLUMN.JUDGE_DATA.ordinal()) {
            title = "Judge's Data";
        } else if (col == COLUMN.VALIDATOR_OUTPUT.ordinal()) {
            title = "Validator STDOUT";
        } else if (col == COLUMN.VALIDATOR_ERR.ordinal()) {
            title = "Validator STDERR";
        }
        String targetFile = this.getFileForTableCell(row, col);
        if (targetFile != null) {
            int testCaseNum = row + 1;
            this.showFile(this.getCurrentViewer(), targetFile, title, "Test Case " + testCaseNum, true);
        } else if (col == COLUMN.TEAM_OUTPUT_VIEW.ordinal()) {
            String msg = "Unable to find file for table cell (" + row + "," + col + ") try executing the run 1st.";
            if (this.log != null) {
                this.log.log(Log.WARNING, "MTSVPane.viewFile(): " + msg);
            } else {
                System.err.println("MTSVPane.viewFile(): " + msg);
            }
            JOptionPane.showMessageDialog(this.getParentFrame(), msg, "File Not Found", 2);
        } else {
            String msg = "No " + title + " found";
            JOptionPane.showMessageDialog(this.getParentFrame(), msg, "File Not Found", 1);
        }
    }

    private void compareFiles(int[] rows) {
        System.out.print("MTSVPane.compareFiles(): displaying comparison of files for test case(s) ");
        int i = 0;
        while (i < rows.length) {
            System.out.print(String.valueOf(new Integer((String)this.resultsTable.getModel().getValueAt(rows[i], 1))) + " ");
            ++i;
        }
        System.out.println();
        int[] testCases = new int[rows.length];
        String[] judgesOutputFileNames = new String[rows.length];
        String[] judgesDataFileNames = new String[rows.length];
        String[] teamOutputFileNames = new String[rows.length];
        String[] judgesAnswerFiles = this.currentProblemDataFiles.getFullJudgesAnswerFilenames(this.getContest(), this.executableDir);
        String[] judgesDataFiles = this.currentProblemDataFiles.getFullJudgesDataFilenames(this.getContest(), this.executableDir);
        int i2 = 0;
        while (i2 < rows.length) {
            testCases[i2] = new Integer((String)this.resultsTable.getModel().getValueAt(rows[i2], 1));
            int testCaseIndex = testCases[i2] - 1;
            if (judgesAnswerFiles.length > testCaseIndex) {
                judgesOutputFileNames[i2] = judgesAnswerFiles[testCaseIndex];
            }
            if (judgesDataFiles.length > testCaseIndex) {
                judgesDataFileNames[i2] = judgesDataFiles[testCaseIndex];
            }
            if (this.currentTeamOutputFileNames == null || this.currentTeamOutputFileNames.length < teamOutputFileNames.length) {
                if (this.log != null) {
                    this.log.warning("MTSVPane.compareFiles(): invalid team output file names array");
                } else {
                    System.err.println("MTSVPane.compareFiles(): invalid team output file names array");
                }
            } else {
                teamOutputFileNames[i2] = this.currentTeamOutputFileNames[testCases[i2] - 1];
            }
            ++i2;
        }
        this.getCurrentComparator().setData(this.currentRun.getNumber(), testCases, teamOutputFileNames, judgesOutputFileNames, judgesDataFileNames);
        this.getCurrentComparator().setVisible(true);
    }

    private MultiFileComparator getCurrentComparator() {
        if (this.currentComparator == null) {
            this.currentComparator = new MultiFileComparator();
            this.currentComparator.setContestAndController(this.getContest(), this.getController());
        }
        return this.currentComparator;
    }

    private String getExecuteDir() {
        if (this.currentRunFiles == null) {
            System.err.println("runFiles for run are null from setData()");
            return null;
        }
        if (this.currentRunFiles == null) {
            System.err.println("runFiles.getMainFile is null");
            return null;
        }
        Executable tempExecutable = new Executable(this.getContest(), this.getController(), this.currentRun, this.currentRunFiles);
        String exeDir = tempExecutable.getExecuteDirectoryName();
        return exeDir;
    }

    private String getFileForTableCell(int row, int col) {
        Problem prob = this.getContest().getProblem(this.currentRun.getProblemId());
        ProblemDataFiles problemDataFiles = this.getController().getProblemDataFiles(prob);
        String returnFile = null;
        if (col == COLUMN.TEAM_OUTPUT_VIEW.ordinal() || col == COLUMN.TEAM_OUTPUT_COMPARE.ordinal()) {
            if (this.currentTeamOutputFileNames != null || this.currentTeamOutputFileNames.length >= row) {
                returnFile = this.currentTeamOutputFileNames[row] == null ? null : this.currentTeamOutputFileNames[row];
            }
        } else if (col == COLUMN.JUDGE_OUTPUT.ordinal()) {
            String[] answerFiles = problemDataFiles.getFullJudgesAnswerFilenames(this.getContest(), this.executableDir);
            returnFile = answerFiles != null && row < answerFiles.length ? answerFiles[row] : null;
        } else if (col == COLUMN.JUDGE_DATA.ordinal()) {
            String[] inputDataFiles = problemDataFiles.getFullJudgesDataFilenames(this.getContest(), this.executableDir);
            returnFile = inputDataFiles != null && row < inputDataFiles.length ? inputDataFiles[row] : null;
        } else if (col == COLUMN.VALIDATOR_OUTPUT.ordinal()) {
            if (this.currentValidatorOutputFileNames != null && this.currentValidatorOutputFileNames.length >= row) {
                returnFile = row >= this.currentValidatorOutputFileNames.length ? null : this.currentValidatorOutputFileNames[row];
            }
        } else if (col == COLUMN.VALIDATOR_ERR.ordinal()) {
            if (this.currentValidatorStderrFileNames != null && this.currentValidatorStderrFileNames.length >= row) {
                returnFile = row >= this.currentValidatorStderrFileNames.length ? null : this.currentValidatorStderrFileNames[row];
            }
        } else {
            returnFile = null;
        }
        return returnFile;
    }

    private void showFile(MultipleFileViewer fileViewer, String file, String title, String tabLabel, boolean visible) {
        System.out.println("MTSVPane.showFile():");
        String viewerString = "<null>";
        if (fileViewer != null) {
            viewerString = fileViewer.getClass().toString();
        }
        System.out.println("  Viewer='" + viewerString + "'" + "  File='" + file + "'" + "  Title='" + title + "'" + "  setVisible='" + visible + "'");
        if (fileViewer == null || file == null) {
            this.log = this.getController().getLog();
            this.log.log(Log.WARNING, "MTSVPane.showFile(): fileViewer or file is null");
            JOptionPane.showMessageDialog(this.getParentFrame(), "System Error: null fileViewer or file; contact Contest Administrator (check logs)", "System Error", 0);
            return;
        }
        File myFile = new File(file);
        if (!myFile.isFile()) {
            JOptionPane.showMessageDialog(this.getParentFrame(), "Error: could not find file: " + file, "File Missing", 0);
            this.log = this.getController().getLog();
            this.log.warning("MTSVPane.showFile(): could not find file " + file);
            return;
        }
        fileViewer.setTitle(title);
        fileViewer.addFilePane(tabLabel, file);
        fileViewer.enableCompareButton(false);
        fileViewer.setInformationLabelText("File: " + myFile.getName());
        if (visible) {
            fileViewer.setVisible(true);
        }
    }

    public void setData(Run run, RunFiles runFiles, Problem problem, ProblemDataFiles problemDataFiles) {
        this.currentRun = run;
        this.currentRunFiles = runFiles;
        this.currentProblem = problem;
        this.currentProblemDataFiles = problemDataFiles;
        this.executableDir = this.getExecuteDir();
        this.populateGUI();
        try {
            this.currentProblemDataFiles.checkAndCreateFiles(this.getContest(), this.executableDir);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this.getParentFrame(), "Error: could not find file: " + e.getMessage(), "File Missing", 0);
            if (this.log != null) {
                this.log.warning("MTSVPane.compareFiles(): could not find file " + e.getMessage());
            }
            System.err.println("MTSVPane.compareFiles(): could not find file " + e.getMessage());
        }
    }

    public void setTeamOutputFileNames(String[] filenames) {
        this.currentTeamOutputFileNames = filenames;
    }

    public JTabbedPane getMultiTestSetTabbedPane() {
        if (this.multiTestSetTabbedPane == null) {
            this.multiTestSetTabbedPane = new JTabbedPane(1);
        }
        return this.multiTestSetTabbedPane;
    }

    public void setValidatorOutputFileNames(String[] filenames) {
        this.currentValidatorOutputFileNames = filenames;
    }

    public void setValidatorStderrFileNames(String[] filenames) {
        this.currentValidatorStderrFileNames = filenames;
    }

    static enum COLUMN {
        SELECT_CHKBOX,
        DATASET_NUM,
        RESULT,
        TIME,
        TEAM_OUTPUT_VIEW,
        TEAM_OUTPUT_COMPARE,
        JUDGE_OUTPUT,
        JUDGE_DATA,
        VALIDATOR_OUTPUT,
        VALIDATOR_ERR;

    }

    public class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public CheckBoxRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected((Boolean)value);
            return this;
        }
    }

    public class LinkRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public void setValue(Object value) {
            this.setForeground(Color.BLUE);
            this.setText(((JLabel)value).getText());
            Font font = this.getFont();
            HashMap map = new HashMap(font.getAttributes());
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            this.setFont(font.deriveFont(map));
            this.setHorizontalAlignment(0);
        }
    }

    public class PassFailCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public void setValue(Object value) {
            String testResult = ((JLabel)value).getText();
            if (!MultiTestSetOutputViewerPane.this.currentProblem.isValidatedProblem()) {
                this.setBackground(Color.yellow);
                this.setText("N/A");
            } else if (testResult.equalsIgnoreCase("Pass")) {
                this.setBackground(Color.green);
                this.setForeground(Color.black);
                this.setText("Pass");
            } else if (testResult.equalsIgnoreCase("Fail")) {
                this.setBackground(Color.red);
                this.setForeground(Color.white);
                this.setText("Fail");
            } else {
                this.setBackground(Color.yellow);
                this.setText("??");
                MultiTestSetOutputViewerPane.this.log = MultiTestSetOutputViewerPane.this.getController().getLog();
                MultiTestSetOutputViewerPane.this.log.log(Log.SEVERE, "MTSV PassFailCellRenderer: unknown pass/fail result: ", value);
            }
            this.setHorizontalAlignment(2);
            this.setBorder(new EmptyBorder(0, 30, 0, 0));
        }
    }

    public class RightJustifyRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public void setValue(Object value) {
            this.setHorizontalAlignment(4);
            this.setBorder(new EmptyBorder(0, 0, 0, 30));
            this.setText((String)value);
        }
    }

    private static enum TYPES {
        INTERNAL,
        LIST,
        USER;

    }
}

