/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.model.SerializedFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JSerializFilePicker
extends JPanel {
    private static final long serialVersionUID = 2669306324313513106L;
    private SerializedFile serializedFile = null;
    private SerializedFile newSerializedFile = null;
    private JButton pickFileButton = null;
    private String lastDirectory = null;
    private JLabel fileNameLabel = null;

    public JSerializFilePicker() {
        this.initialize();
    }

    private void initialize() {
        this.fileNameLabel = new JLabel();
        this.fileNameLabel.setText("");
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(5);
        borderLayout.setVgap(2);
        this.setLayout(borderLayout);
        this.setSize(new Dimension(420, 35));
        this.setPreferredSize(new Dimension(420, 35));
        this.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        this.add((Component)this.getPickFileButton(), "East");
        this.add((Component)this.fileNameLabel, "Center");
    }

    private JButton getPickFileButton() {
        if (this.pickFileButton == null) {
            this.pickFileButton = new JButton();
            this.pickFileButton.setName("Select");
            this.pickFileButton.setText("Select");
            this.pickFileButton.setPreferredSize(new Dimension(90, 90));
            this.pickFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JSerializFilePicker.this.selectAndLoadAFile();
                }
            });
        }
        return this.pickFileButton;
    }

    protected void selectAndLoadAFile() {
        SerializedFile theFile = this.newSerializedFile;
        if (theFile == null) {
            theFile = this.serializedFile;
        }
        System.out.println("debug 22 selectAndLoadAFile " + this.isModified() + " " + this.serializedFile + " " + this.newSerializedFile);
        SerializedFile file = this.selectFile(theFile);
        if (file != null) {
            this.newSerializedFile = file;
            this.updateFileLabel(this.newSerializedFile);
        }
    }

    private void updateFileLabel(SerializedFile sFile) {
        this.fileNameLabel.setText(sFile.getName());
        this.fileNameLabel.setToolTipText(sFile.getAbsolutePath());
        System.out.println("debug 22 updateFileLabel " + this.isModified() + " " + this.serializedFile + " " + this.newSerializedFile);
    }

    private SerializedFile selectFile(SerializedFile file) {
        String startDir = file == null ? this.lastDirectory : this.getParentDirectory(file.getAbsolutePath());
        JFileChooser chooser = new JFileChooser(startDir);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.lastDirectory = chooser.getCurrentDirectory().toString();
            return new SerializedFile(chooser.getSelectedFile().getAbsolutePath());
        }
        chooser = null;
        return null;
    }

    private String getParentDirectory(String path) {
        if (!"".equals(path)) {
            File file = new File(path);
            return file.getParent();
        }
        return "";
    }

    public boolean isModified() {
        if (this.serializedFile == null) {
            return this.newSerializedFile != null;
        }
        if (this.newSerializedFile == null) {
            return false;
        }
        return !this.serializedFile.equals(this.newSerializedFile);
    }

    public SerializedFile getSerializedFile() {
        System.out.println("debug 22 getSerializedFile " + this.isModified() + " " + this.serializedFile + " " + this.newSerializedFile);
        if (this.isModified()) {
            return this.newSerializedFile;
        }
        return this.serializedFile;
    }

    public void setSerializedFile(SerializedFile serializedFile) {
        this.serializedFile = serializedFile;
        this.newSerializedFile = null;
        this.updateFileLabel(serializedFile);
    }
}

