/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.api.exceptions.LoadContestDataException;
import edu.csus.ecs.pc2.core.ContestImporter;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestComparison;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.ProblemsReport;
import edu.csus.ecs.pc2.imports.ccs.ContestYAMLLoader;
import edu.csus.ecs.pc2.ui.FileNameExtensionFilter;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.ReportFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ImportDataPane
extends JPanePlugin {
    private static final long serialVersionUID = 8507451908248919433L;
    private JButton importButton = null;
    private String lastDirectory = null;
    private ContestYAMLLoader loader = new ContestYAMLLoader();
    private static final String NL = System.getProperty("line.separator");
    private JPanel buttonPane = null;
    private JButton importPasswordsButton = null;
    private JPanel centerPane = null;
    private ReportFrame reportFrame = null;

    public ImportDataPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(494, 242));
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getCenterPane(), "Center");
    }

    @Override
    public String getPluginTitle() {
        return "Import Data Pane";
    }

    private JButton getImportButton() {
        if (this.importButton == null) {
            this.importButton = new JButton();
            this.importButton.setText("Import contest.yaml");
            this.importButton.setToolTipText("Import Contest and Problem YAML");
            this.importButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportDataPane.this.selectAndImportContestConfiguration();
                }
            });
        }
        return this.importButton;
    }

    protected void selectAndImportContestConfiguration() {
        String filename = null;
        try {
            filename = this.selectYamlFileName(this.lastDirectory);
        }
        catch (IOException e) {
            this.logException("Problem selecting filename", e);
            this.showMessage("Problem selecting filename " + e.getMessage());
        }
        if (filename != null) {
            if (filename.endsWith("contest.yaml")) {
                try {
                    this.checkAndLoadYAML(filename);
                }
                catch (Exception e) {
                    this.logException("Error loading contest.yaml", e);
                    this.showMessage("Error loading contest.yaml " + e.getMessage());
                }
            } else {
                this.showMessage("Please select a contest.yaml file");
            }
        }
    }

    protected void showReportFrame(IInternalContest inContest) {
        if (this.reportFrame == null) {
            this.reportFrame = new ReportFrame();
            this.reportFrame.setContestAndController(inContest, this.getController());
        }
        FrameUtilities.setFramePosition(this.reportFrame, FrameUtilities.HorizontalPosition.RIGHT, FrameUtilities.VerticalPosition.CENTER);
        this.reportFrame.setVisible(true);
    }

    private void checkAndLoadYAML(String filename) {
        this.getController().getLog().info("Loading contest.yaml from " + filename);
        String directoryName = new File(filename).getParent();
        IInternalContest newContest = null;
        String contestSummary = "";
        int result = 1;
        try {
            boolean loadDataFileContents = true;
            String value = IniFile.getValue("server.externalfiles");
            if (value != null && value.equalsIgnoreCase("yes")) {
                loadDataFileContents = false;
            }
            newContest = this.loader.fromYaml(null, directoryName, loadDataFileContents);
            contestSummary = new ContestComparison().comparisonList(this.getContest(), newContest);
            if (Utilities.isDebugMode()) {
                Utilities.viewReport(new ProblemsReport(), "Title: " + newContest.getTitle(), newContest, this.getController());
            }
            result = FrameUtilities.yesNoCancelDialog(this, "Import" + NL + contestSummary, "Import Contest Settings");
        }
        catch (Exception e) {
            this.logException("Unable to load contest YAML from " + filename, e);
            this.showMessage("Problem loading file(s), check log.  " + e.getMessage());
        }
        if (result != 0) {
            this.getLog().info("No YAML file selected to load");
            return;
        }
        if (newContest != null) {
            ContestImporter contestImporter = new ContestImporter();
            try {
                contestImporter.sendContestSettingsToServer(this.getController(), this.getContest(), newContest);
            }
            catch (LoadContestDataException e) {
                this.logException("LoadContestDataException for " + filename, e);
                this.logNoteList(contestImporter.getNoteList());
                this.showMessage("Problem loading contest data file(s) - " + e.getMessage());
            }
        }
        this.showMessage("All contest settings sent to server" + NL + contestSummary);
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string, "Message", 1);
    }

    public File selectYAMLFileDialog(Component parent, String startDirectory) {
        JFileChooser chooser = new JFileChooser(startDirectory);
        chooser.setFileSelectionMode(0);
        FileNameExtensionFilter filterYAML = new FileNameExtensionFilter("YAML document (*.yaml)", "yaml");
        chooser.addChoosableFileFilter(filterYAML);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filterYAML);
        int action = chooser.showOpenDialog(parent);
        switch (action) {
            case 0: {
                File file = chooser.getSelectedFile();
                this.lastDirectory = chooser.getCurrentDirectory().toString();
                return file;
            }
        }
        return null;
    }

    public File selectTextFileDialog(Component parent, String startDirectory) {
        JFileChooser chooser = new JFileChooser(startDirectory);
        chooser.setFileSelectionMode(0);
        FileNameExtensionFilter filterText = new FileNameExtensionFilter("Text document (*.txt)", "txt");
        chooser.addChoosableFileFilter(filterText);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filterText);
        int action = chooser.showOpenDialog(parent);
        switch (action) {
            case 0: {
                File file = chooser.getSelectedFile();
                this.lastDirectory = chooser.getCurrentDirectory().toString();
                return file;
            }
        }
        return null;
    }

    private String selectTextFileName(String dirname) throws IOException {
        String chosenFile = null;
        File file = this.selectTextFileDialog(this, this.lastDirectory);
        if (file != null) {
            chosenFile = file.getCanonicalFile().toString();
            return chosenFile;
        }
        return null;
    }

    private String selectYamlFileName(String dirname) throws IOException {
        String chosenFile = null;
        File file = this.selectYAMLFileDialog(this, this.lastDirectory);
        if (file != null) {
            chosenFile = file.getCanonicalFile().toString();
            return chosenFile;
        }
        return null;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(35);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getImportButton(), null);
            this.buttonPane.add((Component)this.getImportPasswordsButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getImportPasswordsButton() {
        if (this.importPasswordsButton == null) {
            this.importPasswordsButton = new JButton();
            this.importPasswordsButton.setText("Import Passwords");
            this.importPasswordsButton.setToolTipText("Import passwords.txt");
            this.importPasswordsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportDataPane.this.selectAndImportPasswordsFile();
                }
            });
        }
        return this.importPasswordsButton;
    }

    protected void selectAndImportPasswordsFile() {
        String filename = null;
        try {
            filename = this.selectTextFileName(this.lastDirectory);
        }
        catch (IOException e) {
            this.logException("Problem selecting filename", e);
            this.showMessage("Problem selecting filename " + e.getMessage());
        }
        if (filename != null) {
            if (filename.endsWith("passwords.txt")) {
                try {
                    this.checkAndLoadPasswordsFile(filename);
                }
                catch (FileNotFoundException fnfe) {
                    this.logException("File not found loading passwords.txt ", fnfe);
                    this.showMessage("File not found " + fnfe.getMessage());
                }
                catch (Exception e) {
                    this.logException("Error loading passwords.txt", e);
                    this.showMessage("Error loading passwords.txt " + e.getMessage());
                }
            } else {
                this.showMessage("Please select a passwords.txt file");
            }
        }
    }

    private void checkAndLoadPasswordsFile(String filename) throws Exception {
        String[] lines;
        try {
            lines = Utilities.loadFile(filename);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(filename);
        }
        if (lines.length < 1) {
            throw new FileNotFoundException(filename);
        }
        int numberOfPasswords = lines.length;
        Vector<Account> accounts = this.getContest().getAccounts(ClientType.Type.TEAM, this.getContest().getSiteNumber());
        int numberOfTeams = accounts.size();
        if (numberOfPasswords > numberOfTeams) {
            throw new Exception("Too few accounts, expecting " + numberOfPasswords + " accounts, found " + numberOfTeams);
        }
        int result = FrameUtilities.yesNoCancelDialog(this, "Update " + numberOfPasswords + " teams passwords?", "Confirm update");
        if (result == 0) {
            Account[] teams = accounts.toArray(new Account[accounts.size()]);
            Arrays.sort(teams, new AccountComparator());
            ArrayList<Account> accountList = new ArrayList<Account>();
            int i = 0;
            while (i < lines.length) {
                teams[i].setPassword(lines[i]);
                accountList.add(teams[i]);
                ++i;
            }
            Account[] changedAccounts = accountList.toArray(new Account[accountList.size()]);
            this.getController().updateAccounts(changedAccounts);
        }
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new GridBagLayout());
        }
        return this.centerPane;
    }
}

