/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.imports.ICPCImportData;
import edu.csus.ecs.pc2.core.imports.LoadICPCData;
import edu.csus.ecs.pc2.core.imports.LoadICPCTSVData;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.GroupEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IGroupListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.FileNameExtensionFilter;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.ICPCAccountFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.TabFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ICPCLoadPane
extends JPanePlugin {
    private static final long serialVersionUID = 4668437987656812366L;
    private Log log;
    private JButton importAccountsButton = null;
    private JButton changeDisplayFormatButton = null;
    private JButton importSitesButton = null;
    private JButton importTSVButton = null;
    private String lastDir;
    private ICPCImportData importData;
    private ICPCAccountFrame icpcAccountFrame = null;
    private String lastDirectory;

    public ICPCLoadPane() {
        this.initialize();
    }

    private void initialize() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(10);
        this.setLayout(flowLayout);
        this.setSize(new Dimension(580, 349));
        this.add((Component)this.getImportAccountsButton(), null);
        this.add((Component)this.getChangeDisplayFormatButton(), null);
        this.add((Component)this.getImportSitesButton(), null);
        this.add((Component)this.getImportTSVButton(), null);
    }

    @Override
    public String getPluginTitle() {
        return "ICPC Import Data Pane";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addGroupListener(new GroupListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ICPCLoadPane.this.getImportAccountsButton().setEnabled(ICPCLoadPane.this.getContest().getGroups() != null);
                ICPCLoadPane.this.updateGUIperPermissions();
            }
        });
    }

    private void updateGUIperPermissions() {
        this.changeDisplayFormatButton.setEnabled(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
        this.importSitesButton.setEnabled(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
        this.importAccountsButton.setEnabled(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
        this.importTSVButton.setEnabled(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
    }

    private JButton getImportAccountsButton() {
        if (this.importAccountsButton == null) {
            this.importAccountsButton = new JButton();
            this.importAccountsButton.setText("Import Accounts");
            this.importAccountsButton.setToolTipText("Load ICPC accounts CVS file");
            this.importAccountsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ICPCLoadPane.this.loadPC2Team();
                }
            });
        }
        return this.importAccountsButton;
    }

    protected void loadPC2Team() {
        try {
            JFileChooser chooser = new JFileChooser(this.lastDir);
            chooser.setDialogTitle("Select PC2_Team.tab");
            TabFileFilter tff = new TabFileFilter();
            chooser.setFileFilter(tff);
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(tff);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File newFile = chooser.getSelectedFile().getCanonicalFile();
                boolean newFileProblem = true;
                if (newFile.exists() && newFile.isFile() && newFile.canRead()) {
                    this.lastDir = chooser.getCurrentDirectory().toString();
                    Vector<Account> accountVector = this.getContest().getAccounts(ClientType.Type.TEAM);
                    Account[] accounts = accountVector.toArray(new Account[accountVector.size()]);
                    this.importData = LoadICPCData.loadAccounts(this.lastDir, this.getContest().getGroups(), accounts);
                    newFileProblem = false;
                    this.changeDisplayFormat();
                }
                if (newFileProblem) {
                    this.log.warning("Problem reading _PC2_Team.tab " + newFile.getCanonicalPath());
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Could not open file " + newFile, "Warning", 2);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception ", e);
        }
    }

    private JButton getChangeDisplayFormatButton() {
        if (this.changeDisplayFormatButton == null) {
            this.changeDisplayFormatButton = new JButton();
            this.changeDisplayFormatButton.setText("Change Display Format");
            this.changeDisplayFormatButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ICPCLoadPane.this.changeDisplayFormat();
                }
            });
        }
        return this.changeDisplayFormatButton;
    }

    protected void changeDisplayFormat() {
        boolean gotData = false;
        try {
            Vector<Account> teams = this.getContest().getAccounts(ClientType.Type.TEAM);
            for (Account account : teams) {
                if (account == null || account.getLongSchoolName() == null || this.isEmpty(account.getLongSchoolName())) continue;
                gotData = true;
                break;
            }
        }
        catch (Exception e) {
            this.log.throwing("ICPCPane", "changeDisplayFormat", e);
        }
        if (this.importData == null && !gotData) {
            JOptionPane.showMessageDialog(this, "Please 'Import Accounts' icpc account data first.", "Error", 0);
            return;
        }
        if (this.importData != null && this.importData.getAccounts() != null) {
            this.getICPCAccountFrame().setICPCAccounts(this.importData.getAccounts());
        }
        this.getICPCAccountFrame().setContestAndController(this.getContest(), this.getController());
        this.getICPCAccountFrame().setVisible(true);
    }

    private boolean isEmpty(String longSchoolName) {
        return longSchoolName == null || longSchoolName.trim().length() == 0;
    }

    private JButton getImportSitesButton() {
        if (this.importSitesButton == null) {
            this.importSitesButton = new JButton();
            this.importSitesButton.setText("Import Sites ");
            this.importSitesButton.setToolTipText("Load ICPC sites CSV files");
            this.importSitesButton.setMnemonic(83);
            this.importSitesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ICPCLoadPane.this.loadPC2Site();
                }
            });
        }
        return this.importSitesButton;
    }

    protected void loadPC2Site() {
        try {
            JFileChooser chooser = new JFileChooser(this.lastDir);
            chooser.setDialogTitle("Select PC2_Site.tab");
            TabFileFilter tff = new TabFileFilter();
            chooser.setFileFilter(tff);
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(tff);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File newFile = chooser.getSelectedFile().getCanonicalFile();
                boolean newFileProblem = true;
                if (newFile.exists() && newFile.isFile() && newFile.canRead()) {
                    this.lastDir = chooser.getCurrentDirectory().toString();
                    newFileProblem = false;
                    this.addGroups();
                }
                if (newFileProblem) {
                    this.log.warning("Problem reading PC2_Contest.tab " + newFile.getCanonicalPath());
                    JOptionPane.showMessageDialog(this.getParentFrame(), "Could not open file " + newFile, "Warning", 2);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "loadPC2Site exception ", e);
        }
    }

    private void addGroups() throws Exception {
        block10: {
            ICPCImportData importSiteData = LoadICPCData.loadSites(this.lastDir, this.getContest().getSites());
            Group[] importedGroups = importSiteData.getGroups();
            Group[] modelGroups = this.getContest().getGroups();
            String contestTitle = importSiteData.getContestTitle();
            if (contestTitle != null && contestTitle.trim().length() > 0) {
                ContestInformation ci = this.getContest().getContestInformation();
                ci.setContestTitle(contestTitle);
                this.getController().updateContestInformation(ci);
            }
            if (importedGroups == null || importedGroups.length <= 0) break block10;
            if (modelGroups == null || modelGroups.length == 0) {
                Group[] groupArray = importedGroups;
                int n = importedGroups.length;
                int n2 = 0;
                while (n2 < n) {
                    Group group = groupArray[n2];
                    this.getController().addNewGroup(group);
                    ++n2;
                }
            } else {
                Group group;
                HashMap<String, Group> groupMap = new HashMap<String, Group>();
                Group[] groupArray = modelGroups;
                int n = modelGroups.length;
                int n3 = 0;
                while (n3 < n) {
                    group = groupArray[n3];
                    groupMap.put(group.getDisplayName(), group);
                    groupMap.put(Integer.toString(group.getGroupId()), group);
                    ++n3;
                }
                groupArray = importedGroups;
                n = importedGroups.length;
                n3 = 0;
                while (n3 < n) {
                    group = groupArray[n3];
                    if (groupMap.containsKey(Integer.toString(group.getGroupId()))) {
                        this.mergeGroups((Group)groupMap.get(Integer.toString(group.getGroupId())), group);
                    } else if (groupMap.containsKey(group.getDisplayName())) {
                        this.mergeGroups((Group)groupMap.get(group.getDisplayName()), group);
                    } else {
                        this.getController().addNewGroup(group);
                    }
                    ++n3;
                }
            }
        }
    }

    private void mergeGroups(Group dstGroup, Group srcGroup) {
        if (dstGroup.isSameAs(srcGroup)) {
            return;
        }
        dstGroup.setDisplayName(srcGroup.getDisplayName());
        dstGroup.setGroupId(srcGroup.getGroupId());
        if (srcGroup.getSite() != null) {
            dstGroup.setSite(srcGroup.getSite());
        }
        this.getController().updateGroup(dstGroup);
    }

    private JButton getImportTSVButton() {
        if (this.importTSVButton == null) {
            this.importTSVButton = new JButton();
            this.importTSVButton.setText("Import TSV ");
            this.importTSVButton.setToolTipText("Load ICPC TSV teams, groups and contest files");
            this.importTSVButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ICPCLoadPane.this.loadTSVFiles();
                }
            });
        }
        return this.importTSVButton;
    }

    public File selectTSVFileDialog(Component parent, String startDirectory) {
        JFileChooser chooser = new JFileChooser(startDirectory);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle("Open tab-separated file");
        FileNameExtensionFilter filterYAML = new FileNameExtensionFilter("TSV document (*.tsv)", "tsv");
        chooser.addChoosableFileFilter(filterYAML);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filterYAML);
        int action = chooser.showOpenDialog(parent);
        switch (action) {
            case 0: {
                File file = chooser.getSelectedFile();
                this.lastDirectory = chooser.getCurrentDirectory().toString();
                return file;
            }
        }
        return null;
    }

    private String selectFileName() throws IOException {
        String chosenFile = null;
        File file = this.selectTSVFileDialog(this, this.lastDirectory);
        if (file != null) {
            chosenFile = file.getCanonicalFile().toString();
            return chosenFile;
        }
        return null;
    }

    protected void loadTSVFiles() {
        LoadICPCTSVData loader = new LoadICPCTSVData();
        loader.setContestAndController(this.getContest(), this.getController());
        String filename = null;
        try {
            filename = this.selectFileName();
            boolean loaded = loader.loadFiles(filename);
            if (loaded) {
                this.info("Loaded data from file " + filename);
            }
        }
        catch (IOException e) {
            if (filename != null) {
                this.info("Did not load data from file " + filename);
            }
            this.log.log(Log.DEBUG, "IOException in loadTSVFiles()", e);
            FrameUtilities.showMessage(this, "Error", "Did not load data from file " + filename + ".  " + e.getMessage());
        }
        catch (Exception e) {
            if (filename != null) {
                this.info("Did not load data from file " + filename);
            }
            this.log.log(Log.INFO, "Exception in loadTSVFiles()", e);
            FrameUtilities.showMessage(this, "Error", "Did not load data from file " + filename + ".  " + e.getMessage());
        }
    }

    private void info(String message) {
        this.log.info(message);
    }

    private ICPCAccountFrame getICPCAccountFrame() {
        if (this.icpcAccountFrame == null) {
            this.icpcAccountFrame = new ICPCAccountFrame();
        }
        return this.icpcAccountFrame;
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (ICPCLoadPane.this.getContest().getClientId().equals(account.getClientId())) {
                ICPCLoadPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ICPCLoadPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            Account[] accountArray = accounts = accountEvent.getAccounts();
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (ICPCLoadPane.this.getContest().getClientId().equals(account.getClientId())) {
                    ICPCLoadPane.this.initializePermissions();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ICPCLoadPane.this.updateGUIperPermissions();
                        }
                    });
                }
                ++n2;
            }
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            ICPCLoadPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ICPCLoadPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    public class GroupListenerImplementation
    implements IGroupListener {
        @Override
        public void groupAdded(GroupEvent event) {
            ICPCLoadPane.this.getImportAccountsButton().setEnabled(ICPCLoadPane.this.getContest().getGroups() != null);
        }

        @Override
        public void groupChanged(GroupEvent event) {
            ICPCLoadPane.this.getImportAccountsButton().setEnabled(ICPCLoadPane.this.getContest().getGroups() != null);
        }

        @Override
        public void groupRemoved(GroupEvent event) {
        }

        @Override
        public void groupRefreshAll(GroupEvent groupEvent) {
            ICPCLoadPane.this.getImportAccountsButton().setEnabled(ICPCLoadPane.this.getContest().getGroups() != null);
        }

        @Override
        public void groupsAdded(GroupEvent event) {
            ICPCLoadPane.this.getImportAccountsButton().setEnabled(ICPCLoadPane.this.getContest().getGroups() != null);
        }

        @Override
        public void groupsChanged(GroupEvent event) {
            ICPCLoadPane.this.getImportAccountsButton().setEnabled(ICPCLoadPane.this.getContest().getGroups() != null);
        }
    }
}

