/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class GenerateAccountsPane
extends JPanePlugin {
    private static final long serialVersionUID = 8377729793720023288L;
    private JPanel centerPanel = null;
    private JTextField adminCountTextField = null;
    private JTextField boardCountTextField = null;
    private JTextField teamCountTextField = null;
    private JTextField judgeCountTextField = null;
    private JLabel genAdminLabel = null;
    private JLabel genJudgeLabel = null;
    private JLabel genTeamLabels = null;
    private JLabel genScoreboardLabel = null;
    private JPanel generateButtonPanel = null;
    private JButton generateButton = null;
    private JComboBox<Site> siteSelectionComboBox = null;
    private JLabel genStartNumberLabel = null;
    private JTextField startNumberTextField = null;
    private JLabel siteLabel = null;
    private JLabel genOtherLabel = null;
    private JComboBox<ClientType.Type> otherClientsComboBox = null;
    private JTextField otherClientCountTextBox = null;
    private JButton cancelButton = null;

    public GenerateAccountsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(441, 277));
        this.add((Component)this.getCenterPanel(), "Center");
        this.add((Component)this.getGenerateButtonPanel(), "South");
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GenerateAccountsPane.this.getParentFrame() != null) {
                    GenerateAccountsPane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            GenerateAccountsPane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    private void updateSiteComboBox() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int selectedIndex = GenerateAccountsPane.this.getSiteSelectionComboBox().getSelectedIndex();
                GenerateAccountsPane.this.getSiteSelectionComboBox().removeAllItems();
                Site[] sites = GenerateAccountsPane.this.getContest().getSites();
                Arrays.sort(sites, new SiteComparatorBySiteNumber());
                int i = 0;
                while (i < sites.length) {
                    Site newSite;
                    if (sites[i].getSiteNumber() == GenerateAccountsPane.this.getContest().getSiteNumber()) {
                        newSite = new Site(String.valueOf(sites[i].getDisplayName()) + " (Site " + sites[i].getSiteNumber() + ", This Site)", GenerateAccountsPane.this.getContest().getSiteNumber());
                        if (selectedIndex == -1) {
                            selectedIndex = i;
                        }
                    } else {
                        newSite = new Site(String.valueOf(sites[i].getDisplayName()) + " (Site " + sites[i].getSiteNumber() + ")", sites[i].getSiteNumber());
                    }
                    GenerateAccountsPane.this.getSiteSelectionComboBox().addItem(newSite);
                    ++i;
                }
                if (selectedIndex != -1) {
                    GenerateAccountsPane.this.getSiteSelectionComboBox().setSelectedIndex(selectedIndex);
                }
            }
        });
    }

    private void updateGenerateTitles() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int thisSiteNumber;
                int theSiteNumber = thisSiteNumber = GenerateAccountsPane.this.getContest().getSiteNumber();
                int index = GenerateAccountsPane.this.getSiteSelectionComboBox().getSelectedIndex();
                if (index > -1) {
                    Site site = (Site)GenerateAccountsPane.this.getSiteSelectionComboBox().getSelectedItem();
                    theSiteNumber = site.getSiteNumber();
                }
                int number = GenerateAccountsPane.this.getContest().getAccounts(ClientType.Type.SCOREBOARD, theSiteNumber).size();
                GenerateAccountsPane.this.genScoreboardLabel.setText("Scoreboards (" + number + ")");
                number = GenerateAccountsPane.this.getContest().getAccounts(ClientType.Type.TEAM, theSiteNumber).size();
                GenerateAccountsPane.this.genTeamLabels.setText("Teams (" + number + ")");
                number = GenerateAccountsPane.this.getContest().getAccounts(ClientType.Type.JUDGE, theSiteNumber).size();
                GenerateAccountsPane.this.genJudgeLabel.setText("Judges (" + number + ")");
                number = GenerateAccountsPane.this.getContest().getAccounts(ClientType.Type.ADMINISTRATOR, theSiteNumber).size();
                GenerateAccountsPane.this.genAdminLabel.setText("Administrators (" + number + ")");
                GenerateAccountsPane.this.updateOtherClientsLabel();
                GenerateAccountsPane.this.generateButton.setText("Generate Accounts for Site " + theSiteNumber);
                GenerateAccountsPane.this.generateButton.setMnemonic(71);
            }
        });
    }

    @Override
    public String getPluginTitle() {
        return "Generate Accounts Pane";
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.siteLabel = new JLabel();
            this.siteLabel.setBounds(new Rectangle(79, 8, 48, 20));
            this.siteLabel.setText("Site");
            this.genStartNumberLabel = new JLabel();
            this.genStartNumberLabel.setText("Start Account Number at");
            this.genStartNumberLabel.setSize(new Dimension(200, 19));
            this.genStartNumberLabel.setLocation(new Point(81, 198));
            this.genScoreboardLabel = new JLabel();
            this.genScoreboardLabel.setBounds(new Rectangle(81, 129, 166, 19));
            this.genScoreboardLabel.setText("Scoreboards");
            this.genTeamLabels = new JLabel();
            this.genTeamLabels.setBounds(new Rectangle(81, 99, 166, 19));
            this.genTeamLabels.setText("Teams");
            this.genJudgeLabel = new JLabel();
            this.genJudgeLabel.setBounds(new Rectangle(81, 69, 166, 19));
            this.genJudgeLabel.setText("Judges");
            this.genAdminLabel = new JLabel();
            this.genAdminLabel.setBounds(new Rectangle(81, 39, 166, 19));
            this.genAdminLabel.setText("Administrators");
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(null);
            this.centerPanel.add((Component)this.getAdminCountTextField(), null);
            this.centerPanel.add((Component)this.getBoardCountTextField(), null);
            this.centerPanel.add((Component)this.getTeamCountTextField(), null);
            this.centerPanel.add((Component)this.getJudgeCountTextField(), null);
            this.centerPanel.add((Component)this.genAdminLabel, null);
            this.centerPanel.add((Component)this.genJudgeLabel, null);
            this.centerPanel.add((Component)this.genTeamLabels, null);
            this.centerPanel.add((Component)this.genScoreboardLabel, null);
            this.centerPanel.add(this.getSiteSelectionComboBox(), null);
            this.centerPanel.add((Component)this.genStartNumberLabel, null);
            this.centerPanel.add((Component)this.getStartNumberTextField(), null);
            this.centerPanel.add((Component)this.siteLabel, null);
            this.centerPanel.add(this.getOtherClientsComboBox(), null);
            this.centerPanel.add((Component)this.getOtherClientCountTextBox(), null);
            this.genOtherLabel = new JLabel();
            this.genOtherLabel.setText("0");
            this.genOtherLabel.setSize(new Dimension(200, 19));
            this.genOtherLabel.setLocation(new Point(81, 198));
            this.genOtherLabel.setBounds(283, 163, 48, 19);
            this.centerPanel.add(this.genOtherLabel);
        }
        return this.centerPanel;
    }

    private JTextField getAdminCountTextField() {
        if (this.adminCountTextField == null) {
            this.adminCountTextField = new JTextField();
            this.adminCountTextField.setBounds(new Rectangle(343, 35, 39, 22));
            this.adminCountTextField.setDocument(new IntegerDocument());
            this.adminCountTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    GenerateAccountsPane.this.enableUpdateButton();
                }
            });
        }
        return this.adminCountTextField;
    }

    private JTextField getBoardCountTextField() {
        if (this.boardCountTextField == null) {
            this.boardCountTextField = new JTextField();
            this.boardCountTextField.setBounds(new Rectangle(343, 127, 39, 22));
            this.boardCountTextField.setDocument(new IntegerDocument());
            this.boardCountTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    GenerateAccountsPane.this.enableUpdateButton();
                }
            });
        }
        return this.boardCountTextField;
    }

    private JTextField getTeamCountTextField() {
        if (this.teamCountTextField == null) {
            this.teamCountTextField = new JTextField();
            this.teamCountTextField.setBounds(new Rectangle(343, 97, 39, 22));
            this.teamCountTextField.setDocument(new IntegerDocument());
            this.teamCountTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    GenerateAccountsPane.this.enableUpdateButton();
                }
            });
        }
        return this.teamCountTextField;
    }

    private JTextField getJudgeCountTextField() {
        if (this.judgeCountTextField == null) {
            this.judgeCountTextField = new JTextField();
            this.judgeCountTextField.setBounds(new Rectangle(343, 67, 39, 22));
            this.judgeCountTextField.setDocument(new IntegerDocument());
            this.judgeCountTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    GenerateAccountsPane.this.enableUpdateButton();
                }
            });
        }
        return this.judgeCountTextField;
    }

    private JPanel getGenerateButtonPanel() {
        if (this.generateButtonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(40);
            this.generateButtonPanel = new JPanel();
            this.generateButtonPanel.setLayout(flowLayout);
            this.generateButtonPanel.setPreferredSize(new Dimension(35, 35));
            this.generateButtonPanel.add((Component)this.getGenerateButton(), null);
            this.generateButtonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.generateButtonPanel;
    }

    private JButton getGenerateButton() {
        if (this.generateButton == null) {
            this.generateButton = new JButton();
            this.generateButton.setText("Generate");
            this.generateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenerateAccountsPane.this.generateAccounts();
                }
            });
        }
        return this.generateButton;
    }

    private int getIntegerValue(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private boolean isLocalLoggedIn(int siteNumber) {
        ClientId serverId = new ClientId(siteNumber, ClientType.Type.SERVER, 0);
        return this.getContest().isLocalLoggedIn(serverId) || this.getContest().isRemoteLoggedIn(serverId);
    }

    protected void generateAccounts() {
        try {
            int thisSiteNumber;
            int startNumber = this.getIntegerValue(this.startNumberTextField.getText());
            if (startNumber < 1) {
                startNumber = 1;
            }
            int theSiteNumber = thisSiteNumber = this.getContest().getSiteNumber();
            int index = this.getSiteSelectionComboBox().getSelectedIndex();
            if (index > -1) {
                Site site = (Site)this.getSiteSelectionComboBox().getSelectedItem();
                theSiteNumber = site.getSiteNumber();
            }
            if (theSiteNumber != this.getContest().getSiteNumber() && !this.isLocalLoggedIn(theSiteNumber)) {
                JOptionPane.showMessageDialog(this, "Not currently connected to Site " + theSiteNumber + ", connect to that server and try again", "Not connected to site " + theSiteNumber, 1);
                return;
            }
            int count = this.getIntegerValue(this.adminCountTextField.getText());
            if (count > 0) {
                this.getController().generateNewAccounts(ClientType.Type.ADMINISTRATOR.toString(), theSiteNumber, count, startNumber, true);
                this.adminCountTextField.setText("");
            }
            if ((count = this.getIntegerValue(this.judgeCountTextField.getText())) > 0) {
                this.getController().generateNewAccounts(ClientType.Type.JUDGE.toString(), theSiteNumber, count, startNumber, true);
                this.judgeCountTextField.setText("");
            }
            if ((count = this.getIntegerValue(this.teamCountTextField.getText())) > 0) {
                this.getController().generateNewAccounts(ClientType.Type.TEAM.toString(), theSiteNumber, count, startNumber, true);
                this.teamCountTextField.setText("");
            }
            if ((count = this.getIntegerValue(this.boardCountTextField.getText())) > 0) {
                this.getController().generateNewAccounts(ClientType.Type.SCOREBOARD.toString(), theSiteNumber, count, startNumber, true);
                this.boardCountTextField.setText("");
            }
            if ((count = this.getIntegerValue(this.otherClientCountTextBox.getText())) > 0) {
                ClientType.Type type = (ClientType.Type)((Object)this.otherClientsComboBox.getSelectedItem());
                this.getController().generateNewAccounts(type.toString(), theSiteNumber, count, startNumber, true);
                this.otherClientCountTextBox.setText("");
            }
            this.getStartNumberTextField().setText("");
            this.enableUpdateButtons(false);
        }
        catch (Exception e) {
            this.getLog().log(Log.INFO, e.getMessage(), e);
            e.printStackTrace();
        }
    }

    private JComboBox<Site> getSiteSelectionComboBox() {
        if (this.siteSelectionComboBox == null) {
            this.siteSelectionComboBox = new JComboBox();
            this.siteSelectionComboBox.setBounds(new Rectangle(151, 9, 229, 19));
            this.siteSelectionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenerateAccountsPane.this.updateGenerateTitles();
                }
            });
        }
        return this.siteSelectionComboBox;
    }

    private JTextField getStartNumberTextField() {
        if (this.startNumberTextField == null) {
            this.startNumberTextField = new JTextField();
            this.startNumberTextField.setBounds(new Rectangle(343, 193, 39, 22));
            this.startNumberTextField.setDocument(new IntegerDocument());
        }
        return this.startNumberTextField;
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.updateGenerateTitles();
        this.updateSiteComboBox();
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addSiteListener(new SiteListenerImplementation());
        this.addWindowCloserListener();
    }

    private JComboBox<ClientType.Type> getOtherClientsComboBox() {
        if (this.otherClientsComboBox == null) {
            this.otherClientsComboBox = new JComboBox();
            this.otherClientsComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    GenerateAccountsPane.this.updateOtherClientsLabel();
                }
            });
            this.otherClientsComboBox.setBounds(new Rectangle(81, 162, 167, 20));
            this.otherClientsComboBox.addItem(ClientType.Type.FEEDER);
            this.otherClientsComboBox.setSelectedIndex(0);
        }
        return this.otherClientsComboBox;
    }

    protected void updateOtherClientsLabel() {
        ClientType.Type accountType = (ClientType.Type)((Object)this.otherClientsComboBox.getSelectedItem());
        if (accountType == null) {
            this.genOtherLabel.setText("(0)");
        } else if (this.getContest() != null) {
            int thisSiteNumber = this.getContest().getSiteNumber();
            int number = this.getContest().getAccounts(accountType, thisSiteNumber).size();
            this.genOtherLabel.setText("(" + number + ")");
        }
    }

    private JTextField getOtherClientCountTextBox() {
        if (this.otherClientCountTextBox == null) {
            this.otherClientCountTextBox = new JTextField();
            this.otherClientCountTextBox.setBounds(new Rectangle(343, 160, 39, 22));
            this.otherClientCountTextBox.setDocument(new IntegerDocument());
            this.otherClientCountTextBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    GenerateAccountsPane.this.enableUpdateButton();
                }
            });
        }
        return this.otherClientCountTextBox;
    }

    public void enableUpdateButton() {
        boolean noData = false;
        noData = this.isTextFieldEmpty(this.getAdminCountTextField()) && this.isTextFieldEmpty(this.getJudgeCountTextField());
        noData = noData && this.isTextFieldEmpty(this.getTeamCountTextField()) && this.isTextFieldEmpty(this.getBoardCountTextField());
        noData = noData && this.isTextFieldEmpty(this.getOtherClientCountTextBox());
        this.enableUpdateButtons(!noData);
    }

    protected void enableUpdateButtons(boolean editedText) {
        if (editedText) {
            this.getCancelButton().setText("Cancel");
        } else {
            this.getCancelButton().setText("Close");
        }
        this.getGenerateButton().setEnabled(editedText);
    }

    private boolean isTextFieldEmpty(JTextField textField) {
        return textField.getText().trim().equals("");
    }

    protected void handleCancelButton() {
        if (this.isTextFieldEmpty(this.getAdminCountTextField()) && this.isTextFieldEmpty(this.getJudgeCountTextField()) && this.isTextFieldEmpty(this.getTeamCountTextField()) && this.isTextFieldEmpty(this.getBoardCountTextField())) {
            if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Counts modified, generate accounts?", "Confirm Choice");
            if (result == 0) {
                this.generateAccounts();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1) {
                this.clearCounts();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            }
        }
    }

    private void clearCounts() {
        this.getAdminCountTextField().setText("");
        this.getJudgeCountTextField().setText("");
        this.getTeamCountTextField().setText("");
        this.getBoardCountTextField().setText("");
        this.getStartNumberTextField().setText("");
        this.enableUpdateButtons(false);
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.setPreferredSize(new Dimension(150, 26));
            this.cancelButton.setVisible(false);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenerateAccountsPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    @Override
    public void setParentFrame(JFrame parentFrame) {
        super.setParentFrame(parentFrame);
        this.getCancelButton().setVisible(true);
        this.enableUpdateButton();
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenerateAccountsPane.this.updateGenerateTitles();
                }
            });
        }

        @Override
        public void accountModified(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenerateAccountsPane.this.updateGenerateTitles();
                }
            });
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenerateAccountsPane.this.updateGenerateTitles();
                }
            });
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenerateAccountsPane.this.updateGenerateTitles();
                }
            });
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenerateAccountsPane.this.updateGenerateTitles();
                }
            });
        }
    }

    public class SiteListenerImplementation
    implements ISiteListener {
        @Override
        public void siteProfileStatusChanged(SiteEvent event) {
        }

        @Override
        public void siteAdded(SiteEvent event) {
            GenerateAccountsPane.this.updateSiteComboBox();
        }

        @Override
        public void siteRemoved(SiteEvent event) {
            GenerateAccountsPane.this.updateSiteComboBox();
        }

        @Override
        public void siteChanged(SiteEvent event) {
            GenerateAccountsPane.this.updateSiteComboBox();
        }

        @Override
        public void siteLoggedOn(SiteEvent event) {
            GenerateAccountsPane.this.updateSiteComboBox();
        }

        @Override
        public void siteLoggedOff(SiteEvent event) {
            GenerateAccountsPane.this.updateSiteComboBox();
        }

        @Override
        public void sitesRefreshAll(SiteEvent siteEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GenerateAccountsPane.this.updateGenerateTitles();
                    GenerateAccountsPane.this.updateSiteComboBox();
                }
            });
        }
    }
}

