/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageAutoFill;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.InvalidFieldValue;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class EditLanguagePane
extends JPanePlugin {
    private static final long serialVersionUID = 6229906311932197623L;
    private JPanel buttonPane = null;
    private JButton addButton = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JPanel mainPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JTextField displayNameTextField = null;
    private JTextField compileCommandLineTextField = null;
    private JTextField executableFilenameTextField = null;
    private JLabel jLabel3 = null;
    private JTextField jTextField3 = null;
    private JLabel jLabel4 = null;
    private JTextField programExecutionCommandLineTextField = null;
    private JLabel jLabel5 = null;
    private JComboBox<String> autoPopulateLanguageComboBox = null;
    private static final String NO_CHANGE_TITLE = "No Change";
    private Language language = null;
    private boolean populatingGUI = true;
    private JCheckBox deleteLanguageCheckbox = null;
    private JCheckBox interpretedLanguageCheckBox = null;
    private JTextField judgeCommandLineTextBox = null;
    private JCheckBox chckbxJudgesCommandLine = null;

    public EditLanguagePane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(517, 338));
        this.add((Component)this.getMainPanel(), "Center");
        this.add((Component)this.getButtonPane(), "South");
        this.loadComboBox();
    }

    private void loadComboBox() {
        this.getAutoPopulateLanguageComboBox().addItem(NO_CHANGE_TITLE);
        String[] stringArray = LanguageAutoFill.getLanguageList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String languageName = stringArray[n2];
            this.getAutoPopulateLanguageComboBox().addItem(languageName);
            ++n2;
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.addWindowCloserListener();
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EditLanguagePane.this.getParentFrame() != null) {
                    EditLanguagePane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            EditLanguagePane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    @Override
    public String getPluginTitle() {
        return "Edit Language Pane";
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setEnabled(false);
            this.addButton.setMnemonic(65);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditLanguagePane.this.addLanguage();
                }
            });
        }
        return this.addButton;
    }

    protected void addLanguage() {
        try {
            Language newLanguage = this.getLanguageFromFields(this.language);
            this.getController().addNewLanguage(newLanguage);
            this.cancelButton.setText("Close");
            this.addButton.setEnabled(false);
            this.updateButton.setEnabled(false);
            if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        }
        catch (InvalidFieldValue e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Invalid Language field", 0);
            return;
        }
    }

    private Language getLanguageFromFields(Language existingLanguage) {
        if (existingLanguage == null) {
            existingLanguage = new Language(this.displayNameTextField.getText());
        } else {
            existingLanguage.setDisplayName(this.displayNameTextField.getText());
        }
        existingLanguage.setCompileCommandLine(this.compileCommandLineTextField.getText());
        existingLanguage.setInterpreted(this.getInterpretedLanguageCheckBox().isSelected());
        existingLanguage.setExecutableIdentifierMask(this.getExecutableFilenameTextField().getText());
        existingLanguage.setProgramExecuteCommandLine(this.programExecutionCommandLineTextField.getText());
        existingLanguage.setActive(!this.getDeleteLanguageCheckbox().isSelected());
        existingLanguage.setJudgeProgramExecuteCommandLine(this.judgeCommandLineTextBox.getText());
        existingLanguage.setUsingJudgeProgramExecuteCommandLine(this.chckbxJudgesCommandLine.isSelected());
        this.checkForEmptyField(existingLanguage.getDisplayName(), "Enter a language name");
        this.checkForEmptyField(existingLanguage.getCompileCommandLine(), "Enter a compiler command line");
        this.checkForEmptyField(existingLanguage.getProgramExecuteCommandLine(), "Enter a execute command line");
        if (existingLanguage.isUsingJudgeProgramExecuteCommandLine()) {
            this.checkForEmptyField(existingLanguage.getJudgeProgramExecuteCommandLine(), "Judge execution command line");
        }
        return existingLanguage;
    }

    private void checkForEmptyField(String value, String comment) {
        if (value == null || value.trim().length() == 0) {
            throw new InvalidFieldValue(comment);
        }
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditLanguagePane.this.updateLanguage();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateLanguage() {
        try {
            Language newLanguage = this.getLanguageFromFields(this.language);
            this.getController().updateLanguage(newLanguage);
            this.cancelButton.setText("Close");
            this.addButton.setEnabled(false);
            this.updateButton.setEnabled(false);
            if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        }
        catch (InvalidFieldValue e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Invalid Language field", 0);
            return;
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditLanguagePane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled() || this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Language modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isEnabled()) {
                    this.addLanguage();
                } else {
                    this.updateLanguage();
                }
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setBounds(new Rectangle(67, 13, 129, 20));
            this.jLabel5.setHorizontalAlignment(4);
            this.jLabel5.setText("Auto Populate with");
            this.jLabel5.setName("AutoPopulateLabel");
            this.jLabel4 = new JLabel();
            this.jLabel4.setBounds(new Rectangle(13, 214, 244, 20));
            this.jLabel4.setName("ProgramExLabel");
            this.jLabel4.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.jLabel4.setHorizontalAlignment(4);
            this.jLabel4.setText("Program Execution Command Line");
            this.jLabel4.setForeground(new Color(0, 0, 0));
            this.jLabel3 = new JLabel();
            this.jLabel3.setBounds(new Rectangle(14, 113, 182, 20));
            this.jLabel3.setName("ExeFilenameLabel");
            this.jLabel3.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.jLabel3.setHorizontalAlignment(4);
            this.jLabel3.setText("Executable Filename");
            this.jLabel3.setForeground(Color.black);
            this.jLabel2 = new JLabel();
            this.jLabel2.setBounds(new Rectangle(0, 0, 0, 0));
            this.jLabel2.setName("SourceExtLabel");
            this.jLabel2.setForeground(Color.black);
            this.jLabel2.setHorizontalAlignment(4);
            this.jLabel2.setText("Source Extensions");
            this.jLabel2.setVisible(false);
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(new Rectangle(14, 46, 182, 20));
            this.jLabel1.setName("DisplayNameLabel");
            this.jLabel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.jLabel1.setHorizontalAlignment(4);
            this.jLabel1.setText("Display Name");
            this.jLabel1.setForeground(Color.black);
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(14, 79, 182, 20));
            this.jLabel.setName("CompileCmdLineLabel");
            this.jLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.jLabel.setHorizontalAlignment(4);
            this.jLabel.setText("Compile Cmd Line");
            this.jLabel.setForeground(Color.black);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(null);
            this.mainPanel.setName("advancedEdit");
            this.mainPanel.add((Component)this.jLabel, this.jLabel.getName());
            this.mainPanel.add((Component)this.jLabel1, this.jLabel1.getName());
            this.mainPanel.add((Component)this.jLabel2, this.jLabel2.getName());
            this.mainPanel.add((Component)this.getDisplayNameTextField(), this.getDisplayNameTextField().getName());
            this.mainPanel.add((Component)this.getCompileCommandLineTextField(), this.getCompileCommandLineTextField().getName());
            this.mainPanel.add((Component)this.getExecutableFilenameTextField(), this.getExecutableFilenameTextField().getName());
            this.mainPanel.add((Component)this.jLabel3, this.jLabel3.getName());
            this.mainPanel.add((Component)this.getJTextField3(), this.getJTextField3().getName());
            this.mainPanel.add((Component)this.jLabel4, this.jLabel4.getName());
            this.mainPanel.add((Component)this.getProgramExecutionCommandLineTextField(), this.getProgramExecutionCommandLineTextField().getName());
            this.mainPanel.add((Component)this.jLabel5, this.jLabel5.getName());
            this.mainPanel.add(this.getAutoPopulateLanguageComboBox(), this.getAutoPopulateLanguageComboBox().getName());
            this.mainPanel.add((Component)this.getDeleteLanguageCheckbox(), null);
            this.mainPanel.add((Component)this.getInterpretedLanguageCheckBox(), null);
            this.judgeCommandLineTextBox = new JTextField();
            this.judgeCommandLineTextBox.setToolTipText("Execute command line for Judges");
            this.judgeCommandLineTextBox.setName("judgesProgramCommandLine");
            this.judgeCommandLineTextBox.setBounds(new Rectangle(274, 214, 198, 20));
            this.judgeCommandLineTextBox.setBounds(274, 183, 198, 20);
            this.judgeCommandLineTextBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditLanguagePane.this.enableUpdateButton();
                }
            });
            this.mainPanel.add(this.judgeCommandLineTextBox);
            this.chckbxJudgesCommandLine = new JCheckBox();
            this.chckbxJudgesCommandLine.setToolTipText("Use Judge command line");
            this.chckbxJudgesCommandLine.setHorizontalAlignment(4);
            this.chckbxJudgesCommandLine.setText("Judge execution command line");
            this.chckbxJudgesCommandLine.setBounds(new Rectangle(209, 143, 275, 21));
            this.chckbxJudgesCommandLine.setBounds(19, 182, 238, 21);
            this.chckbxJudgesCommandLine.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditLanguagePane.this.enableUpdateButton();
                }
            });
            this.mainPanel.add(this.chckbxJudgesCommandLine);
        }
        return this.mainPanel;
    }

    private JTextField getDisplayNameTextField() {
        if (this.displayNameTextField == null) {
            this.displayNameTextField = new JTextField();
            this.displayNameTextField.setBounds(new Rectangle(209, 46, 263, 20));
            this.displayNameTextField.setToolTipText("Name to display to users");
            this.displayNameTextField.setName("displayNameTextField");
            this.displayNameTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditLanguagePane.this.enableUpdateButton();
                }
            });
        }
        return this.displayNameTextField;
    }

    private JTextField getCompileCommandLineTextField() {
        if (this.compileCommandLineTextField == null) {
            this.compileCommandLineTextField = new JTextField();
            this.compileCommandLineTextField.setBounds(new Rectangle(208, 79, 264, 20));
            this.compileCommandLineTextField.setToolTipText("Command Line for compiler");
            this.compileCommandLineTextField.setName("commandLineTextField");
            this.compileCommandLineTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditLanguagePane.this.enableUpdateButton();
                }
            });
        }
        return this.compileCommandLineTextField;
    }

    private JTextField getExecutableFilenameTextField() {
        if (this.executableFilenameTextField == null) {
            this.executableFilenameTextField = new JTextField();
            this.executableFilenameTextField.setBounds(new Rectangle(208, 113, 264, 20));
            this.executableFilenameTextField.setToolTipText("Form: exe");
            this.executableFilenameTextField.setName("programExeTextField");
            this.executableFilenameTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditLanguagePane.this.enableUpdateButton();
                }
            });
        }
        return this.executableFilenameTextField;
    }

    private JTextField getJTextField3() {
        if (this.jTextField3 == null) {
            this.jTextField3 = new JTextField();
            this.jTextField3.setBounds(new Rectangle(0, 0, 0, 0));
            this.jTextField3.setName("sourceExtTextField");
            this.jTextField3.setToolTipText("Form: *.cpp;*.c");
            this.jTextField3.setVisible(false);
        }
        return this.jTextField3;
    }

    private JTextField getProgramExecutionCommandLineTextField() {
        if (this.programExecutionCommandLineTextField == null) {
            this.programExecutionCommandLineTextField = new JTextField();
            this.programExecutionCommandLineTextField.setBounds(new Rectangle(274, 214, 198, 20));
            this.programExecutionCommandLineTextField.setToolTipText("Form: exe");
            this.programExecutionCommandLineTextField.setName("programCommandLine");
            this.programExecutionCommandLineTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditLanguagePane.this.enableUpdateButton();
                }
            });
        }
        return this.programExecutionCommandLineTextField;
    }

    private JComboBox<String> getAutoPopulateLanguageComboBox() {
        if (this.autoPopulateLanguageComboBox == null) {
            this.autoPopulateLanguageComboBox = new JComboBox();
            this.autoPopulateLanguageComboBox.setBounds(new Rectangle(209, 12, 259, 23));
            this.autoPopulateLanguageComboBox.setName("LangPopulateComboBox");
            this.autoPopulateLanguageComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditLanguagePane.this.autoFillFields();
                }
            });
        }
        return this.autoPopulateLanguageComboBox;
    }

    protected void autoFillFields() {
        String languageToFill = (String)this.getAutoPopulateLanguageComboBox().getSelectedItem();
        if (NO_CHANGE_TITLE.equals(languageToFill)) {
            return;
        }
        String[] values = LanguageAutoFill.getAutoFillValues(languageToFill);
        this.displayNameTextField.setText(values[4]);
        this.compileCommandLineTextField.setText(values[1]);
        this.executableFilenameTextField.setText(values[2]);
        this.programExecutionCommandLineTextField.setText(values[3]);
        this.judgeCommandLineTextBox.setText(values[3]);
        this.chckbxJudgesCommandLine.setSelected(false);
        boolean isScript = LanguageAutoFill.isInterpretedLanguage(languageToFill);
        this.getInterpretedLanguageCheckBox().setSelected(isScript);
        if (isScript) {
            this.executableFilenameTextField.setText("");
        }
        this.executableFilenameTextField.setEnabled(!isScript);
        this.deleteLanguageCheckbox.setSelected(false);
        this.enableUpdateButtons(true);
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.language != null) {
            Language newLanguage = null;
            try {
                newLanguage = this.getLanguageFromFields(null);
            }
            catch (InvalidFieldValue e) {
                e.printStackTrace();
            }
            enableButton = !this.language.isSameAs(newLanguage);
        } else if (this.getAddButton().isVisible()) {
            enableButton = true;
        }
        this.enableUpdateButtons(enableButton);
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(final Language language) {
        this.language = language;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditLanguagePane.this.populateGUI(language);
                EditLanguagePane.this.enableUpdateButtons(false);
            }
        });
    }

    private void populateGUI(Language language2) {
        this.populatingGUI = true;
        if (language2 != null) {
            this.displayNameTextField.setText(language2.getDisplayName());
            this.compileCommandLineTextField.setText(language2.getCompileCommandLine());
            this.executableFilenameTextField.setText(language2.getExecutableIdentifierMask());
            this.programExecutionCommandLineTextField.setText(language2.getProgramExecuteCommandLine());
            this.getAutoPopulateLanguageComboBox().setSelectedIndex(0);
            this.getDeleteLanguageCheckbox().setSelected(!language2.isActive());
            this.getInterpretedLanguageCheckBox().setSelected(language2.isInterpreted());
            this.chckbxJudgesCommandLine.setSelected(language2.isUsingJudgeProgramExecuteCommandLine());
            this.judgeCommandLineTextBox.setText(language2.getJudgeProgramExecuteCommandLine());
            this.getAddButton().setVisible(false);
            this.getUpdateButton().setVisible(true);
        } else {
            this.displayNameTextField.setText("");
            this.compileCommandLineTextField.setText("");
            this.executableFilenameTextField.setText("");
            this.programExecutionCommandLineTextField.setText("");
            this.chckbxJudgesCommandLine.setSelected(false);
            this.judgeCommandLineTextBox.setText("");
            this.getDeleteLanguageCheckbox().setSelected(false);
            this.getInterpretedLanguageCheckBox().setSelected(false);
            this.getAutoPopulateLanguageComboBox().setSelectedIndex(0);
            this.getAddButton().setVisible(true);
            this.getUpdateButton().setVisible(false);
        }
        this.populatingGUI = false;
    }

    protected void enableUpdateButtons(boolean editedText) {
        if (editedText) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        if (this.getUpdateButton().isVisible()) {
            this.getUpdateButton().setEnabled(editedText);
        } else {
            this.getAddButton().setEnabled(editedText);
        }
    }

    private JCheckBox getDeleteLanguageCheckbox() {
        if (this.deleteLanguageCheckbox == null) {
            this.deleteLanguageCheckbox = new JCheckBox();
            this.deleteLanguageCheckbox.setBounds(new Rectangle(275, 241, 224, 21));
            this.deleteLanguageCheckbox.setText("Hide Language");
            this.deleteLanguageCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditLanguagePane.this.enableUpdateButton();
                }
            });
        }
        return this.deleteLanguageCheckbox;
    }

    private JCheckBox getInterpretedLanguageCheckBox() {
        if (this.interpretedLanguageCheckBox == null) {
            this.interpretedLanguageCheckBox = new JCheckBox();
            this.interpretedLanguageCheckBox.setBounds(new Rectangle(209, 143, 275, 21));
            this.interpretedLanguageCheckBox.setText("Script or Interpreted Language");
            this.interpretedLanguageCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditLanguagePane.this.toggleExecutable();
                }
            });
        }
        return this.interpretedLanguageCheckBox;
    }

    protected void toggleExecutable() {
        boolean intLang = this.getInterpretedLanguageCheckBox().isSelected();
        this.getExecutableFilenameTextField().setEnabled(intLang);
        this.enableUpdateButton();
    }
}

