/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class EditJudgementPane
extends JPanePlugin {
    private static final long serialVersionUID = 6229906311932197623L;
    private JPanel buttonPane = null;
    private JButton addButton = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JPanel centerPane = null;
    private JLabel jLabel2 = null;
    private JTextField displayNameTextField = null;
    private Judgement savedJudgement = null;
    private boolean populatingGUI = true;
    private JCheckBox deleteCheckBox = null;
    private JLabel judgementNameTitle = null;
    private JTextField acronymNameTextField;

    public EditJudgementPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(422, 179));
        this.add((Component)this.getCenterPane(), "Center");
        this.add((Component)this.getButtonPane(), "South");
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.addWindowCloserListener();
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EditJudgementPane.this.getParentFrame() != null) {
                    EditJudgementPane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            EditJudgementPane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    @Override
    public String getPluginTitle() {
        return "Edit Judgement Pane";
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setEnabled(false);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditJudgementPane.this.addJudgement();
                }
            });
        }
        return this.addButton;
    }

    protected void addJudgement() {
        Judgement newJudgement = this.getJudgementFromFields();
        String name = newJudgement.getDisplayName().trim();
        if (name.length() < 1) {
            JOptionPane.showMessageDialog(this, "Enter a judgement", "Missing judgement information", 0);
            return;
        }
        newJudgement.setDisplayName(name);
        this.getController().addNewJudgement(newJudgement);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private Judgement getJudgementFromFields() {
        Judgement judgement;
        if (this.savedJudgement == null) {
            judgement = new Judgement(this.displayNameTextField.getText());
            judgement.setAcronym(this.acronymNameTextField.getText());
        } else {
            judgement = this.savedJudgement;
            judgement.setDisplayName(this.displayNameTextField.getText());
            judgement.setAcronym(this.acronymNameTextField.getText());
        }
        judgement.setActive(!this.getDeleteCheckBox().isSelected());
        return judgement;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditJudgementPane.this.updateJudgement();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateJudgement() {
        Judgement newJudgement = this.getJudgementFromFields();
        String name = newJudgement.getDisplayName().trim();
        newJudgement.setDisplayName(name);
        this.getController().updateJudgement(newJudgement);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditJudgementPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled() || this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Judgement modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isEnabled()) {
                    this.addJudgement();
                } else {
                    this.updateJudgement();
                }
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.judgementNameTitle = new JLabel();
            this.judgementNameTitle.setBounds(new Rectangle(14, 18, 99, 24));
            this.judgementNameTitle.setHorizontalAlignment(4);
            this.judgementNameTitle.setText("Judgement");
            this.jLabel2 = new JLabel();
            this.jLabel2.setBounds(new Rectangle(0, 0, 0, 0));
            this.jLabel2.setName("SourceExtLabel");
            this.jLabel2.setForeground(Color.black);
            this.jLabel2.setHorizontalAlignment(4);
            this.jLabel2.setText("Source Extensions");
            this.jLabel2.setVisible(false);
            this.centerPane = new JPanel();
            this.centerPane.setLayout(null);
            this.centerPane.setName("advancedEdit");
            this.centerPane.add((Component)this.jLabel2, this.jLabel2.getName());
            this.centerPane.add((Component)this.getDisplayNameTextField(), this.getDisplayNameTextField().getName());
            this.centerPane.add((Component)this.getDeleteCheckBox(), null);
            this.centerPane.add((Component)this.judgementNameTitle, null);
            JLabel lblAcronym = new JLabel();
            lblAcronym.setText("Acronym");
            lblAcronym.setHorizontalAlignment(4);
            lblAcronym.setBounds(new Rectangle(14, 18, 99, 24));
            lblAcronym.setBounds(24, 58, 99, 24);
            this.centerPane.add(lblAcronym);
            this.acronymNameTextField = new JTextField();
            this.acronymNameTextField.setToolTipText("Acronym for Judgement");
            this.acronymNameTextField.setName("acronymNameTextField");
            this.acronymNameTextField.setBounds(new Rectangle(126, 20, 263, 20));
            this.acronymNameTextField.setBounds(136, 60, 263, 20);
            this.acronymNameTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditJudgementPane.this.enableUpdateButton();
                }
            });
            this.centerPane.add(this.acronymNameTextField);
        }
        return this.centerPane;
    }

    private JTextField getDisplayNameTextField() {
        if (this.displayNameTextField == null) {
            this.displayNameTextField = new JTextField();
            this.displayNameTextField.setBounds(new Rectangle(136, 20, 263, 20));
            this.displayNameTextField.setToolTipText("Name to display to users");
            this.displayNameTextField.setName("displayNameTextField");
            this.displayNameTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditJudgementPane.this.enableUpdateButton();
                }
            });
        }
        return this.displayNameTextField;
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.savedJudgement != null) {
            Judgement judgement = new Judgement(this.displayNameTextField.getText());
            judgement.setDisplayName(this.displayNameTextField.getText());
            judgement.setActive(!this.getDeleteCheckBox().isSelected());
            judgement.setAcronym(this.acronymNameTextField.getText());
            enableButton = !this.savedJudgement.isSameAs(judgement);
        } else if (this.getAddButton().isVisible()) {
            enableButton = true;
        }
        this.enableUpdateButtons(enableButton);
    }

    public Judgement getJudgement() {
        return this.savedJudgement;
    }

    public void setJudgement(final Judgement judgement) {
        this.savedJudgement = judgement;
        if (judgement == null) {
            this.setDeleteCheckBoxEnabled(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditJudgementPane.this.populateGUI(judgement);
                EditJudgementPane.this.enableUpdateButtons(false);
            }
        });
    }

    public void setDeleteCheckBoxEnabled(boolean enabled) {
        this.getDeleteCheckBox().setEnabled(enabled);
    }

    private void populateGUI(Judgement judgement2) {
        this.populatingGUI = true;
        if (judgement2 != null) {
            this.displayNameTextField.setText(judgement2.getDisplayName());
            this.getAddButton().setVisible(false);
            this.getUpdateButton().setVisible(true);
            this.getDeleteCheckBox().setSelected(!judgement2.isActive());
            this.acronymNameTextField.setText(judgement2.getAcronym());
        } else {
            this.displayNameTextField.setText("");
            this.acronymNameTextField.setText("");
            this.getAddButton().setVisible(true);
            this.getUpdateButton().setVisible(false);
            this.getDeleteCheckBox().setSelected(false);
        }
        this.populatingGUI = false;
    }

    protected void enableUpdateButtons(boolean changed) {
        if (changed) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        if (this.getUpdateButton().isVisible()) {
            this.getUpdateButton().setEnabled(changed);
        } else {
            this.getAddButton().setEnabled(changed);
        }
    }

    private JCheckBox getDeleteCheckBox() {
        if (this.deleteCheckBox == null) {
            this.deleteCheckBox = new JCheckBox();
            this.deleteCheckBox.setBounds(new Rectangle(136, 100, 208, 21));
            this.deleteCheckBox.setText("Hide Judgement");
            this.deleteCheckBox.setToolTipText("Hide this judgement from judges");
            this.deleteCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditJudgementPane.this.enableUpdateButton();
                }
            });
        }
        return this.deleteCheckBox;
    }
}

