/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.ui.IEditChangeCallback;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.NotificationPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class EditJudgementNotificationPane
extends JPanePlugin
implements IEditChangeCallback {
    private static final long serialVersionUID = -6654853645826212444L;
    private JPanel topPane = null;
    private JPanel centerPanel = null;
    private NotificationPane preliminaryNotificationPane = null;
    private NotificationPane finalNotificationPane = null;
    private NotificationSetting notificationSetting = null;
    private JLabel titleLabel = null;
    private IEditChangeCallback callback = null;

    public EditJudgementNotificationPane(NotificationSetting inNotificationSetting, IEditChangeCallback ieCallback) {
        this.notificationSetting = inNotificationSetting;
        this.callback = ieCallback;
        this.initialize();
    }

    private void initialize() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(5);
        this.setLayout(borderLayout);
        this.setSize(new Dimension(441, 164));
        this.add((Component)this.getTopPane(), "North");
        this.add((Component)this.getCenterPanel(), "Center");
        if (this.notificationSetting != null) {
            this.setNotificationSetting(this.notificationSetting);
        }
    }

    @Override
    public String getPluginTitle() {
        return "Edit Judgement Notifications";
    }

    private JPanel getTopPane() {
        if (this.topPane == null) {
            this.titleLabel = new JLabel();
            this.titleLabel.setText("");
            this.titleLabel.setFont(new Font("Dialog", 1, 14));
            this.titleLabel.setHorizontalAlignment(0);
            this.topPane = new JPanel();
            this.topPane.setLayout(new BorderLayout());
            this.topPane.add((Component)this.titleLabel, "North");
        }
        return this.topPane;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 1;
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BoxLayout(this.getCenterPanel(), 1));
            this.centerPanel.add((Component)this.getPreliminaryNotificationPane(), null);
            this.centerPanel.add((Component)this.getFinalNotificationPane(), null);
        }
        return this.centerPanel;
    }

    private NotificationPane getPreliminaryNotificationPane() {
        if (this.preliminaryNotificationPane == null) {
            this.preliminaryNotificationPane = new NotificationPane();
            this.preliminaryNotificationPane.setBorder(BorderFactory.createTitledBorder(null, "Preliminary Judgement", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        }
        return this.preliminaryNotificationPane;
    }

    private NotificationPane getFinalNotificationPane() {
        if (this.finalNotificationPane == null) {
            this.finalNotificationPane = new NotificationPane();
            this.finalNotificationPane.setBorder(BorderFactory.createTitledBorder(null, "Final Judgements", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
        }
        return this.finalNotificationPane;
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getFinalNotificationPane().setCallback(this);
        this.getPreliminaryNotificationPane().setCallback(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditJudgementNotificationPane.this.updateTitle();
            }
        });
    }

    protected void updateTitle() {
        Problem problem = this.getContest().getProblem(this.notificationSetting.getElementId());
        if (problem != null) {
            this.setTitle(problem.getDisplayName());
        }
    }

    public NotificationSetting getNotificationSettingFromFields() {
        NotificationSetting newNotificationSetting = new NotificationSetting(this.notificationSetting.getElementId());
        newNotificationSetting.setPreliminaryNotificationYes(this.getPreliminaryNotificationPane().getYesJudgementNotificationFromFields());
        newNotificationSetting.setPreliminaryNotificationNo(this.getPreliminaryNotificationPane().getNoJudgementNotificationFromFields());
        newNotificationSetting.setFinalNotificationYes(this.getFinalNotificationPane().getYesJudgementNotificationFromFields());
        newNotificationSetting.setFinalNotificationNo(this.getFinalNotificationPane().getNoJudgementNotificationFromFields());
        return newNotificationSetting;
    }

    public NotificationSetting getNotificationSetting() {
        return this.notificationSetting;
    }

    public void setNotificationSetting(NotificationSetting inNotificationSetting) {
        this.notificationSetting = inNotificationSetting;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditJudgementNotificationPane.this.populateGUI(EditJudgementNotificationPane.this.notificationSetting);
            }
        });
    }

    protected void populateGUI(NotificationSetting notificationSetting2) {
        this.getPreliminaryNotificationPane().setJudgementNotifications(notificationSetting2.getPreliminaryNotificationYes(), notificationSetting2.getPreliminaryNotificationNo());
        this.getFinalNotificationPane().setJudgementNotifications(notificationSetting2.getFinalNotificationYes(), notificationSetting2.getFinalNotificationNo());
    }

    public void setTitle(final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditJudgementNotificationPane.this.titleLabel.setText(title);
            }
        });
    }

    @Override
    public void itemChanged(JComponent component) {
        this.callback.itemChanged(component);
    }
}

