/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.EditBalloonSettingPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;

public class EditBalloonSettingsFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -5032031472446676474L;
    private IInternalContest contest = null;
    private IInternalController controller = null;
    private EditBalloonSettingPane balloonSettingPane = null;

    public EditBalloonSettingsFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(618, 450));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getBalloonSettingPane());
        this.setTitle("Edit Balloon Settings");
        FrameUtilities.centerFrame(this);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getBalloonSettingPane().setContestAndController(this.contest, this.controller);
        this.getBalloonSettingPane().setParentFrame(this);
    }

    @Override
    public String getPluginTitle() {
        return "Edit Balloon Settings Frame";
    }

    private EditBalloonSettingPane getBalloonSettingPane() {
        if (this.balloonSettingPane == null) {
            this.balloonSettingPane = new EditBalloonSettingPane();
        }
        return this.balloonSettingPane;
    }

    public void setBalloonSettings(BalloonSettings balloonSettings) {
        this.getBalloonSettingPane().setBalloonSettings(balloonSettings);
        if (balloonSettings != null) {
            this.setTitle("Edit Notification Settings for Site " + balloonSettings.getSiteNumber());
        } else {
            this.setTitle("Add Notification Settings");
        }
    }
}

