/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.HeapSorter;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.JudgementNotification;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.ui.EditJudgementNotificationFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class EOCNotificationsPane
extends JPanePlugin {
    private static final long serialVersionUID = 372287370869620482L;
    private JPanel buttonPane = null;
    private MCLB eocNotificationMCLB = null;
    private JButton editButton = null;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private EditJudgementNotificationFrame editJudgementNotificationFrame = null;
    private Log log;

    public EOCNotificationsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(564, 229));
        this.add((Component)((Object)this.getNotificationListBox()), "Center");
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getNotificationButtonPane(), "South");
        this.editJudgementNotificationFrame = new EditJudgementNotificationFrame();
    }

    @Override
    public String getPluginTitle() {
        return "Notifications Pane";
    }

    private JPanel getNotificationButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getEditButton(), null);
        }
        return this.buttonPane;
    }

    private MCLB getNotificationListBox() {
        if (this.eocNotificationMCLB == null) {
            this.eocNotificationMCLB = new MCLB();
            Object[] cols = new Object[]{"Letter", "Problem", "Final", "Preliminary"};
            this.eocNotificationMCLB.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            this.eocNotificationMCLB.setColumnSorter(0, sorter, 1);
            this.eocNotificationMCLB.setColumnSorter(1, sorter, 2);
            this.eocNotificationMCLB.setColumnSorter(2, sorter, 3);
            this.eocNotificationMCLB.setColumnSorter(3, sorter, 4);
            this.eocNotificationMCLB.autoSizeAllColumns();
        }
        return this.eocNotificationMCLB;
    }

    public void updateNotificationRow(final Problem problem) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] objects = EOCNotificationsPane.this.buildNotificationRow(problem);
                int rowNumber = EOCNotificationsPane.this.eocNotificationMCLB.getIndexByKey(problem);
                if (rowNumber == -1) {
                    EOCNotificationsPane.this.eocNotificationMCLB.addRow(objects, problem);
                } else {
                    EOCNotificationsPane.this.eocNotificationMCLB.replaceRow(objects, rowNumber);
                }
                EOCNotificationsPane.this.eocNotificationMCLB.autoSizeAllColumns();
            }
        });
    }

    protected String getProblemLetter(Problem problem) {
        char let = 'A';
        int count = 0;
        Problem[] problemArray = this.getContest().getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem2 = problemArray[n2];
            if (problem2.equals(problem)) {
                let = (char)(let + count);
            }
            ++count;
            ++n2;
        }
        return "" + let;
    }

    protected Object[] buildNotificationRow(Problem problem) {
        int numberColumns = this.eocNotificationMCLB.getColumnCount();
        Object[] c = new String[numberColumns];
        c[0] = this.getProblemLetter(problem);
        c[1] = problem.getDisplayName();
        c[2] = "";
        c[3] = "";
        NotificationSetting notificationSetting = this.getNotificationSetting(problem);
        if (notificationSetting != null) {
            c[2] = this.getNotificationSettingsString(notificationSetting.getFinalNotificationYes(), notificationSetting.getFinalNotificationNo());
            c[3] = this.getNotificationSettingsString(notificationSetting.getPreliminaryNotificationYes(), notificationSetting.getPreliminaryNotificationNo());
        }
        return c;
    }

    public static String getClientTitle(ClientId clientId) {
        if (clientId.getSiteNumber() == 0 && clientId.getClientNumber() == 0 && clientId.getClientType().equals((Object)ClientType.Type.TEAM)) {
            return "All teams";
        }
        return String.valueOf(clientId.getName()) + " Site " + clientId.getSiteNumber();
    }

    protected String getNotificationSettingsString(JudgementNotification notificationYes, JudgementNotification notificationNo) {
        String s = "";
        if (notificationYes.isNotificationSupressed()) {
            s = "Yes";
            if (notificationYes.getCuttoffMinutes() > 0) {
                s = String.valueOf(s) + " cutoff " + notificationYes.getCuttoffMinutes() + " min";
            }
        }
        if (notificationNo.isNotificationSupressed()) {
            s = String.valueOf(s) + " No";
            if (notificationNo.getCuttoffMinutes() > 0) {
                s = String.valueOf(s) + " cutoff " + notificationNo.getCuttoffMinutes() + " min";
            }
        }
        return s;
    }

    private void reloadListBox() {
        this.eocNotificationMCLB.removeAllRows();
        Problem[] problemArray = this.getContest().getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            this.updateNotificationRow(problem);
            ++n2;
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.editJudgementNotificationFrame.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EOCNotificationsPane.this.reloadListBox();
            }
        });
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setToolTipText("Edit existing Notification definition");
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EOCNotificationsPane.this.editSelectedNotification();
                }
            });
        }
        return this.editButton;
    }

    protected void editSelectedNotification() {
        try {
            this.editJudgementNotificationFrame.resetAllNotificationSettings();
            this.editJudgementNotificationFrame.setVisible(true);
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit notification, check log");
            e.printStackTrace();
        }
    }

    private NotificationSetting getNotificationSetting(Problem problem) {
        ContestInformation contestInformation = this.getContest().getContestInformation();
        JudgementNotificationsList judgementNotificationsList = contestInformation.getJudgementNotificationsList();
        if (judgementNotificationsList == null) {
            return null;
        }
        return judgementNotificationsList.get(problem);
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public class ContestInformationListenerImplementation
    implements IContestInformationListener {
        @Override
        public void contestInformationAdded(ContestInformationEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EOCNotificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void contestInformationChanged(ContestInformationEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EOCNotificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void contestInformationRemoved(ContestInformationEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EOCNotificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EOCNotificationsPane.this.reloadListBox();
                }
            });
        }

        @Override
        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
        }
    }

    private class ProblemListenerImplementation
    implements IProblemListener {
        private ProblemListenerImplementation() {
        }

        @Override
        public void problemAdded(final ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EOCNotificationsPane.this.updateNotificationRow(event.getProblem());
                }
            });
        }

        @Override
        public void problemChanged(final ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EOCNotificationsPane.this.updateNotificationRow(event.getProblem());
                }
            });
        }

        @Override
        public void problemRemoved(ProblemEvent event) {
            EOCNotificationsPane.this.log.info("debug Problem REMOVED  " + event.getProblem());
        }

        @Override
        public void problemRefreshAll(ProblemEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EOCNotificationsPane.this.reloadListBox();
                }
            });
        }
    }
}

