/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Pluralize;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.AccountsReport;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.LanguagesReport;
import edu.csus.ecs.pc2.core.report.ProblemsReport;
import edu.csus.ecs.pc2.core.report.SitesReport;
import edu.csus.ecs.pc2.ui.MCLB;
import edu.csus.ecs.pc2.ui.PluginPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class ContestSummaryPane
extends PluginPane {
    private static final long serialVersionUID = -5998522945378354709L;
    private MCLB contestListBox = null;

    public ContestSummaryPane() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(459, 217));
        this.add((Component)((Object)this.getContestListBox()), "Center");
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContestSummaryPane.this.populateUI();
            }
        });
    }

    protected void populateUI() {
        Language[] languages = this.getContest().getLanguages();
        Problem[] problems = this.getContest().getProblems();
        Site[] sites = this.getContest().getSites();
        ClientSettings[] settings = this.getContest().getClientSettingsList();
        this.addContestRow(sites.length, "site", new SitesReport());
        this.addContestRow(problems.length, "problem", new ProblemsReport());
        if (problems.length > 0) {
            int ansCount = 0;
            int datCount = 0;
            Problem[] problemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                Problem problem = problemArray[n2];
                ProblemDataFiles pdfiles = this.getContest().getProblemDataFile(problem);
                if (pdfiles != null) {
                    ansCount += pdfiles.getJudgesAnswerFiles().length;
                    datCount += pdfiles.getJudgesDataFiles().length;
                }
                ++n2;
            }
            this.addContestRow(datCount, "input data file", null);
            this.addContestRow(ansCount, "answer data file", null);
        }
        this.addContestRow(languages.length, "language", new LanguagesReport());
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n3 = 0;
        while (n3 < n) {
            ClientType.Type type = typeArray[n3];
            Vector<Account> accounts = this.getContest().getAccounts(type);
            String accountTypeName = type.toString().toLowerCase();
            if (accounts.size() > 0) {
                Filter filter = new Filter();
                Account[] list = accounts.toArray(new Account[accounts.size()]);
                filter.addAccounts(list);
                String s = this.pluralizeEntry(accounts.size(), accountTypeName, " account");
                this.addContestRow(accounts.size(), s, new AccountsReport());
            }
            ++n3;
        }
        this.addContestRow(settings.length, "AJ setting", null);
    }

    String pluralizeEntry(int count, String prefix, String entryName) {
        String pluralized;
        StringBuffer buf = new StringBuffer();
        if (count > 0) {
            pluralized = Pluralize.pluralize(entryName, count);
            if (prefix.length() > 0) {
                buf.append(prefix);
            }
        } else {
            return entryName;
        }
        buf.append(' ');
        buf.append(pluralized);
        return buf.toString();
    }

    private void addContestRow(int count, String description, IReport report) {
        Object[] cols = new Object[this.getContestListBox().getColumnCount()];
        cols[0] = Integer.toString(count);
        cols[1] = description;
        cols[2] = report == null ? "No Report" : this.getReportButton(report, description);
        this.getContestListBox().addRow(cols);
        this.getContestListBox().autoSizeAllColumns();
    }

    private JButton getReportButton(final IReport report, final String description) {
        JButton button = new JButton("Report");
        button.setToolTipText(description);
        button.setPreferredSize(new Dimension(35, 35));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Utilities.viewReport(report, description, ContestSummaryPane.this.getContest(), ContestSummaryPane.this.getController());
            }
        });
        return button;
    }

    private MCLB getContestListBox() {
        if (this.contestListBox == null) {
            this.contestListBox = new MCLB();
            Object[] cols = new Object[]{"Count", "Description", "Report"};
            this.contestListBox.addColumns(cols);
        }
        return this.contestListBox;
    }
}

