/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ContestClockDisplay
implements ActionListener,
UIPlugin {
    private static final long serialVersionUID = 8137635697344335832L;
    private Vector<JLabel> elapsedTimeLabelList = new Vector();
    private Vector<JLabel> remainingtimeLabelList = new Vector();
    private Hashtable<Integer, Vector<JLabel>> sitesElapsedTimeLabelList = new Hashtable();
    private Hashtable<Integer, Vector<JLabel>> sitesRemainingtimeLabelList = new Hashtable();
    private Hashtable<Integer, ContestTime> contestTimes = new Hashtable();
    private Timer timer = new Timer(500, this);
    private JFrame clientFrame = null;
    private boolean teamDisplayMode = false;
    private boolean alwaysUpdateTitle = false;
    private DisplayTimes titleTimeToDisplay = DisplayTimes.REMAINING_TIME;
    private String savedFrameTitle = null;
    private boolean frameTitleSet = false;
    private Integer localSiteNumber = new Integer(0);
    private Log log = null;
    private IInternalController controller;
    private IInternalContest contest;

    public ContestClockDisplay(Log log, ContestTime contestTime, int localSiteNum, boolean isTeamDisplay, JFrame clientFrame) {
        this.log = log;
        this.localSiteNumber = localSiteNum;
        this.contestTimes.put(this.localSiteNumber, contestTime);
        this.sitesElapsedTimeLabelList.put(this.localSiteNumber, this.elapsedTimeLabelList);
        this.sitesRemainingtimeLabelList.put(this.localSiteNumber, this.remainingtimeLabelList);
        this.setClientFrame(clientFrame);
        this.teamDisplayMode = isTeamDisplay;
        this.clientFrame = clientFrame;
        this.fireClockStateChange(contestTime);
    }

    public void fireClockStateChange(final ContestTime contestTime) {
        this.contestTimes.put(contestTime.getSiteNumber(), contestTime);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (contestTime.isContestRunning()) {
                    ContestClockDisplay.this.startClockDisplay(contestTime.getSiteNumber());
                } else {
                    ContestClockDisplay.this.stopClockDisplay(contestTime.getSiteNumber());
                }
                ContestClockDisplay.this.updateTimeLabels();
            }
        });
    }

    private void updateTimeLabels() {
        Enumeration<Integer> enumeration = this.contestTimes.keys();
        while (enumeration.hasMoreElements()) {
            Integer element = enumeration.nextElement();
            this.updateTimeLabel(element);
        }
    }

    private void fireClockStateChange(ContestTime contestTime, final int siteNumber) {
        this.contestTimes.put(new Integer(siteNumber), contestTime);
        final ContestTime theContestTime = this.contestTimes.get(new Integer(siteNumber));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (theContestTime.isContestRunning()) {
                    ContestClockDisplay.this.startClockDisplay(siteNumber);
                } else {
                    ContestClockDisplay.this.stopClockDisplay(siteNumber);
                }
                ContestClockDisplay.this.updateTimeLabels();
            }
        });
    }

    public void addLabeltoUpdateList(JLabel labelToUpdate, DisplayTimes whichTime, int siteNumber) {
        if (whichTime == DisplayTimes.ELAPSED_TIME) {
            Vector<JLabel> list = this.sitesElapsedTimeLabelList.get(new Integer(siteNumber));
            if (list == null) {
                list = new Vector();
            }
            list.addElement(labelToUpdate);
            this.sitesElapsedTimeLabelList.put(new Integer(siteNumber), list);
        } else {
            Vector<JLabel> list = this.sitesRemainingtimeLabelList.get(new Integer(siteNumber));
            if (list == null) {
                list = new Vector();
            }
            list.addElement(labelToUpdate);
            this.sitesRemainingtimeLabelList.put(new Integer(siteNumber), list);
        }
        this.updateTimeLabels();
    }

    public void removeLabelFromAllUpdateLists(JLabel labelToUpdate) {
        try {
            Enumeration<Integer> enumeration = this.contestTimes.keys();
            while (enumeration.hasMoreElements()) {
                Integer element = enumeration.nextElement();
                this.removeLabelFromUpdateList(labelToUpdate, element);
            }
        }
        catch (Exception exception) {
            System.out.println("removeLabelFromAllUpdateLists Exception ");
        }
    }

    public void removeLabelFromUpdateList(JLabel labelToUpdate, int siteNumber) {
        Vector<JLabel> list = null;
        try {
            list = this.sitesElapsedTimeLabelList.get(siteNumber);
            list.removeElement(labelToUpdate);
            this.sitesElapsedTimeLabelList.put(siteNumber, list);
        }
        catch (Exception exception) {
            this.log.config("removeLabelFromUpdateList: Elapsed attempted to remove label that was not there");
        }
        try {
            list = this.sitesRemainingtimeLabelList.get(siteNumber);
            list.removeElement(labelToUpdate);
            this.sitesRemainingtimeLabelList.put(siteNumber, list);
        }
        catch (Exception exception) {
            this.log.config("removeLabelFromUpdateList: Remaining attempted to remove label that was not there");
        }
    }

    private void startClockDisplay(final int siteNumber) {
        this.timer.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i;
                Vector list = (Vector)ContestClockDisplay.this.sitesElapsedTimeLabelList.get(siteNumber);
                if (list == null) {
                    ContestClockDisplay.this.log.fine("sitesElapsedTimeLabelList for " + siteNumber + " is null.");
                } else {
                    i = 0;
                    while (i < list.size()) {
                        ((JLabel)list.elementAt(i)).setForeground(Color.BLACK);
                        ++i;
                    }
                }
                list = (Vector)ContestClockDisplay.this.sitesRemainingtimeLabelList.get(new Integer(siteNumber));
                if (list == null) {
                    ContestClockDisplay.this.log.fine("sitesRemainingtimeLabelList for " + siteNumber + " is null.");
                } else {
                    i = 0;
                    while (i < list.size()) {
                        ((JLabel)list.elementAt(i)).setForeground(Color.BLACK);
                        ++i;
                    }
                }
            }
        });
    }

    private void stopClockDisplay(int siteNumber) {
        int i;
        this.timer.stop();
        Vector<JLabel> list = this.sitesElapsedTimeLabelList.get(new Integer(siteNumber));
        if (list == null) {
            this.log.fine("sitesElapsedTimeLabelList for " + siteNumber + " is null");
        } else {
            i = 0;
            while (i < list.size()) {
                list.elementAt(i).setForeground(Color.RED);
                ++i;
            }
        }
        list = this.sitesRemainingtimeLabelList.get(new Integer(siteNumber));
        if (list == null) {
            this.log.fine("sitesRemainingtimeLabelList for " + siteNumber + " is null");
        } else {
            i = 0;
            while (i < list.size()) {
                list.elementAt(i).setForeground(Color.RED);
                ++i;
            }
        }
    }

    private void updateTimeLabel(final int siteNumber) {
        final ContestTime contestTime = this.contestTimes.get(new Integer(siteNumber));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int i;
                    long secsLeft;
                    String clockText = "There no time like the present";
                    clockText = contestTime == null ? "***" : (contestTime.isContestRunning() ? (ContestClockDisplay.this.teamDisplayMode && contestTime.getRemainingSecs() < 120L ? "< 2 mins" : (ContestClockDisplay.this.teamDisplayMode ? contestTime.getRemainingMinStr() : ((secsLeft = contestTime.getRemainingSecs()) < 60L && secsLeft > -1L ? String.valueOf(secsLeft) + " seconds " : contestTime.getRemainingTimeStr()))) : (ContestClockDisplay.this.teamDisplayMode ? "STOPPED" : contestTime.getRemainingTimeStr()));
                    Vector list = (Vector)ContestClockDisplay.this.sitesElapsedTimeLabelList.get(new Integer(siteNumber));
                    if (list != null) {
                        i = 0;
                        while (i < list.size()) {
                            ((JLabel)list.elementAt(i)).setText(contestTime.getElapsedTimeStr());
                            ++i;
                        }
                    }
                    if ((list = (Vector)ContestClockDisplay.this.sitesRemainingtimeLabelList.get(new Integer(siteNumber))) != null) {
                        i = 0;
                        while (i < list.size()) {
                            ((JLabel)list.elementAt(i)).setText(clockText);
                            ++i;
                        }
                    }
                    if (siteNumber == ContestClockDisplay.this.localSiteNumber && ContestClockDisplay.this.clientFrame != null) {
                        if (ContestClockDisplay.this.clientFrame.getState() == 1 || ContestClockDisplay.this.isAlwaysUpdateTitle()) {
                            if (ContestClockDisplay.this.getTitleTimeToDisplay() == DisplayTimes.REMAINING_TIME) {
                                ContestClockDisplay.this.clientFrame.setTitle(String.valueOf(clockText) + " " + ContestClockDisplay.this.savedFrameTitle);
                            } else {
                                ContestClockDisplay.this.clientFrame.setTitle(String.valueOf(contestTime.getElapsedTimeStr()) + " " + ContestClockDisplay.this.savedFrameTitle);
                            }
                            ContestClockDisplay.this.frameTitleSet = true;
                        } else if (ContestClockDisplay.this.frameTitleSet) {
                            ContestClockDisplay.this.frameTitleSet = false;
                            ContestClockDisplay.this.clientFrame.setTitle(ContestClockDisplay.this.savedFrameTitle);
                        }
                    }
                }
                catch (Exception e) {
                    ContestClockDisplay.this.log.throwing("Something in here", "Exception in clock label display method", e);
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        ContestTime contestTime = this.contestTimes.get(this.localSiteNumber);
        this.fireClockStateChange(contestTime);
    }

    public void setContestTime(ContestTime contestTime, int siteNumber) {
        this.contestTimes.put(new Integer(siteNumber), contestTime);
    }

    public boolean isAlwaysUpdateTitle() {
        return this.alwaysUpdateTitle;
    }

    public void setAlwaysUpdateTitle(boolean alwaysUpdateTitle) {
        this.alwaysUpdateTitle = alwaysUpdateTitle;
    }

    public DisplayTimes getTitleTimeToDisplay() {
        return this.titleTimeToDisplay;
    }

    public void setTitleTimeToDisplay(DisplayTimes titleTimeToDisplay) {
        this.titleTimeToDisplay = titleTimeToDisplay;
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
        this.contest.addContestTimeListener(new ContestTimeListenerImplementation());
    }

    @Override
    public String getPluginTitle() {
        return "Contest Clock Display";
    }

    public void setClientFrame(JFrame clientFrame) {
        if (this.clientFrame == null && clientFrame != null) {
            this.clientFrame = clientFrame;
            this.savedFrameTitle = clientFrame.getTitle();
        }
    }

    public JFrame getClientFrame() {
        return this.clientFrame;
    }

    public class ContestTimeListenerImplementation
    implements IContestTimeListener {
        @Override
        public void contestTimeAdded(ContestTimeEvent event) {
            ContestClockDisplay.this.fireClockStateChange(event.getContestTime(), event.getContestTime().getSiteNumber());
        }

        @Override
        public void contestTimeRemoved(ContestTimeEvent event) {
        }

        @Override
        public void contestTimeChanged(ContestTimeEvent event) {
            ContestClockDisplay.this.fireClockStateChange(event.getContestTime(), event.getContestTime().getSiteNumber());
        }

        @Override
        public void contestStarted(ContestTimeEvent event) {
            ContestClockDisplay.this.fireClockStateChange(event.getContestTime(), event.getContestTime().getSiteNumber());
        }

        @Override
        public void contestStopped(ContestTimeEvent event) {
            ContestClockDisplay.this.fireClockStateChange(event.getContestTime(), event.getContestTime().getSiteNumber());
        }

        @Override
        public void refreshAll(ContestTimeEvent event) {
            ContestClockDisplay.this.fireClockStateChange(event.getContestTime(), event.getContestTime().getSiteNumber());
        }
    }

    public static enum DisplayTimes {
        ELAPSED_TIME,
        REMAINING_TIME;

    }
}

