/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.CategoryEvent;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.ICategoryListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.EditCategoryFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CategoriesPane
extends JPanePlugin {
    private static final long serialVersionUID = 7037601796882987184L;
    private MCLB categoryListBox = null;
    private JPanel buttonsPane = null;
    private JButton addButton = null;
    private JPanel statusPanel = null;
    private JButton editButton = null;
    private EditCategoryFrame editCategoryFrame;

    private EditCategoryFrame getEditCategoryFrame() {
        if (this.editCategoryFrame == null) {
            this.editCategoryFrame = new EditCategoryFrame();
        }
        return this.editCategoryFrame;
    }

    public CategoriesPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(584, 211));
        this.add((Component)this.getButtonsPane(), "South");
        this.add((Component)((Object)this.getCategoryListBox()), "Center");
    }

    @Override
    public String getPluginTitle() {
        return "Categories Panel";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addCategoryListener(new CategoryListenerImplementation());
        this.getEditCategoryFrame().setContestAndController(inContest, inController);
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CategoriesPane.this.updateGUIperPermissions();
                CategoriesPane.this.reloadCategoriesList();
            }
        });
    }

    private void updateGUIperPermissions() {
        this.addButton.setVisible(this.isAllowed(Permission.Type.ADD_CATEGORY));
        this.editButton.setVisible(this.isAllowed(Permission.Type.EDIT_CATEGORY));
    }

    private int numberOfClars(Category category) {
        int count = 0;
        ElementId elementId = category.getElementId();
        Clarification[] clarificationArray = this.getContest().getClarifications();
        int n = clarificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Clarification clar = clarificationArray[n2];
            if (!clar.isDeleted() && clar.getProblemId().equals(elementId)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    protected void reloadCategoriesList() {
        this.getCategoryListBox().removeAllRows();
        Category[] categoryArray = this.getContest().getCategories();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Category category = categoryArray[n2];
            this.updateCategoryRow(category);
            ++n2;
        }
        this.getCategoryListBox().autoSizeAllColumns();
    }

    private MCLB getCategoryListBox() {
        if (this.categoryListBox == null) {
            this.categoryListBox = new MCLB();
            this.categoryListBox.add(this.getStatusPanel(), "North");
            Object[] cols = new Object[]{"Category"};
            this.categoryListBox.addColumns(cols);
        }
        return this.categoryListBox;
    }

    private JPanel getButtonsPane() {
        if (this.buttonsPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            this.buttonsPane = new JPanel();
            this.buttonsPane.setLayout(flowLayout);
            this.buttonsPane.add((Component)this.getAddButton(), null);
            this.buttonsPane.add((Component)this.getEditButton(), null);
        }
        return this.buttonsPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setMnemonic(65);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CategoriesPane.this.addCategory();
                }
            });
        }
        return this.addButton;
    }

    protected void addCategory() {
        this.getEditCategoryFrame().setCategory(null);
        this.getEditCategoryFrame().setDeleteCheckBoxEnabled(true);
        this.getEditCategoryFrame().setVisible(true);
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BorderLayout());
            this.statusPanel.setPreferredSize(new Dimension(20, 20));
        }
        return this.statusPanel;
    }

    private void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    private void updateCategoryRow(final Category category) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] objects = CategoriesPane.this.buildCategoryRow(category);
                int rowNumber = CategoriesPane.this.categoryListBox.getIndexByKey(category.getElementId());
                if (rowNumber == -1) {
                    CategoriesPane.this.categoryListBox.addRow(objects, category.getElementId());
                } else {
                    CategoriesPane.this.categoryListBox.replaceRow(objects, rowNumber);
                }
                CategoriesPane.this.categoryListBox.autoSizeAllColumns();
            }
        });
    }

    private Object[] buildCategoryRow(Category category) {
        try {
            int cols = this.categoryListBox.getColumnCount();
            Object[] s = new String[cols];
            s[0] = category.toString();
            if (!category.isActive()) {
                s[0] = "[HIDDEN] " + category.toString();
            }
            return s;
        }
        catch (Exception exception) {
            StaticLog.getLog().log(Log.INFO, "Exception in buildCategoryRow()", exception);
            return null;
        }
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setMnemonic(69);
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CategoriesPane.this.editSelectedCategory();
                }
            });
        }
        return this.editButton;
    }

    protected void editSelectedCategory() {
        int selectedIndex = this.categoryListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.showMessage("Select a category to edit");
            return;
        }
        try {
            ElementId elementId = (ElementId)this.categoryListBox.getKeys()[selectedIndex];
            Category categoryToEdit = this.getContest().getCategory(elementId);
            int numberClars = this.numberOfClars(categoryToEdit);
            if (numberClars > 0) {
                JOptionPane.showMessageDialog(this, "There are " + numberClars + " clarifications which will be changed if this category is changed", "Clarifictions may be changed", 2);
            }
            this.getEditCategoryFrame().setCategory(categoryToEdit);
            this.getEditCategoryFrame().setVisible(true);
        }
        catch (Exception e) {
            this.getController().getLog().log(Log.WARNING, "Exception logged ", e);
            this.showMessage("Unable to edit category, check log");
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (CategoriesPane.this.getContest().getClientId().equals(account.getClientId())) {
                CategoriesPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CategoriesPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            Account[] accountArray = accounts = accountEvent.getAccounts();
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (CategoriesPane.this.getContest().getClientId().equals(account.getClientId())) {
                    CategoriesPane.this.initializePermissions();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CategoriesPane.this.updateGUIperPermissions();
                        }
                    });
                }
                ++n2;
            }
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            CategoriesPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CategoriesPane.this.updateGUIperPermissions();
                }
            });
        }
    }

    public class CategoryListenerImplementation
    implements ICategoryListener {
        @Override
        public void categoryAdded(CategoryEvent event) {
            CategoriesPane.this.reloadCategoriesList();
        }

        @Override
        public void categoryChanged(CategoryEvent event) {
            CategoriesPane.this.reloadCategoriesList();
        }

        @Override
        public void categoryRemoved(CategoryEvent event) {
            CategoriesPane.this.reloadCategoriesList();
        }

        @Override
        public void categoryRefreshAll(CategoryEvent event) {
            CategoriesPane.this.reloadCategoriesList();
        }
    }
}

