/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.tools;

import edu.csus.ecs.pc2.core.ParseArguments;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;

public class Netcat {
    private boolean debugFlag = false;
    private static final int DEFAULT_PORT = 4713;
    private static final String DEFAULT_HOST = "localhost";

    void readAndPrintSocketInput(Socket socket) {
        try {
            InputStreamReader inputReader = new InputStreamReader(socket.getInputStream());
            int data = inputReader.read();
            while (data != -1) {
                char theChar = (char)data;
                System.out.print(theChar);
                data = inputReader.read();
            }
            inputReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void dumpSocketInput(String host, int port) {
        try {
            Socket socket = new Socket(host, port);
            this.readAndPrintSocketInput(socket);
            System.err.println("*EOF* socket read locahost " + port);
        }
        catch (ConnectException e) {
            System.err.println("Host: '" + host + "' port=" + port);
            System.err.println(e);
        }
        catch (UnknownHostException e) {
            System.err.println("Host: '" + host + "' port=" + port);
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println("Host: '" + host + "' port=" + port);
            System.err.println(e);
        }
    }

    public void testClientRunner() throws Exception {
        if (this.debugFlag) {
            this.dumpSocketInput(DEFAULT_HOST, 4713);
        }
    }

    public static void main(String[] args) throws IOException {
        ParseArguments pa = new ParseArguments(args);
        if (pa.isOptPresent("-h") || pa.isOptPresent("--help")) {
            System.out.println("Usage: Netcat [--help] [hostname [port]]\n\nDefault port = 4713\n\n$Id$\n");
        } else if (args.length >= 2) {
            String hostName = args[0];
            if ("-".equals(hostName)) {
                hostName = DEFAULT_HOST;
            }
            int portNumber = Integer.parseInt(args[1]);
            new Netcat().dumpSocketInput(hostName, portNumber);
        } else if (pa.getArgCount() == 1) {
            String hostName = pa.getArg(0);
            int portNumber = 4713;
            new Netcat().dumpSocketInput(hostName, portNumber);
        } else {
            new Netcat().dumpSocketInput(DEFAULT_HOST, 4713);
        }
    }
}

