/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.services.eventFeed;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.services.eventFeed.EventFeedServer;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class EventFeederModule
implements UIPlugin {
    public static final int DEFAULT_EVENT_FEED_PORT_NUMBER = 4713;
    private static final long serialVersionUID = 4459685961401012498L;
    private int port = 4713;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private EventFeedServer eventFeedServer = new EventFeedServer();

    @Override
    public String getPluginTitle() {
        return "Event Feed Server (non-GUI)";
    }

    public EventFeederModule() {
        VersionInfo versionInfo = new VersionInfo();
        System.out.println(versionInfo.getSystemName());
        System.out.println(versionInfo.getSystemVersionInfo());
        System.out.println("Build " + versionInfo.getBuildNumber());
        System.out.println("Date: " + this.getL10nDateTime());
        System.out.println("Working directory is " + Utilities.getCurrentDirectory());
        System.out.println();
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
        try {
            this.showMessage("Starting Event Feed server on port " + this.port + " ...");
            this.eventFeedServer.startSocketListener(this.port, this.getContest(), false);
            this.showMessage("Event Feed server listening on port " + this.port);
        }
        catch (IOException e) {
            this.showMessage("Unable to start event feed server: " + e.getMessage());
            e.printStackTrace(System.err);
            this.getLog().log(Log.INFO, e.getMessage(), e);
        }
    }

    protected String getL10nDateTime() {
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        return dateFormatter.format(new Date());
    }

    private void showMessage(String string) {
        this.getLog().info(string);
        System.out.println(string);
    }

    public Log getLog() {
        return this.log;
    }

    public IInternalContest getContest() {
        return this.contest;
    }

    public IInternalController getController() {
        return this.controller;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

