/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.services.eventFeed;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.services.eventFeed.FeederThread;
import java.io.IOException;
import java.net.ServerSocket;

public class EventFeedServer {
    private FeederThread feederThread = null;
    private ServerSocket server = null;
    private boolean started = false;
    private int portUsed;

    public void startSocketListener(int port, IInternalContest contest, boolean filteredFeed) throws IOException {
        if (this.server != null) {
            throw new IOException("EventFeedServer already running (on port " + this.portUsed + ")");
        }
        this.portUsed = port;
        this.server = new ServerSocket(this.portUsed);
        if (Utilities.isDebugMode()) {
            this.log("Started socket on port " + this.portUsed);
        }
        this.feederThread = new FeederThread(this.server, contest, filteredFeed);
        new Thread(this.feederThread).start();
        this.started = true;
    }

    public boolean isListening() {
        if (this.started) {
            return this.feederThread.isRunning();
        }
        return false;
    }

    public void halt() throws IOException {
        if (this.started) {
            this.feederThread.halt();
            this.feederThread = null;
            this.server.close();
            this.server = null;
            this.started = false;
            if (Utilities.isDebugMode()) {
                this.log("Stopped socket on port " + this.portUsed);
            }
        }
    }

    private void log(String string) {
        System.out.println("debug - " + string);
        StaticLog.info(string);
    }

    public int getPort() {
        return this.portUsed;
    }
}

