/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.profile;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.exception.ProfileCloneException;
import edu.csus.ecs.pc2.core.exception.ProfileException;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.ProfileComparatorByName;
import edu.csus.ecs.pc2.core.security.FileSecurity;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.profile.ProfileLoadException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ProfileManager {
    public static final String DEFAULT_PROFILE_KEY = "current";
    public static final String PROFILE_INDEX_FILENAME = "profiles.properties";
    private static final String ACTIVE_PREFIX = "active=";
    private String propertiesFileName = "profiles.properties";
    private String delimiter = ",";

    public ProfileManager() {
        this.propertiesFileName = PROFILE_INDEX_FILENAME;
    }

    public ProfileManager(String filename) {
        this.propertiesFileName = filename;
    }

    public Profile[] load(String filename) throws IOException, ProfileLoadException {
        if (new File(filename).exists()) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(filename));
            return this.toProfiles(properties);
        }
        throw new FileNotFoundException(filename);
    }

    public Profile[] load() throws IOException, ProfileLoadException {
        return this.load(this.propertiesFileName);
    }

    public void add(String filename, Profile profile) throws IOException, ProfileLoadException {
        if (this.hasDefaultProfile()) {
            Profile[] profiles = this.load(filename);
            Profile defaultProfile = this.getDefaultProfile(filename);
            this.store(filename, profiles, defaultProfile);
        } else {
            this.storeDefaultProfile(filename, profile);
        }
    }

    public void add(Profile profile) throws IOException, ProfileLoadException {
        this.add(this.propertiesFileName, profile);
    }

    public boolean isProfileAvailable(Profile profile, int siteNumber, char[] contestPassword) throws ProfileException {
        return this.getProfileStorage(profile, siteNumber, contestPassword) != null;
    }

    public IStorage getProfileStorage(Profile profile, int siteNumber, char[] contestPassword) throws ProfileException {
        if (profile == null) {
            throw new IllegalArgumentException("Profile can not be null");
        }
        String profilePath = profile.getProfilePath();
        if (new File(profilePath).isDirectory()) {
            String dbDirectory = String.valueOf(profilePath) + File.separator + "db." + siteNumber;
            if (!new File(dbDirectory).isDirectory()) {
                throw new ProfileException(profile, "Profile DB directory does not exist: " + dbDirectory);
            }
            profilePath = dbDirectory;
            FileSecurity fileSecurity = new FileSecurity(profilePath);
            try {
                boolean validPassword = fileSecurity.verifyPassword(contestPassword);
                if (validPassword) {
                    return fileSecurity;
                }
                throw new ProfileException(profile, "Profile contest password is not correct");
            }
            catch (FileSecurityException e) {
                throw new ProfileException(profile, (Throwable)e);
            }
        }
        throw new ProfileException(profile, "Profile directory does not exist: " + profilePath);
    }

    public boolean hasDefaultProfile() {
        return this.hasDefaultProfile(this.propertiesFileName);
    }

    public boolean hasDefaultProfile(String filename) {
        if (new File(filename).exists()) {
            try {
                return this.getDefaultProfile() != null;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public Profile getDefaultProfile() throws IOException, ProfileLoadException {
        return this.getDefaultProfile(this.propertiesFileName);
    }

    public Profile getDefaultProfile(String filename) throws IOException, ProfileLoadException {
        if (new File(filename).exists()) {
            Profile profile = null;
            Properties properties = new Properties();
            properties.load(new FileInputStream(filename));
            String key = properties.getProperty(DEFAULT_PROFILE_KEY);
            if (key != null) {
                String profileLine = properties.getProperty(key);
                return this.toProfile(key, profileLine);
            }
            return profile;
        }
        throw new FileNotFoundException(filename);
    }

    private Profile toProfile(String key, String profileLine) throws ProfileLoadException {
        if (profileLine == null) {
            return null;
        }
        String[] fields = profileLine.split(this.delimiter);
        if (fields.length < 3) {
            throw new IllegalArgumentException("Too few fields for line: " + profileLine);
        }
        String title = this.stripQuote(fields[0]);
        String description = this.stripQuote(fields[1]);
        String path = this.stripQuote(fields[2]);
        String activeField = null;
        if (fields.length > 3) {
            activeField = fields[3];
        }
        if (title == null || title.length() == 0) {
            throw new ProfileLoadException("No title found in: " + profileLine);
        }
        Profile profile = new Profile(title);
        if (description != null) {
            profile.setDescription(description);
        }
        if (path == null || path.length() == 0) {
            throw new ProfileLoadException("No path found in: " + profileLine);
        }
        if (activeField == null) {
            profile.setActive(true);
        } else if (activeField.startsWith(ACTIVE_PREFIX)) {
            String newValue = activeField.replaceFirst(ACTIVE_PREFIX, "");
            profile.setActive(Boolean.parseBoolean(newValue));
        } else assert (false) : "Invalid active= field, active= not found";
        profile.setProfilePath(path);
        profile.setContestId(key);
        return profile;
    }

    protected String stripQuote(String string) {
        int idx;
        if (string == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(string);
        if (buffer.charAt(0) == '\"') {
            buffer.deleteCharAt(0);
        }
        if ((idx = buffer.lastIndexOf("\"")) > -1) {
            buffer.deleteCharAt(idx);
        }
        return buffer.toString();
    }

    private Profile[] toProfiles(Properties properties) throws ProfileLoadException {
        String[] keys;
        Vector<Profile> list = new Vector<Profile>();
        String[] stringArray = keys = properties.keySet().toArray(new String[properties.keySet().size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String profileLine = properties.getProperty(key);
            String[] fields = profileLine.split(this.delimiter);
            if (fields.length > 2) {
                Profile profile = this.toProfile(key, profileLine);
                list.add(profile);
            }
            ++n2;
        }
        return list.toArray(new Profile[list.size()]);
    }

    public boolean store(Profile[] profiles, Profile defaultProfile) throws IOException {
        return this.store(this.propertiesFileName, profiles, defaultProfile);
    }

    public boolean storeDefaultProfile(Profile defaultProfile) throws IOException {
        return this.storeDefaultProfile(this.propertiesFileName, defaultProfile);
    }

    public boolean storeDefaultProfile(String filename, Profile defaultProfile) throws IOException {
        Profile[] profiles = null;
        try {
            profiles = this.load();
        }
        catch (Exception exception) {
            profiles = new Profile[]{defaultProfile};
        }
        return this.store(filename, profiles, defaultProfile);
    }

    public boolean store(String filename, Profile[] profiles, Profile defaultProfile) throws IOException {
        Properties properties = new Properties();
        VersionInfo versionInfo = new VersionInfo();
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            String line = this.createProfileLine(profile);
            properties.put(profile.getElementId().toString(), line);
            ++n2;
        }
        if (!properties.containsKey(defaultProfile.getElementId().toString())) {
            String line = this.createProfileLine(defaultProfile);
            properties.put(defaultProfile.getElementId().toString(), line);
        }
        properties.put(DEFAULT_PROFILE_KEY, defaultProfile.getElementId().toString());
        properties.store(new FileOutputStream(filename), "Created by PC^2 Version " + versionInfo.getVersionNumber() + " " + versionInfo.getBuildNumber() + " $Id$ ");
        return true;
    }

    private String createProfileLine(Profile profile) {
        return String.valueOf(this.quoteString(profile.getName())) + this.delimiter + this.quoteString(profile.getDescription()) + this.delimiter + this.quoteString(profile.getProfilePath()) + this.delimiter + ACTIVE_PREFIX + profile.isActive() + this.delimiter;
    }

    private String quoteString(String name) {
        return "\"" + name + "\"";
    }

    public Profile[] mergeProfiles(Profile[] currentProfiles, Profile[] profiles) {
        Profile profile;
        int n;
        int n2;
        Profile[] profileArray;
        Hashtable<String, Profile> table = new Hashtable<String, Profile>();
        if (currentProfiles != null) {
            profileArray = currentProfiles;
            n2 = currentProfiles.length;
            n = 0;
            while (n < n2) {
                profile = profileArray[n];
                table.put(profile.getProfilePath(), profile);
                ++n;
            }
        }
        if (profiles != null) {
            profileArray = profiles;
            n2 = profiles.length;
            n = 0;
            while (n < n2) {
                profile = profileArray[n];
                table.put(profile.getProfilePath(), profile);
                ++n;
            }
        }
        return table.values().toArray(new Profile[table.values().size()]);
    }

    protected Profile findProfile(IInternalContest contest, Profile aProfile) {
        Profile[] profileArray = contest.getProfiles();
        int n = profileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (aProfile.getProfilePath().equals(profile.getProfilePath())) {
                return profile;
            }
            ++n2;
        }
        return null;
    }

    public static void dumpProfiles(String name, Profile[] profiles) {
        System.out.println(" dumpProfiles - " + name);
        Arrays.sort(profiles, new ProfileComparatorByName());
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            ProfileManager.dumpProfile(null, profile);
            ++n2;
        }
    }

    public static void dumpProfile(String name, Profile profile) {
        if (name != null) {
            System.out.println("dumpProfile - " + name);
        }
        System.out.printf("%-15s %6s %02d %-30s %-20s", profile.getName(), Boolean.toString(profile.isActive()), profile.getSiteNumber(), profile.getContestId(), profile.getDescription());
        System.out.println(" Path=" + profile.getProfilePath());
    }

    public void mergeProfiles(IInternalContest contest) throws IOException, ProfileLoadException {
        if (this.hasDefaultProfile()) {
            Profile[] profiles;
            Profile[] profileArray = profiles = this.load();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                Profile match = this.findProfile(contest, profile);
                if (match != null) {
                    if (!contest.getProfile().isSameAs(match)) {
                        match.setDescription(profile.getDescription());
                        match.setActive(profile.isActive());
                        match.setName(profile.getName());
                        contest.updateProfile(match);
                    }
                } else {
                    contest.addProfile(profile);
                }
                ++n2;
            }
        }
    }

    public static Profile createNewProfile() {
        Profile profile = new Profile("Default");
        profile.setDescription("Default Contest");
        return profile;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public void setPropertiesFileName(String propertiesFileName) {
        this.propertiesFileName = propertiesFileName;
    }

    public boolean createProfilesPathandFiles(Profile newProfile, int siteNumber, String password) throws FileSecurityException, ProfileCloneException {
        String profilePath = newProfile.getProfilePath();
        if (!new File(profilePath).isDirectory()) {
            try {
                new File(profilePath).mkdirs();
            }
            catch (Exception e) {
                throw new ProfileCloneException("Unable to create profile dir " + profilePath, e);
            }
            if (!new File(profilePath).isDirectory()) {
                throw new ProfileCloneException("Unable to use profile dir " + profilePath);
            }
            String databaseDirectoryName = String.valueOf(profilePath) + File.separator + "db." + siteNumber;
            try {
                new File(databaseDirectoryName).mkdirs();
            }
            catch (Exception e) {
                throw new ProfileCloneException("Unable to create DB dir " + profilePath, e);
            }
            FileSecurity fileSecurity = new FileSecurity(databaseDirectoryName);
            fileSecurity.saveSecretKey(password.toCharArray());
            fileSecurity = null;
            return true;
        }
        return false;
    }
}

