/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.imports.ccs;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.exception.YamlLoadException;
import edu.csus.ecs.pc2.core.list.AccountList;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AutoJudgeSetting;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.InternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageAutoFill;
import edu.csus.ecs.pc2.core.model.PlaybackInfo;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.Site;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class ContestYAMLLoader {
    public static final String CONTEST_NAME_KEY = "name";
    public static final String SHORT_NAME_KEY = "short-name";
    public static final String CONTEST_START_TIME = "start-time";
    public static final String CONTEST_DURATION = "duration";
    public static final String SCOREBOARD_FREEZE = "scoreboard-freeze";
    public static final String LANGUAGE_KEY = "languages";
    public static final String DEFAULT_CLARS_KEY = "default-clars";
    public static final String CLAR_CATEGORIES_KEY = "clar-categories";
    public static final String PROBLEMS_KEY = "problemset";
    public static final String JUDGING_TYPE_KEY = "judging-type";
    public static final String MANUAL_REVIEW_KEY = "manual-review";
    public static final String COMPUTER_JUDGING_KEY = "computer-judged";
    public static final String SEND_PRELIMINARY_JUDGEMENT_KEY = "send-prelim-judgement";
    public static final String USE_JUDGE_CMD_KEY = "use-judge-cmd";
    public static final String INTERPRETED_LANGUAGE_KEY = "interpreted";
    public static final String ACCOUNTS_KEY = "accounts";
    public static final String SITES_KEY = "sites";
    public static final String REPLAY_KEY = "replay";
    public static final String JUDGE_CONFIG_PATH_KEY = "judge-config-path";
    public static final String TIMEOUT_KEY = "timeout";
    public static final String LIMITS_KEY = "limits";
    private static final String DELIMIT = ":";
    public static final String DEFAULT_CONTEST_YAML_FILENAME = "contest.yaml";
    public static final String DEFAULT_PROBLEM_YAML_FILENAME = "problem.yaml";
    public static final String DEFAULT_PROBLEM_LATEX_FILENAME = "problem.tex";
    private static final String PROBLEM_NAME_KEY = "title";
    private static final String PROBLEM_INPUT_KEY = "input";
    public static final int DEFAULT_TIME_OUT = 30;
    public static final String AUTO_JUDGE_KEY = "auto-judging";
    public static final String INPUT_KEY = "input";
    public static final String PROBLEM_LOAD_DATA_FILES_KEY = "load-data-files";
    private static final String DEFAULT_VALIDATOR_KEY = "default-validator";
    private static final String OVERRIDE_VALIDATOR_KEY = "override-validator";
    private static final String MTSV_OVERRIDE_VALIDATOR_ARGS = "{:problemletter} {:resfile} {:basename} {:timelimit}";
    private static final String MTSV_PROGRAM_NAME = "mtsv";
    public static final String VALIDATOR_KEY = "validator";
    public static final String USING_PC2_VALIDATOR = "use-internal-validator";
    private static final String READ_FROM_STDIN_KEY = "readFromSTDIN";
    private boolean loadProblemDataFiles = true;

    public IInternalContest fromYaml(IInternalContest contest, String directoryName) {
        return this.fromYaml(contest, directoryName, false);
    }

    public IInternalContest fromYaml(IInternalContest contest, String directoryName, boolean loadDataFileContents) {
        String[] contents;
        try {
            contents = this.loadFileWithIncludes(directoryName, String.valueOf(directoryName) + File.separator + DEFAULT_CONTEST_YAML_FILENAME);
        }
        catch (IOException e) {
            throw new YamlLoadException(e);
        }
        return this.fromYaml(contest, contents, directoryName, loadDataFileContents);
    }

    public String[] loadFileWithIncludes(String dirname, String filename) throws IOException {
        String[] lines;
        if (!new File(filename).isFile()) {
            throw new FileNotFoundException(filename);
        }
        ArrayList<String> outs = new ArrayList<String>();
        String[] stringArray = lines = Utilities.loadFile(filename);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            outs.add(line);
            if (dirname != null && line.trim().startsWith("#include")) {
                String[] includeLines;
                String[] parts = line.split("\"");
                String includeFilename = String.valueOf(dirname) + File.separator + parts[1];
                String[] stringArray2 = includeLines = Utilities.loadFile(includeFilename);
                int n3 = includeLines.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string = stringArray2[n4];
                    outs.add(string);
                    ++n4;
                }
                outs.add("# end include " + includeFilename);
            }
            ++n2;
        }
        return outs.toArray(new String[outs.size()]);
    }

    public String getContestTitle(String contestYamlFilename) throws IOException {
        String[] contents = this.loadFileWithIncludes(null, contestYamlFilename);
        String contestTitle = this.getSequenceValue(contents, CONTEST_NAME_KEY);
        return contestTitle;
    }

    public String getJudgesCDPBasePath(String contestYamlFilename) throws IOException {
        String[] contents = this.loadFileWithIncludes(null, contestYamlFilename);
        String contestTitle = this.getSequenceValue(contents, JUDGE_CONFIG_PATH_KEY);
        return contestTitle;
    }

    public IInternalContest fromYaml(IInternalContest contest, String[] yamlLines, String directoryName, boolean loadDataFileContents) {
        String[] categories;
        Site[] sites;
        int n;
        File mtsvFile;
        String judgeCDPath;
        String startTime;
        contest = this.createContest(contest);
        String contestTitle = this.getSequenceValue(yamlLines, CONTEST_NAME_KEY);
        if (contestTitle != null) {
            this.setTitle(contest, contestTitle);
        }
        if ((startTime = this.getSequenceValue(yamlLines, CONTEST_START_TIME)) != null) {
            try {
                Date date = ContestYAMLLoader.parseStartTime(startTime);
                this.setContestStartDateTime(contest, date);
            }
            catch (ParseException e) {
                throw new YamlLoadException("Invalid start-time value '" + startTime + " expected form yyyy-MM-dd HH:mm, " + e.getMessage(), e);
            }
        }
        if ((judgeCDPath = this.getSequenceValue(yamlLines, JUDGE_CONFIG_PATH_KEY)) != null) {
            this.setCDPPath(contest, judgeCDPath);
        }
        int defaultTimeout = this.getIntegerValue(this.getSequenceValue(yamlLines, TIMEOUT_KEY), 30);
        String[] stringArray = yamlLines;
        int n2 = yamlLines.length;
        int n3 = 0;
        while (n3 < n2) {
            String line = stringArray[n3];
            if (line.startsWith("name:")) {
                this.setTitle(contest, this.unquoteAll(line.substring(line.indexOf(DELIMIT) + 1).trim()));
            }
            ++n3;
        }
        loadDataFileContents = this.getBooleanValue(this.getSequenceValue(yamlLines, PROBLEM_LOAD_DATA_FILES_KEY), loadDataFileContents);
        Language[] languages = this.getLanguages(yamlLines);
        contest.addLanguages(languages);
        String defaultValidatorCommandLine = this.getSequenceValue(yamlLines, DEFAULT_VALIDATOR_KEY);
        String overrideValidatorCommandLine = this.getSequenceValue(yamlLines, OVERRIDE_VALIDATOR_KEY);
        if (overrideValidatorCommandLine == null && (mtsvFile = new File(String.valueOf(directoryName) + File.separator + MTSV_PROGRAM_NAME)).exists()) {
            overrideValidatorCommandLine = String.valueOf(mtsvFile.getAbsolutePath()) + " " + MTSV_OVERRIDE_VALIDATOR_ARGS;
        }
        String[] sectionLines = this.getSectionLines(USING_PC2_VALIDATOR, yamlLines);
        boolean overrideUsePc2Validator = false;
        String usingValidator = this.getSequenceValue(sectionLines, USING_PC2_VALIDATOR);
        if (usingValidator != null && usingValidator.equalsIgnoreCase("true")) {
            overrideUsePc2Validator = true;
        }
        boolean manualReviewOverride = this.getBooleanValue(this.getSequenceValue(yamlLines, MANUAL_REVIEW_KEY), false);
        Problem[] problems = this.getProblems(yamlLines, defaultTimeout, loadDataFileContents, defaultValidatorCommandLine, overrideValidatorCommandLine, overrideUsePc2Validator, manualReviewOverride);
        if (this.loadProblemDataFiles) {
            Problem[] problemArray = problems;
            n = problems.length;
            int n4 = 0;
            while (n4 < n) {
                Problem problem = problemArray[n4];
                this.loadProblemInformationAndDataFiles(contest, directoryName, problem, overrideUsePc2Validator, manualReviewOverride);
                ++n4;
            }
        }
        Site[] siteArray = sites = this.getSites(yamlLines);
        int n5 = sites.length;
        n = 0;
        while (n < n5) {
            Site site = siteArray[n];
            contest.addSite(site);
            ++n;
        }
        String[] stringArray2 = categories = this.loadGeneralClarificationAnswers(yamlLines);
        int n6 = categories.length;
        n5 = 0;
        while (n5 < n6) {
            String name = stringArray2[n5];
            contest.addCategory(new Category(name));
            ++n5;
        }
        Account[] accounts = this.getAccounts(yamlLines);
        contest.addAccounts(accounts);
        AutoJudgeSetting[] autoJudgeSettings = null;
        autoJudgeSettings = problems.length == 0 ? this.getAutoJudgeSettings(yamlLines, contest.getProblems()) : this.getAutoJudgeSettings(yamlLines, problems);
        AutoJudgeSetting[] autoJudgeSettingArray = autoJudgeSettings;
        int n7 = autoJudgeSettings.length;
        int n8 = 0;
        while (n8 < n7) {
            AutoJudgeSetting auto = autoJudgeSettingArray[n8];
            this.addAutoJudgeSetting(contest, auto);
            ++n8;
        }
        PlaybackInfo playbackInfo = this.getReplaySettings(yamlLines);
        if (playbackInfo != null) {
            contest.addPlaybackInfo(playbackInfo);
        }
        return contest;
    }

    public static Date parseStartTime(String dateString) throws ParseException {
        String pattern = "yyyy-MM-dd HH:mm";
        String dateTime = dateString;
        if (dateString.length() == pattern.length() + 1) {
            dateTime = dateString.substring(0, pattern.length());
        }
        SimpleDateFormat parser = new SimpleDateFormat(pattern);
        Date date = parser.parse(dateTime);
        return date;
    }

    private void setCDPPath(IInternalContest contest, String path) {
        ContestInformation contestInformation = contest.getContestInformation();
        contestInformation.setJudgeCDPBasePath(path);
    }

    public PlaybackInfo getReplaySettings(String[] yamlLines) {
        String[] sectionLines = this.getSectionLines(REPLAY_KEY, yamlLines);
        if (sectionLines.length == 0) {
            return null;
        }
        PlaybackInfo info = new PlaybackInfo();
        int idx = 1;
        String[] sequenceLines = this.getNextSequence(sectionLines, idx);
        while (sequenceLines.length > 0) {
            String title = this.getSequenceValue(sequenceLines, "- title").trim();
            info.setDisplayName(title);
            String filename = this.getSequenceValue(sequenceLines, "file").trim();
            info.setFilename(filename);
            String startedStr = this.getSequenceValue(sequenceLines, "auto_start");
            boolean started = this.getBooleanValue(startedStr, false);
            info.setStarted(started);
            String waitString = this.getSequenceValue(sequenceLines, "pacingMS").trim();
            int waitTimeBetweenEventsMS = this.getIntegerValue(waitString, 1000);
            info.setWaitBetweenEventsMS(waitTimeBetweenEventsMS);
            String countString = this.getSequenceValue(sequenceLines, "minevents").trim();
            int minEvents = this.getIntegerValue(countString, 1);
            info.setMinimumPlaybackRecords(minEvents);
            String siteString = this.getSequenceValue(sequenceLines, "site");
            int siteNumber = this.getIntegerValue(siteString, 1);
            info.setSiteNumber(siteNumber);
            sequenceLines = this.getNextSequence(sectionLines, idx += sequenceLines.length);
        }
        return info;
    }

    private void addAutoJudgeSetting(IInternalContest contest, AutoJudgeSetting auto) {
        Account account = contest.getAccount(auto.getClientId());
        if (account == null) {
            throw new YamlLoadException("No such account for auto judge setting, undefined account is " + auto.getClientId());
        }
        ClientSettings clientSettings = contest.getClientSettings(auto.getClientId());
        if (clientSettings == null) {
            clientSettings = new ClientSettings(auto.getClientId());
        }
        clientSettings.setAutoJudgeFilter(auto.getProblemFilter());
        clientSettings.setAutoJudging(auto.isActive());
        contest.addClientSettings(clientSettings);
    }

    private void dumpAJSettings(ClientId clientId, boolean autoJudging, Filter autoJudgeFilter) {
        ElementId[] ids = autoJudgeFilter.getProblemIdList();
        System.out.println("Auto Judge b4  " + clientId + "  " + ids.length + " problems, aj on = " + autoJudging);
        System.out.print("     sent      ");
        ElementId[] elementIdArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            ElementId id = elementIdArray[n2];
            System.out.print(id + " ");
            ++n2;
        }
        System.out.println();
    }

    public Site[] getSites(String[] yamlLines) {
        String[] sectionLines = this.getSectionLines(SITES_KEY, yamlLines);
        Vector<Site> sitesVector = new Vector<Site>();
        int idx = 1;
        String[] sequenceLines = this.getNextSequence(sectionLines, idx);
        while (sequenceLines.length > 0) {
            String siteNumberString = this.getSequenceValue(sequenceLines, "- number");
            String siteTitle = this.getSequenceValue(sequenceLines, CONTEST_NAME_KEY).trim();
            int siteNumber = this.getIntegerValue(siteNumberString.trim(), 0);
            Site site = new Site(siteTitle, siteNumber);
            String hostName = this.getSequenceValue(sequenceLines, "IP").trim();
            String portString = this.getSequenceValue(sequenceLines, "port").trim();
            String password = this.getSequenceValue(sequenceLines, "password");
            if (password == null) {
                password = "site" + siteNumberString;
            }
            site.setPassword(password.trim());
            Properties props = new Properties();
            props.put("IP_KEY", hostName);
            props.put("PORT_KEY", portString);
            site.setConnectionInfo(props);
            sitesVector.addElement(site);
            sequenceLines = this.getNextSequence(sectionLines, idx += sequenceLines.length);
        }
        return sitesVector.toArray(new Site[sitesVector.size()]);
    }

    private Account[] getAccounts(String[] yamlLines) {
        String[] sectionLines = this.getSectionLines(ACCOUNTS_KEY, yamlLines);
        Vector<Account> accountVector = new Vector<Account>();
        AccountList accountList = new AccountList();
        int idx = 1;
        String[] sequenceLines = this.getNextSequence(sectionLines, idx);
        while (sequenceLines.length > 0) {
            if (!sequenceLines[0].trim().startsWith("-")) {
                sequenceLines = this.getNextSequence(sectionLines, idx += sequenceLines.length);
                continue;
            }
            String accountType = this.getSequenceValue(sequenceLines, "- account");
            ClientType.Type type = ClientType.Type.valueOf(accountType.trim());
            int startNumber = 1;
            String startNumberString = this.getSequenceValue(sequenceLines, "start");
            if (startNumberString != null) {
                startNumber = this.getIntegerValue(startNumberString.trim(), 1);
            }
            String countString = this.getSequenceValue(sequenceLines, "count").trim();
            int count = this.getIntegerValue(countString, 1);
            String siteString = this.getSequenceValue(sequenceLines, "site");
            int siteNumber = this.getIntegerValue(siteString, 1);
            Vector<Account> newAccounts = accountList.generateNewAccounts(type, count, startNumber, AccountList.PasswordType.JOE, siteNumber, true);
            accountVector.addAll(newAccounts);
            sequenceLines = this.getNextSequence(sectionLines, idx += sequenceLines.length);
        }
        return accountVector.toArray(new Account[accountVector.size()]);
    }

    public void loadProblemInformationAndDataFiles(IInternalContest contest, String baseDirectoryName, Problem problem, boolean overrideUsePc2Validator) {
        this.loadProblemInformationAndDataFiles(contest, baseDirectoryName, problem, overrideUsePc2Validator, false);
    }

    public void loadProblemInformationAndDataFiles(IInternalContest contest, String baseDirectoryName, Problem problem, boolean overrideUsePc2Validator, boolean overrideManualReview) {
        String timeOut;
        String[] contents;
        String problemDirectory = String.valueOf(baseDirectoryName) + File.separator + problem.getShortName();
        problem.setExternalDataFileLocation(problemDirectory);
        String problemYamlFilename = String.valueOf(problemDirectory) + File.separator + DEFAULT_PROBLEM_YAML_FILENAME;
        try {
            contents = this.loadFileWithIncludes(baseDirectoryName, problemYamlFilename);
        }
        catch (IOException e) {
            throw new YamlLoadException(e);
        }
        if (contents.length == 0) {
            throw new YamlLoadException("Can not load problem.yaml: " + problemYamlFilename);
        }
        String problemLaTexFilename = String.valueOf(problemDirectory) + File.separator + "problem_statement" + File.separator + DEFAULT_PROBLEM_LATEX_FILENAME;
        String problemTitle = this.getSequenceValue(contents, PROBLEM_NAME_KEY);
        if (new File(problemLaTexFilename).isFile()) {
            problemTitle = this.getProblemNameFromLaTex(problemLaTexFilename);
        }
        boolean pc2FormatProblemYamlFile = this.isPC2FormatProblemYaml(contents);
        String[] sectionLines = this.getSectionLines("input", contents);
        if (problemTitle == null && pc2FormatProblemYamlFile) {
            problemTitle = this.getSequenceValue(sectionLines, CONTEST_NAME_KEY);
        }
        if (problemTitle == null) {
            this.syntaxError("No problem name found for " + problem.getShortName() + " in " + problemLaTexFilename);
        }
        problem.setDisplayName(problemTitle);
        String dataFileBaseDirectory = String.valueOf(problemDirectory) + File.separator + "data" + File.separator + "secret";
        ProblemDataFiles problemDataFiles = new ProblemDataFiles(problem);
        if (pc2FormatProblemYamlFile) {
            this.loadPc2ProblemFiles(contest, dataFileBaseDirectory, problem, problemDataFiles, sectionLines);
        } else {
            problem.setComputerJudged(true);
            this.loadCCSProblemFiles(contest, dataFileBaseDirectory, problem, problemDataFiles, sectionLines);
        }
        sectionLines = this.getSectionLines(LIMITS_KEY, contents);
        if (sectionLines.length > 1 && (timeOut = this.getSequenceValue(sectionLines, TIMEOUT_KEY)) != null) {
            problem.setTimeOutInSeconds(Integer.parseInt(timeOut.trim()));
        }
        if (!pc2FormatProblemYamlFile) {
            problem.setComputerJudged(true);
            this.addCCSValidator(problem, problemDataFiles, baseDirectoryName);
        } else {
            problem.setComputerJudged(true);
            this.addDefaultPC2Validator(problem, 1);
        }
        sectionLines = this.getSectionLines(JUDGING_TYPE_KEY, contents);
        this.assignJudgingType(sectionLines, problem, overrideManualReview);
        sectionLines = this.getSectionLines("input", contents);
        String stdinLoadString = this.getSequenceValue(contents, READ_FROM_STDIN_KEY);
        boolean readFromStdin = this.getBooleanValue(stdinLoadString, true);
        problem.setReadInputDataFromSTDIN(readFromStdin);
    }

    protected void assignJudgingType(String[] sectionLines, Problem problem, boolean overrideManualReviewFlag) {
        boolean sendPreliminary = this.getBooleanValue(this.getSequenceValue(sectionLines, SEND_PRELIMINARY_JUDGEMENT_KEY), false);
        if (sendPreliminary) {
            problem.setPrelimaryNotification(true);
        }
        boolean computerJudged = this.getBooleanValue(this.getSequenceValue(sectionLines, COMPUTER_JUDGING_KEY), problem.isComputerJudged());
        problem.setComputerJudged(computerJudged);
        boolean manualReview = this.getBooleanValue(this.getSequenceValue(sectionLines, MANUAL_REVIEW_KEY), false);
        if (overrideManualReviewFlag) {
            manualReview = true;
        }
        if (manualReview) {
            problem.setManualReview(true);
        }
    }

    protected boolean isPC2FormatProblemYaml(String[] contents) {
        boolean pc2Format = false;
        String[] sectionLines = this.getSectionLines(VALIDATOR_KEY, contents);
        String usingValidator = this.getSequenceValue(sectionLines, USING_PC2_VALIDATOR);
        if (usingValidator != null && usingValidator.equalsIgnoreCase("true")) {
            pc2Format = true;
        }
        return pc2Format;
    }

    private void syntaxWarning(String message) {
        System.err.println("Warning - " + message);
    }

    protected String getProblemNameFromLaTex(String filename) {
        String[] lines;
        try {
            lines = this.loadFileWithIncludes(null, filename);
        }
        catch (IOException iOException) {
            return null;
        }
        String name = null;
        String titlePattern = "\\problemtitle{";
        String titlePattern2 = "\\problemname{";
        String commentPattern = "%% plainproblemtitle:";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf("problemtitle") != -1) {
                if (line.trim().startsWith(commentPattern)) {
                    name = line.trim().substring(commentPattern.length()).trim();
                    break;
                }
                if (line.trim().startsWith(titlePattern)) {
                    name = line.trim().substring(titlePattern.length()).trim();
                    name = name.substring(0, name.length() - 1);
                    break;
                }
            }
            if (line.indexOf("problemname") != -1 && line.trim().startsWith(titlePattern2)) {
                name = line.trim().substring(titlePattern2.length()).trim();
                name = name.substring(0, name.length() - 1);
                break;
            }
            ++n2;
        }
        return name;
    }

    protected Problem loadCCSProblemFiles(IInternalContest contest, String dataFileBaseDirectory, Problem problem, ProblemDataFiles problemDataFiles, String[] sectionLines) {
        if (problem.getShortName() == null) {
            throw new YamlLoadException("  For " + problem + " missing problem short name");
        }
        boolean loadExternalFile = problem.isUsingExternalDataFiles();
        Object[] inputFileNames = this.getFileNames(dataFileBaseDirectory, ".in");
        String[] answerFileNames = this.getFileNames(dataFileBaseDirectory, ".ans");
        if (inputFileNames.length == 0) {
            throw new YamlLoadException("Expecting input (.in) files for " + problem.getDisplayName() + " in dir " + dataFileBaseDirectory);
        }
        if (answerFileNames.length == 0) {
            throw new YamlLoadException("Expecting answer (.ans) files forr " + problem.getDisplayName() + " in dir " + dataFileBaseDirectory);
        }
        if (inputFileNames.length == answerFileNames.length) {
            Arrays.sort(inputFileNames);
            ArrayList<SerializedFile> dataFiles = new ArrayList<SerializedFile>();
            ArrayList<SerializedFile> answerFiles = new ArrayList<SerializedFile>();
            int idx = 0;
            while (idx < inputFileNames.length) {
                problem.addTestCaseFilenames((String)inputFileNames[idx], answerFileNames[idx]);
                String dataFileName = String.valueOf(dataFileBaseDirectory) + File.separator + (String)inputFileNames[idx];
                String answerFileName = dataFileName.replaceAll(".in$", ".ans");
                if (idx == 0) {
                    problem.setDataFileName(Utilities.basename(dataFileName));
                    problem.setAnswerFileName(Utilities.basename(answerFileName));
                }
                String answerShortFileName = ((String)inputFileNames[idx]).replaceAll(".in$", ".ans");
                this.checkForFile(dataFileName, "Missing " + (String)inputFileNames[idx] + " file for " + problem.getShortName() + " in " + dataFileBaseDirectory);
                this.checkForFile(answerFileName, "Missing " + answerShortFileName + " file for " + problem.getShortName() + " in " + dataFileBaseDirectory);
                dataFiles.add(new SerializedFile(dataFileName, loadExternalFile));
                answerFiles.add(new SerializedFile(answerFileName, loadExternalFile));
                new File(dataFileName).length();
                new File(answerFileName).length();
                ++idx;
            }
            if (dataFiles.size() > 0) {
                SerializedFile[] data = dataFiles.toArray(new SerializedFile[dataFiles.size()]);
                SerializedFile[] answer = answerFiles.toArray(new SerializedFile[answerFiles.size()]);
                problemDataFiles.setJudgesDataFiles(data);
                problemDataFiles.setJudgesAnswerFiles(answer);
                problem.setDataFileName((String)inputFileNames[0]);
                problem.setAnswerFileName(((String)inputFileNames[0]).replaceAll(".in$", ".ans"));
            } else {
                this.syntaxWarning("There were no data files found/loaded for " + problem.getShortName());
            }
        } else {
            throw new YamlLoadException("  For " + problem.getShortName() + " Missing files -  there are " + inputFileNames.length + " .in files and " + answerFileNames.length + " .ans files " + " in " + dataFileBaseDirectory);
        }
        problem.setReadInputDataFromSTDIN(true);
        if (inputFileNames.length == 0) {
            throw new YamlLoadException("  For " + problem.getShortName() + " Missing files -  there are " + inputFileNames.length + " .in files and " + answerFileNames.length + " .ans files " + " in " + dataFileBaseDirectory);
        }
        contest.addProblem(problem, problemDataFiles);
        this.validateCCSData(contest, problem);
        return problem;
    }

    public void dumpSerialzedFileList(Problem problem, String logPrefixId, SerializedFile[] sfList) {
        System.out.println(String.valueOf(logPrefixId) + ": There are " + sfList.length + "files in list for problem " + problem);
        int count = 1;
        SerializedFile[] serializedFileArray = sfList;
        int n = sfList.length;
        int n2 = 0;
        while (n2 < n) {
            SerializedFile serializedFile = serializedFileArray[n2];
            System.out.println(String.valueOf(logPrefixId) + ": " + count + " " + serializedFile);
            ++count;
            ++n2;
        }
    }

    private void validateCCSData(IInternalContest contest, Problem problem) {
    }

    private void checkForFile(String filename, String message) {
        if (!new File(filename).isFile()) {
            throw new YamlLoadException(message);
        }
    }

    protected String[] getFileNames(String directoryName, String extension) {
        Vector<Object> list = new Vector<Object>();
        File dir = new File(directoryName);
        Object[] entries = dir.list();
        if (entries == null) {
            return new String[0];
        }
        Arrays.sort(entries);
        Object[] objectArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            if (((String)name).endsWith(extension)) {
                list.addElement(name);
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    private void loadPc2ProblemFiles(IInternalContest contest, String dataFileBaseDirectory, Problem problem, ProblemDataFiles problemDataFiles2, String[] sectionLines) {
        String dataFileName = this.getSequenceValue(sectionLines, "datafile");
        String answerFileName = this.getSequenceValue(sectionLines, "answerfile");
        ProblemDataFiles problemDataFiles = new ProblemDataFiles(problem);
        this.pc2AddDataFiles(problem, problemDataFiles, dataFileBaseDirectory, dataFileName, answerFileName);
        contest.addProblem(problem, problemDataFiles);
    }

    protected void pc2AddDataFiles(Problem problem, ProblemDataFiles problemDataFiles, String dataFileBaseDirectory, String dataFileName, String answerFileName) {
        String[] answerFileNames;
        int n;
        String[] inputFileNames;
        if (dataFileName != null) {
            String dataFilePath = String.valueOf(dataFileBaseDirectory) + File.separator + dataFileName;
            if (this.fileNotThere(dataFilePath)) {
                throw new YamlLoadException("Missing data file " + dataFilePath);
            }
            problem.setDataFileName(dataFileName);
            problem.setReadInputDataFromSTDIN(false);
            SerializedFile serializedFile = new SerializedFile(dataFilePath, problem.isUsingExternalDataFiles());
            problemDataFiles.setJudgesDataFile(serializedFile);
        }
        if ((inputFileNames = this.getFileNames(dataFileBaseDirectory, ".in")).length == 0) {
            inputFileNames = this.getFileNames(dataFileBaseDirectory, ".dat");
        }
        if (inputFileNames.length > 0) {
            SerializedFile[] serializedFiles = new SerializedFile[inputFileNames.length];
            int count = 0;
            String[] stringArray = inputFileNames;
            n = inputFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String inFilename = stringArray[n2];
                new File(String.valueOf(dataFileBaseDirectory) + File.separator + inFilename).length();
                serializedFiles[count] = new SerializedFile(String.valueOf(dataFileBaseDirectory) + File.separator + inFilename, problem.isUsingExternalDataFiles());
                ++count;
                ++n2;
            }
            problemDataFiles.setJudgesDataFiles(serializedFiles);
            if (dataFileName == null) {
                problem.setDataFileName(serializedFiles[0].getName());
            }
        }
        if (answerFileName != null) {
            String answerFilePath = String.valueOf(dataFileBaseDirectory) + File.separator + answerFileName;
            if (this.fileNotThere(answerFilePath)) {
                throw new YamlLoadException("Missing data file " + answerFilePath);
            }
            problem.setAnswerFileName(answerFileName);
            SerializedFile serializedFile = new SerializedFile(answerFilePath, problem.isUsingExternalDataFiles());
            problemDataFiles.setJudgesAnswerFile(serializedFile);
        }
        if ((answerFileNames = this.getFileNames(dataFileBaseDirectory, ".ans")).length > 0) {
            SerializedFile[] answerSerializedFiles = new SerializedFile[answerFileNames.length];
            int count = 0;
            String[] stringArray = answerFileNames;
            int n3 = answerFileNames.length;
            n = 0;
            while (n < n3) {
                String ansFilename = stringArray[n];
                new File(String.valueOf(dataFileBaseDirectory) + File.separator + ansFilename).length();
                answerSerializedFiles[count] = new SerializedFile(String.valueOf(dataFileBaseDirectory) + File.separator + ansFilename, problem.isUsingExternalDataFiles());
                ++count;
                ++n;
            }
            problemDataFiles.setJudgesAnswerFiles(answerSerializedFiles);
            if (answerFileName == null) {
                problem.setAnswerFileName(answerSerializedFiles[0].getName());
            }
        }
        if (answerFileName != null) {
            String answerFilePath = String.valueOf(dataFileBaseDirectory) + File.separator + answerFileName;
            if (this.fileNotThere(answerFilePath)) {
                throw new YamlLoadException("Missing data file " + answerFilePath);
            }
            problem.setAnswerFileName(answerFileName);
            SerializedFile serializedFile = new SerializedFile(answerFilePath, problem.isUsingExternalDataFiles());
            problemDataFiles.setJudgesAnswerFile(serializedFile);
        }
    }

    private boolean fileNotThere(String name) {
        return !new File(name).isFile();
    }

    public Problem addDefaultPC2Validator(Problem problem, int optionNumber) {
        problem.setCcsMode(false);
        problem.setValidatedProblem(true);
        problem.setUsingPC2Validator(true);
        problem.setWhichPC2Validator(optionNumber);
        problem.setIgnoreSpacesOnValidation(true);
        problem.setValidatorCommandLine("{:validator} {:infile} {:outfile} {:ansfile} {:resfile}  -pc2 " + problem.getWhichPC2Validator() + " " + problem.isIgnoreSpacesOnValidation());
        problem.setValidatorProgramName("pc2.jar edu.csus.ecs.pc2.validator.Validator");
        return problem;
    }

    private Problem addCCSValidator(Problem problem, ProblemDataFiles problemDataFiles, String baseDirectoryName) {
        problem.setCcsMode(true);
        problem.setValidatedProblem(true);
        problem.setUsingPC2Validator(false);
        problem.setReadInputDataFromSTDIN(true);
        if (problem.getValidatorProgramName() == null) {
            problem.setValidatorProgramName("default_validator");
        }
        if (problem.getValidatorCommandLine() == null) {
            problem.setValidatorCommandLine("{:validator} {:infile} {:ansfile} {:resultsdir} ");
        }
        String validatorName = String.valueOf(baseDirectoryName) + File.separator + problem.getValidatorProgramName();
        try {
            if (new File(validatorName).isFile()) {
                problemDataFiles.setValidatorFile(new SerializedFile(validatorName));
            }
        }
        catch (Exception e) {
            throw new YamlLoadException("Unable to load validator for problem " + problem.getShortName() + ": " + validatorName, e);
        }
        return problem;
    }

    public String[] loadStringList(String key, String[] yamlLines) {
        String[] sectionLines = this.getSectionLines(key, yamlLines);
        int idx = 1;
        String[] sequenceLines = this.getNextSequence(sectionLines, idx);
        Vector<String> outArrays = new Vector<String>();
        while (sequenceLines.length > 0) {
            String line = sequenceLines[0].trim();
            if (line.startsWith("-")) {
                line = line.substring(1);
            }
            outArrays.addElement(line.trim());
            sequenceLines = this.getNextSequence(sectionLines, idx += sequenceLines.length);
        }
        return outArrays.toArray(new String[outArrays.size()]);
    }

    public String[] loadGeneralClarificationAnswers(String[] yamlLines) {
        return this.loadStringList(CLAR_CATEGORIES_KEY, yamlLines);
    }

    public String[] getGeneralAnswers(String[] yamlLines) {
        return this.loadStringList(DEFAULT_CLARS_KEY, yamlLines);
    }

    public String[] getClarificationCategories(String[] yamlLines) {
        String[] sectionLines = this.getSectionLines(CLAR_CATEGORIES_KEY, yamlLines);
        int idx = 1;
        String[] sequenceLines = this.getNextSequence(sectionLines, idx);
        Vector<String> outArrays = new Vector<String>();
        while (sequenceLines.length > 0) {
            String line = sequenceLines[0].trim();
            if (line.startsWith("-")) {
                line = line.substring(1);
            }
            outArrays.addElement(line.trim());
            sequenceLines = this.getNextSequence(sectionLines, idx += sequenceLines.length);
        }
        return outArrays.toArray(new String[outArrays.size()]);
    }

    public Language[] getLanguages(String[] yamlLines) {
        String[] sectionLines = this.getSectionLines(LANGUAGE_KEY, yamlLines);
        Vector<Language> languageList = new Vector<Language>();
        int idx = 1;
        String[] sequenceLines = this.getNextSequence(sectionLines, idx);
        while (sequenceLines.length > 0) {
            String name = this.getSequenceValue(sequenceLines, CONTEST_NAME_KEY);
            if (name == null) {
                this.syntaxError("Language name field missing in languages section");
            } else {
                Language language = new Language(name);
                Language lookedupLanguage = LanguageAutoFill.languageLookup(name);
                String compilerName = this.getSequenceValue(sequenceLines, "compilerCmd");
                if (compilerName == null && lookedupLanguage != null) {
                    language = lookedupLanguage;
                    language.setDisplayName(name);
                } else {
                    if (compilerName == null) {
                        throw new YamlLoadException("Language \"" + name + "\" missing compiler command line");
                    }
                    String compilerArgs = this.getSequenceValue(sequenceLines, "compiler-args");
                    String interpreter = this.getSequenceValue(sequenceLines, "runner");
                    String interpreterArgs = this.getSequenceValue(sequenceLines, "runner-args");
                    String exeMask = this.getSequenceValue(sequenceLines, "exemask");
                    if (compilerArgs == null) {
                        language.setCompileCommandLine(compilerName);
                    } else {
                        language.setCompileCommandLine(String.valueOf(compilerName) + " " + compilerArgs);
                    }
                    language.setExecutableIdentifierMask(exeMask);
                    String programExecuteCommandLine = null;
                    programExecuteCommandLine = interpreter == null ? "a.out" : (interpreterArgs == null ? interpreter : String.valueOf(interpreter) + " " + interpreterArgs);
                    language.setProgramExecuteCommandLine(programExecuteCommandLine);
                }
                String activeStr = this.getSequenceValue(sequenceLines, "active");
                boolean active = this.getBooleanValue(activeStr, true);
                language.setActive(active);
                String useStr = this.getSequenceValue(sequenceLines, USE_JUDGE_CMD_KEY);
                active = this.getBooleanValue(useStr, false);
                language.setUsingJudgeProgramExecuteCommandLine(active);
                String judgeExecuteCommandLine = this.getSequenceValue(sequenceLines, "judge-exec-cmd");
                if (judgeExecuteCommandLine != null) {
                    language.setJudgeProgramExecuteCommandLine(judgeExecuteCommandLine);
                }
                String interpretLangFlag = this.getSequenceValue(sequenceLines, INTERPRETED_LANGUAGE_KEY);
                boolean interpretedLangauge = this.getBooleanValue(interpretLangFlag, false);
                language.setInterpreted(interpretedLangauge);
                if (this.valid(language, name)) {
                    languageList.addElement(language);
                }
            }
            sequenceLines = this.getNextSequence(sectionLines, idx += sequenceLines.length);
        }
        return languageList.toArray(new Language[languageList.size()]);
    }

    private boolean valid(Language language, String prefix) {
        this.checkField(language.getDisplayName(), String.valueOf(prefix) + " Compiler Display name");
        this.checkField(language.getCompileCommandLine(), String.valueOf(prefix) + " Compile Command line");
        return true;
    }

    private void checkField(String field, String fieldName) {
        if (field == null) {
            throw new YamlLoadException("Missing " + fieldName);
        }
        if (field.trim().length() == 0) {
            throw new YamlLoadException("Missing " + fieldName);
        }
    }

    public Problem[] getProblems(String[] yamlLines, int seconds, boolean loadDataFileContents, String defaultValidatorCommand, String overrideValidatorCommandLine, boolean overrideUsePc2Validator, boolean todobool) {
        String[] linesFromSection = this.getSectionLines(PROBLEMS_KEY, yamlLines);
        if (linesFromSection.length == 0) {
            return new Problem[0];
        }
        Vector<Problem> problemList = new Vector<Problem>();
        int idx = 1;
        String[] sequenceLines = this.getNextSequence(linesFromSection, idx);
        while (sequenceLines.length > 0) {
            String problemTitle;
            if (!sequenceLines[0].trim().startsWith("-")) {
                sequenceLines = this.getNextSequence(linesFromSection, idx += sequenceLines.length);
                continue;
            }
            String problemKeyName = this.getSequenceValue(sequenceLines, SHORT_NAME_KEY);
            if (problemKeyName == null) {
                this.syntaxError("Missing short-name in probset section");
            }
            if ((problemTitle = this.getSequenceValue(sequenceLines, PROBLEM_NAME_KEY)) == null) {
                problemTitle = problemKeyName;
            }
            Problem problem = new Problem(problemTitle);
            int actSeconds = this.getIntegerValue(this.getSequenceValue(sequenceLines, TIMEOUT_KEY), seconds);
            problem.setTimeOutInSeconds(actSeconds);
            problem.setShowCompareWindow(false);
            problem.setShortName(problemKeyName);
            if (!problem.isValidShortName()) {
                throw new YamlLoadException("Invalid short problem name '" + problemKeyName + "'");
            }
            String problemLetter = this.getSequenceValue(sequenceLines, "letter");
            String colorName = this.getSequenceValue(sequenceLines, "color");
            String colorRGB = this.getSequenceValue(sequenceLines, "rgb");
            problem.setLetter(problemLetter);
            problem.setColorName(colorName);
            problem.setColorRGB(colorRGB);
            String internalFilesUsesString = this.getSequenceValue(sequenceLines, PROBLEM_LOAD_DATA_FILES_KEY);
            boolean loadFilesFlag = this.getBooleanValue(internalFilesUsesString, loadDataFileContents);
            problem.setUsingExternalDataFiles(!loadFilesFlag);
            String validatorCommandLine = this.getSequenceValue(sequenceLines, VALIDATOR_KEY);
            if (validatorCommandLine == null) {
                validatorCommandLine = defaultValidatorCommand;
            }
            if (overrideValidatorCommandLine != null) {
                validatorCommandLine = overrideValidatorCommandLine;
            }
            problem.setValidatorCommandLine(validatorCommandLine);
            problemList.addElement(problem);
            sequenceLines = this.getNextSequence(linesFromSection, idx += sequenceLines.length);
            problem.setReadInputDataFromSTDIN(true);
        }
        return problemList.toArray(new Problem[problemList.size()]);
    }

    private void syntaxError(String string) {
        YamlLoadException exception = new YamlLoadException("Syntax error: " + string);
        exception.printStackTrace();
        throw exception;
    }

    private String getSequenceValue(String[] lines, String key) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String keyString = String.valueOf(key) + DELIMIT;
            if (line.trim().startsWith(keyString)) {
                return this.unquoteAll(line.trim().substring(keyString.length()).trim());
            }
            keyString = "- " + key + DELIMIT;
            if (line.trim().startsWith(keyString)) {
                return this.unquoteAll(line.trim().substring(keyString.length()).trim());
            }
            ++n2;
        }
        return null;
    }

    protected String unquote(String string, String quoteChar) {
        if (string.startsWith(quoteChar)) {
            String newString = string.substring(1);
            if (newString.endsWith(quoteChar)) {
                newString = newString.substring(0, newString.length() - 1);
            }
            return newString;
        }
        return string;
    }

    protected String unquoteAll(String string) {
        if (string.startsWith("'")) {
            return this.unquote(string, "'");
        }
        if (string.startsWith("\"")) {
            return this.unquote(string, "\"");
        }
        return string;
    }

    public String[] getNextSequence(String[] sectionLines, int idx) {
        Vector<String> lines = new Vector<String>();
        int i = idx;
        while (i < sectionLines.length) {
            String line = sectionLines[i];
            if (i > idx && line.trim().startsWith("-")) break;
            lines.addElement(line);
            ++i;
        }
        return lines.toArray(new String[lines.size()]);
    }

    public boolean isNewSection(String line) {
        if (line == null) {
            return false;
        }
        if (line.indexOf(DELIMIT) > 1) {
            char firstChar = line.charAt(0);
            return firstChar != ' ' && firstChar != '-' && firstChar != '#';
        }
        return false;
    }

    public String[] getSectionLines(String key, String[] yamlLines) {
        Vector<String> lines = new Vector<String>();
        boolean inSection = false;
        String[] stringArray = yamlLines;
        int n = yamlLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (this.isNewSection(line)) {
                inSection = false;
                if (line.startsWith(String.valueOf(key) + DELIMIT)) {
                    inSection = true;
                }
            }
            if (inSection) {
                lines.addElement(line);
            }
            ++n2;
        }
        return lines.toArray(new String[lines.size()]);
    }

    private void setTitle(IInternalContest contest, String title) {
        ContestInformation contestInformation = contest.getContestInformation();
        contestInformation.setContestTitle(title);
    }

    private void setContestStartDateTime(IInternalContest contest, Date date) {
        ContestInformation contestInformation = contest.getContestInformation();
        contestInformation.setStartDate(date);
    }

    public AutoJudgeSetting[] getAutoJudgeSettings(String[] yamlLines, Problem[] problems) {
        String[] sectionLines = this.getSectionLines(AUTO_JUDGE_KEY, yamlLines);
        if (sectionLines == null) {
            System.err.println("section AJ settings sectionLines is null, looking for auto-judging");
        }
        Account[] accounts = this.getAccounts(yamlLines);
        ArrayList<AutoJudgeSetting> ajList = new ArrayList<AutoJudgeSetting>();
        int idx = 1;
        String[] sequenceLines = this.getNextSequence(sectionLines, idx);
        while (sequenceLines.length > 0) {
            if (!sequenceLines[0].trim().startsWith("-")) {
                sequenceLines = this.getNextSequence(sectionLines, idx += sequenceLines.length);
                continue;
            }
            String accountType = this.getSequenceValue(sequenceLines, "- account");
            ClientType.Type type = ClientType.Type.valueOf(accountType.trim());
            String siteString = this.getSequenceValue(sequenceLines, "site");
            int siteNumber = this.getIntegerValue(siteString, 1);
            String numberString = this.getSequenceValue(sequenceLines, "number");
            String problemLettersString = this.getSequenceValue(sequenceLines, "letters");
            String activeStr = this.getSequenceValue(sequenceLines, "active");
            boolean active = this.getBooleanValue(activeStr, true);
            int[] judgeClientNumbers = null;
            if ("all".equalsIgnoreCase(numberString)) {
                if (accounts.length == 0) {
                    throw new YamlLoadException("'all' not allowed, no judge accounts defined in YAML");
                }
                judgeClientNumbers = this.getJudgeAccountNumbers(accounts);
            } else {
                judgeClientNumbers = this.getNumberList(numberString.trim());
            }
            int i = 0;
            while (i < judgeClientNumbers.length) {
                Problem problem;
                int n;
                int n2;
                Problem[] problemArray;
                int clientNumber = judgeClientNumbers[i];
                String name = String.valueOf(accountType.toUpperCase()) + clientNumber;
                AutoJudgeSetting autoJudgeSetting = new AutoJudgeSetting(name);
                ClientId id = new ClientId(siteNumber, type, clientNumber);
                autoJudgeSetting.setClientId(id);
                autoJudgeSetting.setActive(active);
                Filter filter = new Filter();
                if ("all".equalsIgnoreCase(problemLettersString.trim())) {
                    problemArray = problems;
                    n2 = problems.length;
                    n = 0;
                    while (n < n2) {
                        problem = problemArray[n];
                        filter.addProblem(problem);
                        ++n;
                    }
                } else {
                    problemArray = this.getProblemsFromLetters(problems, problemLettersString);
                    n2 = problemArray.length;
                    n = 0;
                    while (n < n2) {
                        problem = problemArray[n];
                        filter.addProblem(problem);
                        ++n;
                    }
                }
                autoJudgeSetting.setProblemFilter(filter);
                ajList.add(autoJudgeSetting);
                ++i;
            }
            sequenceLines = this.getNextSequence(sectionLines, idx += sequenceLines.length);
        }
        return ajList.toArray(new AutoJudgeSetting[ajList.size()]);
    }

    private int[] getJudgeAccountNumbers(Account[] accounts) {
        int count = 0;
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            if (account.getClientId().getClientType().equals((Object)ClientType.Type.JUDGE)) {
                ++count;
            }
            ++n2;
        }
        int[] out = new int[count];
        count = 0;
        Account[] accountArray2 = accounts;
        int n3 = accounts.length;
        n = 0;
        while (n < n3) {
            Account account = accountArray2[n];
            if (account.getClientId().getClientType().equals((Object)ClientType.Type.JUDGE)) {
                out[count] = account.getClientId().getClientNumber();
                ++count;
            }
            ++n;
        }
        Arrays.sort(out);
        return out;
    }

    protected Problem[] getProblemsFromLetters(Problem[] problems, String problemLettersString) {
        String[] list = problemLettersString.split(",");
        Problem[] out = new Problem[list.length];
        int i = 0;
        while (i < list.length) {
            char letter = list[i].trim().toUpperCase().charAt(0);
            int offset = letter - 65;
            if (offset < 0 || offset >= problems.length) {
                throw new YamlLoadException("getProblemsFromLetters: There is no problem definition # " + (offset + 1) + " only " + offset + " problems defined?");
            }
            out[i] = problems[offset];
            ++i;
        }
        return out;
    }

    protected int[] getNumberList(String numberString) {
        String[] list = numberString.split(",");
        if (list.length == 1) {
            int[] out = new int[]{this.getIntegerValue(list[0], 0)};
            return out;
        }
        int[] out = new int[list.length];
        int i = 0;
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            out[i] = this.getIntegerValue(n3, 0);
            ++i;
            ++n2;
        }
        return out;
    }

    private int getIntegerValue(String string, int defaultNumber) {
        int number = defaultNumber;
        if (string != null && string.length() > 0) {
            number = Integer.parseInt(string.trim());
        }
        return number;
    }

    protected boolean getBooleanValue(String string, boolean defaultBoolean) {
        boolean value = defaultBoolean;
        if (string != null && string.length() > 0) {
            if ("yes".equalsIgnoreCase(string = string.trim())) {
                value = true;
            } else if ("no".equalsIgnoreCase(string)) {
                value = false;
            } else if ("true".equalsIgnoreCase(string)) {
                value = true;
            } else if ("false".equalsIgnoreCase(string)) {
                value = false;
            }
        }
        return value;
    }

    private IInternalContest createContest(IInternalContest contest) {
        if (contest == null) {
            contest = new InternalContest();
            contest.setSiteNumber(1);
        }
        return contest;
    }

    public Problem[] getProblems(String[] contents, int defaultTimeOut, boolean loadDataFileContents, String defaultValidatorCommandLine) {
        return this.getProblems(contents, defaultTimeOut, loadDataFileContents, defaultValidatorCommandLine, null, false, false);
    }

    public IInternalContest fromYaml(IInternalContest contest, String[] yamlLines, String directoryName) {
        return this.fromYaml(contest, yamlLines, directoryName, false);
    }

    public Problem[] getProblems(String[] contents, int defaultTimeOut) {
        return this.getProblems(contents, defaultTimeOut, false, null, null, false, false);
    }

    public void setLoadProblemDataFiles(boolean loadProblemDataFiles) {
        this.loadProblemDataFiles = loadProblemDataFiles;
    }

    public boolean isLoadProblemDataFiles() {
        return this.loadProblemDataFiles;
    }
}

