/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.exports.ccs;

import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import java.util.Arrays;
import java.util.Vector;

public class Userdata {
    private static final char TAB = '\t';

    public String[] getAllUserData(IInternalContest contest) {
        Account[] accounts = contest.getAccounts();
        return this.getUserData(accounts);
    }

    public String[] getUserData(IInternalContest contest) {
        Vector<Account> list = new Vector<Account>();
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type type = typeArray[n2];
            switch (type) {
                case UNKNOWN: 
                case ALL: 
                case ADMINISTRATOR: 
                case SCOREBOARD: {
                    break;
                }
                default: {
                    Vector<Account> temp = contest.getAccounts(type);
                    for (Account account : temp) {
                        list.add(account);
                    }
                }
            }
            ++n2;
        }
        return this.getUserData(list.toArray(new Account[list.size()]));
    }

    public String[] getUserData(Account[] accounts) {
        String[] outLines = new String[accounts.length + 1];
        outLines[0] = "userdata\t1";
        String[] userLines = this.getUserDataLines(accounts);
        System.arraycopy(userLines, 0, outLines, 1, userLines.length);
        return outLines;
    }

    public String[] getUserDataLines(Account[] accounts) {
        String[] outLines = new String[accounts.length];
        Arrays.sort(accounts, new AccountComparator());
        int idx = 0;
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            outLines[idx++] = this.userDataLine(account);
            ++n2;
        }
        return outLines;
    }

    private String userDataLine(Account account) {
        ClientId clientId = account.getClientId();
        return String.valueOf(clientId.getClientType().toString().toLowerCase()) + '\t' + clientId.getClientNumber() + '\t' + account.getDisplayName() + '\t' + clientId.getName() + '\t' + account.getPassword();
    }
}

