/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.exports.ccs;

import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import java.util.Arrays;
import java.util.Vector;

public class Teamdata {
    private static final String TAB = "\t";

    public String[] getTeamData(IInternalContest contest) {
        Vector<Account> accountlist = contest.getAccounts(ClientType.Type.TEAM);
        Account[] accounts = accountlist.toArray(new Account[accountlist.size()]);
        return this.getTeamData(contest, accounts);
    }

    public String[] getTeamData(IInternalContest contest, Account[] accounts) {
        String[] outLines = new String[accounts.length + 1];
        outLines[0] = "teams\t1";
        String[] userLines = this.getTeamDataLines(contest, accounts);
        System.arraycopy(userLines, 0, outLines, 1, userLines.length);
        return outLines;
    }

    protected String[] getTeamDataLines(IInternalContest contest, Account[] accounts) {
        String[] outLines = new String[accounts.length];
        Arrays.sort(accounts, new AccountComparator());
        int idx = 0;
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            outLines[idx++] = this.teamDataLine(contest, account);
            ++n2;
        }
        return outLines;
    }

    private String teamDataLine(IInternalContest contest, Account account) {
        ClientId clientId = account.getClientId();
        int groupId = 0;
        if (account.getGroupId() != null) {
            groupId = contest.getGroup(account.getGroupId()).getGroupId();
        }
        return String.valueOf(clientId.getClientNumber()) + TAB + account.getExternalId() + TAB + groupId + TAB + account.getDisplayName() + TAB + account.getLongSchoolName() + TAB + account.getShortSchoolName() + TAB + account.getCountryCode();
    }
}

