/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.exports.ccs;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.XMLUtilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.BalloonDeliveryComparator;
import edu.csus.ecs.pc2.core.list.ClarificationComparator;
import edu.csus.ecs.pc2.core.list.GroupComparator;
import edu.csus.ecs.pc2.core.list.ProblemComparator;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.list.RunTestCaseComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Notification;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunTestCase;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.TabSeparatedValueParser;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public class EventFeedXML {
    public static final String CONTEST_TAG = "contest";
    public static final String INFO_TAG = "info";
    public static final String REGION_TAG = "region";
    public static final String PROBLEM_TAG = "problem";
    public static final String LANGUAGE_TAG = "language";
    public static final String TEAM_TAG = "team";
    public static final String CLARIFICATION_TAG = "clarification";
    public static final String TESTCASE_TAG = "testcase";
    public static final String RUN_TAG = "run";
    public static final String JUDGEMENT_TAG = "judgement";
    public static final String FINALIZE_TAG = "finalized";
    public static final String JUDGEMENT_RECORD_TAG = "judgement_record";
    public static final String BALLOON_TAG = "balloon";
    public static final String BALLOON_LIST_TAG = "balloons";
    public static final String NOTIFICATION_TAG = "notification";
    private RunComparator runComparator = new RunComparator();
    private BalloonSettings colorSettings = null;
    private Log log = null;
    private static final String DEFAULT_ACRONYM = "??";
    private static final String DEFAULT_COLORS_FILENAME = "colors.txt";
    private String[] acronymList = new String[]{"No - Compilation Error;CE", "No - Security Violation;SV", "No - Time Limit Exceeded;TLE", "No - Wrong Output;WA", "Yes;AC", "Accepted;AC", "Wrong Answer;WA"};
    private String colorsFilename = "colors.txt";

    private String guessAcronym(String judgementText) {
        if (judgementText == null) {
            return DEFAULT_ACRONYM;
        }
        String[] stringArray = this.acronymList;
        int n = this.acronymList.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] fields = line.split(";");
            String name = fields[0];
            String acro = fields[1];
            if (name.trim().toLowerCase().equals(judgementText.trim().toLowerCase())) {
                return acro;
            }
            ++n2;
        }
        return DEFAULT_ACRONYM;
    }

    public String toXML(IInternalContest contest) {
        return this.toXML(contest, new Filter());
    }

    public String toXMLFreeze(IInternalContest contest, long minutesFromEnd) {
        long mins = contest.getContestTime().getConestLengthMins() - minutesFromEnd;
        Filter filter = new Filter();
        filter.setEndElapsedTime(mins);
        return this.toXML(contest, filter);
    }

    public String toXML(IInternalContest contest, Filter filter) {
        Problem[] problems;
        Judgement[] judgements;
        XMLMemento mementoRoot = XMLMemento.createWriteRoot(CONTEST_TAG);
        IMemento memento = mementoRoot.createChild(INFO_TAG);
        this.addInfoMemento(memento, contest, contest.getContestInformation());
        Group[] groups = contest.getGroups();
        Arrays.sort(groups, new GroupComparator());
        Group[] groupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            memento = mementoRoot.createChild(REGION_TAG);
            this.addMemento(memento, contest, group);
            ++n2;
        }
        Judgement[] judgementArray = judgements = contest.getJudgements();
        int n3 = judgements.length;
        n = 0;
        while (n < n3) {
            Judgement judgement = judgementArray[n];
            memento = mementoRoot.createChild(JUDGEMENT_TAG);
            this.addMemento(memento, contest, judgement);
            ++n;
        }
        Language[] languages = contest.getLanguages();
        int num = 1;
        Language[] languageArray = languages;
        int n4 = languages.length;
        int n5 = 0;
        while (n5 < n4) {
            Language language = languageArray[n5];
            if (filter.matches(language)) {
                memento = mementoRoot.createChild(LANGUAGE_TAG);
                this.addMemento(memento, contest, language, num);
            }
            ++num;
            ++n5;
        }
        num = 1;
        Problem[] problemArray = problems = contest.getProblems();
        int n6 = problems.length;
        n4 = 0;
        while (n4 < n6) {
            Problem problem = problemArray[n4];
            if (filter.matches(problem)) {
                memento = mementoRoot.createChild(PROBLEM_TAG);
                this.addMemento(memento, contest, problem, num);
            }
            ++num;
            ++n4;
        }
        Vector<Account> teams = contest.getAccounts(ClientType.Type.TEAM);
        Account[] accounts = teams.toArray(new Account[teams.size()]);
        Arrays.sort(accounts, new AccountComparator());
        Account[] accountArray = accounts;
        int n7 = accounts.length;
        int n8 = 0;
        while (n8 < n7) {
            Account account = accountArray[n8];
            if (filter.matches(account) && this.teamDisplayedOnScoreboard(contest, account.getClientId())) {
                memento = mementoRoot.createChild(TEAM_TAG);
                this.addMemento(memento, contest, account);
            }
            ++n8;
        }
        Run[] runs = contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        Run[] runArray = runs;
        int n9 = runs.length;
        n7 = 0;
        while (n7 < n9) {
            Run run = runArray[n7];
            if (this.teamDisplayedOnScoreboard(contest, run.getSubmitter())) {
                if (filter.matches(run)) {
                    memento = mementoRoot.createChild(RUN_TAG);
                    this.addMemento(memento, contest, run, false);
                    RunTestCase[] runTestCases = this.getLastJudgementTestCases(run);
                    Arrays.sort(runTestCases, new RunTestCaseComparator());
                    RunTestCase[] runTestCaseArray = runTestCases;
                    int n10 = runTestCases.length;
                    int n11 = 0;
                    while (n11 < n10) {
                        RunTestCase runTestCase = runTestCaseArray[n11];
                        if (filter.matchesElapsedTime(runTestCase)) {
                            memento = mementoRoot.createChild(TESTCASE_TAG);
                            this.addMemento(memento, contest, runTestCase, run);
                        }
                        ++n11;
                    }
                } else if (!filter.matchesElapsedTime(run)) {
                    this.addMemento(memento, contest, run, false);
                }
            }
            ++n7;
        }
        Clarification[] clarifications = contest.getClarifications();
        Arrays.sort(clarifications, new ClarificationComparator());
        Clarification[] clarificationArray = clarifications;
        int n12 = clarifications.length;
        n9 = 0;
        while (n9 < n12) {
            Clarification clarification = clarificationArray[n9];
            if (filter.matches(clarification)) {
                memento = mementoRoot.createChild(CLARIFICATION_TAG);
                this.addMemento(memento, contest, clarification);
            }
            ++n9;
        }
        BalloonDeliveryInfo[] deliveries = this.getBalloonDeliveries(contest);
        Arrays.sort(deliveries, new BalloonDeliveryComparator(contest));
        int notificationSequenceNumber = 1;
        BalloonDeliveryInfo[] balloonDeliveryInfoArray = deliveries;
        int n13 = deliveries.length;
        int n14 = 0;
        while (n14 < n13) {
            BalloonDeliveryInfo balloonDeliveryInfo = balloonDeliveryInfoArray[n14];
            Run run = this.getFirstSolvedRun(contest, balloonDeliveryInfo.getClientId(), balloonDeliveryInfo.getProblemId());
            memento = mementoRoot.createChild(NOTIFICATION_TAG);
            this.addMemento(memento, contest, run, notificationSequenceNumber);
            ++notificationSequenceNumber;
            ++n14;
        }
        FinalizeData finalizeData = contest.getFinalizeData();
        if (finalizeData != null && finalizeData.isCertified()) {
            memento = mementoRoot.createChild(FINALIZE_TAG);
            this.addMemento(memento, contest, finalizeData);
        }
        return this.toXML(mementoRoot);
    }

    public Run getFirstSolvedRun(IInternalContest contest, ClientId clientId, ElementId problemId) {
        Filter filter = new Filter();
        filter.addAccount(clientId);
        filter.addProblem(contest.getProblem(problemId));
        filter.setFilteringDeleted(true);
        Run[] runs = filter.getRuns(contest.getRuns());
        Arrays.sort(runs, this.runComparator);
        if (runs.length > 0) {
            return runs[0];
        }
        return null;
    }

    public BalloonDeliveryInfo[] getBalloonDeliveries(IInternalContest contest) {
        BalloonDeliveryInfo[] deliveries = new BalloonDeliveryInfo[]{};
        BalloonSettings balloonSettings = contest.getBalloonSettings(contest.getSiteNumber());
        if (balloonSettings == null) {
            return deliveries;
        }
        ClientSettings settings = new ClientSettings(balloonSettings.getBalloonClient());
        Hashtable<String, BalloonDeliveryInfo> deliveryHash = settings.getBalloonList();
        ArrayList<BalloonDeliveryInfo> balloonDeliveryArray = Collections.list(deliveryHash.elements());
        BalloonDeliveryInfo[] balloonDeliveryInfos = balloonDeliveryArray.toArray(new BalloonDeliveryInfo[balloonDeliveryArray.size()]);
        return balloonDeliveryInfos;
    }

    public XMLMemento createInfoElement(IInternalContest contest, Filter filter) {
        XMLMemento memento = XMLMemento.createWriteRoot(INFO_TAG);
        this.addInfoMemento(memento, contest, contest.getContestInformation());
        return memento;
    }

    public IMemento addInfoMemento(IMemento memento, IInternalContest contest, ContestInformation info) {
        ContestTime time = contest.getContestTime();
        XMLUtilities.addChild(memento, "title", info.getContestTitle());
        String contestLengthString = "0:0:0";
        boolean running = false;
        String formattedSeconds = "0.0";
        if (time != null) {
            contestLengthString = time.getContestLengthStr();
            running = time.isContestRunning();
            if (time.getContestStartTime() != null) {
                formattedSeconds = XMLUtilities.formatSeconds(time.getContestStartTime().getTimeInMillis());
            }
        }
        XMLUtilities.addChild(memento, "length", contestLengthString);
        XMLUtilities.addChild(memento, "penalty", DefaultScoringAlgorithm.getDefaultProperties().getProperty("Points per No"));
        XMLUtilities.addChild(memento, "started", running);
        XMLUtilities.addChild(memento, "starttime", formattedSeconds);
        return memento;
    }

    public XMLMemento createInfoElement(IInternalContest contest, ContestInformation info) {
        XMLMemento memento = XMLMemento.createWriteRoot(INFO_TAG);
        this.addInfoMemento(memento, contest, info);
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Language language, int id) {
        XMLMemento memento = XMLMemento.createWriteRoot(LANGUAGE_TAG);
        this.addMemento((IMemento)memento, contest, language, id);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Language language, int id) {
        memento.putInteger("id", id);
        XMLUtilities.addChild(memento, "id", id);
        XMLUtilities.addChild(memento, "name", language.toString());
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Problem problem, int id) {
        XMLMemento memento = XMLMemento.createWriteRoot(PROBLEM_TAG);
        this.addMemento((IMemento)memento, contest, problem, id);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Problem problem, int id) {
        XMLUtilities.addChild(memento, "id", id);
        memento.putBoolean("enabled", problem.isActive());
        String problemLetter = this.getProblemLetter(id);
        memento.createChildNode("label", problemLetter);
        memento.createChildNode("name", problem.toString());
        String color = this.getColor(contest, problem);
        if (color != null) {
            IMemento balloonColor = memento.createChildNode("balloon-color", color);
            String rgbColor = this.getColorRGB(contest, problem);
            balloonColor.putString("rgb", rgbColor);
        }
        return memento;
    }

    private String getColorRGB(IInternalContest contest, Problem problem) {
        BalloonSettings settings = this.getColorSettings(contest);
        if (settings != null) {
            return settings.getColorRGB(problem);
        }
        return null;
    }

    protected BalloonSettings getColorSettings(IInternalContest contest) {
        try {
            if (this.colorSettings == null) {
                BalloonSettings balloonSettings;
                BalloonSettings[] list = contest.getBalloonSettings();
                if (list != null && list.length > 0) {
                    this.colorSettings = list[0];
                }
                if (this.colorSettings == null && (balloonSettings = this.readBalloonSettings(contest, this.getColorsFilename())) != null) {
                    this.colorSettings = balloonSettings;
                }
            }
            return this.colorSettings;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getColorsFilename() {
        return this.colorsFilename;
    }

    public void setColorsFilename(String colorsFilename) {
        this.colorsFilename = colorsFilename;
    }

    private BalloonSettings readBalloonSettings(IInternalContest contest, String filename) {
        if (new File(filename).exists()) {
            try {
                String[] lines = Utilities.loadFile(filename);
                return this.toBalloonSettings(contest, lines);
            }
            catch (Exception e) {
                if (Utilities.isDebugMode()) {
                    e.printStackTrace(System.err);
                }
                return null;
            }
        }
        return null;
    }

    private BalloonSettings toBalloonSettings(IInternalContest contest, String[] lines) throws Exception {
        BalloonSettings settings;
        block6: {
            int site = 1;
            try {
                int found = 0;
                settings = new BalloonSettings("BalloonSettings One", site);
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    String[] fields = TabSeparatedValueParser.parseLine(line);
                    String shortName = fields[0];
                    Problem problem = this.getProblem(contest, shortName);
                    if (problem != null && fields != null && fields.length > 1) {
                        String colorName = fields[1];
                        String rgbColor = "";
                        if (fields.length > 2) {
                            rgbColor = fields[2];
                        }
                        settings.addColor(problem, colorName, rgbColor);
                        ++found;
                    }
                    ++n2;
                }
                if (found != 0) break block6;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return settings;
    }

    private Problem getProblem(IInternalContest contest, String shortName) {
        Problem[] problemArray = contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (shortName.equalsIgnoreCase(problem.getShortName())) {
                return problem;
            }
            ++n2;
        }
        return null;
    }

    private String getColor(IInternalContest contest, Problem problem) {
        BalloonSettings settings = this.getColorSettings(contest);
        if (settings != null) {
            return settings.getColor(problem);
        }
        return null;
    }

    protected String getProblemLetter(int id) {
        char let = 'A';
        let = (char)(let + (id - 1));
        return Character.toString(let);
    }

    public boolean isValidJudgement(Run run, boolean sendNotificationsForPreliminary) {
        boolean result = false;
        if (run.getStatus().equals((Object)Run.RunStates.JUDGED)) {
            result = true;
        } else if (run.isJudged()) {
            if (run.getStatus().equals((Object)Run.RunStates.MANUAL_REVIEW)) {
                if (sendNotificationsForPreliminary) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    public boolean isValidRun(IInternalContest contest, Run run) {
        ContestInformation contestInformation = contest.getContestInformation();
        boolean sendNotification = contestInformation.isPreliminaryJudgementsTriggerNotifications();
        if (run.isJudged() && run.isSolved() && !run.isDeleted() && this.isValidJudgement(run, sendNotification)) {
            return run.isSendToTeams() || !contest.isAllowed(Permission.Type.RESPECT_NOTIFY_TEAM_SETTING);
        }
        return false;
    }

    protected Problem[] getSolvedRuns(IInternalContest contest, ClientId id) {
        Filter filter = new Filter();
        filter.addAccount(id);
        filter.setFilteringDeleted(true);
        Run[] runs = filter.getRuns(contest.getRuns());
        Vector<Problem> probVector = new Vector<Problem>();
        int i = 0;
        while (i < runs.length) {
            Run run = runs[i];
            if (!run.isDeleted()) {
                Problem problem = contest.getProblem(run.getProblemId());
                if (this.isValidRun(contest, run) && !probVector.contains(problem)) {
                    probVector.add(problem);
                }
            }
            ++i;
        }
        Problem[] problems = probVector.toArray(new Problem[probVector.size()]);
        Arrays.sort(problems, new ProblemComparator(contest));
        return problems;
    }

    public IMemento addBalloonMemento(IMemento memento, IInternalContest contest, Problem problem) {
        int problemIndex = this.getProblemIndex(contest, problem);
        memento.putInteger("problem-id", problemIndex);
        XMLUtilities.addChild(memento, "label", this.getProblemLetter(problemIndex));
        XMLUtilities.addChild(memento, "name", contest.getProblem(problem.getElementId()).getDisplayName());
        IMemento colorMemento = XMLUtilities.addChild(memento, "color", this.getProblemBalloonColor(contest, problem));
        colorMemento.putString("rgb", this.getProblemRGB(contest, problem));
        return memento;
    }

    private String getProblemRGB(IInternalContest contest, Problem problem) {
        BalloonSettings settings = contest.getBalloonSettings(contest.getSiteNumber());
        return settings.getColorRGB(problem);
    }

    private String getProblemBalloonColor(IInternalContest contest, Problem problem) {
        BalloonSettings settings = contest.getBalloonSettings(contest.getSiteNumber());
        return settings.getColor(problem);
    }

    public XMLMemento createBalloonElement(IInternalContest contest, Problem problem) {
        XMLMemento memento = XMLMemento.createWriteRoot(BALLOON_TAG);
        this.addBalloonMemento(memento, contest, problem);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Notification notification) {
        ClientId clientId = notification.getSubmitter();
        memento.putInteger("id", notification.getNumber());
        XMLUtilities.addChild(memento, "id", notification.getNumber());
        memento.putInteger("team-id", clientId.getClientNumber());
        XMLUtilities.addChild(memento, "team-id", clientId.getClientNumber());
        XMLUtilities.addChild(memento, "contest-time", XMLUtilities.formatSeconds(notification.getElapsedMS()));
        XMLUtilities.addChild(memento, "time", XMLUtilities.formatSeconds(notification.getElapsedMS()));
        XMLUtilities.addChild(memento, "timestamp", notification.getTimeSent());
        XMLUtilities.addChild(memento, TEAM_TAG, contest.getAccount(clientId).getDisplayName());
        Problem[] problems = this.getSolvedRuns(contest, clientId);
        boolean firstSolvedByteam = problems.length == 1;
        XMLUtilities.addChild(memento, "first-by-team", firstSolvedByteam);
        Problem solvedProblem = contest.getProblem(notification.getProblemId());
        IMemento singleBalloon = memento.createChild(BALLOON_TAG);
        this.addBalloonMemento(singleBalloon, contest, solvedProblem);
        IMemento balloonsRoot = memento.createChild(BALLOON_LIST_TAG);
        Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            memento = balloonsRoot.createChild(BALLOON_TAG);
            this.addBalloonMemento(memento, contest, problem);
            ++n2;
        }
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Run run, int notificationSequenceNumber) {
        ClientId clientId = run.getSubmitter();
        memento.putInteger("id", notificationSequenceNumber);
        XMLUtilities.addChild(memento, "team-id", clientId.getClientNumber());
        XMLUtilities.addChild(memento, "contest-time", XMLUtilities.formatSeconds(run.getElapsedMins() * 1000L));
        XMLUtilities.addChild(memento, "time", XMLUtilities.formatSeconds(run.getElapsedMins() * 1000L));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        XMLUtilities.addChild(memento, TEAM_TAG, contest.getAccount(clientId).getDisplayName());
        Problem[] problems = this.getSolvedRuns(contest, clientId);
        boolean firstSolvedByteam = problems.length == 1;
        XMLUtilities.addChild(memento, "first-by-team", firstSolvedByteam);
        Problem solvedProblem = contest.getProblem(run.getProblemId());
        IMemento singleBalloon = memento.createChild(BALLOON_TAG);
        this.addBalloonMemento(singleBalloon, contest, solvedProblem);
        IMemento balloonsRoot = memento.createChild(BALLOON_LIST_TAG);
        Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            memento = balloonsRoot.createChild(BALLOON_TAG);
            this.addBalloonMemento(memento, contest, problem);
            ++n2;
        }
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Account account) {
        XMLMemento memento = XMLMemento.createWriteRoot(TEAM_TAG);
        this.addMemento((IMemento)memento, contest, account);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Account account) {
        XMLUtilities.addChild(memento, "id", account.getClientId().getClientNumber());
        memento.putInteger("id", account.getClientId().getClientNumber());
        memento.putString("external-id", account.getExternalId());
        XMLUtilities.addChild(memento, "name", account.getDisplayName());
        XMLUtilities.addChild(memento, "nationality", account.getCountryCode());
        XMLUtilities.addChild(memento, "university", account.getDisplayName());
        try {
            String regionName = "";
            if (account.getGroupId() != null) {
                Group group = contest.getGroup(account.getGroupId());
                regionName = group.getDisplayName();
            }
            XMLUtilities.addChild(memento, REGION_TAG, regionName);
        }
        catch (Exception e) {
            System.out.println("Failed to lookup group for " + account + " group id = " + account.getGroupId());
            e.printStackTrace();
        }
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, RunTestCase testCase, Run run) {
        XMLMemento memento = XMLMemento.createWriteRoot(TESTCASE_TAG);
        this.addMemento((IMemento)memento, contest, testCase, run);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, RunTestCase testCase, Run run) {
        Problem problem = contest.getProblem(run.getProblemId());
        XMLUtilities.addChild(memento, "i", testCase.getTestNumber());
        XMLUtilities.addChild(memento, "judged", run.isJudged());
        XMLUtilities.addChild(memento, "judgement_id", testCase.getTestNumber());
        XMLUtilities.addChild(memento, "n", problem.getNumberTestCases());
        XMLUtilities.addChild(memento, "solved", run.isSolved());
        String result = "OCS";
        if (testCase.isPassed()) {
            result = "AC";
        }
        XMLUtilities.addChild(memento, "result", result);
        XMLUtilities.addChild(memento, "run-id", run.getNumber());
        XMLUtilities.addChild(memento, "time", XMLUtilities.formatSeconds(run.getElapsedMS()));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Clarification clarification) {
        XMLMemento memento = XMLMemento.createWriteRoot(CLARIFICATION_TAG);
        this.addMemento((IMemento)memento, contest, clarification);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Clarification clarification) {
        memento.putInteger("id", clarification.getNumber());
        XMLUtilities.addChild(memento, "id", clarification.getNumber());
        memento.putInteger("team-id", clarification.getSubmitter().getClientNumber());
        Problem problem = contest.getProblem(clarification.getProblemId());
        memento.putInteger("problem-id", this.getProblemIndex(contest, problem));
        String answer = clarification.getAnswer();
        if (answer == null) {
            answer = "";
        }
        XMLUtilities.addChild(memento, "answer", answer);
        XMLUtilities.addChild(memento, "question", clarification.getQuestion());
        XMLUtilities.addChild(memento, "to-all", clarification.isSendToAll());
        XMLUtilities.addChild(memento, "contest-time", XMLUtilities.formatSeconds(clarification.getElapsedMins() * 1000L));
        XMLUtilities.addChild(memento, "time", XMLUtilities.formatSeconds(clarification.getElapsedMins() * 1000L));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        return memento;
    }

    private int getProblemIndex(IInternalContest contest, Problem inProblem) {
        int idx = 0;
        Problem[] problemArray = contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (problem.getElementId().equals(inProblem.getElementId())) {
                return idx + 1;
            }
            ++idx;
            ++n2;
        }
        return -1;
    }

    public XMLMemento createElement(IInternalContest contest, Run run, boolean suppressJudgement) {
        XMLMemento memento = XMLMemento.createWriteRoot(RUN_TAG);
        this.addMemento((IMemento)memento, contest, run, suppressJudgement);
        return memento;
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Run run, boolean suppressJudgement) {
        XMLUtilities.addChild(memento, "id", run.getNumber());
        if (suppressJudgement) {
            XMLUtilities.addChild(memento, "judged", false);
        } else {
            XMLUtilities.addChild(memento, "judged", run.isJudged());
        }
        Language language = contest.getLanguage(run.getLanguageId());
        XMLUtilities.addChild(memento, LANGUAGE_TAG, language.getDisplayName());
        if (!run.isSolved() && this.isYoungerThanFirstYes(contest, run)) {
            XMLUtilities.addChild(memento, "penalty", "True");
        } else {
            XMLUtilities.addChild(memento, "penalty", "False");
        }
        Problem problem = contest.getProblem(run.getProblemId());
        int problemIndex = this.getProblemIndex(contest, problem);
        XMLUtilities.addChild(memento, PROBLEM_TAG, problemIndex);
        XMLUtilities.addChild(memento, "team-id", run.getSubmitter().getClientNumber());
        XMLUtilities.addChild(memento, TEAM_TAG, run.getSubmitter().getClientNumber());
        memento.putInteger("team-id", run.getSubmitter().getClientNumber());
        if (!suppressJudgement && run.isJudged()) {
            ElementId judgementId = run.getJudgementRecord().getJudgementId();
            String acronym = contest.getJudgement(judgementId).getAcronym();
            if (acronym == null) {
                acronym = "?";
            }
            XMLUtilities.addChild(memento, "result", acronym);
        }
        XMLUtilities.addChild(memento, "solved", run.isSolved());
        XMLUtilities.addChild(memento, "elapsed-Mins", run.getElapsedMins());
        XMLUtilities.addChild(memento, "time", XMLUtilities.formatSeconds(run.getElapsedMS()));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        return memento;
    }

    protected boolean isYoungerThanFirstYes(IInternalContest contest, Run run) {
        Run firstYes = this.findFistYes(contest, run.getSubmitter(), run.getProblemId());
        if (firstYes == null) {
            return false;
        }
        return run.getElapsedMS() < firstYes.getElapsedMS();
    }

    protected Run findFistYes(IInternalContest contest, ClientId submitter, ElementId problemId) {
        Run[] runs = contest.getRuns();
        Run lastYesRun = null;
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (run.isSolved() && run.getProblemId().equals(problemId) && run.getSubmitter().equals(submitter)) {
                if (lastYesRun == null) {
                    lastYesRun = run;
                } else if (lastYesRun.getElapsedMS() > run.getElapsedMS()) {
                    lastYesRun = run;
                }
            }
            ++n2;
        }
        return lastYesRun;
    }

    protected String toXML(XMLMemento mementoRoot) {
        try {
            return mementoRoot.saveToString(true);
        }
        catch (IOException e) {
            this.logWarning("Error in creating XML", e);
            return "";
        }
    }

    public String createStartupXML(IInternalContest contest) {
        return this.createStartupXML(contest, new Filter());
    }

    public String createStartupXML(IInternalContest contest, Filter filter) {
        Clarification[] clarifications;
        Account[] teamAccounts;
        StringBuffer sb = new StringBuffer("<contest>");
        filter.setFilteringDeleted(true);
        sb.append(this.toXML(this.createInfoElement(contest, contest.getContestInformation())));
        int idx = 1;
        IElementObject[] iElementObjectArray = contest.getLanguages();
        int n = iElementObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = iElementObjectArray[n2];
            sb.append(this.toXML(this.createElement(contest, language, idx)));
            ++idx;
            ++n2;
        }
        idx = 1;
        iElementObjectArray = contest.getProblems();
        n = iElementObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            IElementObject problem = iElementObjectArray[n2];
            if (filter.matches((Problem)problem)) {
                sb.append(this.toXML(this.createElement(contest, (Problem)problem, idx)));
            }
            ++idx;
            ++n2;
        }
        Group[] groups = contest.getGroups();
        Arrays.sort(groups, new GroupComparator());
        IElementObject[] iElementObjectArray2 = groups;
        int n3 = groups.length;
        n = 0;
        while (n < n3) {
            Group group = iElementObjectArray2[n];
            sb.append(this.toXML(this.createElement(contest, group, idx)));
            ++n;
        }
        iElementObjectArray2 = contest.getJudgements();
        n3 = iElementObjectArray2.length;
        n = 0;
        while (n < n3) {
            IElementObject judgement = iElementObjectArray2[n];
            sb.append(this.toXML(this.createElement(contest, (Judgement)judgement)));
            ++n;
        }
        Account[] accountArray = teamAccounts = this.getTeamAccounts(contest);
        int n4 = teamAccounts.length;
        n3 = 0;
        while (n3 < n4) {
            Account account = accountArray[n3];
            if (filter.matches(account) && this.teamDisplayedOnScoreboard(contest, account.getClientId())) {
                sb.append(this.toXML(this.createElement(contest, account)));
            }
            ++n3;
        }
        Clarification[] clarificationArray = clarifications = contest.getClarifications();
        int n5 = clarifications.length;
        n4 = 0;
        while (n4 < n5) {
            Clarification clarification = clarificationArray[n4];
            sb.append(this.toXML(this.createElement(contest, clarification)));
            ++n4;
        }
        Run[] runs = contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        Run[] runArray = runs;
        int n6 = runs.length;
        n5 = 0;
        while (n5 < n6) {
            Run run = runArray[n5];
            if (this.teamDisplayedOnScoreboard(contest, run.getSubmitter())) {
                if (filter.matches(run)) {
                    sb.append(this.toXML(this.createElement(contest, run, false)));
                    RunTestCase[] runTestCases = this.getLastJudgementTestCases(run);
                    Arrays.sort(runTestCases, new RunTestCaseComparator());
                    RunTestCase[] runTestCaseArray = runTestCases;
                    int n7 = runTestCases.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        RunTestCase runTestCase = runTestCaseArray[n8];
                        if (filter.matchesElapsedTime(runTestCase)) {
                            sb.append(this.toXML(this.createElement(contest, runTestCase, run)));
                        }
                        ++n8;
                    }
                } else if (!filter.matchesElapsedTime(run)) {
                    sb.append(this.toXML(this.createElement(contest, run, false)));
                }
            }
            ++n5;
        }
        return sb.toString();
    }

    private boolean teamDisplayedOnScoreboard(IInternalContest inContest, ClientId clientId) {
        return inContest.isAllowed(clientId, Permission.Type.DISPLAY_ON_SCOREBOARD);
    }

    public XMLMemento createElement(IInternalContest contest, Group group, int idx) {
        XMLMemento memento = XMLMemento.createWriteRoot(REGION_TAG);
        this.addMemento((IMemento)memento, contest, group);
        return memento;
    }

    protected RunTestCase[] getLastJudgementTestCases(Run run) {
        ArrayList<RunTestCase> cases = new ArrayList<RunTestCase>();
        if (run.isJudged()) {
            RunTestCase[] runTestCases = run.getRunTestCases();
            JudgementRecord judgementRecord = run.getJudgementRecord();
            RunTestCase[] runTestCaseArray = runTestCases;
            int n = runTestCases.length;
            int n2 = 0;
            while (n2 < n) {
                RunTestCase runTestCase = runTestCaseArray[n2];
                if (runTestCase.matchesJudgement(judgementRecord)) {
                    cases.add(runTestCase);
                }
                ++n2;
            }
        }
        return cases.toArray(new RunTestCase[cases.size()]);
    }

    public Account[] getTeamAccounts(IInternalContest inContest) {
        Vector<Account> accountVector = inContest.getAccounts(ClientType.Type.TEAM);
        Account[] accounts = accountVector.toArray(new Account[accountVector.size()]);
        Arrays.sort(accounts, new AccountComparator());
        return accounts;
    }

    public String createFinalizeXML(IInternalContest contest, FinalizeData data) {
        StringBuffer sb = new StringBuffer();
        XMLMemento memento = XMLMemento.createWriteRoot(FINALIZE_TAG);
        this.addMemento((IMemento)memento, contest, data);
        sb.append(this.toXML(memento));
        sb.append("</");
        sb.append(CONTEST_TAG);
        sb.append(">");
        return sb.toString();
    }

    private void addMemento(IMemento memento, IInternalContest contest, FinalizeData data) {
        XMLUtilities.addChild(memento, "last-gold", data.getGoldRank());
        XMLUtilities.addChild(memento, "last-silver", data.getSilverRank());
        XMLUtilities.addChild(memento, "last-bronze", data.getBronzeRank());
        XMLUtilities.addChild(memento, "comment", data.getComment());
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
    }

    public XMLMemento createElement(IInternalContest contest, Group group) {
        XMLMemento memento = XMLMemento.createWriteRoot(REGION_TAG);
        this.addMemento((IMemento)memento, contest, group);
        return memento;
    }

    public void addMemento(IMemento memento, IInternalContest contest, Group group) {
        memento.putInteger("id", group.getGroupId());
        XMLUtilities.addChild(memento, "external-did", group.getGroupId());
        XMLUtilities.addChild(memento, "name", group.getDisplayName());
    }

    public XMLMemento createElement(IInternalContest contest, Judgement judgement) {
        XMLMemento memento = XMLMemento.createWriteRoot(JUDGEMENT_TAG);
        this.addMemento((IMemento)memento, contest, judgement);
        return memento;
    }

    private String guestAcronym(Judgement judgement) {
        if (judgement.getAcronym() == null || judgement.getAcronym().length() == 0) {
            return this.guessAcronym(judgement.getDisplayName());
        }
        return judgement.getAcronym();
    }

    public IMemento addMemento(IMemento memento, IInternalContest contest, Judgement judgement) {
        String name = judgement.getDisplayName();
        String acronym = this.guestAcronym(judgement);
        XMLUtilities.addChild(memento, "acronym", acronym);
        XMLUtilities.addChild(memento, "name", name);
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, JudgementRecord judgementRecord) {
        XMLMemento memento = XMLMemento.createWriteRoot(JUDGEMENT_RECORD_TAG);
        Judgement judgement = contest.getJudgement(judgementRecord.getJudgementId());
        XMLUtilities.addChild((IMemento)memento, "acronym", this.guestAcronym(judgement));
        XMLUtilities.addChild((IMemento)memento, "name", judgement.getDisplayName());
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, Notification notification) {
        XMLMemento memento = XMLMemento.createWriteRoot(NOTIFICATION_TAG);
        this.addMemento((IMemento)memento, contest, notification);
        return memento;
    }

    public XMLMemento createElement(IInternalContest contest, BalloonDeliveryInfo balloonDeliveryInfo, int notificationSequenceNumber) {
        XMLMemento memento = XMLMemento.createWriteRoot(NOTIFICATION_TAG);
        Run run = this.getFirstSolvedRun(contest, balloonDeliveryInfo.getClientId(), balloonDeliveryInfo.getProblemId());
        this.addMemento((IMemento)memento, contest, run, notificationSequenceNumber);
        return memento;
    }

    private void logWarning(String message, Exception e) {
        this.log.log(Log.WARNING, message, e);
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

