/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.util;

import java.util.Vector;

public final class CommaSeparatedValueParser {
    private static final char COMMA_CHAR = ',';
    private static final String COMMA_STRING = String.valueOf(',');

    public static String[] parseLine(String line) throws Exception {
        if (line == null) {
            throw new IllegalArgumentException("null String not allowed");
        }
        String[] array = new String[]{""};
        int fieldCount = 1;
        String currentField = "";
        Vector<String> v = new Vector<String>();
        boolean inQuote = false;
        int length = line.length();
        int i = 0;
        while (i < line.length()) {
            char current = line.charAt(i);
            if (current == '\"') {
                if (inQuote) {
                    if (i + 1 < length) {
                        char next = line.charAt(i + 1);
                        if (next == ',') {
                            inQuote = false;
                        } else if (next == '\"') {
                            currentField = currentField.concat("\"");
                            ++i;
                        } else {
                            new Exception("found unexpected quote at position " + i + ", but next character '" + String.valueOf(next) + "'");
                        }
                    }
                } else {
                    inQuote = true;
                }
            } else if (current == ',') {
                if (inQuote) {
                    currentField = currentField.concat(COMMA_STRING);
                } else {
                    v.addElement(currentField);
                    ++fieldCount;
                    currentField = "";
                }
            } else {
                currentField = currentField.concat(new Character(current).toString());
            }
            ++i;
        }
        v.addElement(currentField);
        array = new String[fieldCount];
        if (fieldCount != v.size()) {
            new Exception("Incorrect number of fields (found " + fieldCount + ", but expected " + v.size() + ")");
        }
        i = 0;
        while (i < v.size()) {
            Object o = v.elementAt(i);
            array[i] = o != null ? (String)o : "";
            ++i;
        }
        return array;
    }

    public static String toString(String[] array) {
        String s = "";
        int i = 0;
        while (i < array.length) {
            String newField = "";
            int start = 0;
            boolean needsQuote = false;
            String field = array[i];
            if (field.indexOf("\"") > -1) {
                needsQuote = true;
                while (field.indexOf("\"", start) > -1) {
                    newField = newField.concat(String.valueOf(field.substring(start, field.indexOf("\"", start) + 1)) + "\"");
                    start = field.indexOf("\"", start) + 1;
                }
                field = String.valueOf(newField) + field.substring(start);
            }
            s = field.indexOf(String.valueOf(COMMA_STRING)) > -1 || needsQuote ? s.concat("\"" + field + "\",") : s.concat(String.valueOf(field) + COMMA_STRING);
            ++i;
        }
        s = s.substring(0, s.length() - 1);
        return s;
    }

    private CommaSeparatedValueParser() {
    }
}

