/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.transport.connection;

import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.core.transport.IBtoA;
import edu.csus.ecs.pc2.core.transport.ITransportManager;
import edu.csus.ecs.pc2.core.transport.ITwoToOne;
import edu.csus.ecs.pc2.core.transport.TransportException;
import edu.csus.ecs.pc2.core.transport.TransportManager;
import edu.csus.ecs.pc2.core.transport.connection.ConnectionManagerEvent;
import edu.csus.ecs.pc2.core.transport.connection.IConnectionManagerListener;
import java.io.Serializable;
import java.util.Vector;

public class ConnectionManager
implements ITransportManager {
    public static final String DEFAULT_PC2_PORT = "50002";
    private TransportManager transportManager = null;
    private Log cmLog = null;
    private Vector<IConnectionManagerListener> connectionListenerList = new Vector();

    public ConnectionManager(Log log) {
        this.cmLog = log;
        this.transportManager = new TransportManager(this.cmLog);
    }

    private void fireConnectionListener(ConnectionManagerEvent connectionManagerEvent) {
        int i = 0;
        while (i < this.connectionListenerList.size()) {
            switch (connectionManagerEvent.getAction()) {
                case CONNECTED: {
                    this.connectionListenerList.elementAt(i).connectionEstablished(connectionManagerEvent);
                    break;
                }
                case DISCONNECTED: {
                    this.connectionListenerList.elementAt(i).connectionDropped(connectionManagerEvent);
                    break;
                }
                case RECIEVED_OBJECT: {
                    this.connectionListenerList.elementAt(i).receivedObject(connectionManagerEvent);
                    break;
                }
                case FAILED: {
                    this.connectionListenerList.elementAt(i).connectionFailed(connectionManagerEvent);
                    break;
                }
                case TIMED_OUT: {
                    this.connectionListenerList.elementAt(i).connectionTimedOut(connectionManagerEvent);
                    break;
                }
                default: {
                    this.connectionListenerList.elementAt(i).connectionChanged(connectionManagerEvent);
                }
            }
            ++i;
        }
    }

    public void addConnectionListener(IConnectionManagerListener listener) {
        this.connectionListenerList.addElement(listener);
    }

    public void removeConnectionListener(IConnectionManagerListener listener) {
        this.connectionListenerList.removeElement(listener);
    }

    public void establishConnection(ConnectionHandlerID connectionHandlerID) {
        ConnectionManagerEvent connectionManagerEvent = new ConnectionManagerEvent(ConnectionManagerEvent.Action.CONNECTED, connectionHandlerID);
        this.fireConnectionListener(connectionManagerEvent);
    }

    public void connectionDropped(ConnectionHandlerID connectionHandlerID) {
        ConnectionManagerEvent connectionManagerEvent = new ConnectionManagerEvent(ConnectionManagerEvent.Action.DISCONNECTED, connectionHandlerID);
        this.fireConnectionListener(connectionManagerEvent);
    }

    public void connectionTimedOut(ConnectionHandlerID connectionHandlerID) {
        ConnectionManagerEvent connectionManagerEvent = new ConnectionManagerEvent(ConnectionManagerEvent.Action.DISCONNECTED, connectionHandlerID);
        this.fireConnectionListener(connectionManagerEvent);
    }

    public void connectionFailed(ConnectionHandlerID connectionHandlerID) {
        ConnectionManagerEvent connectionManagerEvent = new ConnectionManagerEvent(ConnectionManagerEvent.Action.FAILED, connectionHandlerID);
        this.fireConnectionListener(connectionManagerEvent);
    }

    public void receivedObject(ConnectionHandlerID connectionHandlerID, Serializable serializableObject) {
        ConnectionManagerEvent connectionManagerEvent = new ConnectionManagerEvent(ConnectionManagerEvent.Action.RECIEVED_OBJECT, connectionHandlerID, serializableObject);
        this.fireConnectionListener(connectionManagerEvent);
    }

    @Override
    public void connectToMyServer() throws TransportException {
        this.transportManager.connectToMyServer();
    }

    @Override
    public void send(Serializable msgObj) throws TransportException {
        this.transportManager.send(msgObj);
    }

    @Override
    public ConnectionHandlerID connectToServer(String serverIP, int port) throws TransportException {
        return this.transportManager.connectToServer(serverIP, port);
    }

    @Override
    public void startClientTransport(String serverIP, int port, IBtoA appCallBack) {
        this.transportManager.startClientTransport(serverIP, port, appCallBack);
    }

    @Override
    public void shutdownTransport() {
        this.transportManager.shutdownTransport();
    }

    @Override
    public void setLog(Log log) {
        this.cmLog = log;
        this.transportManager.setLog(log);
    }

    @Override
    public void accecptConnections(int listeningPort) throws TransportException {
        this.transportManager.accecptConnections(listeningPort);
    }

    @Override
    public void send(Serializable msgObj, ConnectionHandlerID connectionHandlerID) throws TransportException {
        this.transportManager.send(msgObj, connectionHandlerID);
    }

    @Override
    public void unregisterConnection(ConnectionHandlerID myConnectionID) {
        this.transportManager.unregisterConnection(myConnectionID);
    }

    @Override
    public void startServerTransport(ITwoToOne appCallBack) {
        this.transportManager.startServerTransport(appCallBack);
    }
}

