/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.security;

import edu.csus.ecs.pc2.core.exception.ContestSecurityException;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.security.ISecurityMessageListener;
import edu.csus.ecs.pc2.core.security.SecurityMessageEvent;
import java.util.Vector;

public class SecurityMessageHandler {
    private Log log = null;
    private String logName = null;
    private Vector<ISecurityMessageListener> securityMessageListenerList = new Vector();

    public SecurityMessageHandler(ClientId clientId) {
        this.logName = String.valueOf(this.stripChar(clientId.toString(), ' ')) + ".security";
    }

    public String getPluginTitle() {
        return "Security Violation Message Handler";
    }

    protected String stripChar(String s, char characterToRemove) {
        int idx = s.indexOf(characterToRemove);
        if (idx > -1) {
            StringBuffer sb = new StringBuffer(s);
            idx = sb.indexOf(String.valueOf(characterToRemove));
            while (idx > -1) {
                sb.deleteCharAt(idx);
                idx = sb.indexOf(String.valueOf(characterToRemove));
            }
            return sb.toString();
        }
        return s;
    }

    public void newMessage(ClientId clientId, String message, String eventName, Exception exception) {
        if (eventName == null) {
            eventName = "";
        }
        if (exception != null) {
            this.getLog().log(Log.SEVERE, "From: " + clientId + " " + eventName + " " + message, exception);
        } else {
            this.getLog().log(Log.SEVERE, "From: " + clientId + " " + eventName + " " + message);
        }
        SecurityMessageEvent securityMessageEvent = new SecurityMessageEvent(SecurityMessageEvent.Action.NEW, clientId, message, eventName, exception);
        this.fireSecurityMessageListener(securityMessageEvent);
    }

    public void newMessage(ClientId clientId, String message, String eventName, ContestSecurityException exception) {
        if (eventName == null) {
            eventName = "";
        }
        if (exception != null) {
            this.getLog().log(Log.SEVERE, "SecurityException From:  " + clientId + " " + eventName + " " + message, exception);
            this.getLog().log(Log.SEVERE, "SecurityException Sec. Message: " + exception.getSecurityMessage() + " ConnHandId " + exception.getConnectionHandlerID());
        } else {
            this.getLog().log(Log.SEVERE, "From: " + clientId + " " + eventName + " " + message);
        }
        SecurityMessageEvent securityMessageEvent = new SecurityMessageEvent(SecurityMessageEvent.Action.NEW, clientId, message, eventName, exception);
        this.fireSecurityMessageListener(securityMessageEvent);
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new Log(this.logName);
        }
        return this.log;
    }

    public void addSecurityMessageListener(ISecurityMessageListener securityMessageListener) {
        this.securityMessageListenerList.addElement(securityMessageListener);
    }

    public void removeSecurityMessageListener(ISecurityMessageListener securityMessageListener) {
        this.securityMessageListenerList.removeElement(securityMessageListener);
    }

    private void fireSecurityMessageListener(SecurityMessageEvent securityMessageEvent) {
        int i = 0;
        while (i < this.securityMessageListenerList.size()) {
            switch (securityMessageEvent.getAction()) {
                case NEW: {
                    this.securityMessageListenerList.elementAt(i).newMessage(securityMessageEvent);
                    break;
                }
                default: {
                    this.securityMessageListenerList.elementAt(i).newMessage(securityMessageEvent);
                }
            }
            ++i;
        }
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
        this.log = null;
    }
}

