/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.security;

import edu.csus.ecs.pc2.core.security.CryptoException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.spec.DHParameterSpec;

public class Crypto {
    public static final String SVN_ID = "$Id$";
    private KeyPair keyPair = null;
    private SecretKey secretKey = null;
    private String encryptionType = "DES";
    private String agreementType = "DH";
    private byte[] skip1024ModulusBytes = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};
    private BigInteger skip1024Modulus = new BigInteger(1, this.skip1024ModulusBytes);
    private BigInteger skip1024Base = BigInteger.valueOf(2L);

    public Crypto() {
        this.setMyKeyPair(this.generateKeyPair());
    }

    public Crypto(KeyPair keyPair) {
        this.setMyKeyPair(keyPair);
    }

    public PublicKey getPublicKey() {
        return this.getKeyPair().getPublic();
    }

    public PrivateKey getPrivateKey() {
        return this.getKeyPair().getPrivate();
    }

    public SealedObject encrypt(Serializable objToEncrypt) throws CryptoException {
        return this.encrypt(objToEncrypt, this.getSecretKey());
    }

    public SealedObject encrypt(Serializable objToEncrypt, SecretKey inSecretKey) throws CryptoException {
        SealedObject encryptedObject = null;
        try {
            Cipher ecipher = Cipher.getInstance(this.encryptionType);
            ecipher.init(1, inSecretKey);
            encryptedObject = new SealedObject(objToEncrypt, ecipher);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CryptoException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoException(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e.getMessage());
        }
        return encryptedObject;
    }

    public Serializable decrypt(SealedObject encryptedObject) throws CryptoException {
        return this.decrypt(encryptedObject, this.getSecretKey());
    }

    public Serializable decrypt(SealedObject encryptedObject, SecretKey inSecretKey) throws CryptoException {
        Serializable decryptedObject = null;
        try {
            String algoName = encryptedObject.getAlgorithm();
            Cipher dcipher = Cipher.getInstance(algoName);
            dcipher.init(2, inSecretKey);
            decryptedObject = (Serializable)encryptedObject.getObject(dcipher);
        }
        catch (IOException e) {
            throw new CryptoException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new CryptoException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new CryptoException(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e.getMessage());
        }
        return decryptedObject;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public void setMyKeyPair(KeyPair myKeyPair) {
        this.keyPair = myKeyPair;
    }

    public SecretKey generateSecretKey(PublicKey publicKey, PrivateKey privateKey) {
        SecretKey outSecretKey = null;
        try {
            KeyAgreement ka = KeyAgreement.getInstance("DH");
            ka.init(privateKey);
            ka.doPhase(publicKey, true);
            String algorithm = this.encryptionType;
            outSecretKey = ka.generateSecret(algorithm);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return outSecretKey;
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(this.agreementType);
            DHParameterSpec dhParamSpec = new DHParameterSpec(this.skip1024Modulus, this.skip1024Base);
            keyGen.initialize(dhParamSpec);
            this.keyPair = keyGen.generateKeyPair();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.keyPair;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(SecretKey secretKey) {
        this.secretKey = secretKey;
    }
}

