/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.scoring;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.PermissionGroup;
import edu.csus.ecs.pc2.core.Plugin;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.list.AccountList;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.list.RunComparatorByTeam;
import edu.csus.ecs.pc2.core.list.RunCompartorByElapsed;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunUtilities;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.scoring.DefaultStandingsRecordComparator;
import edu.csus.ecs.pc2.core.scoring.INewScoringAlgorithm;
import edu.csus.ecs.pc2.core.scoring.ProblemScoreRecord;
import edu.csus.ecs.pc2.core.scoring.ProblemSummaryInfo;
import edu.csus.ecs.pc2.core.scoring.StandingsRecord;
import edu.csus.ecs.pc2.core.scoring.SummaryRow;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class NewScoringAlgorithm
extends Plugin
implements INewScoringAlgorithm {
    private static final long serialVersionUID = -7815725774105747895L;
    private boolean blockRanking = true;
    private boolean respectEOC = false;
    private DefaultStandingsRecordComparator comparator = new DefaultStandingsRecordComparator();
    private PermissionList permissionList = new PermissionList();

    public StandingsRecord[] getRegionalWinners(IInternalContest contest, Properties properties) throws IllegalContestState {
        StandingsRecord[] records = this.getStandingsRecords(contest, properties);
        Vector<StandingsRecord> outVector = new Vector<StandingsRecord>();
        StandingsRecord[] standingsRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            StandingsRecord record = standingsRecordArray[n2];
            if (record.getGroupRankNumber() == 1) {
                outVector.addElement(record);
            }
            ++n2;
        }
        return outVector.toArray(new StandingsRecord[outVector.size()]);
    }

    public StandingsRecord getRegionalWinner(IInternalContest contest, Properties properties, Group group) throws IllegalContestState {
        StandingsRecord[] records = this.getStandingsRecords(contest, properties);
        StandingsRecord outRecord = null;
        StandingsRecord[] standingsRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            Group teamGroup;
            Account account;
            StandingsRecord record = standingsRecordArray[n2];
            if (record.getGroupRankNumber() == 1 && (account = contest.getAccount(record.getClientId())) != null && (teamGroup = contest.getGroup(account.getGroupId())) != null && teamGroup.equals(group)) {
                if (outRecord != null) {
                    return null;
                }
                outRecord = record;
            }
            ++n2;
        }
        return outRecord;
    }

    @Override
    public StandingsRecord[] getStandingsRecords(IInternalContest contest, Properties properties) throws IllegalContestState {
        Vector<Account> accountVector = contest.getAccounts(ClientType.Type.TEAM);
        Account[] accounts = accountVector.toArray(new Account[accountVector.size()]);
        AccountList accountList = new AccountList();
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            accountList.add(account);
            ++n2;
        }
        this.comparator.setCachedAccountList(accountList);
        Run[] runs = contest.getRuns();
        this.respectEOC = this.isAllowed(contest, contest.getClientId(), Permission.Type.RESPECT_EOC_SUPPRESSION);
        if (this.respectEOC) {
            runs = this.filterRunsbyEOC(contest, runs);
        }
        StandingsRecord[] standings = this.computeStandingStandingsRecords(runs, accounts, properties, contest.getProblems());
        Arrays.sort(standings, this.comparator);
        if (this.blockRanking) {
            this.assignRanksBlock(standings);
        } else {
            this.assignRanks(standings);
        }
        this.assignGroupRanks(contest, standings);
        return standings;
    }

    private Run[] filterRunsbyEOC(IInternalContest contest, Run[] runs) {
        Vector<Run> vector = new Vector<Run>();
        JudgementNotificationsList judgementNotificationsList = contest.getContestInformation().getJudgementNotificationsList();
        ContestTime contestTime = contest.getContestTime();
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run;
            Run runToAdd = run = runArray[n2];
            if (this.respectEOC && RunUtilities.supppressJudgement(judgementNotificationsList, run, contestTime)) {
                runToAdd = RunUtilities.createNewRun(run, contest);
            }
            vector.add(runToAdd);
            ++n2;
        }
        return vector.toArray(new Run[vector.size()]);
    }

    @Override
    public String getStandings(IInternalContest contest, Properties properties, Log log) throws IllegalContestState {
        StandingsRecord[] standings = this.getStandingsRecords(contest, properties);
        XMLMemento mementoRoot = XMLMemento.createWriteRoot("contestStandings");
        IMemento summaryMememento = this.createSummaryMomento(contest.getContestInformation(), mementoRoot);
        this.dumpGroupList(contest.getGroups(), mementoRoot);
        Problem[] problems = contest.getProblems();
        summaryMememento.putLong("problemCount", problems.length);
        Site[] sites = contest.getSites();
        summaryMememento.putInteger("siteCount", sites.length);
        Group[] groups = contest.getGroups();
        if (groups != null) {
            this.dumpGroupList(groups, summaryMememento);
        }
        int indexNumber = 0;
        StandingsRecord[] standingsRecordArray = standings;
        int n = standings.length;
        int n2 = 0;
        while (n2 < n) {
            StandingsRecord standingsRecord = standingsRecordArray[n2];
            this.addTeamMemento(mementoRoot, contest, standingsRecord, indexNumber);
            ++indexNumber;
            ++n2;
        }
        GrandTotals grandTotals = this.addProblemSummaryMememento(summaryMememento, standings, contest, contest.getProblems());
        this.addGrandTotals(summaryMememento, grandTotals);
        String xmlString = null;
        try {
            xmlString = mementoRoot.saveToString();
        }
        catch (IOException e) {
            IllegalContestState state = new IllegalContestState(e.getLocalizedMessage());
            state.setStackTrace(e.getStackTrace());
            throw state;
        }
        return xmlString;
    }

    boolean isTied(StandingsRecord standingsRecord, StandingsRecord standingsRecord2) {
        if (standingsRecord2.getNumberSolved() != standingsRecord.getNumberSolved()) {
            return false;
        }
        if (standingsRecord2.getPenaltyPoints() != standingsRecord.getPenaltyPoints()) {
            return false;
        }
        return standingsRecord2.getLastSolved() == standingsRecord.getLastSolved();
    }

    private void assignRanksBlock(StandingsRecord[] standings) {
        int rank = 1;
        if (standings.length > 0) {
            standings[0].setRankNumber(rank);
        }
        int numInBlock = 0;
        if (standings.length > 1) {
            int i = 1;
            while (i < standings.length) {
                if (!this.isTied(standings[i], standings[i - 1])) {
                    ++rank;
                    rank += numInBlock;
                    numInBlock = 0;
                } else {
                    ++numInBlock;
                }
                standings[i].setRankNumber(rank);
                ++i;
            }
        }
    }

    private void assignRanks(StandingsRecord[] standings) {
        int rank = 1;
        standings[0].setRankNumber(rank);
        if (standings.length > 1) {
            int i = 1;
            while (i < standings.length) {
                if (!this.isTied(standings[i], standings[i - 1])) {
                    ++rank;
                }
                standings[i].setRankNumber(rank);
                ++i;
            }
        }
    }

    private void assignGroupRanks(IInternalContest contest, StandingsRecord[] standings) {
        Group[] groups = contest.getGroups();
        if (groups == null || groups.length == 0) {
            return;
        }
        Group[] groupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            int groupRank = 0;
            int lastRank = 0;
            int groupId = group.getGroupId();
            StandingsRecord[] standingsRecordArray = standings;
            int n3 = standings.length;
            int n4 = 0;
            while (n4 < n3) {
                int teamGroupId;
                Group teamGroup;
                ElementId groupElementId;
                StandingsRecord standingsRecord = standingsRecordArray[n4];
                Account account = contest.getAccount(standingsRecord.getClientId());
                if (account != null && (groupElementId = account.getGroupId()) != null && (teamGroup = contest.getGroup(groupElementId)) != null && groupId == (teamGroupId = teamGroup.getGroupId())) {
                    if (lastRank != standingsRecord.getRankNumber()) {
                        lastRank = standingsRecord.getRankNumber();
                        ++groupRank;
                    }
                    standingsRecord.setGroupRankNumber(groupRank);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private GrandTotals addProblemSummaryMememento(IMemento summaryMememento, StandingsRecord[] standings, IInternalContest contest, Problem[] problems) {
        GrandTotals grandTotals = new GrandTotals();
        long[] fastestSolved = new long[problems.length];
        long[] lastSolutionTime = new long[problems.length];
        int[] numberSolved = new int[problems.length];
        int[] numberAttempts = new int[problems.length];
        StandingsRecord[] standingsRecordArray = standings;
        int n = standings.length;
        int n2 = 0;
        while (n2 < n) {
            StandingsRecord standingsRecord = standingsRecordArray[n2];
            SummaryRow summaryRow = standingsRecord.getSummaryRow();
            int i = 0;
            while (i < problems.length) {
                ProblemSummaryInfo problemSummaryInfo = summaryRow.get(i + 1);
                if (problemSummaryInfo != null) {
                    long solveTime = problemSummaryInfo.getSolutionTime();
                    if (fastestSolved[i] == 0L || solveTime < fastestSolved[i]) {
                        fastestSolved[i] = solveTime;
                    }
                    if (solveTime > lastSolutionTime[i]) {
                        lastSolutionTime[i] = solveTime;
                    }
                    if (problemSummaryInfo.isSolved()) {
                        int n3 = i;
                        numberSolved[n3] = numberSolved[n3] + 1;
                    }
                    int n4 = i;
                    numberAttempts[n4] = numberAttempts[n4] + problemSummaryInfo.getNumberSubmitted();
                }
                ++i;
            }
            ++n2;
        }
        int i = 0;
        while (i < problems.length) {
            int id = i + 1;
            IMemento problemMemento = summaryMememento.createChild("problem");
            problemMemento.putInteger("id", id);
            problemMemento.putString("title", problems[i].getDisplayName());
            problemMemento.putLong("attempts", numberAttempts[i]);
            grandTotals.incrementTotalAttempts(numberAttempts[i]);
            problemMemento.putLong("numberSolved", numberSolved[i]);
            grandTotals.incrementTotalSolutions(numberSolved[i]);
            if (numberSolved[i] > 0) {
                problemMemento.putLong("bestSolutionTime", fastestSolved[i]);
                problemMemento.putLong("lastSolutionTime", lastSolutionTime[i]);
            }
            ++i;
        }
        return grandTotals;
    }

    private IMemento addTeamMemento(IMemento mementoRoot, IInternalContest contest, StandingsRecord standingsRecord, int indexNumber) {
        IMemento standingsRecordMemento = mementoRoot.createChild("teamStanding");
        standingsRecordMemento.putLong("firstSolved", standingsRecord.getFirstSolved());
        standingsRecordMemento.putLong("lastSolved", standingsRecord.getLastSolved());
        standingsRecordMemento.putLong("points", standingsRecord.getPenaltyPoints());
        standingsRecordMemento.putInteger("solved", standingsRecord.getNumberSolved());
        standingsRecordMemento.putInteger("rank", standingsRecord.getRankNumber());
        standingsRecordMemento.putInteger("index", indexNumber);
        Account account = contest.getAccount(standingsRecord.getClientId());
        standingsRecordMemento.putString("teamName", account.getDisplayName());
        standingsRecordMemento.putInteger("teamId", account.getClientId().getClientNumber());
        standingsRecordMemento.putInteger("teamSiteId", account.getClientId().getSiteNumber());
        standingsRecordMemento.putString("teamKey", account.getClientId().getTripletKey());
        standingsRecordMemento.putString("teamExternalId", account.getExternalId());
        if (account.getAliasName().trim().equals("")) {
            standingsRecordMemento.putString("teamAlias", String.valueOf(account.getDisplayName()) + " (not aliasesd)");
        } else {
            standingsRecordMemento.putString("teamAlias", account.getAliasName().trim());
        }
        ElementId elementId = account.getGroupId();
        if (elementId != null && contest.getGroup(elementId) != null) {
            Group group = contest.getGroup(elementId);
            standingsRecordMemento.putInteger("groupRank", standingsRecord.getGroupRankNumber());
            standingsRecordMemento.putString("teamGroupName", group.getDisplayName());
            standingsRecordMemento.putInteger("teamGroupExternalId", group.getGroupId());
        }
        Problem[] problems = contest.getProblems();
        int i = 0;
        while (i < problems.length) {
            ProblemSummaryInfo summaryInfo = standingsRecord.getSummaryRow().get(i + 1);
            this.addProblemSummaryRow(standingsRecordMemento, i + 1, summaryInfo);
            ++i;
        }
        return standingsRecordMemento;
    }

    private StandingsRecord[] computeStandingStandingsRecords(Run[] runs, Account[] accounts, Properties properties, Problem[] problems) {
        Arrays.sort(runs, new RunComparatorByTeam());
        if (runs.length == 0) {
            return this.generateStandingsRecords(accounts, problems);
        }
        StandingsRecord[] standingsRecords = new StandingsRecord[accounts.length];
        int standRecCount = 0;
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            StandingsRecord standingsRecord = new StandingsRecord();
            standingsRecord.setClientId(account.getClientId());
            int problemNumber = 1;
            Problem[] problemArray = problems;
            int n3 = problems.length;
            int n4 = 0;
            while (n4 < n3) {
                Problem problem = problemArray[n4];
                Run[] teamProblemRuns = this.getRuns(runs, account.getClientId(), problem);
                if (teamProblemRuns.length > 0) {
                    ProblemScoreRecord problemScoreRecord = this.createProblemScoreRecord(teamProblemRuns, problem, properties);
                    standingsRecord.setPenaltyPoints(standingsRecord.getPenaltyPoints() + problemScoreRecord.getPoints());
                    if (problemScoreRecord.getSolutionTime() > standingsRecord.getLastSolved()) {
                        standingsRecord.setLastSolved(problemScoreRecord.getSolutionTime());
                    }
                    if (standingsRecord.getFirstSolved() == -1L || standingsRecord.getFirstSolved() > problemScoreRecord.getSolutionTime()) {
                        standingsRecord.setFirstSolved(problemScoreRecord.getSolutionTime());
                    }
                    if (problemScoreRecord.isSolved()) {
                        standingsRecord.setNumberSolved(standingsRecord.getNumberSolved() + 1);
                    }
                    ProblemSummaryInfo summaryInfo = this.createProblemSummaryInfo(teamProblemRuns, problem, problemNumber, problemScoreRecord);
                    standingsRecord.getSummaryRow().put(problemNumber, summaryInfo);
                } else {
                    ProblemSummaryInfo summaryInfo = new ProblemSummaryInfo();
                    summaryInfo.setUnJudgedRuns(false);
                    summaryInfo.setSolved(false);
                    summaryInfo.setProblemId(problem.getElementId());
                    standingsRecord.getSummaryRow().put(problemNumber, summaryInfo);
                }
                ++problemNumber;
                ++n4;
            }
            standingsRecords[standRecCount] = standingsRecord;
            ++standRecCount;
            ++n2;
        }
        return standingsRecords;
    }

    private long getYesPenalty(Properties properties) {
        return this.getPropIntValue(properties, "Base Points per Yes", "0");
    }

    private int getPropIntValue(Properties inProperties, String key, String defaultValue) {
        String s = inProperties.getProperty(key, defaultValue);
        Integer i = Integer.parseInt(s);
        return i;
    }

    private int getNoPenalty(Properties properties) {
        return this.getPropIntValue(properties, "Points per No", "20");
    }

    private int getMinutePenalty(Properties properties) {
        return this.getPropIntValue(properties, "Points per Minute (for 1st yes)", "1");
    }

    @Override
    public ProblemScoreRecord createProblemScoreRecord(Run[] runs, Problem problem, Properties properties) {
        boolean solved = false;
        long points = 0L;
        long solutionTime = 0L;
        int numberSubmissions = 0;
        Run solvingRun = null;
        int submissionsBeforeYes = 0;
        int compilationErrorsBeforeYes = 0;
        int securityViolationBeforeYes = 0;
        int numberPending = 0;
        int numberJudged = 0;
        Arrays.sort(runs, new RunCompartorByElapsed());
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (!run.isDeleted()) {
                ++numberSubmissions;
                if (run.isJudged()) {
                    ++numberJudged;
                } else {
                    ++numberPending;
                }
                if (run.isSolved() && solutionTime == 0L) {
                    solved = true;
                    solutionTime = run.getElapsedMins();
                    solvingRun = run;
                }
                if (run.isJudged() && !solved) {
                    ElementId elementId = run.getJudgementRecord().getJudgementId();
                    Judgement judgment = this.getContest().getJudgement(elementId);
                    if ("CE".equals(judgment.getAcronym())) {
                        ++compilationErrorsBeforeYes;
                    } else if ("SV".equals(judgment.getAcronym())) {
                        ++securityViolationBeforeYes;
                    } else {
                        ++submissionsBeforeYes;
                    }
                }
            }
            ++n2;
        }
        if (solved) {
            points = solutionTime * (long)this.getMinutePenalty(properties) + this.getYesPenalty(properties) + (long)(submissionsBeforeYes * this.getNoPenalty(properties)) + (long)(compilationErrorsBeforeYes * this.getCEPenalty(properties)) + (long)(securityViolationBeforeYes * this.getSVPenalty(properties));
        }
        return new ProblemScoreRecord(solved, solvingRun, problem, points, solutionTime, numberSubmissions, submissionsBeforeYes, numberPending, numberJudged);
    }

    private int getCEPenalty(Properties properties) {
        return this.getPropIntValue(properties, "Points per Compilation Error", "0");
    }

    private int getSVPenalty(Properties properties) {
        return this.getPropIntValue(properties, "Points per Security Violation", "0");
    }

    private IMemento addProblemSummaryRow(IMemento mementoRoot, int index, ProblemSummaryInfo summaryInfo) {
        IMemento summaryInfoMemento = mementoRoot.createChild("problemSummaryInfo");
        summaryInfoMemento.putInteger("index", index);
        summaryInfoMemento.putString("problemId", summaryInfo.getProblemId().toString());
        summaryInfoMemento.putInteger("attempts", summaryInfo.getNumberSubmitted());
        summaryInfoMemento.putInteger("points", summaryInfo.getPenaltyPoints());
        summaryInfoMemento.putLong("solutionTime", summaryInfo.getSolutionTime());
        summaryInfoMemento.putBoolean("isSolved", summaryInfo.isSolved());
        summaryInfoMemento.putBoolean("isPending", summaryInfo.isUnJudgedRuns());
        return summaryInfoMemento;
    }

    private ProblemSummaryInfo createProblemSummaryInfo(Run[] runs, Problem problem, int problemNumber, ProblemScoreRecord problemScoreRecord) {
        ProblemSummaryInfo summaryInfo = new ProblemSummaryInfo();
        summaryInfo.setNumberSubmitted(problemScoreRecord.getNumberSubmissions());
        summaryInfo.setJudgedRunCount(problemScoreRecord.getNumberJudgedSubmissions());
        summaryInfo.setPendingRunCount(problemScoreRecord.getNumberPendingSubmissions());
        summaryInfo.setPenaltyPoints((int)problemScoreRecord.getPoints());
        summaryInfo.setSolutionTime(problemScoreRecord.getSolutionTime());
        summaryInfo.setUnJudgedRuns(false);
        summaryInfo.setSolved(problemScoreRecord.isSolved());
        summaryInfo.setProblemId(problem.getElementId());
        return summaryInfo;
    }

    public Run[] getRuns(Run[] runs, ClientId clientId, Problem problem) {
        Vector<Run> vector = new Vector<Run>();
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (clientId.equals(run.getSubmitter()) && run.getProblemId().equals(problem.getElementId())) {
                vector.add(run);
            }
            ++n2;
        }
        return vector.toArray(new Run[vector.size()]);
    }

    private StandingsRecord[] generateStandingsRecords(Account[] accounts, Problem[] problems) {
        Vector<StandingsRecord> vector = new Vector<StandingsRecord>();
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            StandingsRecord standingsRecord = new StandingsRecord();
            standingsRecord.setClientId(account.getClientId());
            standingsRecord.setSummaryRow(this.getBlankSummaryRow(problems));
            vector.add(standingsRecord);
            ++n2;
        }
        return vector.toArray(new StandingsRecord[vector.size()]);
    }

    private SummaryRow getBlankSummaryRow(Problem[] problems) {
        SummaryRow summaryRow = new SummaryRow();
        int problemNumber = 0;
        Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (problem.isActive()) {
                ProblemSummaryInfo problemSummaryInfo = new ProblemSummaryInfo();
                problemSummaryInfo.setProblemId(problem.getElementId());
                summaryRow.put(++problemNumber, problemSummaryInfo);
            }
            ++n2;
        }
        return summaryRow;
    }

    public boolean useBlockRanking() {
        return this.blockRanking;
    }

    public void setBlockRanking(boolean blockRanking) {
        this.blockRanking = blockRanking;
    }

    private void initializePermissions(IInternalContest contest, ClientId clientId) {
        Account account = contest.getAccount(clientId);
        if (account != null) {
            this.permissionList.clearAndLoadPermissions(account.getPermissionList());
        } else {
            this.permissionList.clearAndLoadPermissions(new PermissionGroup().getPermissionList(clientId.getClientType()));
        }
    }

    private boolean isAllowed(IInternalContest contest, ClientId clientId, Permission.Type type) {
        this.initializePermissions(contest, clientId);
        return this.permissionList.isAllowed(type);
    }

    private void addGrandTotals(IMemento summaryMememento, GrandTotals grandTotals) {
        summaryMememento.putInteger("totalAttempts", grandTotals.getTotalAttempts());
        summaryMememento.putInteger("totalSolved", grandTotals.getTotalSolutions());
        summaryMememento.putInteger("problemsAttempted", grandTotals.getTotalProblemAttempts());
    }

    private IMemento createSummaryMomento(ContestInformation contestInformation, XMLMemento mementoRoot) {
        IMemento memento = mementoRoot.createChild("standingsHeader");
        String title = contestInformation.getContestTitle();
        if (title == null || title.length() == 0) {
            title = "Contest";
        }
        memento.putString("title", title);
        VersionInfo versionInfo = new VersionInfo();
        memento.putString("systemName", versionInfo.getSystemName());
        memento.putString("systemVersion", String.valueOf(versionInfo.getVersionNumber()) + " build " + versionInfo.getBuildNumber());
        memento.putString("systemURL", versionInfo.getSystemURL());
        memento.putString("currentDate", new Date().toString());
        memento.putString("generatorId", "$Id$");
        return memento;
    }

    private void dumpGroupList(Group[] groups, IMemento memento) {
        memento.putInteger("groupCount", groups.length + 1);
        IMemento groupsMemento = memento.createChild("groupList");
        int id = 0;
        int i = 0;
        while (i < groups.length) {
            if (groups[i].isDisplayOnScoreboard()) {
                IMemento groupMemento = groupsMemento.createChild("group");
                groupMemento.putInteger("id", ++id);
                groupMemento.putString("title", groups[i].getDisplayName());
                groupMemento.putInteger("externalId", groups[i].getGroupId());
                if (groups[i].getSite() != null) {
                    groupMemento.putInteger("pc2Site", groups[i].getSite().getSiteNumber());
                }
            }
            ++i;
        }
    }

    @Override
    public String getPluginTitle() {
        return "Scoring Algorithm";
    }

    @Override
    public void dispose() {
    }

    private class GrandTotals {
        private int totalAttempts = 0;
        private int totalSolutions = 0;
        private int totalProblemAttempts = 0;

        private GrandTotals() {
        }

        public int getTotalAttempts() {
            return this.totalAttempts;
        }

        public void incrementTotalSolutions(int num) {
            this.totalSolutions += num;
        }

        public void incrementTotalAttempts(int num) {
            this.totalAttempts += num;
        }

        public int getTotalSolutions() {
            return this.totalSolutions;
        }

        public int getTotalProblemAttempts() {
            return this.totalProblemAttempts;
        }
    }
}

