/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import edu.csus.ecs.pc2.core.util.XSLTransformer;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.TransformerConfigurationException;

public class ScoreboardPlugin
implements UIPlugin {
    private static final long serialVersionUID = -5834251267967257702L;
    private String xslDir;
    private IInternalContest contest = null;
    private IInternalController controller = null;
    private Log log = null;

    public void writeHTML(String outputDir) throws IllegalContestState {
        DefaultScoringAlgorithm algorithm = new DefaultScoringAlgorithm();
        String standingsXML = algorithm.getStandings(this.contest, algorithm.getProperties(), this.log);
        this.writeHTML(standingsXML, this.log, outputDir);
    }

    public void writeHTML(String xmlString, Log aLog, String outputDir) {
        File inputDir = new File(this.xslDir);
        if (!inputDir.isDirectory()) {
            aLog.warning("xslDir is not a directory");
            return;
        }
        File outputDirFile = new File(outputDir);
        if (!outputDirFile.exists() && !outputDirFile.mkdirs()) {
            aLog.warning("Could not create " + outputDirFile.getAbsolutePath() + ", defaulting to current directory");
            outputDir = ".";
            outputDirFile = new File(outputDir);
        }
        if (!outputDirFile.isDirectory()) {
            aLog.warning(String.valueOf(outputDir) + " is not a directory.");
            return;
        }
        aLog.fine("Sending output to " + outputDirFile.getAbsolutePath());
        try {
            File output = File.createTempFile("__t", ".tmp", new File("."));
            FileOutputStream outputXML = new FileOutputStream(output);
            outputXML.write(xmlString.getBytes());
            outputXML.close();
            if (output.length() > 0L) {
                File outputFile = new File("results.xml");
                if (!output.renameTo(outputFile)) {
                    outputFile.delete();
                    if (!output.renameTo(outputFile)) {
                        aLog.warning("Could not create " + outputFile.getCanonicalPath());
                    }
                }
            } else {
                aLog.warning("New results.xml is empty, not updating");
                output.delete();
            }
            output = null;
        }
        catch (FileNotFoundException e1) {
            aLog.log(Log.WARNING, "Could not write to results.xml", e1);
        }
        catch (IOException e) {
            aLog.log(Log.WARNING, "Problem writing to results.xml", e);
        }
        String[] inputFiles = inputDir.list();
        XSLTransformer transformer = new XSLTransformer();
        int i = 0;
        while (i < inputFiles.length) {
            String xslFilename = inputFiles[i];
            if (xslFilename.endsWith(".xsl")) {
                String outputFilename = String.valueOf(xslFilename.substring(0, xslFilename.length() - 4)) + ".html";
                try {
                    File output = File.createTempFile("__t", ".htm", outputDirFile);
                    FileOutputStream outputStream = new FileOutputStream(output);
                    transformer.transform(String.valueOf(this.xslDir) + File.separator + xslFilename, new ByteArrayInputStream(xmlString.getBytes()), outputStream);
                    outputStream.close();
                    if (output.length() > 0L) {
                        File outputFile = new File(String.valueOf(outputDir) + File.separator + outputFilename);
                        if (xslFilename.equals("pc2export.xsl")) {
                            outputFile = new File("pc2export.dat");
                        }
                        if (xslFilename.endsWith(".json.xsl") || xslFilename.endsWith(".tsv.xsl") || xslFilename.endsWith(".csv.xsl") || xslFilename.endsWith(".php.xsl")) {
                            outputFile = new File(String.valueOf(outputDir) + File.separator + xslFilename.substring(0, xslFilename.length() - 4));
                        }
                        if (!output.renameTo(outputFile)) {
                            outputFile.delete();
                            if (!output.renameTo(outputFile)) {
                                aLog.warning("Could not create " + outputFile.getCanonicalPath());
                            } else {
                                aLog.finest("rename2 to " + outputFile.getCanonicalPath() + " succeeded.");
                            }
                        } else {
                            aLog.finest("rename to " + outputFile.getCanonicalPath() + " succeeded.");
                        }
                    } else {
                        aLog.warning("output from tranformation " + xslFilename + " was empty");
                        output.delete();
                    }
                    output = null;
                }
                catch (IOException e) {
                    aLog.log(Log.WARNING, "Trouble transforming " + xslFilename, e);
                }
                catch (TransformerConfigurationException e) {
                    aLog.log(Log.WARNING, "Trouble transforming " + xslFilename, e);
                }
                catch (Exception e) {
                    aLog.log(Log.WARNING, "Trouble transforming " + xslFilename, e);
                }
            }
            ++i;
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
        this.xslDir = "data" + File.separator + "xsl";
        File xslDirFile = new File(this.xslDir);
        if (!xslDirFile.canRead() || !xslDirFile.isDirectory()) {
            VersionInfo versionInfo = new VersionInfo();
            this.xslDir = String.valueOf(versionInfo.locateHome()) + File.separator + this.xslDir;
        }
    }

    @Override
    public String getPluginTitle() {
        return "Scorboard HTML Plugin";
    }
}

