/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class RunsReport5
implements IReport {
    private static final long serialVersionUID = -1573641523768053182L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    int problemNumber(ElementId id) {
        Problem[] problems = this.contest.getProblems();
        int i = 0;
        while (i < problems.length) {
            if (problems[i].getElementId().equals(id)) {
                return i;
            }
            ++i;
        }
        System.err.println("Searched " + problems.length + " problems did not find " + id);
        return 1;
    }

    private void writeRow(PrintWriter printWriter, Run run) {
        ClientId clientId = run.getSubmitter();
        printWriter.print(run.getNumber());
        printWriter.print(",");
        printWriter.print(clientId.getClientNumber());
        printWriter.print(",");
        char let = 'A';
        let = (char)(let + this.problemNumber(run.getProblemId()));
        printWriter.print(let);
        printWriter.print(",");
        printWriter.print(run.getElapsedMins());
        printWriter.print(",");
        if (run.isJudged()) {
            if (run.isSolved()) {
                printWriter.print("Yes");
            } else {
                printWriter.print("No");
            }
        } else {
            printWriter.print("New");
        }
        printWriter.println();
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        if (this.filter.isFilterOn()) {
            Run run;
            printWriter.println("Filter: " + this.filter.toString());
            int count = 0;
            Run[] runArray = runs;
            int n = runs.length;
            int n2 = 0;
            while (n2 < n) {
                run = runArray[n2];
                if (this.filter.matches(run)) {
                    ++count;
                }
                ++n2;
            }
            if (count == 0) {
                printWriter.println("-- No runs match of " + runs.length + " runs (filtered) --");
            } else {
                printWriter.println("-- " + count + " of " + runs.length + " runs (filtered) --");
                runArray = runs;
                n = runs.length;
                n2 = 0;
                while (n2 < n) {
                    run = runArray[n2];
                    if (this.filter.matches(run)) {
                        try {
                            this.writeRow(printWriter, run);
                        }
                        catch (Exception e) {
                            printWriter.println("Exception in report: " + e.getMessage());
                            e.printStackTrace(printWriter);
                        }
                    }
                    ++n2;
                }
            }
        } else {
            printWriter.println("-- " + runs.length + " runs --");
            Run[] runArray = runs;
            int n = runs.length;
            int n3 = 0;
            while (n3 < n) {
                Run run = runArray[n3];
                try {
                    this.writeRow(printWriter, run);
                }
                catch (Exception e) {
                    printWriter.println("Exception in report: " + e.getMessage());
                    e.printStackTrace(printWriter);
                }
                ++n3;
            }
        }
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Run 5 field";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Run 5 field Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

