/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunTestCase;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class RunsReport
implements IReport {
    private static final long serialVersionUID = 2758681678568110981L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    private void writeRowOld(PrintWriter printWriter, Run run) {
        ClientId clientId = run.getSubmitter();
        printWriter.print("run " + run.getNumber() + "|");
        printWriter.print("site " + run.getSiteNumber() + "|");
        printWriter.print("proxy |");
        printWriter.print("team " + clientId.getClientNumber() + "|");
        printWriter.print(String.valueOf(clientId.getName()) + ":" + this.getClientName(clientId) + "|");
        printWriter.print("prob " + run.getProblemId() + ":" + this.contest.getProblem(run.getProblemId()) + "|");
        printWriter.print("lang " + run.getLanguageId() + ":" + this.contest.getLanguage(run.getLanguageId()) + "|");
        printWriter.print("tocj |");
        printWriter.print("os " + run.getSystemOS() + "|");
        printWriter.print("sel " + run.getStatus().equals((Object)Run.RunStates.BEING_JUDGED) + "|");
        printWriter.print("tocj false|");
        printWriter.print("jc " + run.isJudged() + "|");
        printWriter.print(String.valueOf(run.getElapsedMins()) + "|");
        printWriter.print("rid " + run.getElementId() + "|");
        printWriter.print("mmfr " + run.isSolved() + "|");
        printWriter.print("del? " + run.isDeleted() + "|");
        String jciString = "";
        String jbyString = "";
        String jtString = "";
        if (run.isJudged()) {
            JudgementRecord judgementRecord = run.getJudgementRecord();
            jciString = judgementRecord.getJudgementId().toString();
            jbyString = judgementRecord.getJudgerClientId().getName();
            jtString = new Long(judgementRecord.getJudgedMinutes()).toString();
        }
        printWriter.print("jt " + jtString + "|");
        printWriter.print("jby " + jbyString + "|");
        printWriter.print("jci " + jciString + "|");
        printWriter.print("pbseq " + run.getPlaybackSequenceNumber() + "|");
        printWriter.print("jci " + new String(run.getPlaybackId()) + "|");
        printWriter.println();
    }

    private void writeRow(PrintWriter printWriter, Run run) {
        ClientId clientId = run.getSubmitter();
        printWriter.print("run " + run.getNumber() + " ");
        if (run.isDeleted()) {
            printWriter.print("DELETED ");
        }
        printWriter.print((Object)((Object)run.getStatus()) + " ");
        printWriter.print("s" + run.getSiteNumber() + " ");
        printWriter.print("at " + run.getElapsedMins() + " (" + run.getCreateDate() + ") ");
        printWriter.print(String.valueOf(clientId.getName()) + " (" + this.getClientName(clientId) + ") ");
        printWriter.print(this.contest.getProblem(run.getProblemId()) + " ");
        printWriter.print(this.contest.getLanguage(run.getLanguageId()) + " ");
        if (run.isDeleted()) {
            printWriter.print(" DELETED ");
        }
        printWriter.println();
        ClientId whoCheckedOutId = this.contest.getRunCheckedOutBy(run);
        if (whoCheckedOutId != null) {
            printWriter.println("    Checked out by: " + whoCheckedOutId);
        }
        if (run.isSendToTeams()) {
            printWriter.println("    Judgement was sent to team.");
        } else {
            printWriter.println("    Judgement was _not_ sent to team.");
        }
        try {
            if (!this.contest.isRunFilesPresent(run)) {
                printWriter.println("    No submitted files found.");
            } else {
                RunFiles runFiles = this.contest.getRunFiles(run);
                SerializedFile mainFile = runFiles.getMainFile();
                int bytes = 0;
                if (mainFile.getBuffer() != null) {
                    bytes = mainFile.getBuffer().length;
                }
                printWriter.println("      main file '" + mainFile.getName() + "' " + bytes + " bytes");
                if (runFiles.getOtherFiles() == null) {
                    printWriter.println("                no additional submitted files");
                } else {
                    printWriter.println("                " + runFiles.getOtherFiles().length + " additional submitted files");
                    if (runFiles.getOtherFiles().length > 0) {
                        SerializedFile[] serializedFileArray = runFiles.getOtherFiles();
                        int n = serializedFileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SerializedFile serializedFile = serializedFileArray[n2];
                            bytes = 0;
                            if (serializedFile.getBuffer() != null) {
                                bytes = serializedFile.getBuffer().length;
                            }
                            printWriter.println("                '" + serializedFile.getName() + "' " + bytes + " bytes");
                            ++n2;
                        }
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            printWriter.println("    No submitted files found (not on server?).");
        }
        catch (Exception ex) {
            if (ex.getMessage().startsWith("Unable to read object from file")) {
                if (run.getSiteNumber() == this.contest.getSiteNumber()) {
                    printWriter.println("    Error - no submitted files found for this run.");
                } else {
                    printWriter.println("    No submitted files found (Run from site " + run.getSiteNumber() + ")");
                }
            }
            ex.printStackTrace(printWriter);
        }
        if (run.getAllJudgementRecords().length > 0) {
            JudgementRecord[] judgementRecordArray = run.getAllJudgementRecords();
            int n = judgementRecordArray.length;
            int n3 = 0;
            while (n3 < n) {
                JudgementRecord judgementRecord = judgementRecordArray[n3];
                if (this.contest == null) {
                    printWriter.println("Contest is null");
                }
                if (judgementRecord.getJudgementId() == null) {
                    printWriter.println("Judgement is null for " + run);
                }
                ElementId elmentId = judgementRecord.getJudgementId();
                String judgementText = this.contest.getJudgement(elmentId).toString();
                String validatorJudgementName = judgementRecord.getValidatorResultString();
                if (judgementRecord.isUsedValidator() && validatorJudgementName != null) {
                    if (validatorJudgementName.trim().length() == 0) {
                        validatorJudgementName = "undetermined";
                    }
                    judgementText = validatorJudgementName;
                }
                printWriter.print("     ");
                printWriter.print(" '" + judgementText + "'");
                printWriter.print(" by " + judgementRecord.getJudgerClientId().getName() + "/s" + judgementRecord.getJudgerClientId().getSiteNumber());
                if (judgementRecord.isComputerJudgement()) {
                    printWriter.print("/Computer");
                } else if (judgementRecord.isUsedValidator()) {
                    printWriter.print("/Validator");
                }
                printWriter.print(" at " + judgementRecord.getWhenJudgedTime());
                if (this.isPreliminaryJudgement(run, judgementRecord)) {
                    printWriter.print(" (preliminary)");
                }
                printWriter.println();
                ++n3;
            }
        }
        this.writeTestCases(printWriter, "     ", this.contest, run);
        printWriter.println();
    }

    private void writeTestCases(PrintWriter printWriter, String pad, IInternalContest internalContest, Run run) {
        RunTestCase[] testcases = run.getRunTestCases();
        printWriter.println(String.valueOf(pad) + "There are " + testcases.length + " test cases.");
        RunTestCase[] runTestCaseArray = testcases;
        int n = testcases.length;
        int n2 = 0;
        while (n2 < n) {
            Judgement j;
            RunTestCase runTestCase = runTestCaseArray[n2];
            String judgement = "Undetermined";
            if (runTestCase.getJudgementId() != null && (j = internalContest.getJudgement(runTestCase.getJudgementId())) != null) {
                judgement = "[" + j.getAcronym() + "] " + j.getDisplayName();
            }
            printWriter.println(String.valueOf(pad) + "Test " + runTestCase.getTestNumber() + " passes " + runTestCase.isPassed() + " at " + runTestCase.getDate() + " judgement " + judgement);
            ++n2;
        }
    }

    private boolean isPreliminaryJudgement(Run run, JudgementRecord record) {
        JudgementRecord[] records;
        Problem problem = this.contest.getProblem(run.getProblemId());
        if (problem.isManualReview() && problem.isComputerJudged() && (records = run.getAllJudgementRecords()) != null) {
            return records[0].getElementId().equals(record.getElementId());
        }
        return false;
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        if (this.filter.isFilterOn()) {
            printWriter.println("Filter: " + this.filter.toString());
            printWriter.println();
            int count = this.filter.countRuns(runs);
            if (count == 0) {
                printWriter.println("-- No runs match of " + runs.length + " runs (filtered) --");
            } else {
                printWriter.println("-- " + count + " of " + runs.length + " runs (filtered) --");
                Run[] runArray = runs;
                int n = runs.length;
                int n2 = 0;
                while (n2 < n) {
                    Run run = runArray[n2];
                    if (this.filter.matches(run)) {
                        try {
                            this.writeRow(printWriter, run);
                        }
                        catch (Exception e) {
                            printWriter.println("Exception in report: " + e.getMessage());
                            e.printStackTrace(printWriter);
                        }
                    }
                    ++n2;
                }
            }
        } else {
            printWriter.println("-- " + runs.length + " runs --");
            Run[] runArray = runs;
            int n = runs.length;
            int n3 = 0;
            while (n3 < n) {
                Run run = runArray[n3];
                try {
                    this.writeRow(printWriter, run);
                }
                catch (Exception e) {
                    printWriter.println("Exception in report: " + e.getMessage());
                    e.printStackTrace(printWriter);
                }
                ++n3;
            }
        }
    }

    private String getClientName(ClientId clientId) {
        Account account = this.contest.getAccount(clientId);
        if (account != null) {
            return account.getDisplayName();
        }
        return clientId.getName();
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Runs";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Runs Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

