/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.NotificationXML;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Hashtable;

public class NotificationsReport
implements IReport {
    private static final long serialVersionUID = -2555946890129189222L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();
    private Hashtable<String, Run> solvedHash = new Hashtable();

    @Override
    public void writeReport(PrintWriter printWriter) throws IOException {
        printWriter.println(this.createReportXML(this.filter));
        printWriter.println();
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        this.filter = inFilter;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public String[] createReport(Filter inFilter) {
        this.filter = inFilter;
        return new String[0];
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        if (this.contest != null) {
            return this.toXML(this.filter);
        }
        return Reports.notImplementedXML(this, "contest is null");
    }

    public String toXML(Filter inFilter) throws IOException {
        NotificationXML notificationXML = new NotificationXML();
        BalloonSettings balloonSettings = this.contest.getBalloonSettings(this.contest.getSiteNumber());
        if (balloonSettings == null) {
            return "<notifications><!-- No Notifications --></notifications>";
        }
        String xml = "<list>\n";
        ClientSettings settings = new ClientSettings(balloonSettings.getBalloonClient());
        Hashtable<String, BalloonDeliveryInfo> deliveryHash = settings.getBalloonList();
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (run.isSolved()) {
                String key = notificationXML.getBalloonKey(run.getSubmitter(), run.getProblemId());
                BalloonDeliveryInfo deliveryInfo = deliveryHash.get(key);
                if (deliveryInfo != null && !this.isAlreadySolved(run)) {
                    try {
                        XMLMemento xmlMemento = notificationXML.createElement(this.contest, run);
                        xml = String.valueOf(xml) + xmlMemento.saveToString();
                    }
                    catch (Exception e) {
                        throw (IOException)e;
                    }
                } else {
                    System.err.println("No delivery info for run " + run);
                }
            }
            ++n2;
        }
        return String.valueOf(xml) + "\n</list>\n";
    }

    private boolean isAlreadySolved(Run run) {
        String key = String.valueOf(run.getSubmitter().getTripletKey()) + ":" + run.getProblemId();
        if (this.solvedHash.get(key) != null) {
            return true;
        }
        this.solvedHash.put(key, run);
        return false;
    }

    @Override
    public String getReportTitle() {
        return "Notifications XML";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Notifications XML Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

