/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class JudgingAnalysisReport
implements IReport {
    private static final long serialVersionUID = 8827529273455158045L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    @Override
    public void writeReport(PrintWriter printWriter) throws IOException {
        printWriter.println("Contest Title: " + this.contest.getContestInformation().getContestTitle());
        printWriter.println();
        printWriter.println(String.valueOf(this.contest.getSites().length) + " sites.");
        printWriter.println();
        Run[] runs = this.filter.getRuns(this.contest.getRuns());
        int count = runs.length;
        if (this.filter.isFilterOn()) {
            printWriter.println("   " + count + " runs.");
        } else {
            printWriter.println("   " + count + " filtered runs runs.");
            printWriter.println("     " + this.filter);
        }
        if (count == 0) {
            return;
        }
        HashMap<ClientId, Integer> judgedRunsMap = new HashMap<ClientId, Integer>();
        HashMap<ClientId, Boolean> autoJudgeMap = new HashMap<ClientId, Boolean>();
        int unjudgedRuns = 0;
        int judgedRuns = 0;
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (!run.isDeleted()) {
                if (run.isJudged()) {
                    JudgementRecord[] records;
                    JudgementRecord[] judgementRecordArray = records = run.getAllJudgementRecords();
                    int n3 = records.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        JudgementRecord judgementRecord = judgementRecordArray[n4];
                        ClientId clientId = judgementRecord.getJudgerClientId();
                        boolean isAJ = judgementRecord.isComputerJudgement();
                        int newValue = this.incrementValue((Integer)judgedRunsMap.get(clientId));
                        judgedRunsMap.put(clientId, newValue);
                        autoJudgeMap.put(clientId, isAJ);
                        ++n4;
                    }
                    ++judgedRuns;
                } else {
                    ++unjudgedRuns;
                }
            }
            ++n2;
        }
        printWriter.println();
        printWriter.println("      Judged runs: " + judgedRuns);
        printWriter.println("    Unjudged runs: " + unjudgedRuns);
        printWriter.println();
        Vector<Account> vector = this.contest.getAccounts(ClientType.Type.JUDGE);
        Account[] accounts = vector.toArray(new Account[vector.size()]);
        Arrays.sort(accounts, new AccountComparator());
        printWriter.println("       JUDGE   RUNS");
        Account[] accountArray = accounts;
        int n5 = accounts.length;
        int n6 = 0;
        while (n6 < n5) {
            Boolean autoJudge;
            Account account = accountArray[n6];
            ClientId clientId = account.getClientId();
            Integer runCount = (Integer)judgedRunsMap.get(clientId);
            if (runCount == null) {
                runCount = 0;
            }
            if ((autoJudge = (Boolean)autoJudgeMap.get(clientId)) == null) {
                autoJudge = false;
            }
            String ajSTring = "  ";
            if (autoJudge.booleanValue()) {
                ajSTring = "AJ";
            }
            String runString = "   ";
            if (runCount > 0) {
                runString = runCount.toString();
            }
            printWriter.format("   %3s %-8s %3s ", ajSTring, String.valueOf(clientId.getClientType().toString()) + " " + clientId.getClientNumber(), runString);
            printWriter.println();
            ++n6;
        }
    }

    private int incrementValue(Integer integer) {
        if (integer == null) {
            return 1;
        }
        return integer + 1;
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public String[] createReport(Filter arg0) {
        return null;
    }

    @Override
    public String createReportXML(Filter arg0) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Judging Analysis";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Judging Analysis Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

