/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReportFile;
import edu.csus.ecs.pc2.core.report.Reports;
import edu.csus.ecs.pc2.exports.ccs.StandingsJSON;
import edu.csus.ecs.pc2.exports.ccs.StandingsJSON2016;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class JSON2016Report
implements IReportFile {
    private static final long serialVersionUID = -6734389749065865458L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter theFilter = null;

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.controller = inController;
        this.contest = inContest;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "JSON 2016 Scoreboard";
    }

    @Override
    public void createReportFile(String filename, Filter filter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.theFilter = filter;
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
                System.out.println();
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter filter) {
        this.theFilter = filter;
        StandingsJSON2016 standings = new StandingsJSON2016();
        try {
            String[] list;
            String result = standings.createJSON(this.contest, this.controller);
            String[] stringArray = list = new String[]{result};
            return stringArray;
        }
        catch (IllegalContestState e) {
            this.log.log(Log.WARNING, e.getMessage(), e.getCause());
        }
        finally {
            standings = null;
        }
        return new String[0];
    }

    @Override
    public String createReportXML(Filter filter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public void writeReport(PrintWriter printWriter) throws Exception {
        StandingsJSON standingsJSON = new StandingsJSON();
        printWriter.print(standingsJSON.createJSON(this.contest));
        standingsJSON = null;
    }

    @Override
    public String getReportTitle() {
        return "JSON 2016 Scoreboard";
    }

    @Override
    public Filter getFilter() {
        return this.theFilter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.theFilter = filter;
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public boolean suppressHeaderFooter() {
        return true;
    }
}

