/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReportFile;
import edu.csus.ecs.pc2.core.report.Reports;
import edu.csus.ecs.pc2.exports.ccs.Groupdata;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class GroupsTSVReport
implements IReportFile {
    private static final long serialVersionUID = -4272718210060832158L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter;

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "groups.tsv";
    }

    @Override
    public void createReportFile(String filename, Filter aFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                this.printHeader(printWriter);
                this.writeReport(printWriter);
                this.printFooter(printWriter);
                printWriter.close();
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
        }
    }

    @Override
    public String[] createReport(Filter aFilter) {
        Groupdata groupData = new Groupdata();
        String[] lines = groupData.getGroupData(this.contest);
        return lines;
    }

    @Override
    public String createReportXML(Filter aFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public void writeReport(PrintWriter printWriter) throws Exception {
        String[] lines;
        Groupdata groupData = new Groupdata();
        String[] stringArray = lines = groupData.getGroupData(this.contest);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            printWriter.println(string);
            ++n2;
        }
    }

    @Override
    public String getReportTitle() {
        return "groups.tsv";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
    }

    @Override
    public boolean suppressHeaderFooter() {
        return true;
    }
}

