/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.model.playback.ReplayEvent;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

public class ExtractPlaybackLoadFilesReport
implements IReport {
    private static final long serialVersionUID = 977130815676827828L;
    private static final String DELIMITER = "|";
    private IInternalContest contest;
    private IInternalController controller;
    private String extractDirectory;
    private String reportFilename;
    private Log log;
    private Filter filter;
    private String reportDirectory = "reports";
    private String universalFileSeparator = "/";

    private void writeRow(PrintWriter printWriter, Run run) throws Exception {
        JudgementRecord[] records;
        RunFiles runFiles = this.contest.getRunFiles(run);
        SerializedFile mainfile = runFiles.getMainFile();
        String mainFileName = mainfile.getName();
        String targetDirectory = String.valueOf(this.extractDirectory) + this.universalFileSeparator + "site" + run.getSiteNumber() + "run" + run.getNumber();
        if (!new File(targetDirectory).isDirectory()) {
            new File(targetDirectory).mkdirs();
        }
        String outputFileName = String.valueOf(targetDirectory) + this.universalFileSeparator + mainFileName;
        mainfile.writeFile(outputFileName);
        outputFileName = String.valueOf(this.removeUpTo(targetDirectory, File.separator).substring(1)) + this.universalFileSeparator + mainFileName;
        this.writeValues(printWriter, "action", ReplayEvent.EventType.RUN_SUBMIT.toString());
        this.writeValues(printWriter, "id", run.getNumber());
        this.writeValues(printWriter, "elapsed", run.getElapsedMins());
        this.writeValues(printWriter, "language", this.contest.getLanguage(run.getLanguageId()).getDisplayName());
        this.writeValues(printWriter, "problem", this.contest.getProblem(run.getProblemId()).getDisplayName());
        this.writeValues(printWriter, "site", run.getSiteNumber());
        this.writeValues(printWriter, "submitclient", run.getSubmitter().getName());
        this.writeValues(printWriter, "mainfile", outputFileName);
        printWriter.println();
        JudgementRecord[] judgementRecordArray = records = run.getAllJudgementRecords();
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            JudgementRecord judgementRecord = judgementRecordArray[n2];
            this.writeJudgementRecord(printWriter, run, judgementRecord);
            ++n2;
        }
    }

    private void writeJudgementRecord(PrintWriter printWriter, Run run, JudgementRecord judgementRecord) {
        this.writeValues(printWriter, "action", ReplayEvent.EventType.RUN_JUDGEMENT.toString());
        this.writeValues(printWriter, "id", run.getNumber());
        this.writeValues(printWriter, "site", run.getSiteNumber());
        this.writeValues(printWriter, "solved", judgementRecord.isSolved());
        this.writeValues(printWriter, "preliminary", judgementRecord.isPreliminaryJudgement());
        this.writeValues(printWriter, "judgeclient", judgementRecord.getJudgerClientId().getName());
        this.writeValues(printWriter, "judgeclientsite", judgementRecord.getJudgerClientId().getSiteNumber());
        this.writeValues(printWriter, "judged_elapsed_time", judgementRecord.getWhenJudgedTime());
        this.writeValues(printWriter, "computer_judged", judgementRecord.isComputerJudgement());
        this.writeValues(printWriter, "judgement", this.contest.getJudgement(judgementRecord.getJudgementId()).getDisplayName());
        this.writeValues(printWriter, "senttoteams", judgementRecord.isSendToTeam());
        printWriter.println();
    }

    private void writeValues(PrintWriter printWriter, String key, long number) {
        printWriter.print(String.valueOf(key) + "=" + number + DELIMITER + " ");
    }

    private void writeValues(PrintWriter printWriter, String key, String value) {
        printWriter.print(String.valueOf(key) + "=" + value + DELIMITER + " ");
    }

    private void writeValues(PrintWriter printWriter, String key, boolean value) {
        printWriter.print(String.valueOf(key) + "=" + value + DELIMITER + " ");
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        if (this.reportFilename == null) {
            throw new IllegalArgumentException("reportFilename is null");
        }
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        printWriter.println("# ------------------------------------------------------------");
        printWriter.println();
        printWriter.println("# " + this.getReportTitle());
        printWriter.println("# Created on " + new Date());
        printWriter.println("# Created by: " + new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        Vector<String> failedRunExtract = new Vector<String>();
        this.extractDirectory = String.valueOf(this.removeUpTo(this.reportFilename, String.valueOf(this.reportDirectory) + File.separator)) + ".files";
        int nonExtractedRuns = 0;
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            try {
                this.writeRow(printWriter, run);
            }
            catch (Exception e) {
                failedRunExtract.add("Failed run: " + run);
                ++nonExtractedRuns;
                printWriter.println("# error extracting run " + run + " " + e.getMessage());
            }
            ++n2;
        }
        String[] list = failedRunExtract.toArray(new String[failedRunExtract.size()]);
        printWriter.println();
        if (nonExtractedRuns > 0) {
            printWriter.println("# " + nonExtractedRuns + " extracting runs NOT extracted");
            String[] stringArray = list;
            int n3 = list.length;
            n = 0;
            while (n < n3) {
                String s = stringArray[n];
                printWriter.println("# " + s);
                ++n;
            }
        } else {
            printWriter.println("# All " + list.length + " runs extracted");
        }
        printWriter.println();
        printWriter.println("# EOF " + this.getReportTitle());
        printWriter.println("# ------------------------------------------------------------");
    }

    protected String removeUpTo(String source, String targetString) {
        int index = source.indexOf(targetString);
        if (index > 0) {
            String debug2 = source.substring(index);
            return debug2;
        }
        return source;
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println("# " + this.getReportTitle() + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("# end ");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        this.reportFilename = filename;
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.reportFilename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Extract Replay Runs";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Extract Replay Runs";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setReportFilename(String reportFilename) {
        this.reportFilename = reportFilename;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }
}

