/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.export.ExportYAML;
import edu.csus.ecs.pc2.core.list.FileComparator;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.report.GroupsTSVReport;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import edu.csus.ecs.pc2.core.report.ScoreboardPlugin;
import edu.csus.ecs.pc2.core.report.ScoreboardTSVReport;
import edu.csus.ecs.pc2.core.report.TeamsTSVReport;
import edu.csus.ecs.pc2.core.report.UserdataTSVReport;
import edu.csus.ecs.pc2.exports.ccs.ResolverEventFeedXML;
import edu.csus.ecs.pc2.exports.ccs.ResultsFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CDPReport
implements IReport {
    private static final long serialVersionUID = 3516176895449881260L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();
    private String directoryName = null;
    private String outputfilename;
    private static final String PAD4 = "    ";
    private static final String PAD2 = "  ";
    public static final String FORMAT_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss z";
    private static final String PROBLEM_SET_KEY = "problemset";
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    private void writeContestTime(PrintWriter printWriter) {
        printWriter.println();
        GregorianCalendar resumeTime = this.contest.getContestTime().getResumeTime();
        if (resumeTime == null) {
            printWriter.println("Contest date/time: never started");
        } else {
            printWriter.println("Contest date/time: " + resumeTime.getTime());
        }
    }

    private String createProblemShortName(String name) {
        String newName = name.trim().split(" ")[0].trim().toLowerCase();
        return newName;
    }

    private String getProblemBalloonColor(IInternalContest aContest, Problem problem) {
        BalloonSettings balloonSettings = aContest.getBalloonSettings(aContest.getSiteNumber());
        String name = null;
        if (balloonSettings != null) {
            name = balloonSettings.getColor(problem);
        }
        return name;
    }

    private String quote(String string) {
        return "'" + string + "'";
    }

    protected static StringBuffer join(String delimiter, List<String> list) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < list.size() - 1) {
            buffer.append(list.get(i));
            buffer.append(delimiter);
            ++i;
        }
        if (list.size() > 0) {
            buffer.append(list.get(list.size() - 1));
        }
        return buffer;
    }

    protected String getProblemLetter(int id) {
        char let = 'A';
        let = (char)(let + (id - 1));
        return Character.toString(let);
    }

    public String getDateTimeString() {
        return this.formatter.format(new Date());
    }

    public void writeProblemYaml(PrintWriter printWriter) {
        this.writeProblemYaml(printWriter, true);
    }

    public void writeProblemYaml(PrintWriter printWriter, boolean useLatestProblemKey) {
        Problem[] problems;
        int id = 1;
        printWriter.println("# Problem Set Configuration, version 1.0 ");
        printWriter.println("# PC^2 Version: " + new VersionInfo().getSystemVersionInfo());
        printWriter.println("# Created: " + this.getDateTimeString());
        printWriter.println("--- ");
        printWriter.println();
        String problemKey = PROBLEM_SET_KEY;
        if (useLatestProblemKey) {
            problemKey = PROBLEM_SET_KEY;
        }
        printWriter.println(String.valueOf(problemKey) + ":");
        Problem[] problemArray = problems = this.contest.getProblems();
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            String name = problem.getDisplayName();
            String letter = this.getProblemLetter(id);
            if (problem.getLetter() != null) {
                letter = problem.getLetter();
            }
            printWriter.println("  - letter: " + letter);
            String shortName = this.createProblemShortName(name);
            if (problem.getShortName() != null && problem.getShortName().trim().length() > 0) {
                shortName = problem.getShortName();
            }
            printWriter.println("    short-name: " + shortName);
            printWriter.println("    name: " + this.quote(name));
            String colorName = this.getProblemBalloonColor(this.contest, problem);
            if (colorName != null) {
                printWriter.println("    color: " + colorName);
            }
            ++id;
            printWriter.println();
            ++n2;
        }
    }

    public void writeLinesToFile(String filename, String[] lines) throws FileNotFoundException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            printWriter.println(line);
            ++n2;
        }
        printWriter.close();
    }

    @Override
    public void writeReport(PrintWriter printWriter) throws Exception {
        ExportYAML exportYAML = new ExportYAML();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.ss.SSS");
        if (this.directoryName == null) {
            this.directoryName = "reports" + File.separator + "yaml" + simpleDateFormat.format(new Date());
        }
        printWriter.println();
        printWriter.println("Writing CDP files to " + this.directoryName);
        if (!new File(this.directoryName).isDirectory()) {
            new File(this.directoryName).mkdirs();
        }
        if (this.outputfilename == null) {
            this.outputfilename = String.valueOf(this.directoryName) + File.separator + "contest.yaml";
        }
        String userDataFilename = String.valueOf(this.directoryName) + File.separator + "userdata.tsv";
        try {
            this.writeUserDataFile(userDataFilename);
        }
        catch (Exception e) {
            printWriter.println("Error creating " + userDataFilename);
            e.printStackTrace(printWriter);
        }
        String resultsdir = String.valueOf(this.directoryName) + File.separator + "results";
        this.ensureDirectory(resultsdir);
        String resultsTSVFilename = String.valueOf(this.directoryName) + File.separator + "results.tsv";
        try {
            this.writeResults(resultsTSVFilename);
        }
        catch (Exception e) {
            printWriter.println("Error creating " + resultsTSVFilename);
            e.printStackTrace(printWriter);
        }
        String scorboardTSVFilename = String.valueOf(this.directoryName) + File.separator + "scoreboard.tsv";
        try {
            this.writeScoreboardTSV(scorboardTSVFilename);
        }
        catch (Exception e) {
            printWriter.println("Error creating " + scorboardTSVFilename);
            e.printStackTrace(printWriter);
        }
        try {
            this.writeScoeboardHTML(resultsdir);
        }
        catch (Exception e) {
            printWriter.println("Error creating HTML in " + resultsdir);
            e.printStackTrace(printWriter);
        }
        String groupsFilename = String.valueOf(this.directoryName) + File.separator + "groups.tsv";
        try {
            this.writeGroupsTSV(groupsFilename);
        }
        catch (Exception e) {
            printWriter.println("Exception writing " + groupsFilename);
            e.printStackTrace(printWriter);
        }
        String teamsFilename = String.valueOf(this.directoryName) + File.separator + "teams.tsv";
        try {
            this.writeteamsTSV(teamsFilename);
        }
        catch (Exception e) {
            printWriter.println("Exception writing " + teamsFilename);
            e.printStackTrace(printWriter);
        }
        try {
            exportYAML.writeContestYAMLFiles(this.contest, this.directoryName, this.outputfilename);
        }
        catch (Exception e) {
            printWriter.println("Exception writing yaml files " + e.getMessage());
            e.printStackTrace(printWriter);
        }
        String problemSetYamlFilename = String.valueOf(this.directoryName) + File.separator + "problemset.yaml";
        try {
            this.writeProblemYaml(problemSetYamlFilename);
        }
        catch (Exception e) {
            printWriter.println("Exception writing yaml files " + e.getMessage());
            e.printStackTrace(printWriter);
        }
        try {
            this.writeSubmissions(printWriter, this.directoryName);
        }
        catch (Exception e) {
            printWriter.println("Exception writing runs or run files " + e.getMessage());
            e.printStackTrace(printWriter);
        }
        String eventFeedDirectory = String.valueOf(this.directoryName) + File.separator + "eventFeed";
        this.ensureDirectory(eventFeedDirectory);
        String eventFeedfilename = String.valueOf(eventFeedDirectory) + File.separator + "events.xml";
        try {
            ResolverEventFeedXML resolverEventFeedXML = new ResolverEventFeedXML();
            resolverEventFeedXML.setLog(this.controller.getLog());
            String efxml = resolverEventFeedXML.toXML(this.contest);
            String[] lines = new String[]{efxml};
            this.writeLinesToFile(eventFeedfilename, lines);
        }
        catch (Exception e) {
            printWriter.println("Exception writing " + teamsFilename);
            e.printStackTrace(printWriter);
        }
        this.listFiles(printWriter, "  file ", this.directoryName);
        printWriter.println();
        printWriter.println("contest.yaml contents");
        printWriter.println();
        Utilities.catFile(printWriter, this.outputfilename);
        printWriter.println();
        printWriter.println();
        printWriter.println("problemset.yaml contents");
        printWriter.println();
        Utilities.catFile(printWriter, problemSetYamlFilename);
        printWriter.println();
    }

    public void writeProblemYaml(String filename) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(new FileOutputStream(filename, false), true);
        this.writeProblemYaml(writer);
        writer.close();
    }

    private void writeteamsTSV(String filename) throws Exception {
        TeamsTSVReport teamsTSVReport = new TeamsTSVReport();
        teamsTSVReport.setContestAndController(this.contest, this.controller);
        PrintWriter writer = new PrintWriter(new FileOutputStream(filename, false), true);
        teamsTSVReport.writeReport(writer);
        writer.close();
    }

    private void writeGroupsTSV(String filename) throws Exception {
        GroupsTSVReport groupsTSVReport = new GroupsTSVReport();
        groupsTSVReport.setContestAndController(this.contest, this.controller);
        PrintWriter writer = new PrintWriter(new FileOutputStream(filename, false), true);
        groupsTSVReport.writeReport(writer);
        writer.close();
    }

    private void writeScoeboardHTML(String resultsdir) throws IllegalContestState {
        ScoreboardPlugin plugin = new ScoreboardPlugin();
        plugin.setContestAndController(this.contest, this.controller);
        plugin.writeHTML(resultsdir);
    }

    private void writeScoreboardTSV(String filename) throws Exception {
        ScoreboardTSVReport scoreboardTSVReport = new ScoreboardTSVReport();
        scoreboardTSVReport.setContestAndController(this.contest, this.controller);
        PrintWriter writer = new PrintWriter(new FileOutputStream(filename, false), true);
        scoreboardTSVReport.writeReport(writer);
        writer.close();
    }

    private void writeResults(String filename) throws Exception {
        ResultsFile resultsFile = new ResultsFile();
        String[] lines = resultsFile.createTSVFileLines(this.contest);
        this.writeLinesToFile(filename, lines);
    }

    private Map<String, RunFiles> getRunFiles(Run[] runs) {
        HashMap<String, RunFiles> list = new HashMap<String, RunFiles>();
        String filename = "pc2v9.ini";
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            RunFiles files = new RunFiles(run, filename);
            String key = run.getElementId().toString();
            list.put(key, files);
            ++n2;
        }
        return list;
    }

    public void writeSubmissions(PrintWriter writer, String dir) throws IOException {
        Run[] runs = this.contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        Map<String, RunFiles> files = this.getRunFiles(runs);
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            try {
                String runDirectory = CDPReport.getRunDirectory(dir, run);
                this.ensureDirectory(runDirectory);
                RunFiles runFiles = this.getRunFiles(files, run);
                this.writeSubmissionInfo(this.contest, runDirectory, run, runFiles);
                SerializedFile mainFile = runFiles.getMainFile();
                mainFile.writeFile(String.valueOf(runDirectory) + File.separator + mainFile.getName());
                SerializedFile[] otherfiles = runFiles.getOtherFiles();
                if (otherfiles != null && otherfiles.length > 0) {
                    SerializedFile[] serializedFileArray = otherfiles;
                    int n3 = otherfiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        SerializedFile serializedFile = serializedFileArray[n4];
                        serializedFile.writeFile(String.valueOf(runDirectory) + File.separator + serializedFile.getName());
                        ++n4;
                    }
                }
            }
            catch (Exception e) {
                writer.println("Problem while writing submission " + run);
                e.printStackTrace(writer);
            }
            ++n2;
        }
    }

    public static String getRunDirectory(String baseDirectory, Run run) {
        if (run.getSiteNumber() > 1) {
            return String.valueOf(baseDirectory) + File.separator + "s" + run.getSiteNumber() + "r" + run.getNumber();
        }
        return String.valueOf(baseDirectory) + File.separator + run.getNumber();
    }

    private void writeSubmissionInfo(IInternalContest inContest, String runDirectory, Run run, RunFiles files) throws FileNotFoundException {
        String infoFilename = String.valueOf(runDirectory) + File.separator + "run.properties";
        PrintWriter writer = new PrintWriter(new FileOutputStream(infoFilename, false), true);
        writer.println("# ");
        writer.println("# Created on " + new Date());
        writer.println("# ");
        writer.println("# Created by " + new VersionInfo().getSystemVersionInfo());
        writer.println("# ");
        ArrayList<String> list = new ArrayList<String>();
        Problem problem = inContest.getProblem(run.getProblemId());
        Language language = inContest.getLanguage(run.getLanguageId());
        list.add("problem=" + problem.getShortName());
        list.add("language=" + language.getDisplayName());
        list.add("submittedby=" + run.getSubmitter().getName());
        list.add("contesttime=" + run.getElapsedMS());
        list.add("solved=" + run.isSolved());
        list.add("site=" + run.getSiteNumber());
        list.add("mainfile=" + files.getMainFile().getName());
        SerializedFile[] others = files.getOtherFiles();
        if (others != null) {
            list.add("sourcecount=" + others.length);
            int count = 1;
            SerializedFile[] serializedFileArray = others;
            int n = others.length;
            int n2 = 0;
            while (n2 < n) {
                SerializedFile file = serializedFileArray[n2];
                list.add("source" + count + "=" + file.getName());
                ++count;
                ++n2;
            }
        }
        for (String string : list) {
            writer.println(string);
        }
        writer.close();
    }

    private RunFiles getRunFiles(Map<String, RunFiles> files, Run run) {
        return files.get(run.getElementId().toString());
    }

    private boolean ensureDirectory(String dir) {
        if (!new File(dir).isDirectory()) {
            new File(dir).mkdirs();
        }
        return new File(dir).isDirectory();
    }

    private void writeUserDataFile(String filename) throws Exception {
        UserdataTSVReport userdataTSVReport = new UserdataTSVReport();
        userdataTSVReport.setContestAndController(this.contest, this.controller);
        PrintWriter writer = new PrintWriter(new FileOutputStream(filename, false), true);
        userdataTSVReport.writeReport(writer);
        writer.close();
    }

    public void listFiles(PrintWriter printWriter, String prefix, String directory) throws Exception {
        File entry;
        File[] entries = new File(directory).listFiles();
        Arrays.sort(entries, new FileComparator());
        File[] fileArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            entry = fileArray[n2];
            if (entry.isFile()) {
                printWriter.println(String.valueOf(prefix) + directory + File.separator + entry.getName());
            }
            ++n2;
        }
        fileArray = entries;
        n = entries.length;
        n2 = 0;
        while (n2 < n) {
            entry = fileArray[n2];
            if (entry.isDirectory()) {
                this.listFiles(printWriter, prefix, String.valueOf(directory) + File.separator + entry.getName());
            }
            ++n2;
        }
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
        this.writeContestTime(printWriter);
        printWriter.println();
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            try {
                this.printHeader(printWriter);
                this.writeReport(printWriter);
                this.printFooter(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Contest Data Package";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Contest Data Package Reportt";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }
}

