/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.AccountComparator;
import edu.csus.ecs.pc2.core.list.RunComparatorByTeamProblem;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;

public class BalloonSummaryReport
implements IReport {
    private static final long serialVersionUID = 3558660040036850297L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();

    private Problem[] solvedProblems(Run[] runs, ClientId clientId) {
        Vector<Problem> probs = new Vector<Problem>();
        Arrays.sort(runs, new RunComparatorByTeamProblem());
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (!run.isDeleted() && run.isSolved() && this.filter.matches(run) && run.getSubmitter().equals(clientId)) {
                if (probs.size() == 0) {
                    probs.addElement(this.contest.getProblem(run.getProblemId()));
                } else {
                    boolean found = false;
                    int i = 0;
                    while (i < probs.size()) {
                        Problem problem = (Problem)probs.elementAt(i);
                        if (this.filter.matches(problem) && problem.getElementId().equals(run.getProblemId())) {
                            found = true;
                        }
                        ++i;
                    }
                    if (!found) {
                        probs.addElement(this.contest.getProblem(run.getProblemId()));
                    }
                }
            }
            ++n2;
        }
        return probs.toArray(new Problem[probs.size()]);
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        Run[] runs = this.contest.getRuns();
        Vector<Account> accountVector = this.contest.getAccounts(ClientType.Type.TEAM);
        Account[] accounts = accountVector.toArray(new Account[accountVector.size()]);
        Arrays.sort(accounts, new AccountComparator());
        Problem[] solvedProbs = null;
        int totalBalloons = 0;
        Account[] accountArray = accounts;
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            if (this.filter.matches(account)) {
                ClientId clientId = account.getClientId();
                solvedProbs = this.solvedProblems(runs, clientId);
                BalloonSettings balloonSettings = this.contest.getBalloonSettings(clientId.getSiteNumber());
                if (solvedProbs.length > 0) {
                    printWriter.print("s" + clientId.getSiteNumber() + "t" + clientId.getClientNumber() + " ");
                    this.truncPrint(printWriter, account, 9);
                    printWriter.print(" has " + solvedProbs.length + ": ");
                    Problem[] problemArray = solvedProbs;
                    int n3 = solvedProbs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Problem problem = problemArray[n4];
                        ++totalBalloons;
                        if (balloonSettings != null && balloonSettings.getColor(problem.getElementId()) != null) {
                            printWriter.print(" " + balloonSettings.getColor(problem.getElementId()));
                        } else {
                            String name = problem.getDisplayName();
                            int truncIndex = Math.min(name.toString().length(), 12);
                            printWriter.format(" " + name.toString().substring(0, truncIndex), new Object[0]);
                        }
                        ++n4;
                    }
                    printWriter.println();
                }
            }
            ++n2;
        }
        printWriter.println();
        printWriter.println("Total Balloons " + totalBalloons);
    }

    private void truncPrint(PrintWriter printWriter, String name, int maxlen) {
        int truncIndex = Math.min(name.toString().length(), maxlen);
        printWriter.format(name.toString().substring(0, truncIndex), new Object[0]);
    }

    private void truncPrint(PrintWriter printWriter, Account account, int maxlen) {
        if (account != null) {
            if (account.getDisplayName() == null) {
                this.truncPrint(printWriter, account.getClientId().getName(), maxlen);
            } else {
                this.truncPrint(printWriter, account.getDisplayName(), maxlen);
            }
        }
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Balloons Summary";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Balloon Summary Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

