/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.ClientIdComparator;
import edu.csus.ecs.pc2.core.list.ClientSettingsComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonDeliveryInfo;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;

public class BalloonDeliveryReport
implements IReport {
    private static final long serialVersionUID = -5374491950286834509L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();
    private ClientIdComparator comparator = new ClientIdComparator();
    private SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss Z yyyy-MM-dd E");

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        if (this.filter.isFilterOn()) {
            printWriter.println(this.filter.toString());
        }
        ClientSettings[] clientSettingsList = this.contest.getClientSettingsList();
        Arrays.sort(clientSettingsList, new ClientSettingsComparator());
        int balloonDeliveries = 0;
        int foundMatching = 0;
        ClientId lastClientId = null;
        ClientSettings[] clientSettingsArray = clientSettingsList;
        int n = clientSettingsList.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSettings clientSettings = clientSettingsArray[n2];
            Hashtable<String, BalloonDeliveryInfo> hashtable = clientSettings.getBalloonList();
            String[] keyList = hashtable.keySet().toArray(new String[hashtable.keySet().size()]);
            Arrays.sort(keyList, new BalloonKeyComparator());
            String[] stringArray = keyList;
            int n3 = keyList.length;
            int n4 = 0;
            while (n4 < n3) {
                String key = stringArray[n4];
                BalloonDeliveryInfo balloonDeliveryInfo = hashtable.get(key);
                ++balloonDeliveries;
                boolean matchesFilter = true;
                if (this.filter.isFilterOn()) {
                    boolean bl = matchesFilter = this.filter.matches(balloonDeliveryInfo.getClientId()) && this.filter.matchesProblem(balloonDeliveryInfo.getProblemId());
                }
                if (matchesFilter) {
                    ++foundMatching;
                    if (lastClientId == null || !lastClientId.equals(balloonDeliveryInfo.getClientId())) {
                        printWriter.println();
                        lastClientId = balloonDeliveryInfo.getClientId();
                        Account account = this.contest.getAccount(lastClientId);
                        String accountTitle = "";
                        if (account != null) {
                            accountTitle = " (" + account.getDisplayName();
                            Site site = this.contest.getSite(lastClientId.getSiteNumber());
                            if (site != null) {
                                accountTitle = String.valueOf(accountTitle) + " at " + site.getDisplayName();
                            }
                            accountTitle = String.valueOf(accountTitle) + ")";
                        }
                        printWriter.println("     Client " + lastClientId.toString() + accountTitle);
                    }
                    try {
                        this.printBalloonDeliveryInfo(printWriter, balloonDeliveryInfo);
                    }
                    catch (Exception e) {
                        printWriter.println("For " + key + " exception " + e.getMessage());
                        this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        printWriter.println();
        printWriter.println("There were " + balloonDeliveries + " delivered");
        if (balloonDeliveries > 0) {
            if (foundMatching > 0) {
                printWriter.println("There were only " + foundMatching + " deliveries that matched the filter.");
            } else {
                printWriter.println("There were no matching balloons for this report");
            }
        }
    }

    private void printBalloonDeliveryInfo(PrintWriter printWriter, BalloonDeliveryInfo balloonDeliveryInfo) {
        Problem problem = this.contest.getProblem(balloonDeliveryInfo.getProblemId());
        Date date = new Date(balloonDeliveryInfo.getTimeSent());
        printWriter.println("            " + problem + " at " + this.formatter.format(date));
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Balloons Delivery";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Balloon Delivery Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    protected class BalloonKeyComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 3204840271423881062L;

        protected BalloonKeyComparator() {
        }

        public ClientId getClientId(String clientIDString) {
            String clientTypeName = ClientType.Type.TEAM.toString();
            int teamIndex = clientIDString.indexOf(clientTypeName);
            if (teamIndex > 0) {
                int siteNumber = Integer.parseInt(clientIDString.substring(0, teamIndex));
                int teamNumber = Integer.parseInt(clientIDString.substring(teamIndex + clientTypeName.length()));
                return new ClientId(siteNumber, ClientType.Type.TEAM, teamNumber);
            }
            return new ClientId(0, ClientType.Type.TEAM, 0);
        }

        @Override
        public int compare(String key1, String key2) {
            String[] fields1 = key1.split(" ");
            String[] fields2 = key2.split(" ");
            ClientId clientId1 = this.getClientId(fields1[0]);
            ClientId clientId2 = this.getClientId(fields2[0]);
            return BalloonDeliveryReport.this.comparator.compare(clientId1, clientId2);
        }
    }
}

