/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.report;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.list.ClientSettingsComparator;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.Reports;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

public class AutoJudgingSettingsReport
implements IReport {
    private static final long serialVersionUID = 1L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;
    private Filter filter = new Filter();
    private int autoJudgeCount = 0;

    private String getProblemlist(Filter inFilter) {
        ElementId[] elementIds = inFilter.getProblemIdList();
        if (elementIds.length == 0) {
            return "(none selected)";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Problem[] problemArray = this.contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            ElementId[] elementIdArray = elementIds;
            int n3 = elementIds.length;
            int n4 = 0;
            while (n4 < n3) {
                ElementId elementId = elementIdArray[n4];
                if (problem.getElementId().equals(elementId)) {
                    stringBuffer.append(problem.getDisplayName());
                    stringBuffer.append(", ");
                }
                ++n4;
            }
            ++n2;
        }
        if (stringBuffer.length() > 0) {
            return new String(stringBuffer).substring(0, stringBuffer.length() - 2);
        }
        return "(none active selected)";
    }

    private String enabledString(boolean b) {
        if (b) {
            return "is ENABLED";
        }
        return "is not enabled";
    }

    protected String getProblemLetter(Problem problem) {
        char let = 'A';
        int count = 0;
        Problem[] problemArray = this.contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem2 = problemArray[n2];
            if (problem2.equals(problem)) {
                let = (char)(let + count);
            }
            ++count;
            ++n2;
        }
        return "" + let;
    }

    public void writeRow(PrintWriter printWriter, ClientSettings clientSettings) {
        if (this.isJudge(clientSettings.getClientId())) {
            printWriter.print(clientSettings.getClientId());
            Filter clientFilter = clientSettings.getAutoJudgeFilter();
            printWriter.println(" auto judge " + this.enabledString(clientSettings.isAutoJudging()));
            if (clientFilter != null) {
                ElementId[] elementIds = clientFilter.getProblemIdList();
                printWriter.println("     Auto judging " + elementIds.length + " problems : " + this.getProblemlist(clientFilter));
            }
            this.writeProblemList("         ", printWriter, clientFilter);
            ++this.autoJudgeCount;
            printWriter.println();
            printWriter.println();
        }
    }

    private boolean isJudge(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    @Override
    public void writeReport(PrintWriter printWriter) {
        printWriter.println();
        ClientSettings[] clientSettingsList = this.contest.getClientSettingsList();
        Arrays.sort(clientSettingsList, new ClientSettingsComparator());
        this.autoJudgeCount = 0;
        ClientSettings[] clientSettingsArray = clientSettingsList;
        int n = clientSettingsList.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSettings clientSettings = clientSettingsArray[n2];
            try {
                this.writeRow(printWriter, clientSettings);
            }
            catch (Exception e) {
                e.printStackTrace(printWriter);
            }
            ++n2;
        }
        printWriter.println("There are " + this.autoJudgeCount + " auto judges");
        printWriter.println();
    }

    @Override
    public void printHeader(PrintWriter printWriter) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println("Date: " + Utilities.getL10nDateTime());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        printWriter.println();
        printWriter.println(String.valueOf(this.getReportTitle()) + " Report");
    }

    @Override
    public void printFooter(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("end report");
    }

    @Override
    public void createReportFile(String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        try {
            this.printHeader(printWriter);
            try {
                this.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            this.printFooter(printWriter);
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception writing report", e);
            printWriter.println("Exception generating report " + e.getMessage());
        }
    }

    void writeProblemList(String pad, PrintWriter printWriter, Filter problemList) {
        ElementId[] elementIds = problemList.getProblemIdList();
        if (elementIds.length == 0) {
            printWriter.println(String.valueOf(pad) + "(none selected)");
        }
        Problem[] problemArray = this.contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            ElementId[] elementIdArray = elementIds;
            int n3 = elementIds.length;
            int n4 = 0;
            while (n4 < n3) {
                ElementId elementId = elementIdArray[n4];
                if (problem.getElementId().equals(elementId)) {
                    printWriter.println(String.valueOf(pad) + this.getProblemLetter(problem) + " - " + problem.getDisplayName());
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public String[] createReport(Filter inFilter) {
        throw new SecurityException("Not implemented");
    }

    @Override
    public String createReportXML(Filter inFilter) throws IOException {
        return Reports.notImplementedXML(this);
    }

    @Override
    public String getReportTitle() {
        return "Auto Judging Settings";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
    }

    @Override
    public String getPluginTitle() {
        return "Auto Judging Settings Report";
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

