/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import java.util.Enumeration;
import java.util.Properties;

public class Site
implements IElementObject {
    private static final long serialVersionUID = 927149732372774783L;
    public static final String PORT_KEY = "PORT_KEY";
    public static final String IP_KEY = "IP_KEY";
    public static final String NUMBER_PATTERN = "%#";
    public static final String LONG_NAME_PATTERN = "%L";
    public static final String SHORT_NAME_PATTERN = "%S";
    private String displayName = null;
    private Properties connectionInfo = new Properties();
    private String connectionDisplayInfo = "";
    private ElementId elementId = null;
    private boolean active = true;
    private String password;

    public Site(String displayName, int siteNumber) {
        this.displayName = displayName;
        this.elementId = new ElementId(displayName);
        this.setSiteNumber(siteNumber);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public String getConnectionDisplayInfo() {
        return this.connectionDisplayInfo;
    }

    public void setConnectionDisplayInfo(String connectionDisplayInfo) {
        this.connectionDisplayInfo = connectionDisplayInfo;
    }

    public Properties getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setConnectionInfo(Properties connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Site) {
            Site otherSite = (Site)obj;
            return otherSite.getElementId().equals(this.elementId);
        }
        return false;
    }

    public Site clone() {
        String[] keys;
        Site newSite = new Site(this.getDisplayName(), this.getSiteNumber());
        newSite.elementId = this.elementId;
        newSite.active = this.active;
        newSite.password = new String(this.password);
        String[] stringArray = keys = this.connectionInfo.keySet().toArray(new String[this.connectionInfo.size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            newSite.getConnectionInfo().put(key, this.connectionInfo.get(key));
            ++n2;
        }
        return newSite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSameAs(Site site) {
        try {
            String element;
            if (!this.displayName.equals(site.getDisplayName())) {
                return false;
            }
            if (this.isActive() != site.isActive()) {
                return false;
            }
            if (!this.connectionDisplayInfo.equals(site.getConnectionDisplayInfo())) {
                return false;
            }
            if (!this.password.equals(site.getPassword())) {
                return false;
            }
            Enumeration<Object> enumeration = this.connectionInfo.keys();
            do {
                if (enumeration.hasMoreElements()) continue;
                return true;
            } while (this.connectionInfo.get(element = (String)enumeration.nextElement()).equals(site.getConnectionInfo().get(element)));
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public StringBuffer format(String pattern) {
        StringBuffer buffer = new StringBuffer();
        if (pattern.equals(NUMBER_PATTERN)) {
            buffer.append(this.getSiteNumber());
        } else if (pattern.equals("%# - %L")) {
            buffer.append(this.getSiteNumber());
            buffer.append(" - ");
            buffer.append(this.getDisplayName());
        } else if (pattern.equals(SHORT_NAME_PATTERN)) {
            buffer.append("Site ");
            buffer.append(this.getSiteNumber());
        } else if (pattern.equals(LONG_NAME_PATTERN)) {
            buffer.append(this.toString());
        }
        return buffer;
    }

    public int hashCode() {
        return this.elementId.hashCode();
    }
}

