/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.StringUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class SerializedFile
implements Serializable {
    static final long serialVersionUID = -254619749606639287L;
    private static File file;
    private byte[] buffer;
    private String name;
    private String absolutePath;
    private String sha1sum;
    private int fileType = 1;
    private int newLineCount = 0;
    private boolean externalFile = false;
    private char[] errorMessage;
    private Exception exception;

    public SerializedFile() {
        this.name = null;
        this.buffer = null;
        file = null;
        this.fileType = 1;
    }

    public SerializedFile(String fileName) {
        this(fileName, false);
    }

    public SerializedFile(String fileName, boolean externalFile) {
        this.externalFile = externalFile;
        file = new File(fileName);
        this.setName(file.getName());
        if (!file.exists()) {
            this.addMessage(String.valueOf(fileName) + " not found in SerializedFile", new FileNotFoundException(fileName));
        } else {
            try {
                this.buffer = this.file2buffer(fileName);
                this.absolutePath = file.getAbsolutePath();
                this.generateSHA1();
                this.generateFileType(this.buffer);
                if (externalFile) {
                    this.buffer = null;
                }
            }
            catch (Exception e) {
                this.addMessage("Exception in SerializeFile for file " + fileName, e);
            }
        }
    }

    public SerializedFile(String fileName, int limit) {
        file = new File(fileName);
        this.setName(file.getName());
        if (!file.exists()) {
            this.addMessage(String.valueOf(fileName) + " not found", null);
        } else {
            try {
                this.buffer = this.file2buffer(fileName, limit);
                this.absolutePath = file.getAbsolutePath();
                this.generateSHA1();
                this.generateFileType(this.buffer);
            }
            catch (Exception e) {
                this.addMessage("Exception in SerializeFile for file " + fileName, e);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        SerializedFile otherFile = (SerializedFile)obj;
        if (!StringUtilities.stringSame(this.sha1sum, otherFile.sha1sum)) {
            return false;
        }
        if (!StringUtilities.stringSame(this.absolutePath, otherFile.absolutePath)) {
            return false;
        }
        if (this.externalFile != otherFile.externalFile) {
            return false;
        }
        if (!StringUtilities.stringSame(this.getErrorMessage(), otherFile.getErrorMessage())) {
            return false;
        }
        if (!StringUtilities.stringSame(this.name, otherFile.name)) {
            return false;
        }
        if (!Arrays.equals(this.buffer, otherFile.buffer)) {
            return false;
        }
        if (this.fileType != otherFile.fileType) {
            return false;
        }
        return this.newLineCount == otherFile.newLineCount;
    }

    public int hashCode() {
        return this.sha1sum.hashCode();
    }

    public void buffer2file(byte[] b, String fileName) {
        try {
            FileOutputStream outputStream = null;
            outputStream = new FileOutputStream(fileName);
            outputStream.write(b, 0, b.length);
            outputStream.close();
        }
        catch (Exception e) {
            this.addMessage("Exception in SerializeFile for file " + fileName, e);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        SerializedFile clone = new SerializedFile();
        clone.setFile(this.getFile());
        clone.buffer = this.cloneBuffer(this.buffer);
        clone.setName(this.cloneString(this.name));
        clone.absolutePath = this.cloneString(this.absolutePath);
        clone.setSHA1sum(this.cloneString(this.getSHA1sum()));
        clone.fileType = this.getFileType();
        clone.newLineCount = this.newLineCount;
        clone.externalFile = this.externalFile;
        if (this.errorMessage != null) {
            clone.errorMessage = (char[])this.errorMessage.clone();
        }
        clone.exception = this.exception;
        return clone;
    }

    private String cloneString(String s) {
        String result = null;
        if (s != null) {
            result = new String(s);
        }
        return result;
    }

    private byte[] cloneBuffer(byte[] bufferToCopy) {
        byte[] clone;
        if (bufferToCopy != null) {
            clone = new byte[bufferToCopy.length];
            int i = 0;
            while (i < bufferToCopy.length) {
                clone[i] = bufferToCopy[i];
                ++i;
            }
        } else {
            clone = null;
        }
        return clone;
    }

    public void writeFile(String fileName) throws IOException {
        if (this.buffer == null || this.buffer.length == 0) {
            this.buffer = new byte[0];
        }
        FileOutputStream outputStream = null;
        outputStream = new FileOutputStream(fileName);
        outputStream.write(this.buffer, 0, this.buffer.length);
        outputStream.close();
    }

    public byte[] file2buffer(String fileName) {
        byte[] b;
        FileInputStream inputStream = null;
        int len = 0;
        try {
            inputStream = new FileInputStream(fileName);
            len = ((InputStream)inputStream).available();
            b = new byte[len];
            ((InputStream)inputStream).read(b);
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            this.addMessage("Exception reading " + fileName, e);
            b = null;
        }
        return b;
    }

    public byte[] file2buffer(String fileName, int limit) {
        byte[] b;
        FileInputStream inputStream = null;
        int len = 0;
        try {
            inputStream = new FileInputStream(fileName);
            len = ((InputStream)inputStream).available();
            if (len > limit) {
                len = limit;
            }
            b = new byte[len];
            ((InputStream)inputStream).read(b);
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            this.addMessage("Exception reading " + fileName, e);
            b = null;
        }
        return b;
    }

    private void addMessage(String message, Exception ex) {
        this.errorMessage = message.toCharArray();
        this.exception = ex;
    }

    private void generateSHA1() {
        this.sha1sum = null;
        try {
            this.sha1sum = SerializedFile.generateSHA1(this.buffer);
        }
        catch (Exception ex99) {
            this.addMessage("Exception calculating SHA1", ex99);
            this.sha1sum = null;
        }
    }

    public static String generateSHA1(File theFile) throws NoSuchAlgorithmException, IOException {
        String fileName = theFile.getAbsolutePath();
        FileInputStream inputStream = null;
        int len = 0;
        inputStream = new FileInputStream(fileName);
        len = ((InputStream)inputStream).available();
        byte[] buf = new byte[len];
        ((InputStream)inputStream).read(buf);
        ((InputStream)inputStream).close();
        return SerializedFile.generateSHA1(buf);
    }

    public static String generateSHA1(byte[] buf) throws NoSuchAlgorithmException {
        String out = null;
        if (buf == null) {
            return null;
        }
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.reset();
        md.update(buf);
        byte[] digested = md.digest();
        out = "";
        int i = 0;
        while (i < digested.length) {
            out = String.valueOf(out) + new Integer(digested[i]).toString();
            ++i;
        }
        return out;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public byte[] getBuffer() {
        if (this.buffer != null) {
            return this.buffer;
        }
        return new byte[0];
    }

    public File getFile() {
        return file;
    }

    public String getSHA1sum() {
        return this.sha1sum;
    }

    public String getName() {
        return this.name;
    }

    public void setFile(File file) {
        SerializedFile.file = file;
    }

    void setSHA1sum(String newSHA1sum) {
        this.sha1sum = newSHA1sum;
    }

    private void setName(String name) {
        this.name = name;
    }

    public void generateFileType(byte[] buf) {
        int dosFlag = 0;
        int unixFlag = 0;
        int macFlag = 0;
        int lastChar = 0;
        int i = 0;
        while (i < buf.length) {
            if (buf[i] == 10) {
                if (lastChar == 13) {
                    ++dosFlag;
                    --macFlag;
                } else {
                    ++unixFlag;
                }
            } else if (buf[i] == 13) {
                ++macFlag;
            }
            if (buf[i] > 127) {
                this.fileType = 1;
                this.newLineCount = 0;
                return;
            }
            lastChar = buf[i];
            ++i;
        }
        if (dosFlag != 0 && unixFlag == 0 && macFlag == 0) {
            this.fileType = 2;
            this.newLineCount = dosFlag;
        } else if (dosFlag == 0 && unixFlag != 0 && macFlag == 0) {
            this.fileType = 8;
            this.newLineCount = unixFlag;
        } else if (dosFlag == 0 && unixFlag == 0 && macFlag != 0) {
            this.fileType = 4;
            this.newLineCount = macFlag;
        } else if (dosFlag == 0 && unixFlag == 0 && macFlag == 0) {
            this.fileType = 16;
            this.newLineCount = 0;
        } else {
            this.fileType = 32;
            this.newLineCount = 0;
        }
    }

    public int getFileType() {
        return this.fileType;
    }

    public boolean convertFile(int convertFileToType) {
        if (this.fileType == 1 || this.fileType == 16 || this.fileType == 32) {
            return false;
        }
        if (this.fileType == convertFileToType) {
            return true;
        }
        byte[] newbuffer = convertFileToType == 2 ? new byte[this.buffer.length + this.newLineCount] : (this.fileType == 2 ? new byte[this.buffer.length - this.newLineCount] : new byte[this.buffer.length]);
        int counter = 0;
        int i = 0;
        while (i < this.buffer.length) {
            if (this.buffer[i] == 13 || this.buffer[i] == 10) {
                if (this.fileType == 2) {
                    if (convertFileToType == 8) {
                        newbuffer[counter++] = 10;
                        ++i;
                    } else {
                        newbuffer[counter++] = 13;
                        ++i;
                    }
                } else if (this.fileType == 8) {
                    if (convertFileToType == 4) {
                        newbuffer[counter++] = 13;
                    } else {
                        newbuffer[counter++] = 13;
                        newbuffer[counter++] = 10;
                    }
                } else if (this.fileType == 4) {
                    if (convertFileToType == 8) {
                        newbuffer[counter++] = 10;
                    } else {
                        newbuffer[counter++] = 13;
                        newbuffer[counter++] = 10;
                    }
                }
            } else {
                newbuffer[counter++] = this.buffer[i];
            }
            ++i;
        }
        String s = "Converted file from ";
        if (this.fileType == 1) {
            s = String.valueOf(s) + "Binary";
        } else if (this.fileType == 2) {
            s = String.valueOf(s) + "DOS";
        } else if (this.fileType == 4) {
            s = String.valueOf(s) + "Apple";
        } else if (this.fileType == 8) {
            s = String.valueOf(s) + "Unix";
        } else if (this.fileType == 16) {
            s = String.valueOf(s) + "ASCII_Generic";
        } else if (this.fileType == 32) {
            s = String.valueOf(s) + "ASCII_Other";
        }
        s = String.valueOf(s) + " to ";
        if (convertFileToType == 1) {
            s = String.valueOf(s) + "Binary";
        } else if (convertFileToType == 2) {
            s = String.valueOf(s) + "DOS";
        } else if (convertFileToType == 4) {
            s = String.valueOf(s) + "Apple";
        } else if (convertFileToType == 8) {
            s = String.valueOf(s) + "Unix";
        } else if (convertFileToType == 16) {
            s = String.valueOf(s) + "ASCII_Generic";
        } else if (convertFileToType == 32) {
            s = String.valueOf(s) + "ASCII_Other";
        }
        this.fileType = convertFileToType;
        this.buffer = newbuffer;
        return true;
    }

    public boolean isExternalFile() {
        return this.externalFile;
    }

    public String getErrorMessage() {
        if (this.errorMessage == null) {
            return null;
        }
        return new String(this.errorMessage);
    }

    public Exception getException() {
        return this.exception;
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.absolutePath + " ext=" + this.externalFile + " SHA=" + this.sha1sum;
    }
}

