/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import edu.csus.ecs.pc2.core.model.Run;

public final class RunUtilities {
    private RunUtilities() {
    }

    public static Run createNewRun(Run run, IInternalContest contest) {
        Run newRun = new Run(run.getSubmitter(), contest.getLanguage(run.getLanguageId()), contest.getProblem(run.getProblemId()));
        newRun.setElementId(run.getElementId());
        newRun.setElapsedMS(run.getElapsedMS());
        newRun.setDeleted(run.isDeleted());
        newRun.setNumber(run.getNumber());
        newRun.setStatus(Run.RunStates.NEW);
        return newRun;
    }

    public static boolean supppressJudgement(JudgementNotificationsList judgementNotificationsList, Run run, ContestTime contestTime) {
        JudgementRecord judgementRecord = run.getJudgementRecord();
        return RunUtilities.supppressJudgement(judgementNotificationsList, run, judgementRecord, contestTime);
    }

    public static boolean supppressJudgement(JudgementNotificationsList judgementNotificationsList, Run run, JudgementRecord judgementRecord, ContestTime contestTime) {
        if (judgementRecord == null) {
            return false;
        }
        if (judgementNotificationsList == null || judgementNotificationsList.getList().length == 0) {
            return false;
        }
        NotificationSetting notificationSetting = (NotificationSetting)judgementNotificationsList.get(run.getProblemId());
        if (notificationSetting == null) {
            return false;
        }
        boolean solvedProblem = judgementRecord.isSolved();
        long runRemainingTime = contestTime.getConestLengthMins() - run.getElapsedMins();
        if (judgementRecord.isPreliminaryJudgement()) {
            if (solvedProblem) {
                if (notificationSetting.getPreliminaryNotificationYes().isNotificationSupressed()) {
                    return runRemainingTime <= (long)notificationSetting.getPreliminaryNotificationYes().getCuttoffMinutes();
                }
            } else if (notificationSetting.getPreliminaryNotificationNo().isNotificationSupressed()) {
                return runRemainingTime <= (long)notificationSetting.getPreliminaryNotificationNo().getCuttoffMinutes();
            }
        } else if (solvedProblem) {
            if (notificationSetting.getFinalNotificationYes().isNotificationSupressed()) {
                return runRemainingTime <= (long)notificationSetting.getFinalNotificationYes().getCuttoffMinutes();
            }
        } else if (notificationSetting.getFinalNotificationNo().isNotificationSupressed()) {
            return runRemainingTime <= (long)notificationSetting.getFinalNotificationNo().getCuttoffMinutes();
        }
        return false;
    }
}

