/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.Language;
import java.io.File;

public final class LanguageAutoFill {
    public static final String JAVATITLE = "Java";
    public static final String DEFAULTTITLE = "Default";
    public static final String GNUCPPTITLE = "GNU C++ (Unix / Windows)";
    public static final String GNUCTITLE = "GNU C (Unix / Windows)";
    public static final String PERLTITLE = "Perl";
    public static final String MSCTITLE = "Microsoft C++";
    public static final String KYLIXTITLE = "Kylix Delphi";
    public static final String KYLIXCPPTITLE = "Kylix C++";
    public static final String FPCTITLE = "Free Pascal";
    public static final String PHPTITLE = "PHP";
    public static final String PYTHONTITLE = "Python";
    public static final String RUBYTITLE = "Ruby";
    public static final String PYTHON3TITLE = "Python 3";
    public static final String INTERPRETER_VALUE = "interpeter";
    private static final String NULL_LANGUAGE_NAME = "";
    private static String[] languageList = new String[]{"Default", "Java", "GNU C++ (Unix / Windows)", "GNU C (Unix / Windows)", "Perl", "PHP", "Python", "Python 3", "Ruby", "Microsoft C++", "Kylix Delphi", "Kylix C++", "Free Pascal"};

    private LanguageAutoFill() {
    }

    public static String[] getAutoFillValues(String key) {
        String fs = File.separator;
        if (key.equals(JAVATITLE)) {
            String[] dVals = new String[]{JAVATITLE, "javac {:mainfile}", "{:basename}.class", "java {:basename}", JAVATITLE, NULL_LANGUAGE_NAME};
            return dVals;
        }
        if (key.equals(KYLIXCPPTITLE)) {
            String[] dVals = new String[]{KYLIXCPPTITLE, "bc++ -A  {:mainfile}", "{:basename}", "." + fs + "{:basename}", KYLIXCPPTITLE, NULL_LANGUAGE_NAME};
            return dVals;
        }
        if (key.equals(MSCTITLE)) {
            String[] dVals = new String[]{MSCTITLE, "cl.exe {:mainfile}", "{:basename}.exe", "." + fs + "{:basename}.exe", MSCTITLE, NULL_LANGUAGE_NAME};
            return dVals;
        }
        if (key.equals(GNUCPPTITLE)) {
            String[] dVals = new String[]{GNUCPPTITLE, "g++ -lm -o {:basename}.exe {:mainfile}", "{:basename}.exe", "." + fs + "{:basename}.exe", "GNU C++", NULL_LANGUAGE_NAME};
            return dVals;
        }
        if (key.equals(GNUCTITLE)) {
            String[] dVals = new String[]{GNUCTITLE, "gcc -lm -o {:basename}.exe {:mainfile}", "{:basename}.exe", "." + fs + "{:basename}.exe", "GNU C", NULL_LANGUAGE_NAME};
            return dVals;
        }
        if (key.equals(KYLIXTITLE)) {
            String[] dVals = new String[]{KYLIXTITLE, "dcc {:mainfile}", "{:basename}", "." + fs + "{:basename}", KYLIXTITLE, NULL_LANGUAGE_NAME};
            return dVals;
        }
        if (key.equals(FPCTITLE)) {
            String[] dVals = new String[]{FPCTITLE, "fpc {:mainfile}", "{:basename}", "." + fs + "{:basename}", FPCTITLE, NULL_LANGUAGE_NAME};
            return dVals;
        }
        if (key.equals(PERLTITLE)) {
            String[] dVals = new String[]{PERLTITLE, "perl -c {:mainfile}", "{:noexe}", "perl {:mainfile}", PERLTITLE, INTERPRETER_VALUE};
            return dVals;
        }
        if (key.equals(PHPTITLE)) {
            String[] dVals = new String[]{PHPTITLE, "php -l {:mainfile}", "{:noexe}", "php {:mainfile}", PHPTITLE, INTERPRETER_VALUE};
            return dVals;
        }
        if (key.equals(PYTHONTITLE)) {
            String[] dVals = new String[]{PYTHONTITLE, "python -m py_compile {:mainfile}", "{:noexe}", "python {:mainfile}", PYTHONTITLE, INTERPRETER_VALUE};
            return dVals;
        }
        if (key.equals(PYTHON3TITLE)) {
            String[] dVals = new String[]{PYTHONTITLE, "python3 -m py_compile {:mainfile}", "{:noexe}", "python3 {:mainfile}", PYTHONTITLE, INTERPRETER_VALUE};
            return dVals;
        }
        if (key.equals(RUBYTITLE)) {
            String[] dVals = new String[]{RUBYTITLE, "ruby -c {:mainfile}", "{:noexe}", "ruby {:mainfile}", RUBYTITLE, INTERPRETER_VALUE};
            return dVals;
        }
        String[] dVals = new String[]{NULL_LANGUAGE_NAME, "<Compiler> {:mainfile}", "{:basename}.exe", "{:basename}.exe", NULL_LANGUAGE_NAME, NULL_LANGUAGE_NAME};
        return dVals;
    }

    public static String[] getLanguageList() {
        return languageList;
    }

    public static boolean isInterpretedLanguage(String key) {
        String[] values = LanguageAutoFill.getAutoFillValues(key);
        return INTERPRETER_VALUE.equals(values[5]);
    }

    public static Language languageLookup(String languageName) {
        String name;
        String[] names;
        String[] stringArray = names = LanguageAutoFill.getLanguageList();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            if (name.equalsIgnoreCase(languageName)) {
                return LanguageAutoFill.createAutoFilledLanguage(name);
            }
            ++n2;
        }
        stringArray = names;
        n = names.length;
        n2 = 0;
        while (n2 < n) {
            name = stringArray[n2];
            if (name.length() > languageName.length() && name.startsWith(String.valueOf(languageName) + " ")) {
                return LanguageAutoFill.createAutoFilledLanguage(name);
            }
            ++n2;
        }
        if (languageName.equalsIgnoreCase("C")) {
            return LanguageAutoFill.createAutoFilledLanguage(GNUCTITLE);
        }
        if (languageName.equalsIgnoreCase("C++")) {
            return LanguageAutoFill.createAutoFilledLanguage(GNUCPPTITLE);
        }
        return null;
    }

    public static Language createAutoFilledLanguage(String name) {
        String[] values = LanguageAutoFill.getAutoFillValues(name);
        if (!values[0].equals(NULL_LANGUAGE_NAME)) {
            Language language = new Language(values[4]);
            language.setCompileCommandLine(values[1]);
            language.setExecutableIdentifierMask(values[2]);
            language.setProgramExecuteCommandLine(values[3]);
            boolean isScript = LanguageAutoFill.isInterpretedLanguage(name);
            language.setInterpreted(isScript);
            language.setJudgeProgramExecuteCommandLine(values[3]);
            return language;
        }
        return null;
    }
}

