/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.StringUtilities;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;

public class Language
implements IElementObject {
    private static final long serialVersionUID = 7782777481422759344L;
    private String displayName = null;
    private ElementId elementId = null;
    private boolean active = true;
    private String compileCommandLine;
    private String executableIdentifierMask;
    private String judgeProgramExecuteCommandLine;
    private boolean usingJudgeProgramExecuteCommandLine = false;
    private String programExecuteCommandLine;
    private boolean interpreted = false;

    public Language(String displayName) {
        this.displayName = displayName;
        this.elementId = new ElementId(displayName);
        this.setSiteNumber(0);
    }

    public boolean isActive() {
        return this.active;
    }

    public String getCompileCommandLine() {
        return this.compileCommandLine;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getProgramExecuteCommandLine() {
        return this.programExecuteCommandLine;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setCompileCommandLine(String compileCommandLine) {
        this.compileCommandLine = compileCommandLine;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setProgramExecuteCommandLine(String programExecuteCommandLine) {
        this.programExecuteCommandLine = programExecuteCommandLine;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Language) {
            Language otherLanguage = (Language)obj;
            return this.elementId.equals(otherLanguage.elementId);
        }
        throw new ClassCastException("expected an Language found: " + obj.getClass().getName());
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public boolean isSameAs(Language language) {
        block13: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                try {
                                    if (StringUtilities.stringSame(this.displayName, language.getDisplayName())) break block8;
                                    return false;
                                }
                                catch (Exception e) {
                                    StaticLog.log("Exception in Language.isSameAs", e);
                                    return false;
                                }
                            }
                            if (this.isActive() == language.isActive()) break block9;
                            return false;
                        }
                        if (StringUtilities.stringSame(this.compileCommandLine, language.getCompileCommandLine())) break block10;
                        return false;
                    }
                    if (StringUtilities.stringSame(this.programExecuteCommandLine, language.getProgramExecuteCommandLine())) break block11;
                    return false;
                }
                if (StringUtilities.stringSame(this.judgeProgramExecuteCommandLine, language.getJudgeProgramExecuteCommandLine())) break block12;
                return false;
            }
            if (this.usingJudgeProgramExecuteCommandLine == language.isUsingJudgeProgramExecuteCommandLine()) break block13;
            return false;
        }
        return this.interpreted == language.isInterpreted();
    }

    public int hashCode() {
        return this.elementId.hashCode();
    }

    public String getExecutableIdentifierMask() {
        return this.executableIdentifierMask;
    }

    public void setExecutableIdentifierMask(String executableIdentifierMask) {
        this.executableIdentifierMask = executableIdentifierMask;
    }

    public void setInterpreted(boolean interpreted) {
        this.interpreted = interpreted;
    }

    public boolean isInterpreted() {
        return this.interpreted;
    }

    public String getJudgeProgramExecuteCommandLine() {
        if (this.usingJudgeProgramExecuteCommandLine) {
            return this.judgeProgramExecuteCommandLine;
        }
        return this.getProgramExecuteCommandLine();
    }

    public void setJudgeProgramExecuteCommandLine(String judgeProgramExecuteCommandLine) {
        this.judgeProgramExecuteCommandLine = judgeProgramExecuteCommandLine;
    }

    public void setUsingJudgeProgramExecuteCommandLine(boolean usingJudgeProgramExecuteCommandLine) {
        this.usingJudgeProgramExecuteCommandLine = usingJudgeProgramExecuteCommandLine;
    }

    public boolean isUsingJudgeProgramExecuteCommandLine() {
        return this.usingJudgeProgramExecuteCommandLine;
    }
}

