/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import java.io.Serializable;

public class Judgement
implements IElementObject,
Serializable {
    private static final long serialVersionUID = -8252588018410124478L;
    public static final String ACRONYM_ACCEPTED = "AC";
    public static final String ACRONYM_JUDGING_ERROR = "JE";
    public static final String ACRONYM_COMPILATION_ERROR = "CE";
    public static final String ACRONYM_SECURITY_VIOLATION = "SV";
    public static final String ACRONYM_RUN_TIME_ERROR = "RTE";
    public static final String ACRONYM_TIME_LIMIT_EXCEEDED = "TLE";
    public static final String ACRONYM_WRONG_ANSWER = "WA";
    public static final String ACRONYM_EXCESSIVE_OUTPUT = "EO";
    public static final String ACRONYM_OUTPUT_FORMAT_ERROR = "OFE";
    public static final String ACRONYM_OTHER_CONTACT_STAFF = "OCS";
    private ElementId elementId = null;
    private String displayName = null;
    private boolean active = true;
    private String acronym;

    public Judgement(String displayName) {
        this(displayName, ACRONYM_WRONG_ANSWER);
    }

    public Judgement(String displayName, String acronym) {
        this.displayName = displayName;
        this.acronym = acronym;
        this.elementId = new ElementId(displayName);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public ElementId getElementId() {
        return this.elementId;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        return this.displayName;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public int versionNumber() {
        return this.elementId.getVersionNumber();
    }

    @Override
    public int getSiteNumber() {
        return this.elementId.getSiteNumber();
    }

    @Override
    public void setSiteNumber(int siteNumber) {
        this.elementId.setSiteNumber(siteNumber);
    }

    public boolean isSameAs(Judgement judgement) {
        block5: {
            block4: {
                try {
                    if (this.getDisplayName().equals(judgement.getDisplayName())) break block4;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (this.getAcronym().equals(judgement.getAcronym())) break block5;
            return false;
        }
        return this.isActive() == judgement.isActive();
    }

    public String getAcronym() {
        return this.acronym;
    }

    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }
}

