/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ClientType;
import java.io.Serializable;

public class ClientId
implements Serializable {
    private static final long serialVersionUID = -3481561733498755619L;
    public static final int UNSET = 0;
    private int siteNumber = 0;
    private int clientNumber = 0;
    private ClientType.Type clientType = ClientType.Type.UNKNOWN;
    private boolean active = true;

    public ClientId(int siteNumber, ClientType.Type type, int clientNumber) {
        this.siteNumber = siteNumber;
        this.clientNumber = clientNumber;
        this.clientType = type;
    }

    public String toString() {
        return String.valueOf(this.clientType.toString()) + this.clientNumber + " @ site " + this.siteNumber;
    }

    public int getClientNumber() {
        return this.clientNumber;
    }

    public ClientType.Type getClientType() {
        return this.clientType;
    }

    public int getSiteNumber() {
        return this.siteNumber;
    }

    public String getName() {
        if (this.clientNumber == 0 && this.clientType == ClientType.Type.ADMINISTRATOR) {
            return "root";
        }
        return new String("" + (Object)((Object)this.clientType) + this.clientNumber).toLowerCase();
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ClientId) {
            ClientId otherId = (ClientId)obj;
            return this.getClientType() == otherId.getClientType() && this.getClientNumber() == otherId.getClientNumber() && this.getSiteNumber() == otherId.getSiteNumber();
        }
        return false;
    }

    public String getTripletKey() {
        return String.valueOf(this.getSiteNumber()) + this.getClientType().toString() + this.getClientNumber();
    }

    public void setSiteNumber(int siteNumber) {
        this.siteNumber = siteNumber;
    }
}

